@set TEMPPR=%PROMPT%
@if NOT EXIST setup.bat goto ERR1
call setup
@echo Can NOT get PIPING to work in WIN32 ...
@goto END

call mdd temp
@if NOT EXIST ..\sparse02.bat goto ERR2
@set PROMPT=# 

@REM # Tar 1.14 - 1.15.1 was unable to extract sparse files to a pipe.
@REM # References: <16896.21739.460782.124775@jik.kamens.brookline.ma.us>
@REM # http://lists.gnu.org/archive/html/bug-tar/2005-02/msg00003.html 

genfile --sparse --file sparsefile --block-size 512 0 ABCD 1M EFGH 2000K IJKL
@if ERRORLEVEL 1 goto ERR3
@if NOT EXIST sparsefile goto ERR4

%TEMPT% -c -f archive --sparse sparsefile
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST archive goto ERR6

@echo separator

%TEMPT% xfO archive | copy > sparsecopy
%TEMPC% sparsefile sparsecopy

@cd ..
@goto END

:ERR1
@echo Can NOT locate setup.bat ... check name, location ...
@goto END

:ERR2
@echo mdd.bat missing, or failed ... check name, location ...
@goto END

:ERR3
@echo ERROR: genfile exited with errorlevel %ERRORLEVEL% ... is genfile in PATH ...
@goto WAIT

:ERR4
@echo ERROR: genfile failed to create sparsefile ... is genfile in PATH? ...
@goto WAIT

:ERR5
@echo ERROR: tar exited with errorlevel %ERRORLEVEL% ... is %TEMPT% available? ...
@goto WAIT

:ERR6
@echo ERROR: tar failed to create archive ... is %TEMPT% available? ...
@goto WAIT

:WAIT
cd ..
@set PROMPT=%TEMPPR%
@pause
@goto END

:END
@set PROMPT=%TEMPPR%
