@set TEMPPR=%PROMPT%
@if NOT EXIST setup.bat goto ERR1
call setup
call mdd temp
@if NOT EXIST ..\sparse01.bat goto ERR2
@set PROMPT=# 

@echo Generate a set of file in 'temp' ...
genfile --length 1000 -f begin
genfile --length 1000 -f end
genfile --sparse --file sparsefile --block-size 512 0 ABCD 1M EFGH 2000K IJKL
@if ERRORLEVEL 1 goto ERR3
@if NOT EXIST sparsefile goto ERR4

@set TEMPA=archive.default
@REM ##########################################
@REM 1. USING DEFAULT FORMAT
@REM ##########################################
@echo Creating the archive %TEMPA% ... using default,  and listing ...
@%TEMPT% -c -f %TEMPA% --sparse begin sparsefile end
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST %TEMPA% goto ERR6
@%TEMPT% tfv %TEMPA%
@md directory
@if NOT EXIST directory\nul goto ERR7
%TEMPT% Cxf directory %TEMPA%
@if ERRORLEVEL 1 goto ERR8
@if NOT EXIST directory\sparsefile goto ERR9
@genfile --stat=name,size,ssize,sparse sparsefile
@genfile --stat=name,size,ssize,sparse directory/sparsefile
@echo Both 'stats' should show file size different, and '1' for sparse ...
@%TEMPC% sparsefile directory/sparsefile -b

@REM ##########################################
@REM 2. USING gnu FORMAT
@REM ##########################################

@REM echo Clean up ...
@%TEMPX% directory > nul
@set TEMPA=archive.gnu
@echo Creating the archive %TEMPA% ... using 'gnu'  and listing ...
@%TEMPT% -c -f %TEMPA% -H gnu --sparse begin sparsefile end
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST %TEMPA% goto ERR6
@%TEMPT% tfv %TEMPA%
@md directory
@if NOT EXIST directory\nul goto ERR7
%TEMPT% Cxf directory %TEMPA%
@if ERRORLEVEL 1 goto ERR8
@if NOT EXIST directory\sparsefile goto ERR9
@genfile --stat=name,size,ssize,sparse sparsefile
@genfile --stat=name,size,ssize,sparse directory/sparsefile
@echo Both 'stats' should show file size different, and '1' for sparse ...
@%TEMPC% sparsefile directory/sparsefile -b

@REM ##########################################
@REM 3. USING posix FORMAT
@REM ##########################################
@REM echo Clean up ...
@%TEMPX% directory > nul
@set TEMPA=archive.posix
@echo Creating the archive %TEMPA% ... using 'posix' and listing ...
@%TEMPT% -c -f %TEMPA% -H posix --sparse begin sparsefile end
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST %TEMPA% goto ERR6
@%TEMPT% tfv %TEMPA%
@md directory
@if NOT EXIST directory\nul goto ERR7
%TEMPT% Cxf directory %TEMPA%
@if ERRORLEVEL 1 goto ERR8
@if NOT EXIST directory\sparsefile goto ERR9
@genfile --stat=name,size,ssize,sparse sparsefile
@genfile --stat=name,size,ssize,sparse directory/sparsefile
@echo Both 'stats' should show file size different, and '1' for sparse ...
@%TEMPC% sparsefile directory/sparsefile -b

@REM ##########################################
@REM 4. USING oldgnu FORMAT
@REM ##########################################
@REM echo Clean up ...
@%TEMPX% directory > nul
@set TEMPA=archive.oldgnu
@echo Creating the archive %TEMPA% ... using 'oldgnu' ... and listing ...
@%TEMPT% -c -f %TEMPA% -H oldgnu --sparse begin sparsefile end
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST %TEMPA% goto ERR6
@%TEMPT% tfv %TEMPA%
@md directory
@if NOT EXIST directory\nul goto ERR7
%TEMPT% Cxf directory %TEMPA%
@if ERRORLEVEL 1 goto ERR8
@if NOT EXIST directory\sparsefile goto ERR9
@genfile --stat=name,size,ssize,sparse sparsefile
@genfile --stat=name,size,ssize,sparse directory/sparsefile
@echo Both 'stats' should show file size different, and '1' for sparse ...
@%TEMPC% sparsefile directory/sparsefile -b
@cd ..
@goto END

:ERR1
@echo Can NOT locate setup.bat ... check name, location ...
@goto END

:ERR2
@echo mdd.bat missing, or failed ... check name, location ...
@goto END

:ERR3
@echo genfile returned an error ... maybe it is not in your PATH ...
@goto WAIT

:ERR4
@echo genfile did not create sparsefile ... maybe it is not in your PATH ...
@goto WAIT

:ERR5
@echo tar returned an error ... maybe %TEMPT% does not exist, or some other problem ...
@goto WAIT

:ERR6
@echo tar did not create %TEMPA% ... maybe %TEMPT% does not exist, or some other problem ...
@goto WAIT

:ERR7
@echo Unable to create 'directory' ...
@goto WAIT

:ERR8
@echo tar returned an error ... maybe %TEMPT% does not exist, or some other problem ...
@goto WAIT

:ERR9
@echo tar did not extract directory\sparsefile ...
@goto WAIT

:WAIT
cd ..
@set PROMPT=%TEMPPR%
@pause
@goto END

:END
@set PROMPT=%TEMPPR%
