/* protos.h */

/* to supply some missing prototypes, mainly to avoid warnings ;=))
   Note, some prototypes have also been provided in
   Win32\unistd.h, under the usual _MSC_VER switch!
 */

#ifndef HAVE_STRCASECMP
/* Define the internal `strcasecmp' function
   here we have included strcasecmp.c in libtar, so */
extern int strcasecmp (const char *s1, const char *s2);
#endif /* !HAVE_STRCASECMP */
#ifndef HAVE_MEMPCPY
/* Define the internal `mempcpy' function
   here we have included mempcpy.c in libtar, so */
extern void * mempcpy (void *dest, const void *src, size_t n);
#endif /* !HAVE_MEMPCPY */

#ifndef HAVE_STPCPY
/* Define the internal `stpcpy' function
   here we have included stpcpy.c in libtar, so */
extern char * stpcpy (char *dest, const char *src);
#endif /* !HAVE_STPCPY */

// NOTE: These two are done in inttypes.h
//#ifndef HAVE_STRTOUMAX
/* Define the internal 'strtoumax' function. */
//extern uintmax_t strtoumax (char const *ptr, char **endptr, int base);
//#endif /* !HAVE_STRTOUMAX */

//#if !HAVE_DECL_STRTOIMAX
/* Define the internal 'strtoimax' function. */
//extern uintmax_t strtoimax (char const *ptr, char **endptr, int base);
//#endif   /* HAVE_DECL_STRTOIMAX = 0 */

#if !HAVE_DECL_STRNDUP
extern char * strndup (char const *s, size_t n);
#endif /* !HAVE_DECL_STRNDUP */

#ifndef HAVE_STRCHRNUL
/* Define the internal 'strchrnul' function
   since strchrnul.c include in library. */
char * strchrnul (const char *s, int c_in);
#endif /* !HAVE_STRCHRNUL */

#if !HAVE_DECL_GETLINE
/* Define the internal 'getline' */
extern ssize_t getline (char **lineptr, size_t *n, FILE *stream);
#endif /* !HAVE_DECL_GETLINE */

#if !HAVE_DECL_MEMRCHR
/* Define to internal 'memrchr' */
extern void * memrchr (void const *s, int c_in, size_t n);
#endif /* !HAVE_DECL_MEMRCHR */

#ifndef HAVE_FCHDIR
/* Define to internal 'fchdir' function. */
extern int fchdir (int fd);
#endif /* !HAVE_FCHDIR */

extern int mbscasecmp (const char *s1, const char *s2);

#if !HAVE_DECL_GETDELIM
/* Define to internal  'getdelim' function */
extern ssize_t getdelim (char **lineptr, size_t *n, int delimiter, FILE *fp);
#endif /* !HAVE_DECL_GETDELIM */

#ifndef HAVE_LCHOWN
/* Define to internal 'lchown' function. */
extern int lchown (const char *file, uid_t uid, gid_t gid);
#endif /* !HAVE_LCHOWN */

#ifndef HAVE_UNSETENV
/* Define to internal 'unsetenv' function. */
extern int unsetenv (const char *name);
#endif /* !HAVE_UNSETENV */

#ifndef HAVE_SETENV
/* Define to internal 'setenv' function, modified for _MSC_VER. */
extern int setenv (const char *name, const char *value, int replace);
#endif /* !HAVE_SETENV */

#ifndef HAVE_WCWIDTH
/* Define to internal 'wcwidth' function. */
extern int wcwidth (wchar_t wc);
#endif /* !HAVE_WCWIDTH */

#ifndef HAVE_MKDTEMP
/* Define to internal 'mkdtemp' function. */
extern char * mkdtemp (char *temp);
#endif /* !HAVE_MKDTEMP */


/* eof - protos.h */
