@REM #! /bin/sh
@REM # Test for POSIX.2 options for grep
@REM # grep -E -f pattern_file file
@REM # grep -F -f pattern_file file
@REM # grep -G -f pattern_file file

@if EXIST grepsetup.bat goto DOSETUP
@if EXIST %TEMPGREP% goto DNSETUP
@goto ERR1
:DOSETUP
@call grepsetup
@if EXIST %TEMPGREP% goto DNSETUP
@goto ERR1

:DNSETUP
@if "%TEMPECH%." == "." goto ERR1
@if "%TEMPFIL%." == "." goto ERR1

@set TEMPERR=0
@set TEMPCNT=0
@set TEMPMEE=0
@echo Start %TIME% >> tempgrep.txt

@set TEMPPAT=temppat.txt
@echo radar > %TEMPPAT%
@echo MILES >> %TEMPPAT%
@echo GNU >> %TEMPPAT%
@echo. >> tempgrep.txt
@echo File: Patterns to %TEMPPAT% - radar MILES GNU >> tempgrep.txt

@REM # match
@echo. >> tempgrep.txt
@echo Test #1 echo miles to grep -i -E -f %TEMPPAT% >> tempgrep.txt
@echo miles|%TEMPGREP% -i -E -f %TEMPPAT% >> tempgrep.txt 2>&1
@set TEMPERR=%ERRORLEVEL%
@REM if test $? -ne 0 ; then
@if ERRORLEVEL 1 goto TEST1ERR
@%TEMPECH% file: match: SUCCESS, test #1. Want and got %TEMPERR%
@echo file: match: SUCCESS, test #1. Want and got %TEMPERR% >> tempgrep.txt
@goto DNTEST1

:TEST1ERR
@echo file: match: test #1 failed. Want 0, got %TEMPERR% from echo miles to grep -i -E -f %TEMPPAT%
@echo file: match: test #1 failed. Want 0, got %TEMPERR% from echo miles to grep -i -E -f %TEMPPAT% >> %TEMPFIL%
@echo file: match: test #1 failed. Want 0, got %TEMPERR% from echo miles to grep -i -E -f %TEMPPAT%>> tempgrep.txt
@set /a TEMPMEE+=1
@set /a TEMPFAIL+=1
@goto DNTEST1

:DNTEST1

@REM # match 
@echo. >> tempgrep.txt
@echo Test #2 echo GNU to grep -G -f %TEMPPAT% >> tempgrep.txt
@echo GNU|%TEMPGREP% -G -f %TEMPPAT%  >> tempgrep.txt 2>&1
@REM if test $? -ne 0 ; then
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto TEST2ERR
@%TEMPECH% file: match: SUCCESS, test #2. Want and got %TEMPERR%
@echo file: match: SUCCESS, test #2. Want and got %TEMPERR% >> tempgrep.txt
@goto DNTEST2

:TEST2ERR
@echo file: match: test #2 failed. Want 0, got %TEMPERR% echo GNU to grep -G -f %TEMPPAT%
@echo file: match: test #2 failed. Want 0, got %TEMPERR% echo GNU to grep -G -f %TEMPPAT% >> %TEMPFIL%
@echo file: match: test #2 failed. Want 0, got %TEMPERR% echo GNU to grep -G -f %TEMPPAT% >> tempgrep.txt
@set /a TEMPMEE+=1
@set /a TEMPFAIL+=1
@goto DNTEST2

:DNTEST2
@REM # checking for no match
@echo. >> tempgrep.txt
@echo Test #3 echo ridar to grep -F -f %TEMPPAT% >> tempgrep.txt
@echo ridar|%TEMPGREP% -F -f %TEMPPAT% >> tempgrep.txt 2>&1
@set TEMPERR=%ERRORLEVEL%
@REM if test $? -ne 1 ; then
@if "%TEMPERR%." NEQ "1." goto TEST3ERR
@%TEMPECH% file: no match: SUCCESS, test #3. Want and got %TEMPERR%
@echo file: no match: SUCCESS, test #3. Want and got %TEMPERR% >> tempgrep.txt
@goto DNTEST3

:TEST3ERR
@echo file: no match: test #3 failed. Want 0, got %TEMPERR% echo ridar to grep -F -f %TEMPPAT%
@echo file: no match: test #3 failed. Want 0, got %TEMPERR% echo ridar to grep -F -f %TEMPPAT% >> %TEMPFIL%
@echo file: no match: test #3 failed. Want 0, got %TEMPERR% echo ridar to grep -F -f %TEMPPAT% >> tempgrep.txt
@set /a TEMPMEE+=1
@set /a TEMPFAIL+=1
@goto DNTEST3

:DNTEST3

@REM cat <<EOF >patfile
@REM
@REM EOF
@echo. > %TEMPPAT%
@echo. >> tempgrep.txt
@echo File: BLANK Pattern to %TEMPPAT% >> tempgrep.txt

@REM # empty pattern : every match
@echo. >> tempgrep.txt
@echo Test #4 echo abbcd to grep -F -f %TEMPPAT% >> tempgrep.txt
@echo abbcd|%TEMPGREP% -F -f %TEMPPAT% >> tempgrep.txt 2>&1
@set TEMPERR=%ERRORLEVEL%
@REM if test $? -ne 0 ; then
@if ERRORLEVEL 1 goto TEST4FAIL
@%TEMPECH% file: blank: SUCCESS, test #4. Want and got %TEMPERR%
@echo file: blank: SUCCESS, test #4. Want and got %TEMPERR% >> tempgrep.txt
@goto DNTEST4

:TEST4FAIL
@echo file: blank: test #4 failed, got %TEMPERR%, Want 0 echo abbcd to grep -F -f %TEMPPAT%
@echo file: blank: test #4 failed, got %TEMPERR%, Want 0 echo abbcd to grep -F -f %TEMPPAT% >> %TEMPFIL%
@echo file: blank: test #4 failed, got %TEMPERR%, Want 0 echo abbcd to grep -F -f %TEMPPAT% >> tempgrep.txt
@set /a TEMPMEE+=1
@set /a TEMPFAIL+=1
@goto DNTEST4

:DNTEST4

@copy nul %TEMPPAT% > nul
@echo File: nul Pattern to %TEMPPAT% >> tempgrep.txt
@echo. >> tempgrep.txt

@REM # null pattern : no match
@echo. >> tempgrep.txt
@echo Test #5 echo abbcd to grep -F -f %TEMPPAT% >> tempgrep.txt
@echo abbcd|%TEMPGREP% -F -f %TEMPPAT% >> tempgrep.txt 2>&1
@set TEMPERR=%ERRORLEVEL%
@REM if test $? -ne 1 ; then
@if %TEMPERR% NEQ 1 goto TEST5FAIL
@%TEMPECH% file: nul: SUCCESS, test #5. Want and got %TEMPERR%
@echo file: nul: SUCCESS, test #5. Want and got %TEMPERR% >> tempgrep.txt
@goto DNTEST5
:TEST5FAIL
@echo file: null: test #5 failed, got %TEMPERR%, Want 1 echo abbcd to grep -F -f %TEMPPAT%
@echo file: null: test #5 failed, got %TEMPERR%, Want 1 echo abbcd to grep -F -f %TEMPPAT% >> %TEMPFIL%
@echo file: null: test #5 failed, got %TEMPERR%, Want 1 echo abbcd to grep -F -f %TEMPPAT% >> tempgrep.txt
@set /a TEMPMEE+=1
@set /a TEMPFAIL+=1
@goto DNTEST5

:DNTEST5

@goto DONE

:ERR1
@echo %0: test not done ...
@echo %0: test not done ... >> tempgrep.txt
@goto END

:DONE
@if "%TEMPMEE%." == "0." goto ALLOK
@echo %0: It appears %TEMPMEE% tests failed ...
@echo %0: It appears %TEMPMEE% tests failed ... >> tempgrep.txt
@goto END
:ALLOK
@echo %0: It appears ALL tests succeeded ...
@echo %0: It appears ALL tests succeeded ... >> tempgrep.txt
@goto END

:END
@echo End %TIME% >> tempgrep.txt
