/* ========================================================================
   config.h
   Hand crafted configuration for WIN32 MSVC (_MSC_VER) environment
   Suitable for MSVC6 (1998), MSVC7.1 (2003), MSVC8 (2005) and MSVC9 (2008)
   In this regards, Windows seldom (never?) changes ;=))
   ======================================================================== */
#ifndef _config_h_
#define _config_h_

#pragma warning(disable:4996)   /* disable peskie 'depreciated' warnings */

/* ********************************************************************
   NOTE: Due to compiling library with Disabled language extensions,
         /Za (to define __STDC__) <Windows.h> _CAN NOT_ be included!
         It is of course included in winport.c, but this is specially
         exempted - uses /Ze instead - and hence the use of 'void *'
         instead of 'FILETIME *' in one place.
   ******************************************************************** */
#include <stdlib.h>
#include <wchar.h>
#include <wctype.h>
#include <malloc.h>  /* for alloca in regex.c */

#define alloca _alloca
#define off_t	_off_t
#define inline __inline

#define HAVE_WCTYPE_H 1
#define HAVE_WCHAR_H 1
#define HAVE_BTOWC 1

#define HAVE_STDDEF_H 1
#define HAVE_STDLIB_H 1
#define STAT_MACROS_BROKEN 1
#define HAVE_DECL_STRERROR_R 1
#define STDC_HEADERS 1
#define HAVE_VPRINTF 1
#define HAVE_STRING_H 1

#define HAVE_DECL_STRTOUL 1
#define HAVE_DECL_STRTOULL 0
typedef unsigned int uintmax_t;
#define HAVE_DONE_WORKING_MALLOC_CHECK 1
#define HAVE_DONE_WORKING_REALLOC_CHECK 1

#define HAVE_DOS_FILE_CONTENTS 1
#define HAVE_DOS_FILE_NAMES 1
#define STDC_HEADERS 1
#define HAVE_MEMCHR 1
#define HAVE_MEMMOVE 1
#define HAVE_FCNTL_H 1
#define HAVE_STRERROR 1

#define HAVE_LIMITS_H 1

#define PACKAGE_BUGREPORT "bug-grep@gnu.org"
#define PACKAGE_NAME "GNU grep"
#define PACKAGE_VERSION "2.5.4-cvs"
#define PACKAGE_STRING  (PACKAGE_NAME " " PACKAGE_VERSION " w32.02")

#define STDOUT_FILENO   _fileno( stdout )

/* problem with macro - #  define is_EISDIR(e, f) ((e) == EISDIR) = errno = EACCESS */
#define HAVE_DIR_EACCES_BUG 1

#define MEOR "\r\n" /* Windows line ending set */

typedef struct tagSPLITTING {
   char path[_MAX_DIR];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];
}SPLITTING, * PSPLITTING;

typedef size_t ssize_t;
#define strcasecmp stricmp
#define stat _stat

/* for EXTRA DEBUG outputs */
#define ADD_GREP_STATS     /* out files searched and FIND count */

#define MX_SHOW_BUF  32 /* maximum bytes of buffer to show */
#ifndef NDEBUG
#define EXTRA_DEBUG2  1  /* show command line, input if piped, and keys ... */
#else
#undef EXTRA_DEBUG2
#endif

#define GREP_PROGRAM

#include "winport.h" /* for initialize_main */

#endif // _config_h_
// eof - config.h - hand crafted for MSVC (_MSC_VER) environment

