
/* node2stg.c - FOR DEBUG ONLY */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef  NDEBUG

#include "tidy-int.h"
#include "tmbstr.h"
#include <windows.h>


tmbstr node2stg( Node * node )
{
   /* node->type is one of these values
   */
   if ( !node )
      return "<Node is NULL>";

   if ( node->type == RootNode )
      return "RootNode";
   else if ( node->type == DocTypeTag )
      return "DocTypeTag";
   else if ( node->type == CommentTag )
      return "CommentTag";
   else if ( node->type == ProcInsTag )
      return "ProcInsTag";
   else if ( node->type == TextNode )
      return "TextNode";
   else if (( node->type == StartTag ) ||
      ( node->type == EndTag ) ||
      ( node->type == StartEndTag ) ) {
      if ( nodeIsHTML( node ) )
         return "HTML";
      else if ( nodeIsHEAD( node ) )
         return "HEAD";
      else if ( nodeIsTITLE( node ) )
         return "TITLE";
      else if ( nodeIsBASE( node ) )
         return "BASE";
      else if ( nodeIsMETA( node ) )
         return "META";
      else if ( nodeIsBODY( node ) )
         return "BODY";
      else if ( nodeIsFRAMESET( node ) )
         return "FRAMESET";
      else if ( nodeIsFRAME( node ) )
         return "FRAME";
      else if ( nodeIsIFRAME( node ) )
         return "IFRAME";
      else if ( nodeIsNOFRAMES( node ) )
         return "NOFRAMES";
      else if ( nodeIsHR( node ) )
         return "HR";
      else if ( nodeIsH1( node ) )
         return "H1";
      else if ( nodeIsH2( node ) )
         return "H2";
      else if ( nodeIsPRE( node ) )
         return "PRE";
      else if ( nodeIsLISTING( node ) )
         return "LISTING";
      else if ( nodeIsP( node ) )
         return "P";
      else if ( nodeIsUL( node ) )
         return "UL";
      else if ( nodeIsOL( node ) )
         return "OL";
      else if ( nodeIsDL( node ) )
         return "DL";
      else if ( nodeIsDIR( node ) )
         return "DIR";
      else if ( nodeIsLI( node ) )
         return "LI";
      else if ( nodeIsDT( node ) )
         return "DT";
      else if ( nodeIsDD( node ) )
         return "DD";
      else if ( nodeIsTABLE( node ) )
         return "TABLE";
      else if ( nodeIsCAPTION( node ) )
         return "CAPTION";
      else if ( nodeIsTD( node ) )
         return "TD";
      else if ( nodeIsTH( node ) )
         return "TH";
      else if ( nodeIsTR( node ) )
         return "TR";
      else if ( nodeIsCOL( node ) )
         return "COL";
      else if ( nodeIsCOLGROUP( node ) )
         return "COLGROUP";
      else if ( nodeIsBR( node ) )
         return "BR";
      else if ( nodeIsA( node ) )
         return "A";
      else if ( nodeIsLINK( node ) )
         return "LINK";
      else if ( nodeIsB( node ) )
         return "B";
      else if ( nodeIsI( node ) )
         return "I";
      else if ( nodeIsSTRONG( node ) )
         return "STRONG";
      else if ( nodeIsEM( node ) )
         return "EM";
      else if ( nodeIsBIG( node ) )
         return "BIG";
      else if ( nodeIsSMALL( node ) )
         return "SMALL";
      else if ( nodeIsPARAM( node ) )
         return "PARAM";
      else if ( nodeIsOPTION( node ) )
         return "OPTION";
      else if ( nodeIsOPTGROUP( node ) )
         return "OPTGROUP";
      else if ( nodeIsIMG( node ) )
         return "IMG";
      else if ( nodeIsMAP( node ) )
         return "MAP";
      else if ( nodeIsAREA( node ) )
         return "AREA";
      else if ( nodeIsNOBR( node ) )
         return "NOBR";
      else if ( nodeIsWBR( node ) )
         return "WBR";
      else if ( nodeIsFONT( node ) )
         return "FONT";
      else if ( nodeIsLAYER( node ) )
         return "LAYER";
      else if ( nodeIsSPACER( node ) )
         return "SPACER";
      else if ( nodeIsCENTER( node ) )
         return "CENTER";
      else if ( nodeIsSTYLE( node ) )
         return "STYLE";
      else if ( nodeIsSCRIPT( node ) )
         return "SCRIPT";
      else if ( nodeIsNOSCRIPT( node ) )
         return "NOSCRIPT";
      else if ( nodeIsFORM( node ) )
         return "FORM";
      else if ( nodeIsTEXTAREA( node ) )
         return "TEXTAREA";
      else if ( nodeIsBLOCKQUOTE( node ) )
         return "BLOCKQUOTE";
      else if ( nodeIsAPPLET( node ) )
         return "APPLET";
      else if ( nodeIsOBJECT( node ) )
         return "OBJECT";
      else if ( nodeIsDIV( node ) )
         return "DIV";
      else if ( nodeIsSPAN( node ) )
         return "SPAN";
      else if ( nodeIsINPUT( node ) )
         return "INPUT";
      else if ( nodeIsQ( node ) )
         return "Q";
      else if ( nodeIsLABEL( node ) )
         return "LABEL";
      else if ( nodeIsH3( node ) )
         return "H3";
      else if ( nodeIsH4( node ) )
         return "H4";
      else if ( nodeIsH5( node ) )
         return "H5";
      else if ( nodeIsH6( node ) )
         return "H6";
      else if ( nodeIsADDRESS( node ) )
         return "ADDRESS";
      else if ( nodeIsXMP( node ) )
         return "XMP";
      else if ( nodeIsSELECT( node ) )
         return "SELECT";
      else if ( nodeIsBLINK( node ) )
         return "BLINK";
      else if ( nodeIsMARQUEE( node ) )
         return "MARQUEE";
      else if ( nodeIsEMBED( node ) )
         return "EMBED";
      else if ( nodeIsBASEFONT( node ) )
         return "BASEFONT";
      else if ( nodeIsISINDEX( node ) )
         return "ISINDEX";
      else if ( nodeIsS( node ) )
         return "S";
      else if ( nodeIsSTRIKE( node ) )
         return "STRIKE";
      else if ( nodeIsSUB( node ) )
         return "SUB";
      else if ( nodeIsSUP( node ) )
         return "SUP";
      else if ( nodeIsU( node ) )
         return "U";
      else if ( nodeIsMENU( node ) )
         return "MENU";
      else if ( nodeIsBUTTON( node ) )
         return "BUTTON";
      else {
         if ( node->tag ) {
            if ( node->tag->id == TidyTag_UNKNOWN ) {
               if ( node->tag->name )
                  return node->tag->name;
            }
         }
      }
   } else if ( node->type == CDATATag )
      return "CDATATag";
   else if ( node->type == SectionTag )
      return "SectionTag";
   else if ( node->type == AspTag )
      return "AspTag";
   else if ( node->type == JsteTag )
      return "JsteTag";
   else if ( node->type == PhpTag )
      return "PhpTag";
   else if ( node->type == XmlDecl )
      return "XmlDecl";

   return "UNCASED";

}

#define  VH(a)    a
#define  MXIO  1024

int   gbCheckCrLf = 0;
FILE * hUserOut = NULL;
char _s_goutbuf[MXIO+4]; // [MXIO + 4];

void oi( tmbstr lps )
{
	uint  i, dw;
   i = 0;
	if( lps )
      i = (uint)strlen( lps );
   if(i) {
      if( hUserOut == NULL )
         hUserOut = fopen( "temptidy.txt", "wb");

      if( VH(hUserOut) ) {
			//WriteFile( hUserOut, lps, i, &dw, NULL );
         dw = fwrite( lps, 1, i, hUserOut );
         if ( dw != i ) {
            fclose(hUserOut);
            hUserOut = NULL;
         } else {
            fflush(hUserOut);
         }
      }
	}
}

void	prt( tmbstr lps )
{
	char * buf = _s_goutbuf; // [MXIO + 4];
	tmbstr	lpb;
	int		i, j, k;
	char	c, d;
   i = strlen(lps);
	if(i) {
		k = 0;
		d = 0;
		lpb = &buf[0];
		for( j = 0; j < i; j++ ) {
			c = lps[j];
			if( c == 0x0d ) {
				if( (j+1) < i ) {
					if( lps[j+1] != 0x0a ) {
						lpb[k++] = c;
						c = 0x0a;
					}
				} else {
					lpb[k++] = c;
					c = 0x0a;
				}
			} else if( c == 0x0a ) {
				if( d != 0x0d ) {
					lpb[k++] = 0x0d;
				}
			}
			lpb[k++] = c;
			d = c;
			if( k >= MXIO ) {
				lpb[k] = 0;
				oi( lpb );
				k = 0;
			}
		}	// for length of string
		if( k ) {
			if( ( gbCheckCrLf ) &&
				( d != 0x0a ) ) {
				// add Cr/Lf pair
				lpb[k++] = 0x0d;
				lpb[k++] = 0x0a;
				lpb[k] = 0;
			}
			lpb[k] = 0;
			oi( lpb );
		}
	}
}

int _cdecl sprtf( tmbstr lpf, ... )
{
   static char _s_sprtfbuf[1024];
   char *      lpb = &_s_sprtfbuf[0];
   int         i;
   va_list     arg_ptr;

   va_start(arg_ptr, lpf);
   i = vsprintf( lpb, lpf, arg_ptr );
   va_end(arg_ptr);

   if(i)
      prt(lpb);

   return i;
}

int   bShowParent = 0;
int   iShowAddress = 0;
int   iShowPrevious = 0;
int   iShowNext = 1;
void  show_a_node(  TidyDocImpl* doc, Node *node, int level )
{
   while( level-- )
      sprtf( "   ");
   if( iShowAddress ) {
      sprtf( "node[%08X]: %s", node, node2stg( node ) );
      if ( node->content )
         sprtf( " content[%08X] %s", node->content, node2stg( node->content ) );
      if ( bShowParent ) {
         if ( node->parent )
            sprtf( " parent[%08X] %s", node->parent, node2stg( node->parent ) );
      }
      if ( iShowPrevious ) {
         if ( node->prev )
            sprtf( " previous[%08X] %s", node->prev, node2stg( node->prev ) );
      }
   } else {
      Node * content = node->content;
      if ( iShowPrevious ) {
         if ( node->prev )
            sprtf( "prev %s ", node2stg( node->prev ) );
      }
      sprtf( "node: %s", node2stg( node ) );
      while ( content ) {
         sprtf( " content %s", node2stg( content ) );
         content = content->content;
      }
      if ( bShowParent ) {
         if ( node->parent )
            sprtf( " parent %s", node2stg( node->parent ) );
      }
      if ( iShowNext ) {
         Node * next = node->next;
         while ( next ) {
            sprtf( " next %s", node2stg( next ) );
            next = next->next;
         }
      }
   }
   sprtf( "\n");
}

void  display_nodes(  TidyDocImpl* doc, Node *node, int level )
{
   while ( node ) {
      show_a_node( doc, node, level );
      if (node->content)
         display_nodes( doc, node->content, level + 1 );
      node = node->next;
   }
}

void  show_nodes(  TidyDocImpl* doc, Node *node, int level, tmbstr msg )
{
   sprtf( "Display of NODES in tree ... %s\n", msg );
   display_nodes( doc, node, level );
   sprtf( "END Display of NODES in tree ... %s\n", msg );
}

#endif   // #ifndef  NDEBUG

/* eof - node2stg.c */
