#!Perl -W
#NAME: fixmf.cgi
#AIM: To adjust the Makefile generated for things I can NOT seem
# to adjust using Makefile.PL
use strict;
use warnings;
my $exit = 4;
my $in_file = 'Makefile';
my $out_file = $in_file;

if (open INF, "<$in_file") {
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    my $lnnum = 0;
    my $chges = 0;
    prt( "Processing $lncnt lines in $in_file ...\n" );
    for (my $i = 0; $i < $lncnt; $i++) {
        $lnnum++;
        my $line = $lines[$i];
        if ($line =~ /msvcrt\./) {
            my $ln = $line;
            chomp $ln;
            prt( "$lnnum: Found [$ln]\n" );
            $line =~ s/msvcrt\./libcmt\./g;
            $lines[$i] = $line;
            $chges++;
            $ln = $line;
            chomp $ln;
            prt( "$lnnum: Change [$line]\n" );
        }
    }
    if ($chges) {
        if (open OUTF, ">$out_file") {
            print OUTF join("", @lines);
            close OUTF;
            prt( "Written changed $out_file ... with $chges changes ...\n" );
            $exit = 0;
        } else {
            prt( "ERROR: Failed to create OUT file ...\n" );
            $exit = 2;
        }
    }
} else {
    prt( "ERROR: Failed to open $in_file ...\n" );
    $exit = 3;
}
prt( "Exit with ERRORLEVEL $exit ...\n" );
exit($exit);
#######################

sub prt {
    my ($txt) = shift;
    print $txt;
}

# eof - fixmf.cgi
