@setlocal

@REM shptest.bat: 2010-08-121, based on ..\shpproj.sh script

@echo Run some tests using the Release builds...
@echo You need to have ALSO built the 'shpproj' projects, which
@echo depends on the PROJ.4 library.

@set TEMPD1=tests
@set TEMPD2=bin
@set TEMPT1=shpcreate.exe
@set TEMPT2=shpadd.exe
@set TEMPT3=dbfcreate.exe
@set TEMPT4=dbfadd.exe
@set TEMPT5=shpproj.exe
@set TEMPT6=shpdump.exe

@if NOT EXIST %TEMPD2%\%TEMPT1% goto NOEX1
@if NOT EXIST %TEMPD2%\%TEMPT2% goto NOEX2
@if NOT EXIST %TEMPD2%\%TEMPT3% goto NOEX2
@if NOT EXIST %TEMPD2%\%TEMPT4% goto NOEX4
@if NOT EXIST %TEMPD2%\%TEMPT5% goto NOEX5
@if NOT EXIST %TEMPD2%\%TEMPT6% goto NOEX6

@echo All necessary utilities appear to have been found in %TEMPD2%
@echo *** CONTINUE? ***
@pause

@if NOT EXIST %TEMPD1%\. @md %TEMPD1%
@if NOT EXIST %TEMPD1%\. goto MDFAILED

@cd %TEMPD1% 

@if EXIST test*.* @del test*

@echo Create test.shp file...
..\%TEMPD2%\%TEMPT1% test point
@if ERRORLEVEL 1 goto FAILED1

..\%TEMPD2%\%TEMPT2% test -83.54949956  34.992401
@..\%TEMPD2%\%TEMPT2% test -83.52162155 34.99276748
@..\%TEMPD2%\%TEMPT2% test -84.01681518 34.67275985
@..\%TEMPD2%\%TEMPT2% test -84.15596023 34.64862437
@..\%TEMPD2%\%TEMPT2% test -83.61951463 34.54927047

@echo Create test.dbf file...
..\%TEMPD2%\%TEMPT3% test -s fd 30
@if ERRORLEVEL 1 goto FAILED3
..\%TEMPD2%\%TEMPT4% test "1"
@..\%TEMPD2%\%TEMPT4% test "2"
@..\%TEMPD2%\%TEMPT4% test "3"
@..\%TEMPD2%\%TEMPT4% test "4"
@..\%TEMPD2%\%TEMPT4% test "5"

..\%TEMPD2%\%TEMPT5% test test_1 -i=geographic -o="init=nad83:1002 units=us-ft"
@if ERRORLEVEL 1 goto FAILED51
..\%TEMPD2%\%TEMPT5% test_1 test_2 -o="proj=utm zone=16 units=m"
@if ERRORLEVEL 1 goto FAILED52
..\%TEMPD2%\%TEMPT5% test_2 test_3 -o=geographic
@if ERRORLEVEL 1 goto FAILED53

..\%TEMPD2%\%TEMPT6%  test    > test.out
..\%TEMPD2%\%TEMPT6%  test_3  > test_3.out

@REM diff test.out test_3.out
@echo N >test.n
comp test.out test_3.out <test.n
@if ERRORLEVEL 1 goto ISDIFF
@echo.
@echo It is a success if there is NO difference!
@goto DNDIFF
:ISDIFF
@echo.
@echo It is a success if there is NO difference!
@echo But comp returned ERRORLEVEL=%ERRORLEVEL%, which suggests a DIFFERENCE!
:DNDIFF

@echo.
@echo Continue to DELETE all tests. Ctrl+C to abort, and examine the tests...
@pause

@REM clean up all
@if EXIST test*.* del test*
@cd ..
rd %TEMPD1%

@goto END

:FAILED1
@echo ERROR: LEVEL=%ERRORLEVEL% Failed '..\%TEMPD2%\%TEMPT1% test point'
@goto END

:FAILED3
@echo ERROR: LEVEL=%ERRORLEVEL% Failed '..\%TEMPD2%\%TEMPT3% test -s fd 30'
@goto END

:FAILED51
@echo ERROR: LEVEL=%ERRORLEVEL% Failed '..\%TEMPD2%\%TEMPT5% test test_1 -i=geographic -o="init=nad83:1002 units=us-ft"'
@goto PROJ_FAIL

:FAILED52
@echo ERROR: LEVEL=%ERRORLEVEL% Failed '..\%TEMPD2%\%TEMPT5% test_1 test_2 -o="proj=utm zone=16 units=m"'
@goto PROJ_FAIL

:PROj_FAIL
@echo.
@echo One very _LIKELY_ place is in the shpgeo.c library!
@echo I have USED -
@echo #ifdef _MSC_VER
@echo  _putenv("PROJ_LIB=C:\\Projects\\proj.4\\proj-4.7.0\\nad");
@echo #endif
@echo YOu _MUST_ correct this to point to the location of the 'nad83' file!
@echo Correct this and recompile... or if you are without this 'patch',
@echo then manually set the PROJ_LIB environment variable.
@echo If it is NOT this, then you must look deeper...
@goto END

:FAILED53
@echo ERROR: LEVEL=%ERRORLEVEL% Failed '..\%TEMPD2%\%TEMPT5% test_2 test_3 -o=geographic'
@goto PROJ_FAIL

:NOEX1
@echo NOT EXIST %TEMPD2%\%TEMPT1%!
@goto END

:NOEX2
@echo NOT EXIST %TEMPD2%\%TEMPT2%!
@goto END

:NOEX2
@echo NOT EXIST %TEMPD2%\%TEMPT3%!
@goto END

:NOEX4
@echo NOT EXIST %TEMPD2%\%TEMPT4%!
@goto END

:NOEX5
@echo NOT EXIST %TEMPD2%\%TEMPT5%!
@goto END

:NOEX6
@echo NOT EXIST %TEMPD2%\%TEMPT6%!
@goto END


:MDFAILED
@echo ERROR: Unable to create directory %TEMPD1%!
@goto END

:END
@endlocal
