// hand crafted for MSVC

#include "flite.h"

// VOXES = cmu_us_kal cmu_time_awb cmu_us_kal16 \
//  cmu_us_awb cmu_us_rms cmu_us_slt

#ifndef NO_US_KAL_VOICE
cst_voice *register_cmu_us_kal(const char *voxdir);
cst_voice *register_cmu_us_kal16(const char *voxdir);
#endif
cst_voice *register_cmu_us_slt(const char *voxdir);
cst_voice *register_cmu_us_awb(const char *voxdir);

cst_val *flite_set_voice_list(void)
{
#ifndef NO_US_KAL_VOICE
        flite_voice_list = cons_val(voice_val(register_cmu_us_kal(NULL)),flite_voice_list);
        flite_voice_list = cons_val(voice_val(register_cmu_us_kal16(NULL)),flite_voice_list);
#endif
        flite_voice_list = cons_val(voice_val(register_cmu_us_awb(NULL)),flite_voice_list);
        flite_voice_list = cons_val(voice_val(register_cmu_us_slt(NULL)),flite_voice_list);
        flite_voice_list = val_reverse(flite_voice_list);
        return flite_voice_list;
}

// eof - flite_voice_list.c

