// ps.cxx : Defines the entry point for the console application.
/*******************ps.cxx*****************/
// 2011-09-01 - Add alphabeitc, and PID sort
// 2011-02-08 - List running processes...
//
// Written by Geoff R. McLane, started February 2011.
//
// Copyright (C) 2011 - ????  Geoff R. McLane  
//    - http://geoffair.org - reports@geoffair.info -
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// $Id$
//
#pragma warning( disable : 4996 ) // 'stricmp': The POSIX name for this item is deprecated

#include "ps.hxx"
#include <Psapi.h>
#include <vector>
#include <map>
#include <tlhelp32.h>
#include "sprtf.hxx"
#include "utils.hxx"

#include <iostream>
#include <string>
#include <map>
#include <algorithm>

using namespace std ;

typedef map<string, int> STRING2INT;

//  Forward declarations:
BOOL GetProcessList( );
int ListProcessModules( DWORD dwPID );
int ListProcessThreads( DWORD dwOwnerPID, DWORD * ptid );
void printError( TCHAR* msg );
BOOL Enable_SeDebugPrivilege( HANDLE hToken );

using std::vector;

#define MAX_PROCESSES   1024*4
#define MAX_MODULES     1024*4
#define MAX_THREADS     1024*4
#define MIN_PROCESS_NAME 30

static DWORD aProcesses[MAX_PROCESSES];

typedef struct tagPROCLIST {
    DWORD id;
    int pl_thread_count;
    DWORD threads[MAX_THREADS];
    int mod_count;
    DWORD nm_off;
    TCHAR name[MAX_PATH];
}PROCLIST, * PPROCLIST;

typedef vector<PROCLIST> vPROCS;
typedef vPROCS::iterator vPI;

typedef vector<char *> vNAMES; // of 'names' to find
typedef vNAMES::iterator vNI;

vPROCS vprocs;
vNAMES vnames;
STRING2INT mStr2Int;

static size_t max_name_len = 0;
static char * pname = NULL;
static int verbose = 0;
static int show_all = 0;
static int enable_debug = 0;
static int process_counter = 0;

static bool sort_by_name = false;
static bool sort_by_pid = false;

#define VERB1 (verbose >= 1)
#define VERB2 (verbose >= 2)
#define VERB5 (verbose >= 5)
#define VERB9 (verbose >= 9)

// forward
int main_enum_process( void );
int GetProcessThreadCount( DWORD dwOwnerPID, DWORD * ptid );

bool my_NameSort( PROCLIST & pl1, PROCLIST & pl2 )
{
    if (stricmp( pl1.name, pl2.name ) < 0)
        return true;
    return false;
}

bool my_PIDSort( PROCLIST & pl1, PROCLIST & pl2 )
{
    return (pl1.id < pl2.id);
}


void getProcessNameAndID( DWORD processID )
{
    static PROCLIST pl;
    char * ppn = &pl.name[0];
    int i;

    ZeroMemory(&pl,sizeof(pl));

    strcpy(ppn, "<unknown>");
    pl.id = processID;
    pl.mod_count = -1;
    pl.nm_off = (DWORD)-1;
    pl.pl_thread_count = 0;
    if (VERB1)
        pl.pl_thread_count = GetProcessThreadCount( processID, &pl.threads[0] );

    // Get a handle to the process.
    HANDLE hProcess = OpenProcess( PROCESS_QUERY_INFORMATION |
                                   PROCESS_VM_READ,
                                   FALSE, processID );

    // Get the process name.
    if (NULL != hProcess )
    {
        static HMODULE hMod[MAX_MODULES];
        DWORD cbNeeded;

        if ( EnumProcessModules( hProcess, &hMod[0], sizeof(hMod), 
             &cbNeeded) )
        {
            pl.mod_count = cbNeeded / sizeof(HMODULE);
            for (i = 0; i < pl.mod_count; i++) {
                if ( GetModuleBaseName( hProcess, hMod[i], ppn, MAX_PATH ) ) {
                    pl.nm_off = i;
                    break;
                }
            }
        }
    }

    CloseHandle( hProcess );

    vprocs.push_back(pl);

    size_t len = strlen(ppn);
    if (len > max_name_len)
        max_name_len = len;
}

DWORD get_process_list(void)
{
    // Get the list of process identifiers.
    static DWORD aProcesses[MAX_PROCESSES], cbNeeded, cProcesses;
    unsigned int i;

    if ( !EnumProcesses( aProcesses, sizeof(aProcesses), &cbNeeded ) )
        return 0;

    // Calculate how many process identifiers were returned.
    cProcesses = cbNeeded / sizeof(DWORD);

    // Print the name and process identifier for each process.
    for ( i = 0; i < cProcesses; i++ )
        getProcessNameAndID( aProcesses[i] );

    return cProcesses;
}

void print_process_info( PROCLIST & pl )
{
    static char _s_buff[MAX_PATH];
    char * cp = _s_buff;
    strcpy(cp, pl.name);
    while (strlen(cp) < max_name_len)
        strcat(cp," "); // space out to MAX NAME LENGTH
    sprtf("%s PID=%04u Mods=%03d (%d)", cp, pl.id, pl.mod_count, pl.nm_off);
    if (VERB1) {
        if (pl.pl_thread_count) {
            sprtf(" %d threads.", pl.pl_thread_count);
            if (VERB9) {
                int i;
                sprtf("\n[v9] Threads:");
                for (i = 0; i < pl.pl_thread_count; i++)
                    sprtf(" %4u", pl.threads[i]);
            }
        }
    }
    sprtf("\n");
}

size_t instri( char * str, char * fnd )
{
   size_t iret = -1;
   if( _stricmp( str, fnd ) == 0 )
      iret = 0;
   else
   {
      size_t len = strlen(str);
      size_t fl = strlen(fnd);
      if(len && (len > fl))
      {
         if(fl == 0)
            iret = 0;   // everything matches nothing!!!
         else
         {
            size_t i, max;
            max = len - fl;
            for( i = 0; i <= max; i++ )
            {
               if( _strnicmp( &str[i], fnd, fl ) == 0 )
               {
                  iret = i;
                  break;
               }
            }
         }
      }
   }
   return iret;
}

void show_process_list(void)
{
    vPI it;
    size_t tot_threads = 0;
    sprtf("Listing of %d processes...\n", vprocs.size());
    if (sort_by_name)
        sort( vprocs.begin(), vprocs.end(), my_NameSort );
    else if (sort_by_pid)
        sort( vprocs.begin(), vprocs.end(), my_PIDSort );

    for ( it = vprocs.begin(); it != vprocs.end(); it++ ) {
        PROCLIST pl = *it;
        print_process_info( pl );
        tot_threads += pl.pl_thread_count;
    }
    sprtf("Done List of %d processes... ", vprocs.size());
    if (VERB1)
        sprtf("Total %d threads... ", tot_threads);
    sprtf("\n");
}


void find_process_name(void)
{
    vPI it;
    vNI in;
    size_t cnt = vnames.size();
    if (cnt) {
        int found = 0;
        sprtf("Searching %d processes...\n", vprocs.size());
        for ( it = vprocs.begin(); it != vprocs.end(); it++ )
        {
            PROCLIST pl = *it;
            for ( in = vnames.begin(); in != vnames.end(); in++ ) {
                char * cp = *in;
                if ( instri( &pl.name[0], cp ) != -1 ) {
                    print_process_info( pl );
                    found++;
                    break;
                }
            }
        }
        if (found) {
            sprtf("Found %d processes matching %d names... ", found, vnames.size());
        } else {
            sprtf("Nothing found matching %d names... ", vnames.size());
        }
        for ( in = vnames.begin(); in != vnames.end(); in++ ) {
            char * cp = *in;
            sprtf("[%s] ",cp);
        }
        sprtf("\n");
    } else
        show_process_list();
}



// from MSDN
BOOL GetProcessList( )
{
  HANDLE hProcessSnap;
  HANDLE hProcess;
  PROCESSENTRY32 pe32;
  DWORD dwPriorityClass;
    int ok = 1;
  // Take a snapshot of all processes in the system.
  hProcessSnap = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
  if( hProcessSnap == INVALID_HANDLE_VALUE )
  {
    printError( "CreateToolhelp32Snapshot (of processes)" );
    return( FALSE );
  }

  // Set the size of the structure before using it.
  pe32.dwSize = sizeof( PROCESSENTRY32 );

  // Retrieve information about the first process,
  // and exit if unsuccessful
  if( !Process32First( hProcessSnap, &pe32 ) )
  {
    printError( "Process32First" );  // Show cause of failure
    CloseHandle( hProcessSnap );     // Must clean up the snapshot object!
    return( FALSE );
  }

  PROCLIST pl;
  char * ppn = &pl.name[0];

  // Now walk the snapshot of processes, and
  // display information about each process in turn
  do
  {
      pl.id = pe32.th32ProcessID;
      pl.mod_count = (DWORD)-1;
      pl.nm_off = process_counter;
      pl.pl_thread_count = 0;

      strcpy( ppn, pe32.szExeFile );
      process_counter++;
    sprtf( "\n\n=====================================================" );
    sprtf( "\n%3d: PROCESS NAME:  %s", process_counter, pe32.szExeFile );
    sprtf( "\n-----------------------------------------------------" );
    // Retrieve the priority class.
    dwPriorityClass = 0;
    hProcess = OpenProcess( PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID );
    ok = 1;
    if( hProcess == NULL ) {
        hProcess = OpenProcess( PROCESS_QUERY_INFORMATION, FALSE, pe32.th32ProcessID );
        if (hProcess == NULL) {
            ok = 0;
            printError( "OpenProcess" );
        }
    }
    if (ok)
    {
      dwPriorityClass = GetPriorityClass( hProcess );
      if( !dwPriorityClass )
        printError( "GetPriorityClass" );
      CloseHandle( hProcess );
    }

    sprtf( "\n  process ID        = 0x%08X", pe32.th32ProcessID );
    sprtf( "  parent process ID = 0x%08X", pe32.th32ParentProcessID );
    sprtf( "\n  Priority Base     = %d", pe32.pcPriClassBase );
    if( dwPriorityClass )
      sprtf( "  Priority Class    = %d", dwPriorityClass );
    sprtf( "\n  thread count      = %d",   pe32.cntThreads );

    // List the modules and threads associated with this process
    pl.mod_count = ListProcessModules( pe32.th32ProcessID );

    pl.pl_thread_count = ListProcessThreads( pe32.th32ProcessID, &pl.threads[0] );

    vprocs.push_back(pl);
    size_t len = strlen(ppn);
    if (len > max_name_len)
        max_name_len = len;

  } while( Process32Next( hProcessSnap, &pe32 ) );

  CloseHandle( hProcessSnap );
  sprtf("\nListed %d processes...\n", process_counter);
  return( TRUE );
}

int ListProcessModules( DWORD dwPID )
{
  HANDLE hModuleSnap = INVALID_HANDLE_VALUE;
  MODULEENTRY32 me32;
  int module_count = 0;

  // Take a snapshot of all modules in the specified process.
  hModuleSnap = CreateToolhelp32Snapshot( TH32CS_SNAPMODULE, dwPID );
  if( hModuleSnap == INVALID_HANDLE_VALUE )
  {
    printError( "CreateToolhelp32Snapshot (of modules)" );
    return -1;
  }

  // Set the size of the structure before using it.
  me32.dwSize = sizeof( MODULEENTRY32 );

  // Retrieve information about the first module,
  // and exit if unsuccessful
  if( !Module32First( hModuleSnap, &me32 ) )
  {
    printError( "Module32First" );  // Show cause of failure
    CloseHandle( hModuleSnap );     // Must clean up the snapshot object!
    return -1;
  }

  // Now walk the module list of the process,
  // and display information about each module
  do
  {
      module_count++;
      sprtf( "\n%3d: MODULE NAME:     %s", module_count,  me32.szModule );
    sprtf( "  process ID     = 0x%08X",         me32.th32ProcessID );
    sprtf( "\n     executable     = %s",             me32.szExePath );
    sprtf( "\n     ref count (g)  =     0x%04X",     me32.GlblcntUsage );
    sprtf( "  ref count (p)  =     0x%04X",     me32.ProccntUsage );
    sprtf( "\n     base address   = 0x%08X", (DWORD) me32.modBaseAddr );
    sprtf( "  base size      = %d",             me32.modBaseSize );

  } while( Module32Next( hModuleSnap, &me32 ) );

  CloseHandle( hModuleSnap );
  if (module_count)
      sprtf("\nListed %d modules, loaded by PID 0x%08X", module_count, dwPID);
  return module_count;
}

int GetProcessThreadCount( DWORD dwOwnerPID, DWORD * ptid ) 
{
    HANDLE hThreadSnap = INVALID_HANDLE_VALUE; 
    THREADENTRY32 te32;
    int thread_count = 0;
    // Take a snapshot of all running threads  
    hThreadSnap = CreateToolhelp32Snapshot( TH32CS_SNAPTHREAD, 0 );
    if( hThreadSnap == INVALID_HANDLE_VALUE )
        return 0; 
    // Fill in the size of the structure before using it. 
    te32.dwSize = sizeof(THREADENTRY32 ); 
    // Retrieve information about the first thread,
    // and exit if unsuccessful
    if( !Thread32First( hThreadSnap, &te32 ) )  {
        // printError( "Thread32First" );  // Show cause of failure
        CloseHandle( hThreadSnap );     // Must clean up the snapshot object!
        return 0;
    }

    // Now walk the thread list of the system,
    // and display information about each thread
    // associated with the specified process
    do {
        if( te32.th32OwnerProcessID == dwOwnerPID ) {
            if (thread_count < MAX_THREADS)
                ptid[thread_count] = te32.th32ThreadID;
            thread_count++;
        }
    } while( Thread32Next(hThreadSnap, &te32 ) );
    CloseHandle( hThreadSnap );
    return thread_count;
}

int ListProcessThreads( DWORD dwOwnerPID, DWORD * ptid ) 
{ 
  HANDLE hThreadSnap = INVALID_HANDLE_VALUE; 
  THREADENTRY32 te32; 
  int thread_count = 0;
  // Take a snapshot of all running threads  
  hThreadSnap = CreateToolhelp32Snapshot( TH32CS_SNAPTHREAD, 0 ); 
  if( hThreadSnap == INVALID_HANDLE_VALUE ) 
    return -1; 
  // Fill in the size of the structure before using it. 
  te32.dwSize = sizeof(THREADENTRY32 ); 
  // Retrieve information about the first thread,
  // and exit if unsuccessful
  if( !Thread32First( hThreadSnap, &te32 ) ) 
  {
    printError( "Thread32First" );  // Show cause of failure
    CloseHandle( hThreadSnap );     // Must clean up the snapshot object!
    return -1;
  }

  // Now walk the thread list of the system,
  // and display information about each thread
  // associated with the specified process
  do 
  { 
    if( te32.th32OwnerProcessID == dwOwnerPID )
    {
        if (thread_count < MAX_THREADS)
            ptid[thread_count] = te32.th32ThreadID;
        thread_count++;
        sprtf( "\n%3d: THREAD ID      = 0x%08X", thread_count, te32.th32ThreadID ); 
      sprtf( "\n     base priority  = %d", te32.tpBasePri ); 
      sprtf( "  delta priority = %d", te32.tpDeltaPri ); 
    }
  } while( Thread32Next(hThreadSnap, &te32 ) ); 

  CloseHandle( hThreadSnap );
  if (thread_count)
      sprtf("\nListed %d threads, with owner PID 0x%08X", thread_count, dwOwnerPID); 
  return thread_count;
}

void printError( TCHAR* msg )
{
  DWORD eNum;
  TCHAR sysMsg[256];
  TCHAR* p;

  eNum = GetLastError( );
  FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
         NULL, eNum,
         MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
         sysMsg, 256, NULL );

  // Trim the end of the line and terminate it with a null
  p = sysMsg;

  while( ( *p > 31 ) || ( *p == 9 ) )
    ++p;

  do { *p-- = 0; } while( ( p >= sysMsg ) &&
                          ( ( *p == '.' ) || ( *p < 33 ) ) );

  // Display the message
  sprtf( "\n  WARNING: %s failed with error %d (%s)", msg, eNum, sysMsg );
}

// priviledges???
BOOL SetPrivilege(
    HANDLE hToken,          // access token handle
    LPCTSTR lpszPrivilege,  // name of privilege to enable/disable
    BOOL bEnablePrivilege   // to enable or disable privilege
    ) 
{
    TOKEN_PRIVILEGES tp;
    LUID luid;

    if ( !LookupPrivilegeValue( 
        NULL,            // lookup privilege on local system
        lpszPrivilege,   // privilege to lookup 
        &luid ) )        // receives LUID of privilege
    {
        sprtf("LookupPrivilegeValue error: %u\n", GetLastError() ); 
        return FALSE; 
    }

    tp.PrivilegeCount = 1;
    tp.Privileges[0].Luid = luid;
    if (bEnablePrivilege)
        tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
    else
        tp.Privileges[0].Attributes = 0;

    // Enable the privilege or disable all privileges.

    if ( !AdjustTokenPrivileges(
       hToken, 
       FALSE, 
       &tp, 
       sizeof(TOKEN_PRIVILEGES), 
       (PTOKEN_PRIVILEGES) NULL, 
       (PDWORD) NULL) )
    {
        sprtf("AdjustTokenPrivileges error: %u\n", GetLastError() ); 
        return FALSE; 
    } 

    if (GetLastError() == ERROR_NOT_ALL_ASSIGNED)
    {
        sprtf("The token does not have the specified privilege. \n");
        return FALSE;
    } 

    return TRUE;
}

BOOL Enable_SeDebugPrivilege( HANDLE hToken )
{
    return SetPrivilege( hToken, "SeDebugPrivilege", TRUE );
}

// pppppppppppppppppppppppppppppppppppppppp

void show_help(char * pname)
{
    sprtf("%s, version %s, compiled on %s, at %s\n",
        get_last_name_ptr(pname), PS_VERSION, __DATE__, __TIME__ );
    sprtf("Usage: [options] [name1 [name2 [...]]]\n");
    sprtf("Options:\n");
    sprtf(" --help  (-? or -h) = This help, and exit 0.\n");
    sprtf(" --all         (-a) = Print out the full list of processes.\n");
    sprtf(" --debug       (-d) = Set debug on. (def=%s)\n", (enable_debug ? "On" : "Off"));
    sprtf(" --sort        (-s) = Sort by Name. (def=%s)\n", (sort_by_name ? "On" : "Off"));
    sprtf(" --SORT        (-S) = Sort by PID. (def=%s)\n", (sort_by_pid ? "On" : "Off"));
    sprtf(" --verbose     (-v) = Bump verbosity. (def=%d)\n", verbose);
    sprtf("If not -all, then a simple list of process names, and PID.\n");
    sprtf("If name(s) given, then only those matching are listed.\n");
}

// ===== program entry =====

int main(int argc, char * argv[])
{
    int iret = 0;
    int i, ncnt;
    char * arg;
    char c;
    ncnt = 0;
    for ( i = 1; i < argc; i++ ) {
        arg = argv[i];
        c = *arg;
        if ( c == '-' ) {
            arg++;
            while (*arg == '-') arg++;
            c = *arg;
            if (( c == '?' )||( c == 'h' )) {
                show_help( argv[0] );
                return 0;
            } else if (c == 's') {
                sort_by_name = 1;
                sprtf("Sorting by name ON\n");
            } else if (c == 'S') {
                sort_by_pid = 1;
                sprtf("Sorting by PID ON\n");
            } else if (c == 'd') {
                enable_debug = 1;
                sprtf("Set debug ON\n");
            } else if (c == 'v') {
                if (is_digits(&arg[1])) {
                    verbose = atoi(&arg[1]);
                } else {
                    while (*arg == 'v') {
                        verbose++;
                        arg++;
                    }
                }
                sprtf("Set verbosity = %d\n", verbose);
            } else if ((strcmp(arg,"all") == 0)||(*arg == 'a')) {
                show_all++;
            } else {
                arg = argv[i];
                sprtf("ERROR: Unknown argument [%s]! Aborting\n", arg );
                return 1;
            }
        } else {
            vnames.push_back(arg);
            sprtf("Find a match for [%s]\n", arg);
            ncnt++;
        }
    }

    //if (VERB9)
    //    main_enum_process();

    if (show_all) {
        sprtf("Showing full list of processes...\n");
        if ( GetProcessList() ) {
           find_process_name();
        } else {
            sprtf("Failed to get process list!\n");
            iret = 1;
        }
    } else {
        if ( get_process_list() ) {
           find_process_name();
        } else {
            iret = 1;
            sprtf("Failed to get process list!\n");
        }
    }
    if (VERB1 || show_all)
        sprtf("Log output to file [%s], Exit %d\n", get_log_name(), iret);

	return iret;
}

// alternative
// from :
// To ensure correct resolution of symbols, add Psapi.lib to TARGETLIBS
// and compile with -DPSAPI_VERSION=1

void PrintProcessNameAndID( DWORD processID )
{
    TCHAR szProcessName[MAX_PATH] = TEXT("<unknown>");

    // Get a handle to the process.
    HANDLE hProcess = OpenProcess( PROCESS_QUERY_INFORMATION |
                                   PROCESS_VM_READ,
                                   FALSE, processID );
    // Get the process name.
    if (NULL != hProcess )
    {
        HMODULE hMod;
        DWORD cbNeeded;

        if ( EnumProcessModules( hProcess, &hMod, sizeof(hMod), 
             &cbNeeded) )
        {
            GetModuleBaseName( hProcess, hMod, szProcessName, 
                               sizeof(szProcessName)/sizeof(TCHAR) );
        }
    }

    while(strlen(szProcessName) < MIN_PROCESS_NAME)
        strcat(szProcessName," ");

    // Print the process name and identifier.
    _tprintf( TEXT("%s PID: %6u\n"), szProcessName, processID );

    // Release the handle to the process.
    CloseHandle( hProcess );
}

// only done in -v9 case... as an initial list
int main_enum_process( void )
{
    // Get the list of process identifiers.
    DWORD cbNeeded, cProcesses;
    unsigned int i;
    size_t cnt = 0;

    ZeroMemory( &aProcesses[0], sizeof(aProcesses)); /* zero the pad */
    if ( !EnumProcesses( aProcesses, sizeof(aProcesses), &cbNeeded ) ) {
        return 1;
    }

    // Calculate how many process identifiers were returned.
    cProcesses = cbNeeded / sizeof(DWORD);

    // Print the name and process identifier for each process.
    sprtf("[v9] List of %d processes...\n", cProcesses );
    for ( i = 0; i < cProcesses; i++ )
    {
        if( aProcesses[i] != 0 )
        {
            cnt++;
            PrintProcessNameAndID( aProcesses[i] );
        }
    }
    sprtf("[v9] Done list of %d processes...\n", cnt );
    return 0;
}


// eof - ps.cxx ===========
