// utils.cxx
//
// Written by Geoff R. McLane, started February 2011.
//
// Copyright (C) 2011 - ????  Geoff R. McLane  
//    - http://geoffair.org - reports@geoffair.info -
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// $Id$
//

#include <string.h>
#include "utils.hxx"

char * get_last_name_ptr( char * pname )
{
    char * cp = pname;
    size_t len = strlen(pname);
    size_t i;
    int c;
    for (i = 0; i < len; i++)
    {
        c = pname[i];
        if ((( c == '/' )||( c == '\\' )) &&
            ( (i + 1) < len )) {
                cp = &pname[i+1];
        }
    }
    return cp;
}

int is_digits(char * pt)
{
    size_t len = strlen(pt);
    size_t i;
    if (len == 0)
        return 0;
    for (i = 0; i < len; i++)
    {
        if (!ISDIGIT(pt[i]))
            return 0;
    }
    return 1;
}

// eof - utils.cxx

