// poly-paint.cxx

#include "poly-view.h"
#include "poly-utils.hxx"
#include "load-poly.hxx"
#include "parseargs.h"

#define  DEFAULT_ZOOM   0.00003

double current_zoom = DEFAULT_ZOOM;
//double current_zoom = 0.000015;
//double current_zoom = 0.000013;
//double current_zoom = 0.01;
double zoom_change = 5E-07;

bool modify_xy = false;

static char _s_tmpbuf[1024];

COLORREF crGrid = RGB(90,90,90);
COLORREF crBox = RGB(190,190,190);
HPEN  hpGrid = NULL;
HFONT hfCN8 = NULL;
HPEN  hpBox = NULL;

#define  MX_COLORS   3

COLORREF colors[MX_COLORS] = {
   RGB(255,0,0),
   RGB(0,0,255),
   RGB(0,255,0)
};

void Increment_ZOOM( void )
{
   current_zoom += zoom_change;
}
void Decement_ZOOM( void )
{
   current_zoom -= zoom_change;
}
void Restore_ZOOM( void )
{
   current_zoom = DEFAULT_ZOOM;
}

int   next_color = 0;
COLORREF get_next_color( void )
{
   COLORREF cr = colors[next_color];
   next_color++;
   if( next_color >= MX_COLORS )
      next_color = 0;
   return cr;
}


HFONT Get_CN8_Font( HDC hdc )
{
   LOGFONT lf;
   LOGFONT * plf = &lf;
   HFONT hf = hfCN8;
   if(hf)
      return hf;
   ZeroMemory( plf, sizeof(LOGFONT) );
   plf->lfHeight = -MulDiv( 8, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
   strcpy( &plf->lfFaceName[0], "Courier New" );
   //plf->lfWeight = FW_BOLD;   // set BOLD font
   hf = CreateFontIndirect( plf );
   hfCN8 = hf;
   return hf;
}

HPEN Get_GRID_Pen( void )
{
   if( hpGrid )
      return hpGrid;
   hpGrid = CreatePen( PS_SOLID, // int fnPenStyle, 
      1, // int nWidth, 
      crGrid );   // COLORREF crColor
   return hpGrid;
}

HPEN Get_BOX_Pen( void )
{
   if( hpBox )
      return hpBox;
   hpBox = CreatePen( PS_DASH, // int fnPenStyle, 
      1, // int nWidth, 
      crBox );   // COLORREF crColor
   return hpBox;
}


void draw_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   MoveToEx( hdc, x1, y1, NULL ); // start
   LineTo( hdc, x2, y2 ); // to center bottom
}

int get_steps( double min, double max, int msteps )
{
   int step = 1;
   int   scnt;
   while(msteps) {
      int imin = (int)min;
      if( (double)imin < min )
         imin++;
      scnt = 0;
      while((double)imin < max) {
         scnt++;
         imin += step;
      }
      if( scnt > msteps )
         step++;
      else
         return step;
   }
   return step;
}

void get_ll2pt( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double * px_pixel, double * py_pixel )
{
   win_ll2pt( obj_latr, obj_lonr,
      cent_latr, cent_lonr,
      map_size,  map_zoom,
      px_pixel, py_pixel );
   sprtf( "lat,lon %0.6f,%0.6f yielded x,y %0.2f,%0.2f\n",
      obj_latr, obj_lonr, *px_pixel, *py_pixel );
}

void paint_min_max_box( HDC hdc, PRECT prc, double map_size,
                        double max_lat, double max_lon,
                        double min_lat, double min_lon,
                        double c_lat,   double c_lon )
{
   double dx,dy;
   int x, y, last_x, last_y;
   sprtf( "Paint box lon,lat MIN %0.6f,%0.6f MAX %0.6f,%0.6f\n",
      min_lon, min_lat, max_lon, max_lat );
   // fixed max_lat
   get_ll2pt( max_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( max_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );
   // fixed min_lat
   get_ll2pt( min_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );

   // fixed max_lon
   get_ll2pt( max_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );

   // fixed min_lon
   get_ll2pt( max_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );
}

void paint_bounding_box( HDC hdc, PRECT pmm )
{
   HPEN hp = Get_BOX_Pen();
   HPEN hpOld;

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   // top line
   draw_line( hdc, pmm->left, pmm->top, pmm->right, pmm->top );
   // right side
   draw_line( hdc, pmm->right, pmm->top, pmm->right, pmm->bottom );
   // bottom side
   draw_line( hdc, pmm->left, pmm->bottom, pmm->right, pmm->bottom );
   // left side
   draw_line( hdc, pmm->left, pmm->top, pmm->left, pmm->bottom );

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

void paint_lat_lon_grid( HDC hdc, double c_lon, double c_lat,
                        double map_size, PRECT prc )
{
   COLORREF crText = RGB(90,90,90);
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   HPEN hpGrid = Get_GRID_Pen();
   HPEN hpOld;
   double dx, dy;
   double dlon, dlat;
   double rdx,rdy;
   double min_slat, max_slat, min_slon, max_slon;
   RECT  rc = *prc;
   int   x, y;
   int   last_x, last_y;

   min_slat = 2000.0;
   max_slat = -2000.0;
   min_slon = 2000.0;
   max_slon = -2000.0;
            SIZE sz;
            POINT pT;
            char * ps = _s_tmpbuf;
            int   iLen;

            sprtf( "Paint: center lon,lat %0.4f,%0.4f, size %f, zoom %f\n",
               c_lon, c_lat, map_size, current_zoom );
            crOld = SetTextColor( hdc, crText );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hf);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpGrid);

            // get screen extents
            // =========================================
            dx = 0.0;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = (double) rc.right;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = (double) rc.right;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = rc.bottom - sz.cy - 2;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = 0.0;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = rc.bottom - sz.cy;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;
            // =========================================

            int step_lat = get_steps( min_slat, max_slat, 5 );
            int step_lon = get_steps( min_slon, max_slon, 5 );

            int imin_lon = (int)min_slon;
            if((double)imin_lon < min_slon)
               imin_lon++;

            int imin_lat = (int)min_slat;
            if( (double)imin_lat < min_slat )
               imin_lat++;

            if(( (max_slon - min_slon) > 1.0 ) && (step_lon > 0) )
            {
               while((double)imin_lon < max_slon) {
                  get_ll2pt( max_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( min_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lon %d from %d,%d to %d,%d\n",
                     imin_lon, last_x, last_y, x, y );
                  imin_lon += step_lon;
               }
            }
            if(( (max_slat - min_slat) > 1.0 ) && (step_lat > 0))
            {
               while((double)imin_lat < max_slat) {
                  get_ll2pt( (double)imin_lat, max_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( (double)imin_lat, min_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lat %d from %d,%d to %d,%d\n",
                     imin_lat, last_x, last_y, x, y );
                  imin_lat += step_lat;
               }
            }
            crOld = SetTextColor( hdc, crOld );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hfOld);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpOld);
}

//	SetBkColor(crOldBack);
//	oldcr = SetTextColor(hdc, cr);
void paint_poly( HWND hwnd, HDC hdc )
{
   RECT rc;
   COLORREF crText = RGB(90,90,90);
   COLORREF crOld;
   TGPolyLoad * polyload = NULL;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   HPEN hpGrid = Get_GRID_Pen();
   HPEN hpOld;
   RECT mm;
   int points_painted = 0;
   double min_slat, max_slat, min_slon, max_slon;
   double map_size = 600.0;
   int polys_painted = 0;
   double c_lat = 0.0;
   double c_lon = 0.0;

   GetClientRect( hwnd, &rc );
   sprtf( "\nPaint: Got window size x,y [%d,%d,%d,%d]\n", rc.left, rc.top, rc.right, rc.bottom  );
   if( !done_arguments ) {
      sprtf("Not done arguments...\n");
      return;
   }

   min_slat = 2000.0;
   max_slat = -2000.0;
   min_slon = 2000.0;
   max_slon = -2000.0;
   mm.bottom = -10000;
   mm.left   =  10000;
   mm.right  = -10000;
   mm.top    =  10000;
   if( rc.right > rc.bottom )
      map_size = (double)rc.right;
   else
      map_size = (double)rc.bottom;

   next_color = 0;
   points_painted = 0;
   polyload = get_first_loaded_poly();
   while( polyload ) {
      PPolyCounter ppc = Get_Poly_Counts();
      COLORREF cr = get_next_color();  //RGB(255,0,0);
      if ( ppc->total )
      {
         double dx, dy;
         int x, y, last_x, last_y;
         double dlon, dlat, rdx, rdy;
         polys_painted++;

         if( polys_painted == 1 ) {
            //double min_lat, max_lat, min_lon, max_lon;
            c_lon = ppc->pcenter.lon();
            c_lat = ppc->pcenter.lat();
            //double xdist = ppc->pdist.lon();
            //double ydist = ppc->pdist.lat();
            //min_lat = ppc->pmin.lat();
            //min_lon = ppc->pmin.lon();
            //max_lat = ppc->pmax.lat();
            //max_lon = ppc->pmax.lon();
            //paint_lat_lon_grid( hdc, c_lon, c_lat );
            SIZE sz;
            POINT pT;
            char * ps = _s_tmpbuf;
            int   iLen;

            sprtf( "Paint: center lon,lat %0.4f,%0.4f, size %f, zoom %f\n",
               c_lon, c_lat, map_size, current_zoom );
            crOld = SetTextColor( hdc, crText );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hf);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpGrid);

            // get screen extents
            // =========================================
            dx = 0.0;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = (double) rc.right;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = (double) rc.right;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = rc.bottom - sz.cy - 2;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            dx = 0.0;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = rc.bottom - sz.cy;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;
            // =========================================

            int step_lat = get_steps( min_slat, max_slat, 5 );
            int step_lon = get_steps( min_slon, max_slon, 5 );

            int imin_lon = (int)min_slon;
            if((double)imin_lon < min_slon)
               imin_lon++;

            int imin_lat = (int)min_slat;
            if( (double)imin_lat < min_slat )
               imin_lat++;

            if(( (max_slon - min_slon) > 1.0 ) && (step_lon > 0) )
            {
               while((double)imin_lon < max_slon) {
                  get_ll2pt( max_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( min_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lon %d from %d,%d to %d,%d\n",
                     imin_lon, last_x, last_y, x, y );
                  imin_lon += step_lon;
               }
            }
            if(( (max_slat - min_slat) > 1.0 ) && (step_lat > 0))
            {
               while((double)imin_lat < max_slat) {
                  get_ll2pt( (double)imin_lat, max_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( (double)imin_lat, min_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lat %d from %d,%d to %d,%d\n",
                     imin_lat, last_x, last_y, x, y );
                  imin_lat += step_lat;
               }
            }
            crOld = SetTextColor( hdc, crOld );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hfOld);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpOld);
         } // only painted for FIRST poly

         // === BEGIN PAINT POINTS ===
         void * vp = get_first_point( &dlon, &dlat );
         if ( vp ) {
            last_x = -5000;
            last_y = -5000;
            do {
               win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
               x = (int)( dx + 0.5 );
               y = (int)( dy + 0.5 );
               if(( x > rc.left  ) &&
                  ( x < rc.right ) &&
                  ( y > rc.top   ) &&
                  ( y < rc.bottom) ) {
                  // point is in screen RANGE
                  if(( x != last_x ) || ( y != last_y )) {
                     SetPixel( hdc, x, y, cr );
                     points_painted++;
                     last_x = x;
                     last_y = y;
                     if( x < mm.left )
                        mm.left = x;
                     if( x > mm.right )
                        mm.right = x;
                     if( y < mm.top )
                        mm.top = y;
                     if( y > mm.bottom )
                        mm.bottom = y;
                  }
               }
            } while (( vp = get_next_point( vp, &dlon, &dlat ) ) != NULL );
         }  // if vp - got first point
         // === END PAINT POINTS ===
      }
      polyload = get_next_loaded_poly();
   }

   if( points_painted ) {
      paint_bounding_box( hdc, &mm );
   }
}

// eof - poly-paint.cxx
