// poly-view.cpp : Defines the entry point for the application.
//

#include "poly-view.hxx"
#include "poly-paint.hxx"
#include "poly-load.hxx"
#include "poly-ini.hxx"
#include "poly-utils.hxx"
#include "poly-bmp.hxx"
#include "poly-png.hxx"
#include "poly-ptools.hxx"
#include "poly-dlgs.hxx"
#include "poly-timer.hxx"
#include "poly-context.hxx"
#include "poly-menu.hxx"
#include "poly-text.hxx"

#ifdef _WIN32_WINNT
#pragma message ("_WIN32_WINNT is defined as " MY_STGIZE(_WIN32_WINNT) "!")
#endif
#define USE_NEW_PNG2

extern VOID UpdateWP( HWND hWnd );
extern void clean_up_paint_tools(void);
extern void clear_all_op_lists( void ); // clear_ops_list();
extern void set_mapobj_mapsize(int size);
extern double get_distance_between( int left, int top,
                             int right, int bottom,
                             double * pdirection );
extern void write_out_zoom(void);
extern void clear_tiles_loaded(void);
extern void show_memory_usage(void);
extern int get_page_key_steps(void);
extern void write_out_center(void);

// forward references
VOID Do_IDM_FILL_POLY(HWND hWnd);
VOID Do_IDM_FILL_SCENE(HWND hWnd);
VOID Do_F3_Key( HWND hWnd );
VOID Do_IDM_PAINT_X(HWND hWnd);
VOID Do_IDM_PAINT_FIT_POINTS(HWND hWnd);
VOID Do_IDM_PAINT_FIT_TRIS(HWND hWnd);


#define MAX_LOADSTRING 100
#define PAINT_TO_MEM

// add a timer message
#define ADD_TIMER1
#define TIMER_ID1 1234
#define TIMER_INTERVAL1 200
UINT uiTimer1;
// ====================

#define  MB(a) MessageBox( NULL, a, "CRITICAL ERROR", MB_OK | MB_ICONINFORMATION )

// Global Variables:
HWND        g_hWnd  = NULL;      // main window handle
HINSTANCE   g_hInst = NULL;		// current instance
BOOL        g_bAShiftDown = FALSE;   // shift key DOWN (VK_SHIFT)
BOOL        g_bCtrlDown = FALSE;    // CTRL key (VK_CONTROL)
BOOL        g_bAltDown = FALSE;     // ALT key  (VK_MENU)
SIZE        g_wm_size;
RECT        g_rcClient;
int         g_in_exit_process = 0;

TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM  MyRegisterClass(HINSTANCE hInstance);
BOOL  InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
VOID Do_WM_KEYDOWN( HWND hWnd, WPARAM wParam, LPARAM lParam );
VOID Do_WM_KEYUP( HWND hWnd, WPARAM wParam, LPARAM lParam );
VOID Do_WM_CHAR( HWND hWnd, WPARAM wParam, LPARAM lParam );

void do_exit_process(void)
{
   g_in_exit_process = 1;
   WriteINI();
   clear_tiles_loaded();
   delete_loaded_poly();
   clean_up_paint_tools();
   clear_all_op_lists();    // clear_ops_list(); for both paint and accum
   show_memory_usage();
}

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: Place code here.
    MSG msg;
    HACCEL hAccelTable;

    set_log_file("temppv2.txt");
    open_log_file();

    init_poly_load(); // some intial defaults

    ReadINI();        // may be changed by INI

    // Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_POLYVIEW, szWindowClass, MAX_LOADSTRING);

	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) {
        close_log_file();
        MB( "InitInstance FAILED! Aborting ..." );
		return FALSE;
	}

   // and INI items may be changed by comand line argument
   if ( ParseArgs(__argc, __argv) ) {
      delete_loaded_poly();
      close_log_file();
      MB( "Command line error! Aborting ..." );
      return FALSE;
   } else {
      PostMessage( g_hWnd, WM_COMMAND, IDM_REPAINT, 0 );
   }

#ifdef	ADD_TIMER1
   if( !(uiTimer1 = SetTimer( g_hWnd, TIMER_ID1, TIMER_INTERVAL1, NULL)) ) {
      MB( "Failed in get Timer! Aborting ..." );
      return FALSE;
	}
#endif	/* ADD_TIMER1 */

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_POLYVIEW));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

    do_exit_process();
    sprtf( "Closing log file...\n" );
    close_log_file();
    set_log_file("tempafter.txt");
    return (int) msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_POLYVIEW));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_POLYVIEW);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

// int GetDeviceCaps( HDC hdc, [HORZRES and VERTRES] ), in pixel
BOOL Get_Screen_Dimensions( PSIZE psz )
{
   SIZE sz;
   HDC hdc = GetDC(NULL);  // get HDC of SCREEN
   if(hdc)
   {
      sz.cx = GetDeviceCaps( hdc, HORZRES );
      sz.cy = GetDeviceCaps( hdc, VERTRES );
      ReleaseDC(NULL,hdc);
      if( sz.cx && sz.cy ) {
         psz->cx = sz.cx;
         psz->cy = sz.cy;
         return TRUE;
      }
   }
   return FALSE;
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   SIZE  sz;
   g_hInst = hInstance; // Store instance handle in our global variable

   if ( Get_Screen_Dimensions( &sz ) ) {
      if(sz.cy < sz.cx)
         sz.cx = sz.cy;
      sz.cy = sz.cx;
      if(sz.cy > 654) {
         sz.cy = 654;
         sz.cx = 608;
      }
   } else {
      sz.cx = CW_USEDEFAULT;
      sz.cy = 0;
   }


   g_hWnd = CreateWindow(szWindowClass,
      szTitle,
      WS_OVERLAPPEDWINDOW,
      10,
      10,
      sz.cx,   // WIDTH
      sz.cy,   // HEIGHT
      NULL,
      NULL,
      hInstance,
      NULL);

   if (!g_hWnd) {
      return FALSE;
   }

   ShowWindow(g_hWnd, nCmdShow);
   UpdateWindow(g_hWnd);

   return TRUE;
}

void Do_InvalidateRect(void * vp)
{
   HWND hWnd;
   if(vp)
      hWnd = (HWND)vp;
   else
      hWnd = g_hWnd;
   paint_center_text( " < Moment... repainting... > " ); // paint line to screen
   //InvalidateRect(hWnd, NULL, TRUE);
   InvalidateRect(hWnd, NULL, FALSE);
}

void Post_Exit_Message(void) {
   PostMessage (g_hWnd, WM_COMMAND, IDM_EXIT, 0L);
}

int is_shift_down( void )
{
   if( g_bAShiftDown )
      return 1;
   return 0;
}
int is_ctrl_down( void )
{
   if( g_bCtrlDown )
      return 1;
   return 0;
}

VOID Do_WM_PAINT( HWND hWnd )
{
	PAINTSTRUCT ps;
	HDC hdc;
   hdc = BeginPaint(hWnd, &ps);
   PPPSET pps = init_act_paint_set();
   pps->hdc = hdc;
#ifdef   PAINT_TO_MEM
   // alias the hdc, paint, and swap
   HDC hdcMem = CreateCompatibleDC(hdc);
   BOOL DnPaint = FALSE;
   if( hdcMem ) {
      RECT rc;
      GetClientRect(hWnd, &rc );
      HBITMAP hbmWindow = CreateCompatibleBitmap(hdc, rc.right, rc.bottom );
      if(hbmWindow) {
         if ( SelectObject(hdcMem, hbmWindow) ) {
            FillRect( hdcMem, &rc, (HBRUSH)GetStockObject(WHITE_BRUSH) );
            pps->hdc = hdcMem;   // set the HDC to write to
            paint_polys();
            BitBlt( hdc,
               rc.left,
			      rc.top,
			      rc.right,
			      rc.bottom,
			      hdcMem,
			      0, 0,
               SRCCOPY );
            DnPaint = TRUE;
         }
         DeleteObject(hbmWindow);
      }
      DeleteDC(hdcMem);
   }
   if( !DnPaint ) {
      paint_polys();
   }
#else
   // directly paint to screen hdc
   paint_polys();
#endif
	EndPaint(hWnd, &ps);
}

LRESULT Do_WM_COMMAND(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   LRESULT lRes = 0;
	int wmId, wmEvent;
    PPolyGlobs ppg = get_poly_globs();
	wmId    = LOWORD(wParam);
	wmEvent = HIWORD(wParam);
	// Parse the menu selections:
	switch (wmId)
	{
	case IDM_ABOUT:
        Do_IDM_ABOUT( hWnd );
		break;
	case IDM_EXIT:
            sprtf( "\nIDM_EXIT: doing DestroyWindow(%#x)\n", hWnd );
            write_out_center();
            g_in_exit_process = 1;
            DestroyWindow(hWnd);
            break;
   case IDM_REPAINT:
      sprtf( "\nIDM_REPAINT: InvalidateRect(%#x)\n", hWnd );
      Do_InvalidateRect(hWnd);
      break;
   case IDM_ZOOM:
      sprtf( "\nIDM_ZOOM: Get NEW Zoom factor...\n" );
      Do_IDM_ZOOM(hWnd);
      break;
   case IDM_CENTER:
      sprtf( "\nIDM_CENTER: Get NEW center...\n" );
      Do_IDM_CENTER(hWnd);
      break;
   case IDM_CENTER2:
      sprtf( "\nIDM_CENTER2: Set NEW center...\n" );
      Do_IDM_CENTER2(hWnd);
      break;
   case IDM_FILL_POLY:
      sprtf( "\nIDM_FILL_POLY: Toggle fill polys...\n" );
      Do_IDM_FILL_POLY(hWnd);
      break;
   case IDM_FILL_SCENE:
      sprtf( "\nIDM_FILL_SCENE: Toggle fill polys...\n" );
      Do_IDM_FILL_SCENE(hWnd);
      break;
   case IDM_SCREEN_SNAP:
       sprtf( "\nIDM_SCREEN_SNAP: Write a PNG file of screen...\n" );
       Do_F3_Key( hWnd );
       break;
   case IDM_PAINT_X:
      sprtf( "\nIDM_FILL_SCENE: Toggle fill polys...\n" );
      Do_IDM_PAINT_X(hWnd);
      break;
   case IDM_PAINT_FIT_POINTS:
      sprtf( "\nIDM_PAINT_FIT_POINTS: Toggle paint fitted points...\n" );
      Do_IDM_PAINT_FIT_POINTS(hWnd);
      break;
   case IDM_PAINT_FIT_TRIS:
      sprtf( "\nIDM_PAINT_FIT_TRIS: Toggle paint fitted points...\n" );
      Do_IDM_PAINT_FIT_TRIS(hWnd);
      break;
   case IDM_PAINT_BUCKETS:
       if (ppg->g_paint_buckets)
           ppg->g_paint_buckets = 0;
       else
           ppg->g_paint_buckets = 1;
       sprtf("\nIDM_PAINT_BUCKET: Toggled paint bucket %s (%d)\n",
           ppg->g_paint_buckets ? "On" : "Off",
           ppg->g_bucket_count );
       Do_InvalidateRect(hWnd);
       break;
	default:
		lRes = DefWindowProc(hWnd, message, wParam, lParam);
      break;
	}
   return lRes;
}


VOID Do_WM_MOUSEMOVE( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   int xPos = LOWORD(lParam); // GET_X_LPARAM(lParam);
   int yPos = HIWORD(lParam); // GET_Y_LPARAM(lParam);
   int shift = is_shift_down();
   if(shift) {
      HDC hdc = GetDC(hWnd);
      if(hdc) {
         COLORREF cr = GetPixel(hdc,    // handle to DC
            xPos,  // x-coordinate of pixel
            yPos );  // y-coordinate of pixel
         paint_color_to_hdc(hdc, cr);
         ReleaseDC(hWnd,hdc);
      }
   }
   paint_mouse_coordinates( xPos, yPos, shift, (g_bCtrlDown ? 1 : 0) );
}

//SIZE g_wm_size;
//RECT g_rcClient;


// WM_SIZE
VOID Do_WM_SIZE( HWND hWnd, LPARAM lParam )
{
   g_wm_size.cx = LOWORD(lParam);
   g_wm_size.cy = HIWORD(lParam);   // width and height
   //SetScrollRanges(hWnd, LOWORD(lParam), HIWORD(lParam));
   GetClientRect( hWnd, &g_rcClient );
   int win_size = ((g_rcClient.right > g_rcClient.bottom) ?
      g_rcClient.right : g_rcClient.bottom );
   set_mapobj_mapsize(win_size);
   set_g_map_size( (double)win_size );
   UpdateWP( hWnd );
   double clon, clat;
   get_g_center( &clon, &clat );
   sprtf("WM_SIZE: set size = %d. center = %0.6f,%0.06f\n", win_size, clon, clat );
   //Do_ResizeStatus( hWnd );
}

static RECT rcClip = { 0, 0, 0, 0 };
static PRECT lpClipRect = &rcClip;
static RECT rcPrevClip;
void DrawSelect( HDC hDC, LPRECT lprcClip )
{
	char	szStr[80];
	DWORD	dwExt;
	int		x, y, nLen, dx, dy;
	HDC		hDCBits;
	HBITMAP	hBitmap, hOldmap;

	// Don't have anything to do if the rectangle is empty.
	if( ( hDC == 0 ) ||
		( lprcClip == 0 ) ||
		( IsRectEmpty( lprcClip ) ) )
		return;

	// Draw rectangular clip region
	PatBlt( hDC,
		lprcClip->left,
		lprcClip->top,
		lprcClip->right - lprcClip->left,
		1,
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->left,
		lprcClip->bottom,
		1,
		-(lprcClip->bottom - lprcClip->top),
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->right - 1,
		lprcClip->top,
		1,
		lprcClip->bottom - lprcClip->top,
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->right,
		lprcClip->bottom - 1,
		-(lprcClip->right - lprcClip->left),
		1,
		DSTINVERT );

	// Format the dimensions string
	sprintf( szStr,
		"%dx%d",
		(lprcClip->right - lprcClip->left),
		(lprcClip->bottom - lprcClip->top) );

	nLen = lstrlen( szStr );

	// and center it in the rectangle
   SIZE sz;
	GetTextExtentPoint32( hDC, szStr, nLen, &sz );
	dx      = sz.cx;
	dy      = sz.cy;
	x       = (lprcClip->right  + lprcClip->left - dx) / 2;
	y       = (lprcClip->bottom + lprcClip->top  - dy) / 2;

	hDCBits = CreateCompatibleDC( hDC );

	// Output the text to the DC
	SetTextColor( hDCBits, RGB(255, 255, 255) );
	SetBkColor(   hDCBits, RGB(  0,   0,   0) );

	hBitmap = CreateBitmap( dx, dy, 1, 1, NULL );
	if( hBitmap )
	{
		hOldmap = (HBITMAP)SelectObject( hDCBits, hBitmap );
		ExtTextOut( hDCBits, 0, 0, 0, NULL, szStr, nLen, NULL );
		BitBlt( hDC, x, y, dx, dy, hDCBits, 0, 0, SRCINVERT );
		SelectObject( hDCBits, hOldmap );
		DeleteObject( hBitmap );
	}

	DeleteDC( hDCBits );

	rcPrevClip.left   = lprcClip->left;
	rcPrevClip.top    = lprcClip->top;
	rcPrevClip.right  = lprcClip->right;
	rcPrevClip.bottom = lprcClip->bottom;

}

#define SWAP(x,y)   ((x)^=(y)^=(x)^=(y))
// Some useful macros.
#define MAX(a,b)     ((a) > (b) ? (a) : (b))
#define MIN(a,b)     ((a) < (b) ? (a) : (b))

int NormalizeRect (LPRECT lpRect)
{
   int   ret = 0;
   if (lpRect->right < lpRect->left) {
      SWAP (lpRect->right,lpRect->left);
      ret |= 1; //SWAP_LR;
   }

   if (lpRect->bottom < lpRect->top) {
      SWAP (lpRect->bottom,lpRect->top);
      ret |= 2; // SWAP_TB;
   }
   return ret;
}
extern void center_on_this( int left, int top, int right, int bottom );

void TrackMouse( HWND hWnd, int x, int y )
{

	HDC   hDC;
	MSG   msg;
	//POINT ptOrigin;
   POINT ptStart, ptSave;
	RECT  rcClient, rcLast;

	hDC = GetDC (hWnd);
	if( !hDC )
		return;

	SetCapture( hWnd );

	GetClientRect( hWnd, &rcClient );
   rcLast = *lpClipRect;
   int cxDIB = rcClient.right;
   int cyDIB = rcClient.bottom;
	// Get mouse coordinates relative to origin of DIB.  Then
	//  setup the clip rectangle accordingly (it already should
	//  contain the starting point in its top/left).
   //Dv_Set_Scroll_Origin( hWnd, hDC, &ptOrigin, &ptSave );
	// FIX981228 - This looks WRONG
	//lpClipRect->top   += ptOrigin.x;
	//lpClipRect->left  += ptOrigin.y;
	// Lets SWITCH IT and SEE
	//lpClipRect->left  += ptOrigin.x;
	//lpClipRect->top   += ptOrigin.y;
	lpClipRect->right  = lpClipRect->left = x;
	lpClipRect->bottom = lpClipRect->top  = y;

	ptStart.x          = lpClipRect->left;    // Need to remember the
	ptStart.y          = lpClipRect->top;     //  starting point.

	// ADD THE FIRST NEW CLIP, but will do nothing, since no width/height yet
   DrawSelect( hDC, lpClipRect );

	rcLast = *lpClipRect;
	// Eat mouse messages until a WM_LBUTTONUP is encountered.
	// Meanwhile continue to draw a rubberbanding rectangle
	// and display it's dimensions
	for( ;; )
	{

		// The WaitMessage function yields control to other threads
		// when a thread has no other messages in its message queue.
		// The WaitMessage function suspends the thread and does not
		// return until a new message is placed in the thread's
		// message queue. 
		WaitMessage();

		// PeekMessage Return Values
		// If a message is available, the return value is nonzero.
		if( PeekMessage( &msg, NULL, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE ) )
		{
			// Erase the OLD rectangle
         DrawSelect( hDC, lpClipRect );

			rcLast = *lpClipRect;

			// Determine new coordinates.
			lpClipRect->left   = ptStart.x;
			lpClipRect->top    = ptStart.y;

			lpClipRect->right  = LOWORD (msg.lParam); // + ptOrigin.x;
			lpClipRect->bottom = HIWORD (msg.lParam); // + ptOrigin.y;

			NormalizeRect( lpClipRect );

			// Keep the rectangle within the bounds of the DIB.
			lpClipRect->left   = MAX(lpClipRect->left,   0);
			lpClipRect->top    = MAX(lpClipRect->top,    0);
			lpClipRect->right  = MAX(lpClipRect->right,  0);
			lpClipRect->bottom = MAX(lpClipRect->bottom, 0);

			lpClipRect->left   = MIN(lpClipRect->left,   cxDIB);
			lpClipRect->top    = MIN(lpClipRect->top,    cyDIB);
			lpClipRect->right  = MIN(lpClipRect->right,  cxDIB);
			lpClipRect->bottom = MIN(lpClipRect->bottom, cyDIB);

			// Draw the NEW rectangle.
			DrawSelect( hDC, lpClipRect );

			// If the button is released, quit.
			if( msg.message == WM_LBUTTONUP )
			{
				// we have completed tracking
            DrawSelect( hDC, lpClipRect );   // remove out RECT
				break;
			}
		}
		else
			continue;

	}	// FOREVER

	// Clean up.
	ReleaseCapture();

   //Dv_Reset_Scroll_Origin( hDC, &ptSave );

	ReleaseDC( hWnd, hDC );

   center_on_this( lpClipRect->left, lpClipRect->top, lpClipRect->right, lpClipRect->bottom );

   Do_InvalidateRect( hWnd );

} // end - void TrackMouse (HWND hWnd, LPRECT lpClipRect, int cxDIB, int cyDIB)

// draw a diagonal line, and add lat.lon of ends, and distance, and direction
typedef struct tagDISTSTR {
   double dist;
   double heading;
   char	 szStr[264];
}DISTSTR, * PDISTSTR;

static DISTSTR diststr;

void DrawStretch( HDC hDC, LPRECT lprcClip )
{
	DWORD	   dwExt;
	int		x, y, nLen, dx, dy;
	HDC		hDCBits;
	HBITMAP	hBitmap, hOldmap;
   PDISTSTR pds = &diststr;
   char *   ps = &pds->szStr[0];

	// Don't have anything to do if the rectangle is empty.
	if( ( hDC == 0 ) ||
		( lprcClip == 0 ) ||
		( IsRectEmpty( lprcClip ) ) )
		return;

	// Draw rectangular clip region
	PatBlt( hDC,
		lprcClip->left,
		lprcClip->top,
		lprcClip->right - lprcClip->left,
		1,
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->left,
		lprcClip->bottom,
		1,
		-(lprcClip->bottom - lprcClip->top),
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->right - 1,
		lprcClip->top,
		1,
		lprcClip->bottom - lprcClip->top,
		DSTINVERT );

	PatBlt( hDC,
		lprcClip->right,
		lprcClip->bottom - 1,
		-(lprcClip->right - lprcClip->left),
		1,
		DSTINVERT );

	// Format the dimensions string
   pds->dist = get_distance_between( lprcClip->left, lprcClip->top,
      lprcClip->right, lprcClip->bottom, &pds->heading );

	nLen = sprintf( ps,
		" %0.6f %0.1f ",
      pds->dist, pds->heading );

   paint_center_bottom(ps);

	hDCBits = CreateCompatibleDC( hDC );
   if(hDCBits) {
	   // and center it in the rectangle
      SIZE sz;
	   GetTextExtentPoint32( hDC, ps, nLen, &sz );
	   dx      = sz.cx;  // length
	   dy      = sz.cy;  // height
	   x       = (lprcClip->right  + lprcClip->left - dx) / 2;
	   y       = (lprcClip->bottom + lprcClip->top  - dy) / 2;
	   // Output the text to the DC
	   SetTextColor( hDCBits, RGB(255, 255, 255) );
	   SetBkColor(   hDCBits, RGB(  0,   0,   0) );
	   hBitmap = CreateBitmap( dx, dy, 1, 1, NULL );
	   if( hBitmap ) {
         RECT rc;
         rc.left   = 0;
         rc.top    = 0;
         rc.right  = dx;
         rc.bottom = dy;
		   hOldmap = (HBITMAP)SelectObject( hDCBits, hBitmap );
		   ExtTextOut( hDCBits, 0, 0, 0, &rc, ps, nLen, NULL );
		   BitBlt( hDC, x, y, dx, dy, hDCBits, 0, 0, SRCINVERT );
		   SelectObject( hDCBits, hOldmap );
		   DeleteObject( hBitmap );
	   }
	   DeleteDC( hDCBits );
   }

	rcPrevClip.left   = lprcClip->left;
	rcPrevClip.top    = lprcClip->top;
	rcPrevClip.right  = lprcClip->right;
	rcPrevClip.bottom = lprcClip->bottom;

}

void TrackMouse2( HWND hWnd, int x, int y )
{

	HDC   hDC;
	MSG   msg;
	//POINT ptOrigin;
   POINT ptStart, ptSave;
	RECT  rcClient, rcLast;
   PDISTSTR pds = &diststr;

	hDC = GetDC (hWnd);
	if( !hDC )
		return;

	SetCapture( hWnd );

	GetClientRect( hWnd, &rcClient );
   rcLast = *lpClipRect;
   int cxDIB = rcClient.right;
   int cyDIB = rcClient.bottom;
	// Get mouse coordinates relative to origin of DIB.  Then
	//  setup the clip rectangle accordingly (it already should
	//  contain the starting point in its top/left).
   //Dv_Set_Scroll_Origin( hWnd, hDC, &ptOrigin, &ptSave );
	// FIX981228 - This looks WRONG
	//lpClipRect->top   += ptOrigin.x;
	//lpClipRect->left  += ptOrigin.y;
	// Lets SWITCH IT and SEE
	//lpClipRect->left  += ptOrigin.x;
	//lpClipRect->top   += ptOrigin.y;
	lpClipRect->right  = lpClipRect->left = x;
	lpClipRect->bottom = lpClipRect->top  = y;

	ptStart.x          = lpClipRect->left;    // Need to remember the
	ptStart.y          = lpClipRect->top;     //  starting point.

	// ADD THE FIRST NEW CLIP, but will do nothing, since no width/height yet
   DrawStretch( hDC, lpClipRect );

	rcLast = *lpClipRect;
	// Eat mouse messages until a WM_LBUTTONUP is encountered.
	// Meanwhile continue to draw a rubberbanding rectangle
	// and display it's dimensions
	for( ;; )
	{

		// The WaitMessage function yields control to other threads
		// when a thread has no other messages in its message queue.
		// The WaitMessage function suspends the thread and does not
		// return until a new message is placed in the thread's
		// message queue. 
		WaitMessage();

		// PeekMessage Return Values
		// If a message is available, the return value is nonzero.
		if( PeekMessage( &msg, NULL, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE ) )
		{
			// Erase the OLD rectangle
         DrawStretch( hDC, lpClipRect );

			rcLast = *lpClipRect;

			// Determine new coordinates.
			lpClipRect->left   = ptStart.x;
			lpClipRect->top    = ptStart.y;

			lpClipRect->right  = LOWORD (msg.lParam); // + ptOrigin.x;
			lpClipRect->bottom = HIWORD (msg.lParam); // + ptOrigin.y;

			NormalizeRect( lpClipRect );

			// Keep the rectangle within the bounds of the DIB.
			lpClipRect->left   = MAX(lpClipRect->left,   0);
			lpClipRect->top    = MAX(lpClipRect->top,    0);
			lpClipRect->right  = MAX(lpClipRect->right,  0);
			lpClipRect->bottom = MAX(lpClipRect->bottom, 0);

			lpClipRect->left   = MIN(lpClipRect->left,   cxDIB);
			lpClipRect->top    = MIN(lpClipRect->top,    cyDIB);
			lpClipRect->right  = MIN(lpClipRect->right,  cxDIB);
			lpClipRect->bottom = MIN(lpClipRect->bottom, cyDIB);

			// Draw the NEW rectangle.
			DrawStretch( hDC, lpClipRect );

			// If the button is released, quit.
			if( msg.message == WM_LBUTTONUP )
			{
				// we have completed tracking
            DrawStretch( hDC, lpClipRect );   // remove out RECT
				break;
			}
		}
		else
			continue;

	}	// FOREVER

	// Clean up.
	ReleaseCapture();

   //Dv_Reset_Scroll_Origin( hDC, &ptSave );

	ReleaseDC( hWnd, hDC );

   // output distance and direction
   double invers = ((pds->heading > 180.0) ?
      pds->heading - 180.0 : 180.0 - pds->heading);
   sprtf("DIST: %s (or %0.1f, %0.1f, %0.1f)\n", pds->szStr,
      (360.0 - pds->heading),
       invers, (360.0 - invers));

} // end - void TrackMouse2 (HWND hWnd, LPRECT lpClipRect, int cxDIB, int cyDIB)


VOID Do_WM_LBUTTONDOWN( HWND hWnd, LPARAM lParam )
{
   if( g_bAShiftDown ) {
      TrackMouse( hWnd, LOWORD(lParam), HIWORD(lParam) );
   } else {
      // show distance and 
      TrackMouse2( hWnd, LOWORD(lParam), HIWORD(lParam) );

   }
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   LRESULT lRes = 0;
	switch (message)
	{
    case WM_INITMENUPOPUP:
        lRes = Do_WM_INITMENUPOPUP( hWnd, wParam, lParam );
        break;
	case WM_COMMAND:
        lRes = Do_WM_COMMAND( hWnd, message, wParam, lParam );
		break;
	case WM_PAINT:
        Do_WM_PAINT( hWnd );
		break;
   case WM_KEYDOWN:
      Do_WM_KEYDOWN( hWnd, wParam, lParam );
      break;
   case WM_KEYUP:
      Do_WM_KEYUP( hWnd, wParam, lParam );
      break;
   case WM_CHAR:
      Do_WM_CHAR( hWnd, wParam, lParam );
      break;
   case WM_SIZE:
      Do_WM_SIZE( hWnd, lParam );
      break;

   case WM_LBUTTONDOWN:
      Do_WM_LBUTTONDOWN( hWnd, lParam );
      break;
   case WM_LBUTTONUP:
      break;
	//case WM_LBUTTONDBLCLK:
	//case WM_RBUTTONUP:
   case WM_CONTEXTMENU:
       Do_WM_CONTEXTMENU( hWnd, wParam, lParam );
       break;

   case WM_TIMER:
       Do_WM_TIMER( hWnd );
       break;
      
   case WM_MOUSEMOVE:
      Do_WM_MOUSEMOVE( hWnd, wParam, lParam );
      break;
#ifdef WM_MOUSEWHEEL
   case WM_MOUSEWHEEL:
       Do_WM_MOUSEWHEEL(hWnd, wParam, lParam);
       break;
#endif // #ifdef WM_MOUSEWHEEL

	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		lRes = DefWindowProc(hWnd, message, wParam, lParam);
      break;
	}
	return lRes;
}

void paint_center_to_center_bottom(void)
{
    char * cp = GetNxtBuf();
    double clon = get_g_center_lon();
    double clat = get_g_center_lat();
    sprintf(cp,"C=%0.6f,%0.6f", clon, clat);
    paint_center_bottom(cp);
}

VOID Do_F3_Key( HWND hWnd )
{
   int done_image = 0;
   paint_center_to_center_bottom();
   HDC hdc = GetDC(hWnd);
   PRECT prc  = get_client_prec();
   int width  = prc->right;
   int height = prc->bottom;
   char * nxtfile = Get_Next_FileName( "temppng", "png" );
   if(hdc) {
      // DC to bitmap
      HDC hdcMem = CreateCompatibleDC(hdc);
      if(hdcMem) {
         // Create a compatible bitmap for hdcScreen. 
         HBITMAP hbmp = CreateCompatibleBitmap(hdc, width, height );
         if(hbmp) {
            if ( SelectObject(hdcMem, hbmp) ) {
               if ( BitBlt(hdcMem, 0, 0, width, height, hdc, 0, 0, SRCCOPY) ) {
#ifdef USE_NEW_PNG2
                  int cwidth, cheight;
                  unsigned char * image = get_image_bits2( hdc, hbmp, &cwidth, &cheight );
                  if(image) {
                     if( write_png_file2( nxtfile,
                        cwidth, cheight, image ) )
                        done_image = 1;
                     free(image);
                  }
#else // old SQUARE image
                  int current_size;
                  unsigned char * image = get_image_bits( hdc, hbmp, &current_size );
                  if(image) {
                     if( write_png_file( nxtfile,
                        current_size, image ) )
                        done_image = 1;
                     free(image);
                  }
#endif // new and old png writer
                  if( !done_image ) {
                     sprtf("Writing BMP, due writing PNG seems to have failed.\n");
                     nxtfile = Get_Next_FileName( "tempbmp", "bmp" );
                     done_image = write_bmp_file( hdc, hbmp, nxtfile );
                  }
               }
            }
            DeleteObject(hbmp);
         }
         DeleteDC(hdcMem);
      }
      ReleaseDC(hWnd,hdc);
   }
   char * cp = GetNxtBuf();
   if ( done_image )
       sprintf(cp,"Written screen dump to [%s] file.", nxtfile );
   else
       strcpy(cp,"ERROR: Screen dump FAILED!");
   paint_center_text(cp);
   g_time_repaint = 5;
}

VOID Do_WM_KEYDOWN( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   /* Translate keyboard messages to scroll commands */
   int i;
   switch (wParam)
   {
   case VK_UP:
      increase_lat_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_DOWN:
      decrease_lat_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_LEFT:
      decrease_lon_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_RIGHT:
      //  PostMessage (hWnd, WM_HSCROLL, SB_LINEDOWN, 0L);
      increase_lon_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_PRIOR:   //  PAGE UP key 
        // PostMessage (hWnd, WM_VSCROLL, SB_PAGEUP,   0L);
      i = get_page_key_steps();  // 10;
      while(i--)
         increase_lat_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_NEXT:    // PAGE DOWN key
        //PostMessage (hWnd, WM_VSCROLL, SB_PAGEDOWN, 0L);
      i = get_page_key_steps();  // 10;
      while(i--)
         decrease_lat_offset();
      Do_InvalidateRect(hWnd);
      break;

    case VK_HOME:
        PostMessage (hWnd, WM_HSCROLL, SB_PAGEUP,   0L);
        break;

    case VK_END:
        PostMessage (hWnd, WM_HSCROLL, SB_PAGEDOWN, 0L);
        break;

    case VK_SHIFT:
       g_bAShiftDown = TRUE;
       break;
   case VK_CONTROL:
      g_bCtrlDown = TRUE; // CTRL key
      break;
   case VK_MENU:
      g_bAltDown = TRUE;  // ALT key  
      break;
   case VK_F3: // F3 function key
      Do_F3_Key( hWnd );
      break;
   }
}

VOID Do_WM_KEYUP( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   switch (wParam)
   {
   case VK_UP:
   case VK_DOWN:
   case VK_PRIOR:
   case VK_NEXT:
      PostMessage (hWnd, WM_VSCROLL, SB_ENDSCROLL, 0L);
      break;

   case VK_HOME:
   case VK_END:
   case VK_LEFT:
   case VK_RIGHT:
      PostMessage (hWnd, WM_HSCROLL, SB_ENDSCROLL, 0L);
      break;
   case VK_SHIFT:
       g_bAShiftDown = FALSE;
       break;
   case VK_CONTROL:
      g_bCtrlDown = FALSE; // CTRL key
      break;
   case VK_MENU:
      g_bAltDown = FALSE;  // ALT key  
      break;

   }
}

VOID Do_IDM_FILL_POLY(HWND hWnd)
{
    toggle_fill_poly();
    Do_InvalidateRect(hWnd);
}

VOID Do_IDM_FILL_SCENE(HWND hWnd)
{
    toggle_fill_poly2();
    Do_InvalidateRect(hWnd);
}

VOID Do_IDM_PAINT_X(HWND hWnd)
{
    toggle_paint_x();
    Do_InvalidateRect(hWnd);
}
VOID Do_IDM_PAINT_FIT_POINTS(HWND hWnd)
{
    toggle_paint_fit_points();
    Do_InvalidateRect(hWnd);
}
VOID Do_IDM_PAINT_FIT_TRIS(HWND hWnd)
{
    toggle_paint_fit_tris();
    Do_InvalidateRect(hWnd);
}


VOID Do_WM_CHAR( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   int i;
   int max = 1;
   int num = (wParam - '1');
   if( is_shift_down() )
      max = 10;
   if( is_ctrl_down() )
       max = 100;

   switch(wParam)
   {
   case '+':
       sprtf("WM_CHAR: + max = %d\n", max);
      for( i = 0; i < max; i++ )
         Increment_ZOOM();
      Do_InvalidateRect(hWnd);
      break;
   case '-':
       sprtf("WM_CHAR: - max = %d\n", max);
      for( i = 0; i < max; i++ )
         Decement_ZOOM();
      Do_InvalidateRect(hWnd);
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      toggle_poly_enabled(num);
      Do_InvalidateRect(hWnd);
      break;
   case 'c':
      reset_lat_lon_offset();
      Do_InvalidateRect(hWnd);
      break;

   case 'd':   // dump to BMP file
#ifdef   ADD_OLD_BITMAP_SERVICES
      write_client_windows_to_bitmap();
#else
      Do_F3_Key(hWnd);
#endif // #ifdef   ADD_OLD_BITMAP_SERVICES
      break;
   case 'f':
       Do_IDM_FILL_POLY(hWnd);
      break;
   case 'F':
       Do_IDM_FILL_SCENE(hWnd);
      break;
   case 'j':
      toggle_join_points(); // g_join_poly_points 'j' key
      Do_InvalidateRect(hWnd);
      break;
   case 'l':
      toggle_join_first_to_last();
      Do_InvalidateRect(hWnd);
      break;

   case 0x1b:  // out of here
   case 'q':   // likewise, quit/exit
   case 'Q':   // likewise, quit/exit
      Post_Exit_Message();
      break;

   case 'r':
      Restore_Previous();
      Do_InvalidateRect(hWnd);
      break;
   case 'R':
      Restore_ZOOM();
      Do_InvalidateRect(hWnd);
      break;
   case 's':
      toggle_scenery_paint();
      Do_InvalidateRect(hWnd);
      break;

   case 'z':
      write_out_zoom();
      break;
   case '?':
      show_usage_dialogue();
      break;
   }
}

/* ==================================================
    wParam
    The high-order word indicates the distance the wheel is rotated, 
        expressed in multiples or divisions of WHEEL_DELTA, which is 120.
        A positive value indicates that the wheel was rotated forward, away from the user; 
        a negative value indicates that the wheel was rotated backward, toward the user. 

    The low-order word indicates whether various virtual keys are down. 
        This parameter can be one or more of the following values. 
        MK_CONTROL - The CTRL key is down.
        MK_LBUTTON - The left mouse button is down.
        MK_MBUTTON - The middle mouse button is down.
        MK_RBUTTON - The right mouse button is down.
        MK_SHIFT - The SHIFT key is down.
        MK_XBUTTON1 - Windows 2000/XP: The first X button is down.
        MK_XBUTTON2 - Windows 2000/XP: The second X button is down.
    lParam
    The low-order word specifies the x-coordinate of the pointer, relative 
        to the upper-left corner of the screen. 
    The high-order word specifies the y-coordinate of the pointer, relative 
        to the upper-left corner of the screen. 
   ================================================== */
VOID Do_WM_MOUSEWHEEL( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   int wDist = LOWORD(wParam); // GET_X_LPARAM(lParam);
   int iVirt = HIWORD(wParam); // GET_Y_LPARAM(lParam);
   if (wDist > 0)
       Do_WM_CHAR( hWnd, '-', 0 );
   else
       Do_WM_CHAR( hWnd, '+', 0 );
}

// eof - poly-view.cpp
