// poly-utils.hxx
#ifndef _poly_utils_hxx_
#define _poly_utils_hxx_
#include <string>
#include <simgear\math\point3d.hxx>
#include <simgear/bucket/newbucket.hxx>

using namespace std;

extern void win_ll2pt( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double * px_pixel, double * py_pixel );

extern void win_pt2ll( double * pobj_latr, double * pobj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double x_pixel, double y_pixel );

// convert (lat,lon) = (x,y) to ZOOM
extern void win_llpt2zoom( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double * pmap_zoom,
           double px_pixel, double py_pixel );

#define  win_int(a)  ( a < 0.0 ) ? (int)(a - 0.5) : (int)(a + 0.5)
#define  EndBuf(a)   ( a + strlen(a) )

// aim - to get close to target number of division
// between two double, using largest (integral) value
// of step from the first... return 1 for succes, 0 = FAILED
extern int poly_get_dstep2( double min, double max,         // from here to here
               int target_min, int target_max,  // target min and max
               double *first, double * step, // first value, and step
               int * pcnt, int * pdec );  // last 2 can be NULL
extern int double_value_is_integer( double val );

extern char * GetNxtBuf(void);
extern int is_file_or_directory( string cur_item );
#ifdef _MSC_VER
extern double rint( double x );
#endif // _MSC_VER
extern char * Get_Next_FileName( char * pbase, char * pext );
extern char * get_rectangle_string( PRECT prc );
extern size_t get_file_size( string cur_item );

extern Point3D cartv3d_2_p3dllh( SGVec3d cart, const SGVec3d &c );
extern Point3D cartv3f_2_p3dllh( SGVec3f cart, const SGVec3d &c );
extern char * pt3d2stg( Point3D & pt );
extern char * sgv22stg( sgVec2 & pt );

extern bool out_of_bucket_range( double lon_in, double lat_in, SGBucket & b );
extern bool sgv2_out_of_bucket_range( sgVec2 & pt, SGBucket & b );
extern bool Pt3d_out_of_bucket_range( Point3D & pt, SGBucket & b );
extern bool sgg_out_of_bucket_range( SGGeod & pt, SGBucket & b );

#define set_unix_sep(s) {    \
   size_t fnd = s.find('\\'); \
   while( fnd != -1 ) {       \
      s.replace(fnd, 1, "/"); \
      fnd = s.find('\\'); }}

extern void split_file_path(string in_file,
                     string & out_dir, string & out_name, string & out_ext);

extern int InStr( char * lpb, char * lps );  // extracted from FixFObj.c, dc4wUtil.c
extern int in_world_range( double lon, double lat );
extern char * float3p2rgbstg( float * fp, int typ );

#endif // #ifndef _poly_utils_hxx_
// eof = poly-utils.hxx


