// poly-ptools.cxx
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "poly-paint.hxx"
#include "poly-paint2.hxx"
#include "poly-ptools.hxx"

extern void delete_color_list(void);

COLORREF crGrid = RGB(90,90,90);
COLORREF crBox = RGB(190,190,190);
COLORREF crGray = RGB(90,90,90);
COLORREF crText = RGB(90,90,90);
COLORREF crCntr = RGB(255,0,0);
COLORREF crTop = RGB(255,0,0);
COLORREF crPurp = RGB(128,0,255);
COLORREF crLBrown = RGB(192,128,32);
COLORREF crLGreen = RGB(144,238,144);
COLORREF crLBlue = RGB(0,0,128);

HPEN  hpGrid = NULL;
HPEN  hpGrid2 = NULL;
HFONT hfCN8  = NULL;
HPEN  hpBox  = NULL;
HPEN  hpGray = NULL;
HPEN  hpPurp = NULL;
HPEN  hpLBrown_1 = NULL;
HPEN  hpLBrown_2 = NULL;
HPEN  hpLBrown_4 = NULL;
HPEN  hpLGreen = NULL;
HPEN  hpLBlue = NULL;
//int join_poly_points = 1;
//int join_first_to_last = 1;
//int g_paint_bounding_box = 0; // paint_bounding_box( hdc, &mm ); can overwrite points!
//int g_paint_airports = 1;     // only 1 or 2 selected - could load apt.dat...
// paint_airports( hdc, g_c_lat, g_c_lon, map_size, map_zoom, &rc );

int done_CN8_text = 0;
SIZE g_szCN8Text = { 14, 14 };

#define  MX_COLORS   12
typedef struct tagColorSet {
   COLORREF cr;
   char * desc;
   int   style;
   HPEN  hp;
   HBRUSH hb;
}ColorSet, * PColorSet;

ColorSet colors[MX_COLORS] = {
   { RGB(255,0,0), "red", HS_BDIAGONAL, 0, 0 }, // 45-degree upward left-to-right hatch 
   { RGB(0,0,255), "blue", HS_CROSS, 0, 0 },    // Horizontal and vertical crosshatch
   { RGB(0,255,0), "green", HS_DIAGCROSS, 0, 0 }, // 45-degree crosshatch
   { RGB(255,255,0), "redgreen", HS_FDIAGONAL, 0, 0 }, // 45-degree downward left-to-right hatch 
   { RGB(255,0,255), "redblue", HS_HORIZONTAL, 0, 0 }, // Horizontal hatch
   { RGB(0,255,255), "greenblue", HS_VERTICAL, 0, 0 }, // Vertical hatch
   { RGB(125,0,0), "halfred", HS_BDIAGONAL, 0, 0 },
   { RGB(0,0,125), "halfblue", HS_CROSS, 0, 0 },
   { RGB(0,125,0), "halfgreen", HS_DIAGCROSS, 0, 0 },
   { RGB(125,125,0), "halfredgreen", HS_FDIAGONAL, 0, 0 },
   { RGB(125,0,125), "halfredblue", HS_HORIZONTAL, 0, 0 },
   { RGB(0,125,125), "halfgreenblue", HS_VERTICAL, 0, 0 }
};


void clean_up_paint_tools(void)
{
   int i;
   PColorSet pcs = &colors[0];
   for(i = 0; i < MX_COLORS; i++, pcs++)
   {
      if(pcs->hp)
         DeleteObject(pcs->hp);
      pcs->hp = 0;
      if(pcs->hb)
         DeleteObject(pcs->hb);
      pcs->hb = 0;
   }
   if(hpGrid)
      DeleteObject(hpGrid);
   hpGrid = NULL;
   if(hpGrid2)
      DeleteObject(hpGrid2);
   hpGrid2 = NULL;
   if(hpBox)
      DeleteObject(hpBox);
   hpBox = NULL;
   if(hpGray)
      DeleteObject(hpGray);
   hpGray = NULL;
   if(hpPurp)
      DeleteObject(hpPurp);
   hpPurp = NULL;

   if(hpLBrown_1)
      DeleteObject(hpLBrown_1);
   hpLBrown_1 = NULL;
   if(hpLBrown_2)
      DeleteObject(hpLBrown_2);
   hpLBrown_2 = NULL;
   if(hpLBrown_4)
      DeleteObject(hpLBrown_4);
   hpLBrown_4 = NULL;

   if(hpLGreen)
      DeleteObject(hpLGreen);
   hpLGreen = NULL;
   if (hpLBlue)
       DeleteObject(hpLBlue);
   hpLBlue = NULL;
   if(hfCN8)
      DeleteObject(hfCN8);
   hfCN8 = NULL;
   clear_painted_points();
   clear_paintPoints();
   delete_color_list();
}

HBRUSH CreateStyledBrush( int fnStyle, COLORREF clrref )
{
   return CreateHatchBrush( fnStyle,      // hatch style
      clrref );   // foreground color
}

HFONT Get_CN8_Font( HDC hdc )
{
   LOGFONT lf;
   LOGFONT * plf = &lf;
   HFONT hf = hfCN8;
   if(hf)
      return hf;
   ZeroMemory( plf, sizeof(LOGFONT) );
   plf->lfHeight = -MulDiv( 8, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
   strcpy( &plf->lfFaceName[0], "Courier New" );
   //plf->lfWeight = FW_BOLD;   // set BOLD font
   hf = CreateFontIndirect( plf );
   hfCN8 = hf;
   return hf;
}

void get_text_size_len_hdc( PSIZE psz, char * ps, int len, HDC hdc )
{
   GetTextExtentPoint32( hdc, ps, len, psz );
}

void get_text_size_len( PSIZE psz, char * ps, int len )
{
   PPPSET pps = get_act_paint_set();
   get_text_size_len_hdc( psz, ps, len, pps->hdc );
}

void get_text_size( PSIZE psz, char * ps )
{
   get_text_size_len( psz, ps, strlen(ps) );
}

void get_CN8_Text_Size( HDC hdc, PSIZE psz )
{
   if( done_CN8_text ) {
      psz->cx = g_szCN8Text.cx;
      psz->cy = g_szCN8Text.cy;
      return;
   }
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);

   get_text_size_len_hdc( &g_szCN8Text, "A", 1, hdc );

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);

   psz->cx = g_szCN8Text.cx;
   psz->cy = g_szCN8Text.cy;
   done_CN8_text = 1;   // only do this once
}

HPEN Get_Solid_Pen_1( COLORREF cr )  { return CreatePen( PS_SOLID, 1, cr ); }
HPEN Get_Solid_Pen_2( COLORREF cr )  { return CreatePen( PS_SOLID, 2, cr ); }
HPEN Get_Solid_Pen_4( COLORREF cr )  { return CreatePen( PS_SOLID, 4, cr ); }
HPEN Get_Dotted_Pen_1( COLORREF cr ) { return CreatePen( PS_DOT, 1, cr );   }
// brush color value
HBRUSH Get_Solid_Brush( COLORREF cr ){ return CreateSolidBrush(cr); }

HPEN Get_GRAY_Pen_1( void )
{
   if( hpGray )
      return hpGray;
   hpGray = Get_Solid_Pen_1( crGray );   // COLORREF crColor
   return hpGray;
}

HPEN Get_GRID_Pen( void )
{
   if( hpGrid )
      return hpGrid;
   hpGrid = Get_Solid_Pen_1( crGrid );   // COLORREF crColor - Get_GRID_Pen
   return hpGrid;
}

HPEN Get_GRID2_Pen( void )
{
   if( hpGrid2 )
      return hpGrid2;
   hpGrid2 = Get_Dotted_Pen_1( crGrid );   // COLORREF crColor
   return hpGrid2;
}

HPEN Get_Purp_Pen( void )
{
   if( hpPurp )
      return hpPurp;
   hpPurp = Get_Dotted_Pen_1( crPurp );   // COLORREF crColor
   return hpPurp;
}
HPEN Get_LBrown_Pen_1( void )
{
   if( hpLBrown_1 )
      return hpLBrown_1;
   hpLBrown_1 = Get_Solid_Pen_1( crLBrown );   // COLORREF crColor
   return hpLBrown_1;
}
HPEN Get_LBrown_Pen_2( void )
{
   if( hpLBrown_2 )
      return hpLBrown_2;
   hpLBrown_2 = Get_Solid_Pen_2( crLBrown );   // COLORREF crColor
   return hpLBrown_2;
}
HPEN Get_LBrown_Pen_4( void )
{
   if( hpLBrown_4 )
      return hpLBrown_4;
   hpLBrown_4 = Get_Solid_Pen_4( crLBrown );   // COLORREF crColor
   return hpLBrown_4;
}

HPEN Get_LGreen_Pen( void )
{
   if( hpLGreen )
      return hpLGreen;
   hpLGreen = Get_Solid_Pen_1( crLGreen );   // COLORREF crColor
   return hpLGreen;
}
HPEN Get_LBlue_Pen( void )
{
   if( hpLBlue )
      return hpLBlue;
   hpLBlue = Get_Solid_Pen_1( crLBlue );   // COLORREF crColor
   return hpLBlue;
}

HPEN Get_BOX_Pen( void )
{
   if( hpBox )
      return hpBox;
   hpBox = CreatePen( PS_DASH, // int fnPenStyle, 
      1, // int nWidth, 
      crBox );   // COLORREF crColor
   return hpBox;
}

int   g_map_next_color = 0;
int   curr_act_color;
char * g_act_color = "none";
PColorSet ps_act_pcs = NULL;
HPEN Get_Act_Pen(void)
{
   if(ps_act_pcs)
      return ps_act_pcs->hp;
   return NULL;
}
HBRUSH get_act_brush(void)
{
   if(ps_act_pcs)
      return ps_act_pcs->hb;
   return NULL;
}

COLORREF get_next_color( void )
{
   curr_act_color = g_map_next_color;
   ps_act_pcs = &colors[curr_act_color];
   COLORREF cr = ps_act_pcs->cr;
   g_act_color = ps_act_pcs->desc;
   if( !ps_act_pcs->hp )
      ps_act_pcs->hp = Get_Solid_Pen_1(cr);
   if( !ps_act_pcs->hb )
      ps_act_pcs->hb = CreateStyledBrush( ps_act_pcs->style, cr );

   // if changing colors, bump tot next, wrapping
   if( get_poly_globs()->g_paint_colors ) {
      g_map_next_color++;  // bump to NEXT
      if( g_map_next_color >= MX_COLORS )
         g_map_next_color = 0;
   }
   return cr;  // return color to use
}

COLORREF get_std_text_color(void) { return crText; }

COLORREF Get_LBrown_Color(void) { return crLBrown; }
COLORREF Get_LGreen_Color(void) { return crLGreen; }
COLORREF Get_Cntr_Color(void)   { return crCntr;   }
COLORREF Get_Top_Color(void)    { return crTop;   }

// eof - poly-ptools.cxx
