// poly-paint2.cxx

#include "poly-paint.hxx"
#include "poly-paint2.hxx"
#include "poly-ptools.hxx"
#include "poly-utils.hxx"  // win_ll2pt, ...
#include "poly-view.hxx"   // get_cleint_prec(), ...

static PPSET _s_act_set;
PPPSET get_act_paint_set(void) { return &_s_act_set; }

#define sprtf_region
//#define sprtf_region sprtf // for DEBUG

vector<COLORREF> color_list;

#ifndef uchar
typedef unsigned char uchar;
#endif

void add_to_color_list( COLORREF cr )
{
   int max = color_list.size();
   int i;
   uchar r,g,b,r1,g1,b1;
   COLORREF tcr;
   r = GetRValue(cr);
   g = GetGValue(cr);
   b = GetBValue(cr);
   for( i = 0; i < max; i++ )
   {
      if( cr == color_list[i] )
         return;
      tcr = color_list[i];
      r1 = GetRValue(tcr);
      g1 = GetGValue(tcr);
      b1 = GetBValue(tcr);
      if((r == r1)&&(b == b1)&&(g == g1))
         return;
   }
   color_list.push_back(cr);
}
void delete_color_list(void)
{
   int max = color_list.size();
   int i;
   uchar r,g,b;
   COLORREF tcr;
   if(max) {
      sprtf( "color list with %d colors...\n", max );
      for( i = 0; i < max; i++ )
      {
         tcr = color_list[i];
         r = GetRValue(tcr);
         g = GetGValue(tcr);
         b = GetBValue(tcr);
         sprtf( "RGB(%3d,%3d,%3d)\n",
            r & 0xff, g & 0xff, b & 0xff);
      }
   }
   color_list.clear();
}

void paint_a_point( Point3D & pt )
{
   char * cp = "pt";
   PPPSET pps = get_act_paint_set();
   pps->dlat = pt.lat();
   pps->dlon = pt.lon();
   win_ll2pt( pps->dlat, pps->dlon,
      pps->c_lat, pps->c_lon,
      pps->map_size, pps->map_zoom,
      &pps->dx, &pps->dy );
   pps->x = win_int(pps->dx);
   pps->y = win_int(pps->dy);
   paint_pixel_X( pps->hdc, pps->x, pps->y, pps->cr,
       (pps->ppg->g_paint_X ? pps->spread_x : 0) );
   add_painted_point( pps->x, pps->y, pps->dlon, pps->dlat );
   if( pps->cnt == 0 ) {
      pps->first_x = pps->x;
      pps->first_y = pps->y;
      cp = "first";
   } else if( pps->ppg->g_join_poly_points ) {
      draw_line( pps->hdc, pps->last_x, pps->last_y, pps->x, pps->y ); // join with pen
      cp = "joined";
   }
   pps->last_x = pps->x;
   pps->last_y = pps->y;
   pps->cnt++;
   if( pps->ppg->g_show_point_paint ) {   // PO_DEBUG
      sprtf( "point: lonlat %0.6f,%0.6f at xy %d,%d (%s)\n",
      pt.lon(), pt.lat(), pps->x, pps->y, cp );
   }
}

void paint_GL_point( Point3D & pt )
{
   PPNTOBJ papo = get_act_paint_obj();
   PPPSET pps = get_act_paint_set();
   int join = ((papo->flag & PO_JOIN) ? 1 : 0);
   int save_join = pps->ppg->g_join_poly_points;
   if( save_join && !join )
      pps->ppg->g_join_poly_points = 0;
   else if( !save_join && join )
      pps->ppg->g_join_poly_points = 1;
   paint_a_point(pt);
   pps->ppg->g_join_poly_points = save_join;
}

void clear_paint_set( PPPSET pps )
{
   pps->cnt      = 0;
   pps->first_x  = -1;
   pps->first_y  = -1;
   pps->last_x   = -1;
   pps->last_y   = -1;
   pps->hb       = NULL;
   pps->hp       = NULL;
}

PPPSET init_act_paint_set( void )
{
   PPPSET pps    = get_act_paint_set();
   pps->ppg      = get_poly_globs();
   pps->map_zoom = mm_map_zoom;
   pps->map_size = mm_map_size;
   pps->c_lon    = mm_c_lon;
   pps->c_lat    = mm_c_lat;
   pps->spread_x  = pps->ppg->g_fixed_spread ? pps->ppg->g_fixed_spread :
       ((pps->map_zoom < 0.001) ? 0 : win_int(pps->map_zoom * 1000.0));
   pps->prc      = get_client_prec();

   pps->pen_size = 0;   // use pen size 1
   // line width, can depend on map zoom
   if (pps->ppg->g_var_line_size) {
       if (pps->map_zoom >= (10.0 / 1000.0))
           pps->pen_size = 2;   // use pen size 4
       else if (pps->map_zoom >= (5.0 / 1000.0))
           pps->pen_size = 1;   // use pen size 2
   }

   // show some init information
   sprtf("init_act_paint_set: pen=%d, zoom=%f, size=%u)\n", 
       (pps->pen_size ? (pps->pen_size * 2) : 1),
       (pps->map_zoom * 1000.0),
       (int)pps->map_size );

   clear_paint_set(pps);
   return pps;
}

static PNTOBJ _s_pntobj;
PPNTOBJ get_act_paint_obj(void) { return &_s_pntobj; }

void obj_glBegin_paint( PPNTOBJ ppo )
{
   PPPSET pps = get_act_paint_set();
   PPNTOBJ papo = get_act_paint_obj();

   clear_painted_points();
   *papo = *ppo;
   clear_paint_set(pps);
   papo->save_dbg = pps->ppg->g_show_point_paint;
   if( papo->flag & PO_DEBUG )
      pps->ppg->g_show_point_paint = 1;
   if( pps->hdc ) {
       if( papo->flag & PO_WPEN ) {
           if ( pps->pen_size >= 2 )
               pps->hp = Get_Solid_Pen_4( ppo->cr ); // obj_glBegin_paint:
           else if (pps->pen_size >= 1)
               pps->hp = Get_Solid_Pen_2( ppo->cr ); // obj_glBegin_paint:
           else
               pps->hp = Get_Solid_Pen_1( ppo->cr ); // obj_glBegin_paint:
       }
      if( papo->flag & PO_WBRUSH )
         pps->hb = Get_Solid_Brush( ppo->cr );
      // setup for paint
      if(pps->hb && (papo->flag & PO_FILL))
         pps->hbOld = (HBRUSH)SelectObject(pps->hdc, pps->hb);
      if(pps->hp)
         pps->hpOld = (HPEN)SelectObject(pps->hdc, pps->hp);
   }
   add_to_color_list( ppo->cr );
}
int fill_all_objs = 0;
void obj_glEnd_paint( PPNTOBJ ppo )
{
   PPPSET pps = get_act_paint_set();
   PPNTOBJ papo = get_act_paint_obj();
   if( pps->ppg->g_join_poly_points && pps->ppg->g_join_first_to_last &&
      first_last_all_in_range(pps) && (papo->flag & PO_JOIN)) {
      draw_line( pps->hdc, pps->first_x, pps->first_y, pps->last_x, pps->last_y ); // join with pen
      if( papo->flag & PO_DEBUG )
         sprtf( "Obj_end: joined first %d,%d to last %d,%d\n", pps->first_x, pps->first_y, pps->last_x, pps->last_y ); // join with pen

      if( pps->hdc && pps->hb &&
         ( fill_all_objs || pps->ppg->g_fill_scene ) ) { //||(papo->flag & PO_FILL)
         fill_polygon_with_brush( pps->hdc, pps->prc, pps->hb );
      }
   }
   if( pps->hdc ) {
      if(( ppo->flag & PO_WPEN ) && pps->hp ) {
         SelectObject(pps->hdc, pps->hpOld);
         DeleteObject(pps->hp);
      }
      if(( ppo->flag & PO_FILL ) && pps->hb ) {
         SelectObject(pps->hdc, pps->hbOld);
         DeleteObject(pps->hb);
      }
   }
   pps->ppg->g_show_point_paint = papo->save_dbg;
   clear_paint_set(pps);
}

static int add_one_more = 0;
// debug
static int debug_fill_service = 0;
void fill_polygon_with_brush( HDC hdc, PRECT prc, HBRUSH hb )
{
   int   i, max;
   max = painted_points.size();
   if((max > 2) && hb) {  
      // convert vector to simple array
      // BUT if some point off screen, then HOW to 'fix'
      // the points so they correctly have only an 
      // 'inside'... even when all ON-SCREEN
      PPOINT pp = new POINT[max + 1];
      if(pp) {
         for( i = 0; i < max; i++ ) {
            pp[i] = painted_points[i];
         }
         pp[i] = pp[0];
         if(add_one_more)
            max++;
#if 0
         if( debug_fill_service ) {
            int i2;
            HPEN hp = Get_Purp_Pen();
            HPEN hpold;
            if(hp)
               hpold = (HPEN)SelectObject(hdc,hp);
            for( i = 0; i < max; i++ ) {
               i2 = i + 1;
               if( i2 >= max )
                  i2 = 0;
               POINT pt1 = pp[i];
               POINT pt2 = pp[i2];
               pt1.x += 1;
               pt1.y += 1;
               pt2.x += 1;
               pt2.y += 1;
               draw_line(hdc, pt1.x, pt1.y, pt2.x, pt2.y );
            }
            if(hp)
               SelectObject(hdc,hpold);
         } else
#endif // 0 only for DEBUG

         {
            //HRGN hRgn = CreatePolygonRgn( pp, max, WINDING );
            HRGN hRgn = CreatePolygonRgn( pp, max, ALTERNATE );
            if(hRgn) {
               sprtf_region( "Filled region: %d points.\n", max );
               FillRgn( hdc, hRgn, hb );
               DeleteObject( hRgn );
            } else {
               sprtf( "FAILED CreatePolygonRgn %d points.\n", max );
            }
         }
         delete pp;
      }
   } else if(hb) {
      sprtf( "No fill of region: just %d points.\n", max );
   } else {
      sprtf( "No fill of region: %d points, but NO BRUSH.\n", max );
   }
}


// eof - poly-paint2.cxx
