// poly-outGL.hxx
#ifndef _Poly_OutGL_HXX_
#define _Poly_OutGL_HXX_
#ifndef __OUTPUTGL_H__
#define __OUTPUTGL_H__

#include <simgear/compiler.h>
//#include SG_GLUT_H
#include <plib/fnt.h>
#include <plib/pu.h>
#ifdef POLY_VIEW
#include "poly-out.hxx"
#else // !POLY_VIEW
#include "Output.hxx"
#endif // POLY_VIEW y/n

#include <vector>
using std::vector;

class OutputGL : public GfxOutput {
public:
#ifdef POLY_VIEW
   // provide a DEFAULT constructor, and
   OutputGL();
   // use a separate 'init' service
  void init( const char *filename, int size, bool smooth_shading,
	    bool useTexturedFont, char *fontname, bool jpg = false,
            int q = 75, int r = 1 );
  sgVec3 ref_xyz; // added this, but did not get much from using it

#endif // POLY_VIEW

  OutputGL( const char *filename, int size, bool smooth_shading,
	    bool useTexturedFont, char *fontname, bool jpg = false,
            int q = 75, int r = 1 );
  ~OutputGL();

  virtual void openFragment( int x, int y, int size );
  virtual void closeFragment();
  virtual void closeOutput();

  virtual void setShade( bool shade );
  virtual bool getShade();
  virtual void setLightVector( sgVec3 light );
  virtual void setColor( const float *rgb );
  virtual void clear( const float *rgb );
  virtual void drawTriangle( const sgVec2 *p, const sgVec3 *normals );
  virtual void drawQuad    ( const sgVec2 *p, const sgVec3 *normals );
  virtual void drawTriangle( const sgVec2 *p, const sgVec3 *normals, const sgVec4 *color );
  virtual void drawQuad    ( const sgVec2 *p, const sgVec3 *normals, const sgVec4 *color );
  virtual void drawCircle  ( sgVec2 p, int radius );
  virtual void drawLine    ( sgVec2 p1, sgVec2 p2 );
  virtual void drawText    ( sgVec2 p, char *text );

#ifdef POLY_VIEW
  virtual void drawPoint( const sgVec2 *p, const sgVec3 *normals );
#endif // POLY_VIEW
  //void setFont( bool useTexturedFont );

protected:
  enum { SUBDIVISIONS = 18 };

  static const float BRIGHTNESS;
  static float circle_x[SUBDIVISIONS], circle_y[SUBDIVISIONS];

  fntTexFont *font;
  fntRenderer textRenderer;
  puFont *glutFont;
  const char *filename;
  bool useTexturedFont, shade, jpeg;
  int jpeg_quality, rescale;
  GLubyte * image;

  sgVec4 light_vector;
};

extern int paint_GL_polys( HDC hdc );
extern int paint_GL_points(void);

#endif
#endif // #ifndef _Poly_OutGL_HXX_
// eof - poly-outGL.hxx

