// poly-outGL.cxx

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <png.h>
extern "C" {
#include <jpeglib.h>
}
#ifdef POLY_VIEW
#include <simgear/math/polar3d.hxx>
#include "poly-outGL.hxx"
#include "lib_sprtf.hxx"
#include "poly-geod.hxx"
#include "poly-utils.hxx"
#include "poly-paint2.hxx"
#include "poly-mygl.hxx"
#include "poly-map.hxx"

#else // !POLY_VIEW
#include "OutputGL.hxx"
#endif // POLY_VIEW y/n

extern int get_act_poly_type(void);

float OutputGL::circle_x[];
float OutputGL::circle_y[];

const float OutputGL::BRIGHTNESS = 0.6f;

#ifdef POLY_VIEW

#define sprtf_outgl  
//#define sprtf_outgl  sprtf // FOR DEBUG
#define sprtf_extra
//#define sprtf_extra  sprtf // FOR DEBUG

// forward ref
char * Get_GL_Desc( GLenum type );

// The pixel coordinate system is measured in pixels, with (0,0) 
// at the upper left, increasing down and to the right.

typedef struct tagGL_OPERATION {
   GLenum type;
   COLORREF cr;
   string mat;
   int glo_color_index;
   int glo_poly_type;
#ifdef ADD_KEEP_NORMALS
   vector<Point3D> pt_norms;
#endif #ifdef ADD_KEEP_NORMALS
   vector<Point3D> pt_verts;
} GL_OPERATION, * PGL_OPERATION;

typedef vector<PGL_OPERATION>   vecOpList;

static COLORREF act_cr = RGB(0,0,0);
static GLenum act_type;
static unsigned int gl_Errors_Value = 0;
static PGL_OPERATION pActOp = NULL;
static vecOpList paint_ops_list;
static vecOpList accum_ops_list;
static sgVec3 ref_xyz;
static int use_paint_ops_list = 1;
static std::string act_material = "";   // IF ANY
int act_outGL_mat_type = -1;
static std::string mat_list = "";

void m_set_act_material( std::string mat, char * caller )
{
    act_outGL_mat_type = (int)get_area_type(mat);
    act_material = mat;
    if (mat_list.find(mat) == std::string::npos) {
        if (VERB2) sprtf( "[V2]:Material: %s (%d) %s\n", mat.c_str(), act_outGL_mat_type, caller);
        if (mat_list.size())
            mat_list += ";";
        mat_list += mat;
    }
}

int set_paint_ops_list(int set)
{
    int cu = use_paint_ops_list;
    use_paint_ops_list = set;
    sprtf( "Set op list to %d (%s)\n", set, (use_paint_ops_list ? "PAINT" : "ACCUM"));
    return cu;
}

vecOpList * get_ops_list(void)
{
    if ( use_paint_ops_list )
        return &paint_ops_list;
    return &accum_ops_list;
}

void clear_ops_list( void )
{
   int i;
   vecOpList * ops_list = get_ops_list();
   int max = ops_list->size();
   for( i = 0; i < max; i++ ) {
      PGL_OPERATION pglo = ops_list->at(i);
#ifdef ADD_KEEP_NORMALS
      pglo->pt_norms.clear();
#endif // #ifdef ADD_KEEP_NORMALS
      pglo->pt_verts.clear();
      delete pglo;
   }
   ops_list->clear();
}

void clear_all_op_lists( void )
{
    int cu = set_paint_ops_list(1);
    clear_ops_list();   // clear the PAINT ops list
    set_paint_ops_list(0);
    clear_ops_list();   // clear the ACCUM ops list
    set_paint_ops_list(cu);
}

static int next_op_item = 0;
int get_next_op_item( COLORREF * pcr, vector<Point3D> & pverts, int * pci )
{
    vecOpList * ops_list = get_ops_list();
    int max = ops_list->size();
    if (next_op_item < max) {
        PGL_OPERATION pglo = ops_list->at(next_op_item);
        pverts = pglo->pt_verts;
        *pcr   = pglo->cr;
        //*pci   = pglo->color_index;
        *pci   = pglo->glo_poly_type;
        next_op_item++;
        return 1;
    }
    return 0;
}    

int get_first_op_item( COLORREF * pcr, vector<Point3D> & pverts, int * pci )
{
    next_op_item = 0;
    return get_next_op_item(pcr,pverts,pci);
}

static PNTOBJ _s_m_pntobj;
PPNTOBJ get_pnt_obj(void) { return &_s_m_pntobj; };
int paint_GL_points(void)
{
   int cnt = 0;
   PPNTOBJ ppo = get_pnt_obj();
   int i, mx;
   mx = ppo->v_pts.size();
   ppo->type = GL_POINTS;
   ppo->cr   = RGB(255,255,0);   // yellow lights
   //ppo->cr   = RGB(0,0,0);
   ppo->flag = PO_WPEN; // only with PEN, of the above color
   obj_glBegin_paint(ppo);
   for(i = 0; i < mx; i++) {
      Point3D pt = ppo->v_pts[i];
      paint_GL_point( pt );
      cnt++;
   }
   obj_glEnd_paint(ppo);
   return cnt;
}

int paint_GL_polys( HDC hdc )
{
    size_t tot = 0;
   int cnt = 0;
   int i, j, mx;
   PPNTOBJ ppo = get_pnt_obj();
   vecOpList * ops_list = get_ops_list();
   int max = ops_list->size();
   ppo->v_pts.clear();
   for( i = 0; i < max; i++ ) {
      PGL_OPERATION pglo = ops_list->at(i);
#ifdef ADD_KEEP_NORMALS
      mx = pglo->pt_norms.size();
      ppo->type = pglo->type;
      ppo->cr   = pglo->cr;
      ppo->flag = PO_ALL | PO_DEBUG;
      if( pglo->type == GL_TRIANGLES ) {
          tot += mx;
         //if( mx < 3 )
            ppo->flag &= ~(PO_FILL | PO_JOIN);
         obj_glBegin_paint(ppo);
         for( j = 0; j < mx; j++ ) {
            Point3D pt = pglo->pt_norms[j];
            paint_GL_point( pt );
         }
         obj_glEnd_paint(ppo);
      } else {
         sprtf("WARNING: %s Object NOT handled (%d)\n",
            Get_GL_Desc( pglo->type ), pglo->type );
      }
#endif // #ifdef ADD_KEEP_NORMALS
      mx = pglo->pt_verts.size();
      ppo->type = pglo->type;
      ppo->cr   = pglo->cr;
      ppo->flag = PO_ALL;  // | PO_DEBUG;
      if( pglo->type == GL_TRIANGLES ) {
          tot += mx;
         if( mx < 3 )
            ppo->flag &= ~PO_FILL;
         obj_glBegin_paint(ppo);
         for( j = 0; j < mx; j++ ) {
            Point3D pt = pglo->pt_verts[j];
            paint_GL_point( pt );
         }
         obj_glEnd_paint(ppo);
      } else if( pglo->type == GL_QUADS ) {
          tot += mx;
         if( mx < 3 )
            ppo->flag &= ~PO_FILL;
         obj_glBegin_paint(ppo);
         for( j = 0; j < mx; j++ ) {
            Point3D pt = pglo->pt_verts[j];
            paint_GL_point( pt );
         }
         obj_glEnd_paint(ppo);
      } else if( pglo->type == GL_POINTS ) {
         // tot += mx;
         // paint a LIGHT point
         //ppo->flag &= ~(PO_FILL|PO_JOIN);
         //obj_glBegin_paint(ppo);
         for( j = 0; j < mx; j++ ) {
            Point3D pt = pglo->pt_verts[j];
            //paint_GL_point( pt );
            ppo->v_pts.push_back(pt);
         }
         //obj_glEnd_paint(ppo);
      //} else if( pglo->type == GL_TRIANLGE_FAN ) {
      //   if( mx < 3 )
      //      ppo->flag &= ~PO_FILL;
      //   obj_glBegin_paint(ppo);
      //   for( j = 0; j < mx; j++ ) {
      //      Point3D pt = pglo->pt_verts[j];
      //      paint_GL_point( pt );
      //   }
      //   obj_glEnd_paint(ppo);
      } else {
         sprtf("WARNING: %s Object NOT handled (%d)\n",
            Get_GL_Desc( pglo->type ), pglo->type );
      }
   }
   sprtf("paint_GL_polys: painted %u points...\n", tot);
   return cnt;
}

void set_ref_xyz( sgVec3 xyz )
{
   ref_xyz[0] = xyz[0];
   ref_xyz[1] = xyz[1];
   ref_xyz[2] = xyz[2];
}

//  m_glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, rgba);
void m_glMaterialfv( GLenum face,  GLenum pname, const GLfloat * params)
{

}
//  m_glColor4fv( rgba );
void m_glColor4fv( const float * v)
{
   int red   = (int)(v[0] * 255.0);
   int green = (int)(v[1] * 255.0);
   int blue  = (int)(v[2] * 255.0);
   int inten = (int)(v[3] * 255.0);
   sprtf_outgl( "Set color RGB(%3d,%3d,%3d)\n", red, green, blue );
   act_cr = RGB(red,green,blue);
}

typedef struct tagGLBEGIN {
   GLenum mode;
   char * full_description;
   char * desc;
   int   flag;
}GLBEGIN, * PGLBEGIN;

GLBEGIN gl_begin[] = {
   { GL_POINTS,
   "Treats each vertex as a single point. Vertex n defines point n. N points are drawn.",
   "GL_POINTS", 0 },
   { GL_LINES,
   "Treats each pair of vertices as an independent line segment. Vertices 2?n?1 and 2?n define line n. N2 lines are drawn.",
   "GL_LINES", 0 },
   { GL_LINE_STRIP,
   "Draws a connected group of line segments from the first vertex to the last. Vertices n and n+1 define line n. N?1 lines are drawn.",
   "GL_LINE_STRIP", 0 },
   { GL_LINE_LOOP,
   "Draws a connected group of line segments from the first vertex to the last, then back to the first. Vertices n and n+1 define line n. The last line, however, is defined by vertices N and 1. N lines are drawn.",
   "GL_LINE_LOOP", 0 },
   { GL_TRIANGLES,
   "Treats each triplet of vertices as an independent triangle. Vertices 3?n?2, 3?n?1, and 3?n define triangle n. N3 triangles are drawn.",
   "GL_TRIANGLE", 0 },
   { GL_TRIANGLE_STRIP,
   "Draws a connected group of triangles. One triangle is defined for each vertex presented after the first two vertices. For odd n, vertices n, n+1, and n+2 define triangle n. For even n, vertices n+1, n, and n+2 define triangle n. N?2 triangles are drawn.",
   "GL_TRIANLGE_STRIP", 0 },
   { GL_TRIANGLE_FAN,
   "Draws a connected group of triangles. One triangle is defined for each vertex presented after the first two vertices. Vertices 1, n+1, and n+2 define triangle n. N?2 triangles are drawn.",
   "GL_TRIANLGE_FAN", 0 },
   { GL_QUADS,
   "Treats each group of four vertices as an independent quadrilateral. Vertices 4?n?3, 4?n?2, 4?n?1, and 4?n define quadrilateral n. N4 quadrilaterals are drawn.",
   "GL_QUADS", 0 },
   { GL_QUAD_STRIP,
   "Draws a connected group of quadrilaterals. One quadrilateral is defined for each pair of vertices presented after the first pair. Vertices 2?n?1, 2?n, 2?n+2, and 2?n+1 define quadrilateral n. N2?1 quadrilaterals are drawn. Note that the order in which vertices are used to construct a quadrilateral from strip data is different from that used with independent data.",
   "GL_QUAD_STRIP", 0 },
   { GL_POLYGON,
   "Draws a single, convex polygon. Vertices 1 through N define this polygon.",
   "GL_POLYGON", 0 },
   { 0, 0, 0, 0 }
};
    
char * Get_GL_Desc( GLenum type )
{
   PGLBEGIN pgl = &gl_begin[0];
   while(pgl->desc) {
      if( pgl->mode == type ) {
         return pgl->desc;
      }
      pgl++;
   }
   return "Unknown";
}

// m_glBegin(GL_TRIANGLES);
//void  m_glBegin( GLenum type )
void  m_glBegin( int type )
{
   act_type = type;
   PGLBEGIN pgl = &gl_begin[0];
   while(pgl->desc) {
      if( pgl->mode == type ) {
         sprtf_outgl("Got mode %s\n", pgl->desc );
         pActOp = new GL_OPERATION;
         pActOp->type = type;
         pActOp->cr   = act_cr;
         pActOp->mat  = act_material;
         pActOp->glo_color_index = iact_map_rgba_index;
         pActOp->glo_poly_type = get_act_poly_type();
#ifdef ADD_KEEP_NORMALS
         pActOp->pt_norms.clear();
#endif // #ifdef ADD_KEEP_NORMALS
         pActOp->pt_verts.clear();
         sprtf_extra("glBegin: Got mode %s, type %d (%d)\n", pgl->desc, type,
             get_ops_list()->size());
         return;
      }
      pgl++;
   }
   sprtf("ERROR: Unknown operation MODE %d\n", type );
   gl_Errors_Value |= GL_INVALID_OPERATION;
}

void m_glEnd(void)
{
    vecOpList * ops_list = get_ops_list();
   if(pActOp) {
      ops_list->push_back(pActOp);
      sprtf_extra("glEnd: End type %d - count = %d - pushed (%s) - to %d\n", pActOp->type,
           pActOp->pt_verts.size(),
           (use_paint_ops_list ? "PAINT" : "ACCUM"),
           ops_list->size());
   } else {
      sprtf("ERROR: no begin!\n" );
      gl_Errors_Value |= GL_INVALID_OPERATION;
   }
   pActOp = NULL;
}

// m_glNormal3fv( normals[0] )
// v Specifies a pointer to an array of three elements:
// the x, y, and z coordinates of the new current normal.
//void m_glNormal3fv( const GLfloat * v )
void m_glNormal3fv( const float * v )
{
   // float array to sgVec3
   sgVec3 xyz;
   xyz[0] = v[0];
   xyz[1] = v[1];
   xyz[2] = v[2];
#ifdef ADD_KEEP_NORMALS
   Point3D pt;
   sgVec3 dst;
   Normal2Llhv3( xyz, dst ); // convert to lon,lat
   pt.setlon ( dst[0] * SG_RADIANS_TO_DEGREES );
   pt.setlat ( dst[1] * SG_RADIANS_TO_DEGREES );
   pt.setelev( dst[2] * SG_RADIANS_TO_DEGREES );
   if(pActOp) {
      pActOp->pt_norms.push_back(pt);
      sprtf("Got Normal xyz %f,%f,%f (%f,%f,%f)\n",
         v[0], v[1], v[2],
         pt.lon(), pt.lat(), pt.elev() );
   } else {
      sprtf("ERROR: no begin!\n" );
      gl_Errors_Value |= GL_INVALID_OPERATION;
   }
#endif // #ifdef ADD_KEEP_NORMALS
}

//    m_glVertex2f( p[0] + circle_x[i] * radius,
//		p[1] + circle_y[i] * radius );
//void m_glVertex2f( GLfloat v1, GLfloat v2 )
void m_glVertex2f( float v1, float v2 )
{
   Point3D pt;
   pt.setlon(v1);
   pt.setlat(v2);
   pt.setelev(0.0);
   if(pActOp) {
      pActOp->pt_verts.push_back(pt);
      sprtf_outgl("Got Vertex xy %f,%f (2f)\n", pt.lon(), pt.lat() );
   } else {
      sprtf("ERROR: no begin!\n" );
      gl_Errors_Value |= GL_INVALID_OPERATION;
   }
}

//void m_glVertex2fv( const GLfloat * v ) { m_glVertex2f( v[0], v[1] ); }
void m_glVertex2fv( const float * v ) { m_glVertex2f( v[0], v[1] ); }
void m_glVertex3fv( const float * v ) { m_glVertex2f( v[0], v[1] ); }

// m_glEnable( GL_LIGHTING );
void m_glEnable( GLenum value )
{

}

//    m_glDisable( GL_LIGHTING );
void  m_glDisable( GLenum value )
{

}

//  m_glClearColor(rgb[0], rgb[1], rgb[2], 1.0f);
void  m_glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat inten)
{

}
//  m_glClear(GL_COLOR_BUFFER_BIT);
void  m_glClear( GLenum face )
{

}

//    m_glutFont_drawString( text, (int)p[0], (int)p[1] );
void  m_glutFont_drawString( char * text, int x, int y )
{
   sprtf("String [%s], at x,y %d,%d\n", text, x, y );
}
//  m_glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
void m_glLightfv( GLenum e1, GLenum e2, GLfloat * v )
{

}

#else // !POLY_VIEW
#define m_glMaterialfv  glMaterialfv
#define m_glColor4fv    glColor4fv
#define m_glBegin       glBegin
#define m_glNormal3fv   glNormal3fv
#define m_glVertex2fv   glVertex2fv
#define m_glEnd         glEnd
#define m_glEnable      glEnable
#define m_glDisable     glDisable
#define m_glClearColor  glClearColor
#define m_glClear       glClear
#define m_glLightfv     glLightfv
#endif // POLY_VIEW y/n

#ifdef POLY_VIEW
void OutputGL::init( const char *filename, int size, bool smooth_shading, 
		    bool useTexturedFont, char *fontname, bool jpg, int q, int r )
{
   font = NULL;
   glutFont = NULL;
   filename = filename;
   useTexturedFont = useTexturedFont;
   shade = smooth_shading;
   jpeg = jpg;
   jpeg_quality = q;
   rescale = r;
   image = NULL;
   for (int i = 0; i < SUBDIVISIONS; i++) {
      circle_x[i] = cos(2*SG_PI / SUBDIVISIONS * i);
      circle_y[i] = sin(2*SG_PI / SUBDIVISIONS * i);
   }

   image = new GLubyte[size*size*3];

}

OutputGL::OutputGL( const char *filename, int size, bool smooth_shading, 
	bool useTexturedFont, char *fontname, bool jpg, int q, int r ) : 
   GfxOutput(filename, size)
{
   init( filename, size, smooth_shading, useTexturedFont, fontname, false, 75, 1 );
}

OutputGL::OutputGL() : GfxOutput(NULL, 256)
{
   init( NULL, 256, false, false, NULL, false, 75, 1 );
}


#else // !POLY_VIEW 

OutputGL::OutputGL( const char *filename, int size, bool smooth_shading, 
		    bool useTexturedFont, char *fontname, bool jpg, int q, int r ) : 
  GfxOutput(filename, size), filename(filename), 
  useTexturedFont(useTexturedFont), jpeg(jpg), jpeg_quality(q), rescale(r)
{
#ifndef POLY_VIEW
  if ( filename == NULL )
    openFragment( 0, 0, size );

  glEnable(GL_BLEND);
  glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

  shade = true;
  glEnable(GL_LIGHTING);
  glShadeModel(smooth_shading ? GL_SMOOTH : GL_FLAT);

  glEnable(GL_COLOR_MATERIAL);
  glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);

  if (useTexturedFont) {
    font = new fntTexFont( fontname );
    textRenderer.setFont( font );
    textRenderer.setPointSize( 12 );
  } else {
    glutFont = new puFont;
  }

#endif // #ifndef POLY_VIEW

  for (int i = 0; i < SUBDIVISIONS; i++) {
    circle_x[i] = cos(2*SG_PI / SUBDIVISIONS * i);
    circle_y[i] = sin(2*SG_PI / SUBDIVISIONS * i);
  }

  image = new GLubyte[size*size*3];
}
#endif   // POLY_VIEW y/n


OutputGL::~OutputGL() {
   if(image)
      delete [] image;
   image = NULL;

#ifndef POLY_VIEW
  if (useTexturedFont) {
    delete font;
  } else {
    delete glutFont;
  }
#endif // #ifndef POLY_VIEW
}

void OutputGL::openFragment( int x, int y, int s )
{
  fragment_size = s;
  posx = x;
  posy = y;

  if ( s == 0 )
      s = size;

#ifndef POLY_VIEW
  glViewport( 0, 0, s, s );
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glOrtho( x, x+s, y, y+s, -1.0f, 1.0f );
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();
#endif // #ifndef POLY_VIEW

}

void OutputGL::closeFragment() {

#ifndef POLY_VIEW
  if (!open)
    return;

  GLubyte *subimage = new GLubyte[fragment_size*fragment_size*3];
  if (!subimage)
    return;

  // grab screen
  glFinish();
  glReadPixels(0, 0, fragment_size, fragment_size,
	       GL_RGB, GL_UNSIGNED_BYTE, subimage);

  int sx = fragment_size,
      sy = fragment_size;
  if ( posx + sx > size )
    sx = size - posx;
  if ( posy + sy > size )
    sy = size - posy;
  for ( int i = 0; i < sx; ++i ) {
    for ( int j = 0; j < sy; ++j ) {
      image[(( j+posy ) * size + ( i+posx )) * 3] = subimage[(j * fragment_size + i) * 3];
      image[(( j+posy ) * size + ( i+posx )) * 3 + 1] = subimage[(j * fragment_size + i) * 3 + 1];
      image[(( j+posy ) * size + ( i+posx )) * 3 + 2] = subimage[(j * fragment_size + i) * 3 + 2];
    }
  }
  delete [] subimage;
#endif // #ifndef POLY_VIEW
}

void OutputGL::closeOutput() {

#ifndef POLY_VIEW
  if (!open)
    return;

  open = false;

  int scale = rescale;
  int current_size = size;
  while ( scale && ( scale & 1 ) == 0 ) {
    int new_size = current_size / 2;
    GLubyte *buffer = new GLubyte[new_size*new_size*3];
    for ( int x2 = 0; x2 < new_size; ++x2 ) {
      for ( int y2 = 0; y2 < new_size; ++y2 ) {
        for ( int c = 0; c < 3; ++c ) {
          int x1 = x2 + x2;
          int x1_1 = x1 + 1;
          int y1 = y2 + y2;
          int y1_1 = y1 + 1;

          int t1 = image[ (y1   * current_size + x1  ) * 3 + c ];
          int t2 = image[ (y1_1 * current_size + x1  ) * 3 + c ];
          int t3 = image[ (y1   * current_size + x1_1) * 3 + c ];
          int t4 = image[ (y1_1 * current_size + x1_1) * 3 + c ];

          buffer[ (y2 * new_size + x2) * 3 + c ] = ( t1 + t2 + t3 + t4 ) / 4 ;
        }
      }
    }
    scale >>= 1;
    current_size = new_size;
    delete[] image;
    image = buffer;
  }

  FILE *fp = fopen(filename, "wb");
  if (!fp) {
    printf("OutputGL::closeOutput: can't create '%s'\n", filename);
    return;
  }

  if ( jpeg ) {
    jpeg_compress_struct cinfo;
    memset( &cinfo, 0, sizeof cinfo );

    jpeg_error_mgr jerr;
    memset( &jerr, 0, sizeof jerr );
    cinfo.err = jpeg_std_error( &jerr );

    jpeg_create_compress( &cinfo );
    jpeg_stdio_dest( &cinfo, fp );

    cinfo.image_width = current_size;
    cinfo.image_height = current_size;
    cinfo.input_components = 3;
    cinfo.in_color_space = JCS_RGB;

    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo,jpeg_quality,false);

    jpeg_start_compress( &cinfo, TRUE );

    while ( cinfo.next_scanline < cinfo.image_height ) {
       unsigned char *buf;
       if ( 1 ) {
	  buf = (unsigned char *)&image[ current_size * ( current_size - ( cinfo.next_scanline + 1 ) ) * 3 ];
       } else {
	  buf = (unsigned char *)&image[ current_size * cinfo.next_scanline * 3 ];
       }
       jpeg_write_scanlines( &cinfo, (JSAMPARRAY)&buf, 1 );
    }

    jpeg_finish_compress( &cinfo );
    jpeg_destroy_compress( &cinfo );
  } else {
    png_structp png_ptr = png_create_write_struct
      (PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    if (!png_ptr)
      return;

    png_infop info_ptr = png_create_info_struct(png_ptr);
    if (!info_ptr) {
      png_destroy_write_struct(&png_ptr,
			       (png_infopp)NULL);
      return;
    }

    if (setjmp(png_ptr->jmpbuf)) {
      png_destroy_write_struct(&png_ptr, &info_ptr);
      fclose(fp);
      return;
    }

    png_init_io(png_ptr, fp);
    png_set_IHDR(png_ptr, info_ptr, current_size, current_size, 8, PNG_COLOR_TYPE_RGB,
		 PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT,
		 PNG_FILTER_TYPE_DEFAULT);
    png_write_info(png_ptr, info_ptr);

    png_byte **row_pointers = new png_byte*[current_size];
    for (int i = 1; i <= current_size; i++) {
      row_pointers[i-1] = (png_byte*)(image + current_size * (current_size-i) * 3);
    }

    // actually write the image
    png_write_image(png_ptr, row_pointers);

    delete[] row_pointers;

    png_write_end(png_ptr, info_ptr);
    png_destroy_write_struct(&png_ptr, &info_ptr);
  }
  fclose(fp);
  printf("Written '%s'\n", filename);
#endif // #ifndef POLY_VIEW
}

void OutputGL::setShade( bool shade ) {
  if (shade) {
    m_glEnable( GL_LIGHTING );
  } else {
    m_glDisable( GL_LIGHTING );
  }

  this->shade = shade;
}

bool OutputGL::getShade() {
  return shade;
}

void OutputGL::setLightVector( sgVec3 light ) {
  GLfloat ambient[] = {BRIGHTNESS/3.0f, BRIGHTNESS/3.0f, BRIGHTNESS/3.0f,1.0f};
  GLfloat diffuse[] = {BRIGHTNESS, BRIGHTNESS, BRIGHTNESS, 1.0f};

  sgCopyVec3( light_vector, light );
  light_vector[3] = 0.0f;
  m_glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
  m_glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );
  m_glLightfv( GL_LIGHT0, GL_POSITION, light_vector );
  m_glEnable( GL_LIGHT0 );
}

void OutputGL::setColor( const float *rgba ) {
  m_glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, rgba);
  m_glColor4fv( rgba );
}

void OutputGL::clear( const float *rgb ) {
  m_glClearColor(rgb[0], rgb[1], rgb[2], 1.0f);
  m_glClear(GL_COLOR_BUFFER_BIT);
}

#ifdef POLY_VIEW
void OutputGL::drawPoint( const sgVec2 *p, const sgVec3 *normals ) {
  m_glBegin(GL_POINTS);
  m_glNormal3fv( normals[0] ); m_glVertex2fv( p[0] );
  m_glEnd();
}
#endif // POLY_VIEW

void OutputGL::drawTriangle( const sgVec2 *p, const sgVec3 *normals ) {
  m_glBegin(GL_TRIANGLES);
  m_glNormal3fv( normals[0] ); m_glVertex2fv( p[0] );
  m_glNormal3fv( normals[1] ); m_glVertex2fv( p[1] );
  m_glNormal3fv( normals[2] ); m_glVertex2fv( p[2]);
  m_glEnd();
  if (VERB9) {
      sprtf("[V9]:OutputGL::drawTriangle: %g,%g %g,%g %g,%g\n",
          p[0][0], p[0][1],
          p[1][0], p[1][1],
          p[2][0], p[2][1] );
  }
}

void OutputGL::drawTriangle( const sgVec2 *p, const sgVec3 *normals, const sgVec4 *color ) {
  m_glBegin(GL_TRIANGLES);
    m_glColor4fv( color[0] );m_glNormal3fv( normals[0] ); m_glVertex2fv( p[0] );
    m_glColor4fv( color[1] );m_glNormal3fv( normals[1] ); m_glVertex2fv( p[1] );
    m_glColor4fv( color[2] );m_glNormal3fv( normals[2] ); m_glVertex2fv( p[2]);
  m_glEnd();
  if (VERB9) {
      sprtf("[V9]:OutputGL::drawTriangle: %g,%g %g,%g %g,%g\n",
          p[0][0], p[0][1],
          p[1][0], p[1][1],
          p[2][0], p[2][1] );
  }
}

void OutputGL::drawQuad( const sgVec2 *p, const sgVec3 *normals ) {
  m_glBegin(GL_QUADS);
  m_glNormal3fv( normals[0] ); m_glVertex2fv( p[0] );
  m_glNormal3fv( normals[1] ); m_glVertex2fv( p[1] );
  m_glNormal3fv( normals[2] ); m_glVertex2fv( p[2] );
  m_glNormal3fv( normals[3] ); m_glVertex2fv( p[3] );
  m_glEnd();
}

void OutputGL::drawQuad( const sgVec2 *p, const sgVec3 *normals, const sgVec4 *color ) {
  m_glBegin(GL_QUADS);
    m_glColor4fv( color[0] );m_glNormal3fv( normals[0] ); m_glVertex2fv( p[0] );
    m_glColor4fv( color[1] );m_glNormal3fv( normals[1] ); m_glVertex2fv( p[1] );
    m_glColor4fv( color[2] );m_glNormal3fv( normals[2] ); m_glVertex2fv( p[2] );
    m_glColor4fv( color[3] );m_glNormal3fv( normals[3] ); m_glVertex2fv( p[3] );
  m_glEnd();
}

void OutputGL::drawCircle( sgVec2 p, int radius ) {

  m_glBegin(GL_LINE_LOOP);
  for (int i = 0; i < SUBDIVISIONS; i++) {
    m_glVertex2f( p[0] + circle_x[i] * radius,
		p[1] + circle_y[i] * radius );
  }
  m_glEnd();
}

void OutputGL::drawLine( sgVec2 p1, sgVec2 p2 ) {
  m_glBegin(GL_LINES);
  m_glVertex2fv(p1);
  m_glVertex2fv(p2);
  m_glEnd();
}

void OutputGL::drawText( sgVec2 p, char *text ) {
#ifdef POLY_VIEW
    m_glutFont_drawString( text, (int)p[0], (int)p[1] );
#else // !#ifdef POLY_VIEW
  if (useTexturedFont) {
    textRenderer.begin();
    textRenderer.start2fv( p );
    textRenderer.puts( text );
    textRenderer.end();
    glDisable(GL_TEXTURE_2D);
  } else {
    glutFont->drawString( text, (int)p[0], (int)p[1] );
  }
#endif // #ifdef POLY_VIEW y/n

}


// eof - poly-outGL.cxx
