// poly_geod.cxx

#ifndef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <math.h>
#include <PLIB/sg.h>
#include "poly-geod.hxx"

// =======================================================================
// Conversions - Cartesian coordinate system, EFG, to/from
// Geodetic coordinates, represented by longitude, latitude, and elevation above sea level
// see : http://www.flightgear.org/Docs/Scenery/CoordinateSystem/CoordinateSystem.html
// for more details. And the convertsion factor used here are
// Major_Axis               6378137.0,  and
// Inverse_flattening_value 298.257223563
// These are the values usually defined for WGS84 - WGS 1984 values.
// =======================================================================
void wgs84_EFG2Llh( double efg[], double *lat, double *lon, double * hgt )
{
    double p, u, u_prime;
    double a = Major_Axis;
    double flat = Earth_Flattening;
    double b = Minor_axis_value;
    double e2 = Eccentricity_squared;
    double ee2 = Eccentricity_squaredP;
    double sign = 1.0;

    /* Get the ellipsoid parameters */
    //geoGetEllipsoid (&a, &b, &e2, &ee2, &flat, datum);

    // Computes EFG to lat, lon & height
    p = sqrt(sqr(efg[GEO_E]) + sqr(efg[GEO_F]));

    u = atan2(efg[GEO_G] * a , p * b);

    *lat = atan((efg[GEO_G] + ee2 * b * pow(sin(u),3.0) ) /
          ( p - e2 * a * pow(cos(u),3.0) ) );

    u_prime =  atan((1.0 - flat) * tan(*lat));
    if((p - a * cos(u_prime) ) < 0.0) sign= -1.0; // determine sign

//     *hgt = p / cos(*lat) - ( a / (sqrt(1.0 - e2 * pow(sin(*lat),2.0))));   //same results
    *hgt =  sign * sqrt( sqr( p - a * cos(u_prime)) +
                         sqr(efg[GEO_G] - b * sin(u_prime)));
    *lon = atan2(efg[GEO_F], efg[GEO_E]);  // atan(f/e)

}

void wsg84_Llh2Efg (double lat, double lon, double height,
                    double *e,  double *f,  double *g)
{
    double N,a,e2,ee2, b, flat;

    /* Get the ellipsoid parameters */
    // geoGetEllipsoid(&a,&b,&e2,&ee2,&flat,datum);
    a = Major_Axis;
    flat = Earth_Flattening;
    b = Minor_axis_value;
    e2 = Eccentricity_squared;
    ee2 = Eccentricity_squaredP;

    /* Compute the radius of curvature */
    N = a / (sqrt(1.0 - e2 * pow(sin(lat),2.0)));

    /* Compute the EFG(XYZ) coordinates (earth centered) */
    *e = (N + height) * cos(lat) * cos(lon);
    *f = (N + height) * cos(lat) * sin(lon);
    *g = (N * (1.0 - e2) + height) * sin(lat);

}

void Normal2Llh( sgVec3 xyz, double *lat, double *lon, double * hgt )
{
   double factor = 10000000.0;
   double efg[3];
   efg[GEO_E] = xyz[0] * factor;
   efg[GEO_F] = xyz[1] * factor;
   efg[GEO_G] = xyz[2] * factor;
   wgs84_EFG2Llh( efg, lat, lon, hgt );
}
void Normal2Llhv3( sgVec3 xyz, sgVec3 dst )
{
   double factor = 10000000.0;
   double efg[3];
   double ddst[3];
   efg[GEO_E] = xyz[0] * factor;
   efg[GEO_F] = xyz[1] * factor;
   efg[GEO_G] = xyz[2] * factor;
   wgs84_EFG2Llh( efg, &ddst[0], &ddst[1], &ddst[2] );
   dst[0] = (float)ddst[0];
   dst[1] = (float)ddst[1];
   dst[2] = (float)ddst[2];
}

// eof - poly-geod.cxx
