// poly-dlgs.cxx

#include <stdio.h>  // for sprintf
#include "poly-view.hxx"
#include "poly-dlgs.hxx"
#include "poly-load.hxx"    // get_g_center_lon|lat
#include "poly-utils.hxx"   // for Instr(), in_world_range(lon,lat)

//extern double get_g_map_zoom( void );  // { return g_map_zoom; }
//extern double set_g_map_zoom( double zoom ); // and return previous
extern void Do_InvalidateRect(void * vp);

// Center a CHILD on a PARENT window
// =================================

BOOL CenterWindow(HWND hwndChild, HWND hwndParent)
{
    RECT    rcChild, rcParent;
    int     cxChild, cyChild, cxParent, cyParent;
    int     cxScreen, cyScreen, xNew, yNew;
    HDC     hdc;

    // Get the Height and Width of the child window
    GetWindowRect(hwndChild, &rcChild);
    cxChild = rcChild.right - rcChild.left;
    cyChild = rcChild.bottom - rcChild.top;

    // Get the Height and Width of the parent window
    GetWindowRect(hwndParent, &rcParent);
    cxParent = rcParent.right - rcParent.left;
    cyParent = rcParent.bottom - rcParent.top;

    // Get the display limits
    hdc = GetDC(hwndChild);
    cxScreen = GetDeviceCaps(hdc, HORZRES);
    cyScreen = GetDeviceCaps(hdc, VERTRES);
    ReleaseDC(hwndChild, hdc);

    // Calculate new X position, then adjust for screen
    xNew = rcParent.left + ((cxParent - cxChild) / 2);
    if (xNew < 0) {
        xNew = 0;
    } else if ((xNew + cxChild) > cxScreen) {
        xNew = cxScreen - cxChild;
    }

    // Calculate new Y position, then adjust for screen
    yNew = rcParent.top  + ((cyParent - cyChild) / 2);
    if (yNew < 0) {
        yNew = 0;
    } else if ((yNew + cyChild) > cyScreen) {
        yNew = cyScreen - cyChild;
    }

    // Set it, and return
    return SetWindowPos(hwndChild,
                        NULL,
                        xNew, yNew,
                        0, 0,
                        SWP_NOSIZE | SWP_NOZORDER);
}	// end - BOOL CenterWindow(HWND hwndChild, HWND hwndParent)

// =========================================
// About BOX

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
        CenterWindow(hDlg, GetWindow(hDlg, GW_OWNER));
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

VOID Do_IDM_ABOUT( HWND hWnd )
{
    DialogBox(g_hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
}

// ==================================================
// ZOOM DIALOG
/* =====================================
IDD_ZOOM DIALOG  0, 0, 292, 110
STYLE DS_SETFONT | DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU
CAPTION "SET NEW ZOOM VALUE"
FONT 8, "MS Sans Serif"
BEGIN
    DEFPUSHBUTTON   "OK",IDOK,235,89,50,14
    PUSHBUTTON      "Cancel",IDCANCEL,63,89,50,14
    LTEXT           "Current",IDC_CURR_ZOOM,7,19,278,12,SS_SUNKEN
    LTEXT           "Enter new zoom factor:",IDC_CURR_MSG,7,40,73,10
    EDITTEXT        IDC_EDIT1,7,57,278,12,ES_AUTOHSCROLL
END
   ===================================== */
static char tbuf[264];
VOID Do_Z_WM_INITDIALOG(HWND hDlg)
{
    double zoom = get_g_map_zoom() * 1000.0;    // get current zoom X 1000
    char * cp = tbuf;
    sprintf(cp,"Current Zoom [%f] (x 1000)",zoom);
    SetDlgItemText( hDlg, IDC_CURR_ZOOM, cp );

    CenterWindow(hDlg, GetWindow(hDlg, GW_OWNER));

    SetFocus( GetDlgItem( hDlg, IDC_EDIT1 ) );
}

VOID Do_Z_IDOK(HWND hDlg)
{
    double zoom = get_g_map_zoom() * 1000.0;    // get current zoom X 1000
    char * cp = tbuf;
    UINT ui;

    *cp = 0;
    ui = GetDlgItemText( hDlg, IDC_EDIT1, cp, 256 );
    if ( ui ) {
        double nzoom = atof(cp);
        if ((nzoom > 0.0) && ((nzoom < zoom)||(nzoom > zoom))) {
            sprtf("Setting NEW ZOOM factor %g (%f)\n", nzoom, nzoom );
            nzoom /= 1000.0;
            set_g_map_zoom(nzoom);
            Do_InvalidateRect(NULL);
        }
    }
}


INT_PTR CALLBACK ZOOMDLG(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
        Do_Z_WM_INITDIALOG(hDlg);
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK) {
            Do_Z_IDOK(hDlg);
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
        } else if (LOWORD(wParam) == IDCANCEL) {
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
        }
		break;
	}
	return (INT_PTR)FALSE;
}

VOID Do_IDM_ZOOM(HWND hWnd)
{
    DialogBox(g_hInst, MAKEINTRESOURCE(IDD_ZOOM), hWnd, ZOOMDLG);
}

// ===============================================================
// void set_g_center_lon_lat( double lon, double lat )

VOID Do_C_WM_INITDIALOG(HWND hDlg)
{
    double clon = get_g_center_lon();
    double clat = get_g_center_lat();
    char * cp = tbuf;

    SetWindowText(hDlg, "SET NEW CENTER");

    sprintf(cp,"Current Center - lon %0.6f lat %0.6f",clon,clat);
    SetDlgItemText( hDlg, IDC_CURR_ZOOM, cp );

    SetDlgItemText( hDlg, IDC_CURR_MSG, "Enter new center:" );

    sprintf(cp,"%0.6f,%0.6f",clon,clat);
    SetDlgItemText( hDlg, IDC_EDIT1, cp );

    CenterWindow(hDlg, GetWindow(hDlg, GW_OWNER));

    SetFocus( GetDlgItem( hDlg, IDC_EDIT1 ) );
}

int set_new_center_lon_lat( double nlon, double nlat )
{
    double clon = get_g_center_lon();
    double clat = get_g_center_lat();
    if (((nlon < clon)||(nlon > clon)||(nlat < clat)||(nlat > clat))&&
        in_world_range(nlon,nlat)) {
        // we have a CHANGED (valid) CENTER
        set_g_center_lon_lat( nlon, nlat );
        sprtf("--center-lon-lat=%0.6f,%0.6f\n", nlon, nlat );
        Do_InvalidateRect(NULL);
        return 1;
    }
    return 0;
}


VOID Do_C_IDOK(HWND hDlg)
{
    char * cp = tbuf;
    unsigned int ui;
    int i;
    char * cp2;

    *cp = 0;
    ui = GetDlgItemText( hDlg, IDC_EDIT1, cp, 256 );
    if ( !ui )
        return;
    i = InStr(cp,",");
    if (i < 2)
        return;
    cp2 = &cp[i];
    cp[i-1] = 0;

    double nlon = atof(cp);
    double nlat = atof(cp2);
    set_new_center_lon_lat( nlon, nlat );

}

INT_PTR CALLBACK CENTERDLG(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
        Do_C_WM_INITDIALOG(hDlg);
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK) {
            Do_C_IDOK(hDlg);
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
        } else if (LOWORD(wParam) == IDCANCEL) {
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
        }
		break;
	}
	return (INT_PTR)FALSE;
}

VOID Do_IDM_CENTER(HWND hWnd)
{
    DialogBox(g_hInst, MAKEINTRESOURCE(IDD_ZOOM), hWnd, CENTERDLG);
}

// =========================================================

VOID Do_X_WM_INITDIALOG(HWND hDlg)
{

    char * cp = tbuf;
    int spread = get_poly_globs()->g_fixed_spread;

    SetWindowText(hDlg, "SET NEW SPREAD");

    sprintf(cp,"Current Spread = %d",spread);
    SetDlgItemText( hDlg, IDC_CURR_ZOOM, cp );

    SetDlgItemText( hDlg, IDC_CURR_MSG, "Enter new spread X:" );

    sprintf(cp,"%d",spread);
    SetDlgItemText( hDlg, IDC_EDIT1, cp );

    CenterWindow(hDlg, GetWindow(hDlg, GW_OWNER));

    SetFocus( GetDlgItem( hDlg, IDC_EDIT1 ) );
}
VOID Do_X_IDOK(HWND hDlg)
{
    char * cp = tbuf;
    unsigned int ui;
    int spread;
    *cp = 0;
    ui = GetDlgItemText( hDlg, IDC_EDIT1, cp, 256 );
    if ( !ui || (*cp == 0))
        return;
    spread = atoi(cp);
    if (spread >= 0) {
        int old = get_poly_globs()->g_fixed_spread;
        if (old != spread) {
            get_poly_globs()->g_fixed_spread = spread;
            sprtf("set new --set-spread-x=%d old=%d\n", spread, old );
            Do_InvalidateRect(NULL);
        }
    }
}


INT_PTR CALLBACK SPREADXDLG(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        Do_X_WM_INITDIALOG(hDlg);
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK) {
            Do_X_IDOK(hDlg);
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        } else if (LOWORD(wParam) == IDCANCEL) {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}
VOID Do_IDM_SPREAD_X(HWND hWnd)
{
    DialogBox(g_hInst, MAKEINTRESOURCE(IDD_ZOOM), hWnd, SPREADXDLG);
}


// =========================================================

// eof - poly-dlgs.cxx
