// poly-context.cxx

#include "poly-view.hxx"
#include "poly-context.hxx"
#include "poly-load.hxx"    // for mm_pt2ll macro
#include "poly-utils.hxx"   // for win_pt2ll() func used in above macro
#include "poly-dlgs.hxx"

#define  AM(a,b)  Append_2_Menu(hMenu,uFlags,a,b)

static double cm_lon = NO_LATLON;
static double cm_lat = NO_LATLON;

int get_context_lon_lat( double * plon, double * plat )
{
    if ( in_world_range( cm_lon, cm_lat ) ) {
        *plon = cm_lon;
        *plat = cm_lat;
        return 1;
    }
    return 0;
}

BOOL Append_2_Menu( HMENU hMenu, UINT uFlags, UINT uCmd, PTSTR lpb )
{
   BOOL  bRet = FALSE;
   //if( Not_Yet_Added( uCmd ) )
      bRet = AppendMenu( hMenu, uFlags, uCmd, lpb );
   return bRet;
}



// Handler for
// WM_CONTEXTMENU -  WPARAM wParam; LPARAM lParam;
// wParam 
// Handle to the window in which the user right-clicked the mouse.
// This can be a child window of the window receiving the message. 
// For more information about processing this message, see the Remarks section. 

// lParam 
// The low-order word specifies the horizontal position of the cursor,
// in screen coordinates, at the time of the mouse click. 
// The high-order word specifies the vertical position of the cursor, 
// in screen coordinates, at the time of the mouse click. 
VOID Do_WM_CONTEXTMENU( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
    POINT pnt;
    HMENU hMenu;
    HWND  hChild = (HWND)wParam;   // get PARENT handle
    char * cp = GetNxtBuf();
    PPolyGlobs ppg = get_poly_globs();

    if ( hChild != g_hWnd )
        return;

    pnt.x = LOWORD(lParam);
    pnt.y = HIWORD(lParam);
    double dx = (double)pnt.x;
    double dy = (double)pnt.y;
    mm_pt2ll( &cm_lat, &cm_lon, dx, dy );

    hMenu = CreatePopupMenu(); // create a POPUP Menu
    if ( !hMenu )
        return;

    UINT uFlags = MF_STRING | MF_BYCOMMAND;
    UINT uOpts  = TPM_LEFTALIGN | TPM_TOPALIGN;

    if ( in_world_range( cm_lon, cm_lat ) ) {
        sprintf(cp,"Center on %0.6f,%0.6f", cm_lon, cm_lat);
        AM( IDM_CENTER2, cp );
    }
    // ================================================================
    cp = GetNxtBuf();
    sprintf(cp, "Toggle polygon fill %s", ppg->g_fill_polygon ? "Off" : "On" ); 
    AM( IDM_FILL_POLY, cp );
    // ================================================================
    cp = GetNxtBuf();
    sprintf(cp, "Toggle scenery fill %s", ppg->g_fill_scene ? "Off" : "On" ); 
    AM( IDM_FILL_SCENE, cp );
    // ================================================================
    cp = GetNxtBuf();
    sprintf(cp, "Toggle paint points as X %s", ppg->g_paint_X ? "Off" : "On" );
    AM( IDM_PAINT_X, cp );
    // ================================================================
    if (ppg->g_fit_point_count) {
        cp = GetNxtBuf();
        sprintf(cp, "Toggle paint fit points %s (%d)",
            ppg->g_paint_fit_points ? "Off" : "On",
            ppg->g_fit_point_count );
        AM( IDM_PAINT_FIT_POINTS, cp );
    }
    // ================================================================
    if (ppg->g_fit_tris_count) {
        cp = GetNxtBuf();
        sprintf(cp, "Toggle paint fit tris %s (%d)",
            ppg->g_paint_fit_tris ? "Off" : "On",
            ppg->g_fit_tris_count );
        AM( IDM_PAINT_FIT_TRIS, cp );
    }
    // ================================================================
    if (ppg->g_bucket_count > 1) {
        cp = GetNxtBuf();
        sprintf(cp, "Toggle paint buckets %s (%d)",
            ppg->g_paint_buckets ? "Off" : "On",
            ppg->g_bucket_count );
        AM( IDM_PAINT_BUCKETS, cp );

    }
    // ================================================================
    AM( IDM_EXIT,  "Exit Application [ESC]!" );

    TrackPopupMenu( hMenu,         // handle to shortcut menu
        uOpts,   // TPM_CENTERALIGN | TPM_VCENTERALIGN, // options
        pnt.x,   // horizontal position
        pnt.y,   // vertical position
        0,       // reserved, must be zero
        hWnd,    // handle to owner window
        0 );     // ignored


    DestroyMenu(hMenu);

}

VOID Do_IDM_CENTER2( HWND hWnd )
{
    double nlon, nlat;
    if ( get_context_lon_lat( &nlon, &nlat ) )
        set_new_center_lon_lat( nlon, nlat );
}

// eof - poly-context.cxx
