// load-poly.hxx
#ifndef _load_poly_hxx_
#define _load_poly_hxx_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <simgear/compiler.h>

#include <iostream>
#include <string>
#include <vector>

#include <plib/sg.h>

#include <simgear/constants.h>
#include <simgear/bucket/newbucket.hxx>
#include <simgear/debug/logstream.hxx>
#include <simgear/math/polar3d.hxx>

#include <Geometry/poly_support.hxx>
#include <Array/array.hxx>
#include <Clipper/clipper.hxx>
#include <GenOutput/genobj.hxx>
#include <Match/match.hxx>
#include <Triangulate/triangle.hxx>
#include <landcover/landcover.hxx>
#include <Osgb36/osgb36.hxx>
#include <sstream>   // for ostringstream

#define  ADD_POLY_CLIPPING

using std::ostringstream;

typedef struct tagPolyCounter {
   int   size[TG_MAX_AREA_TYPES];
   int   total, points;
   Point3D pmin, pmax, pcenter, pdist;
}PolyCounter, * PPolyCounter;

class TGPolyLoad 
{
public:

   TGPolyList polys_in;
   TGPolyList polys_clipped;
   TGTriNodes fixed_elevations;

   // Constructor.
   TGPolyLoad (void);

   // Destructor.
   ~TGPolyLoad  (void);

   // Initialize Clipper (allocate and/or connect structures.)
   bool init();

   // Load a polygon definition file
   bool load_polys(const std::string& path, ostringstream & msg);
   int load_btg_polys(const std::string & file, ostringstream & msg );
   void transfer_paint_ops(void);

   // Load an Osgb36 polygon definition file
   bool load_osgb36_polys(const std::string& path, ostringstream & msg );

   // Add a polygon.
   void add_poly(int area, const TGPolygon &poly);

#ifdef   ADD_POLY_CLIPPING

   void move_slivers( TGPolygon& in, TGPolygon& out );
   void merge_slivers( TGPolyList& clipped, TGPolygon& slivers );
   // Clip all the polygons against each other in a priority scheme based
   // on order of the polygon type in the polygon type enum.
   bool clip_all(const point2d& min, const point2d& max);

   // Return output poly list
   inline TGPolyList get_polys_clipped() const { return polys_clipped; }

#endif // #ifdef   ADD_POLY_CLIPPING

   PPolyCounter ppc;

   double nudge;
};

#endif // #ifndef _load_poly_hxx_
// eof - load-poly.hxx
