// load-btg.cxx
// Second attempt at loading a BTG file

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <simgear/compiler.h>
#include <simgear/io/sg_binobj.hxx>
#include <Clipper/priorities.hxx>

#include "poly-view.hxx"
#include "load-btg.hxx"
#include "lib_sprtf.hxx"
#include "load-scene.hxx"
#include "poly-mygl.hxx"
#include "poly-load.hxx"

//#include <string>
//using namespace std;
#define m_printf    sprtf
static int add_elevation_output2 = 0;   // Triangle: add elevation as well

#define my_glBegin m_glBegin
#define my_glVertex3fv m_glVertex3fv
#define my_glEnd m_glEnd
#define my_glColor4fv m_glColor4fv

static int btg_triangles = 0;
static int btg_verticies = 0;
#ifndef GL_TRIANGLES
#define GL_TRIANGLES                      0x0004
#endif

SGVec3d act_gbs_p;
SGGeod act_center_geod;
string act_material;
AreaType act_poly_type = DefaultArea;
SGBucket act_tile_bucket;

struct pv_SGVertNormTex {
  pv_SGVertNormTex()
  { }
  pv_SGVertNormTex(const SGVec3f& v, const SGVec3f& n, const SGVec2f& t) :
    vertex(v), normal(n), texCoord(t)
  { }
  struct less
  {
    inline bool operator() (const pv_SGVertNormTex& l,
                            const pv_SGVertNormTex& r) const
    {
      if (l.vertex < r.vertex) return true;
      else if (r.vertex < l.vertex) return false;
      else if (l.normal < r.normal) return true;
      else if (r.normal < l.normal) return false;
      else return l.texCoord < r.texCoord;
    }
  };

  SGVec3f vertex;
  SGVec3f normal;
  SGVec2f texCoord;
};

pv_SGVertNormTex v0, v1, v2;

int get_act_poly_type(void) { return (int)act_poly_type; }



static SGVec2f
pv_getTexCoord(const std::vector<SGVec2f>& texCoords, const int_list& tc,
              const SGVec2f& tcScale, unsigned i)
{
    if (tc.empty())
      return tcScale;
    else if (tc.size() == 1)
      return mult(texCoords[tc[0]], tcScale);
    else
      return mult(texCoords[tc[i]], tcScale);
}

static void btg_drawTriangle(const sgVec3 *p)
{
    btg_triangles++;
    my_glColor4fv(get_map_palette_color_ptr(act_material)); // set act_col
    my_glBegin(GL_TRIANGLES);   // start a group
    for (int i = 0; i < 3; i++) {
        my_glVertex3fv(p[i]);   // set verticies
        btg_verticies++;
    }
    my_glEnd();                 // end group
}

static void
triangles_insert(pv_SGVertNormTex & v0, pv_SGVertNormTex & v1, pv_SGVertNormTex & v2)
{
    SGVec3d p1((double)v0.vertex.x(),(double)v0.vertex.y(),(double)v0.vertex.z());
    SGVec3d p2((double)v1.vertex.x(),(double)v1.vertex.y(),(double)v1.vertex.z());
    SGVec3d p3((double)v2.vertex.x(),(double)v2.vertex.y(),(double)v2.vertex.z());
    p1 += act_gbs_p;
    p2 += act_gbs_p;
    p3 += act_gbs_p;
    SGGeod g1 = SGGeod::fromCart(p1);
    SGGeod g2 = SGGeod::fromCart(p2);
    SGGeod g3 = SGGeod::fromCart(p3);
    if (VERB9) {
        if (add_elevation_output2 ) {
            m_printf("Triangle: %g,%g,%g - %g,%g,%g - %g,%g,%g\n",
              g1.getLongitudeDeg(),g1.getLatitudeDeg(),g1.getElevationM(),
              g2.getLongitudeDeg(),g2.getLatitudeDeg(),g2.getElevationM(),
              g3.getLongitudeDeg(),g3.getLatitudeDeg(),g3.getElevationM() );
        } else {
            m_printf("Triangle: %g,%g %g,%g %g,%g\n",
              g1.getLongitudeDeg(),g1.getLatitudeDeg(),
              g2.getLongitudeDeg(),g2.getLatitudeDeg(),
              g3.getLongitudeDeg(),g3.getLatitudeDeg() );
        }
    }
    sgVec3 vp[3];
    vp[0][0] = g1.getLongitudeDeg();
    vp[0][1] = g1.getLatitudeDeg();
    vp[0][2] = g1.getElevationM();

    vp[1][0] = g2.getLongitudeDeg();
    vp[1][1] = g2.getLatitudeDeg();
    vp[1][2] = g2.getElevationM();

    vp[2][0] = g3.getLongitudeDeg();
    vp[2][1] = g3.getLatitudeDeg();
    vp[2][2] = g3.getElevationM();

    btg_drawTriangle(&vp[0]);
}

static void
pv_addTriangleGeometry(const std::string& mat, // SGTexturedTriangleBin& triangles,
                      const std::vector<SGVec3d>& vertices,
                      const std::vector<SGVec3f>& normals,
                      const std::vector<SGVec2f>& texCoords,
                      const int_list& tris_v,
                      const int_list& tris_n,
                      const int_list& tris_tc,
                      const SGVec2f& tcScale)
{
    if (tris_v.size() != tris_n.size()) {
      // If the normal indices do not match, they should be inmplicitly
      // the same than the vertex indices. So just call ourselves again
      // with the matching index vector.
      pv_addTriangleGeometry(mat, vertices, normals, texCoords,
                          tris_v, tris_v, tris_tc, tcScale);
      return;
    }

    for (unsigned i = 2; i < tris_v.size(); i += 3) {
      //SGVertNormTex v0;
      v0.vertex = toVec3f(vertices[tris_v[i-2]]);
      v0.normal = normals[tris_n[i-2]];
      v0.texCoord = pv_getTexCoord(texCoords, tris_tc, tcScale, i-2);
      //SGVertNormTex v1;
      v1.vertex = toVec3f(vertices[tris_v[i-1]]);
      v1.normal = normals[tris_n[i-1]];
      v1.texCoord = pv_getTexCoord(texCoords, tris_tc, tcScale, i-1);
      //SGVertNormTex v2;
      v2.vertex = toVec3f(vertices[tris_v[i]]);
      v2.normal = normals[tris_n[i]];
      v2.texCoord = pv_getTexCoord(texCoords, tris_tc, tcScale, i);
      //triangles.insert(v0, v1, v2);
    }
}

static void
pv_addStripGeometry(const std::string& mat, // SGTexturedTriangleBin& triangles,
                   const std::vector<SGVec3d>& vertices,
                   const std::vector<SGVec3f>& normals,
                   const std::vector<SGVec2f>& texCoords,
                   const int_list& strips_v,
                   const int_list& strips_n,
                   const int_list& strips_tc,
                   const SGVec2f& tcScale)
  {
    if (strips_v.size() != strips_n.size()) {
      // If the normal indices do not match, they should be inmplicitly
      // the same than the vertex indices. So just call ourselves again
      // with the matching index vector.
      pv_addStripGeometry(mat, vertices, normals, texCoords,
                       strips_v, strips_v, strips_tc, tcScale);
      return;
    }

    for (unsigned i = 2; i < strips_v.size(); ++i) {
      //SGVertNormTex v0;
      v0.vertex = toVec3f(vertices[strips_v[i-2]]);
      v0.normal = normals[strips_n[i-2]];
      v0.texCoord = pv_getTexCoord(texCoords, strips_tc, tcScale, i-2);
      //SGVertNormTex v1;
      v1.vertex = toVec3f(vertices[strips_v[i-1]]);
      v1.normal = normals[strips_n[i-1]];
      v1.texCoord = pv_getTexCoord(texCoords, strips_tc, tcScale, i-1);
      //SGVertNormTex v2;
      v2.vertex = toVec3f(vertices[strips_v[i]]);
      v2.normal = normals[strips_n[i]];
      v2.texCoord = pv_getTexCoord(texCoords, strips_tc, tcScale, i);
      if (i%2)
        //triangles.insert(v1, v0, v2);
        triangles_insert(v1, v0, v2);
      else
        //triangles.insert(v0, v1, v2);
        triangles_insert(v0, v1, v2);
    }
}
  
static void
pv_addFanGeometry(const std::string & mat, // SGTexturedTriangleBin& triangles,
                 const std::vector<SGVec3d>& vertices,
                 const std::vector<SGVec3f>& normals,
                 const std::vector<SGVec2f>& texCoords,
                 const int_list& fans_v,
                 const int_list& fans_n,
                 const int_list& fans_tc,
                 const SGVec2f& tcScale)
  {
    if (fans_v.size() != fans_n.size()) {
      // If the normal indices do not match, they should be implicitly
      // the same than the vertex indices. So just call ourselves again
      // with the matching index vector.
      pv_addFanGeometry(mat, vertices, normals, texCoords,
                     fans_v, fans_v, fans_tc, tcScale);
      return;
    }

    //SGVertNormTex v0;
    v0.vertex = toVec3f(vertices[fans_v[0]]);
    v0.normal = normals[fans_n[0]];
    v0.texCoord = pv_getTexCoord(texCoords, fans_tc, tcScale, 0);
    //SGVertNormTex v1;
    v1.vertex = toVec3f(vertices[fans_v[1]]);
    v1.normal = normals[fans_n[1]];
    v1.texCoord = pv_getTexCoord(texCoords, fans_tc, tcScale, 1);
    for (unsigned i = 2; i < fans_v.size(); ++i) {
      //SGVertNormTex v2;
      v2.vertex = toVec3f(vertices[fans_v[i]]);
      v2.normal = normals[fans_n[i]];
      v2.texCoord = pv_getTexCoord(texCoords, fans_tc, tcScale, i);
      //triangles.insert(v0, v1, v2);
      triangles_insert(v0, v1, v2);
      v1 = v2;
    }
}

//bool insertSurfaceGeometry(const SGBinObject& obj, SGMaterialLib* matlib)
bool btg_insertSurfaceGeometry(const SGBinObject& obj)
{
    unsigned int grp;
#define materialName act_material

    if (obj.get_tris_n().size() < obj.get_tris_v().size() ||
        obj.get_tris_tc().size() < obj.get_tris_v().size())
    {
        sprtf("ERROR: Group list sizes for triangles do not match!\n");
        return false;
    }
    if (obj.get_strips_n().size() < obj.get_strips_v().size() ||
        obj.get_strips_tc().size() < obj.get_strips_v().size()) {
        sprtf("ERROR: Group list sizes for strips do not match!\n");
        return false;
    }
    if (obj.get_fans_n().size() < obj.get_fans_v().size() ||
        obj.get_fans_tc().size() < obj.get_fans_v().size()) {
        sprtf("ERROR: Group list sizes for fans do not match!\n");
        return false;
    }

    SGVec2f tcScale(1,1);

    for (grp = 0; grp < obj.get_tris_v().size(); ++grp) {
      materialName = obj.get_tri_materials()[grp];
      act_poly_type = get_area_type( materialName );
      //SGVec2f tcScale = getTexCoordScale(materialName, matlib);
      m_set_act_material(materialName, "load-btg:tris");
      pv_addTriangleGeometry(materialName,
                          obj.get_wgs84_nodes(), obj.get_normals(),
                          obj.get_texcoords(), obj.get_tris_v()[grp],
                          obj.get_tris_n()[grp], obj.get_tris_tc()[grp],
                          tcScale);
    }

    for (grp = 0; grp < obj.get_strips_v().size(); ++grp) {
      materialName = obj.get_strip_materials()[grp];
      //SGVec2f tcScale = getTexCoordScale(materialName, matlib);
      act_poly_type = get_area_type( materialName );
      m_set_act_material(materialName, "load-btg:strips");
      pv_addStripGeometry(materialName,
                       obj.get_wgs84_nodes(), obj.get_normals(),
                       obj.get_texcoords(), obj.get_strips_v()[grp],
                       obj.get_strips_n()[grp], obj.get_strips_tc()[grp],
                       tcScale);
    }

    for (grp = 0; grp < obj.get_fans_v().size(); ++grp) {
      materialName = obj.get_fan_materials()[grp];
      //SGVec2f tcScale = getTexCoordScale(materialName, matlib);
      act_poly_type = get_area_type( materialName );
      m_set_act_material(materialName,"load-btg:fans");
      pv_addFanGeometry(materialName,
                     obj.get_wgs84_nodes(), obj.get_normals(),
                     obj.get_texcoords(), obj.get_fans_v()[grp],
                     obj.get_fans_n()[grp], obj.get_fans_tc()[grp],
                     tcScale);
    }
    sprtf("Added %d verticies, in %d triangles...\n",
        btg_verticies, btg_triangles);

    return true;
}

bool process_bin_load(SGBinObject & obj)
{
    act_gbs_p = obj.get_gbs_center2();
    act_center_geod = SGGeod::fromCart(act_gbs_p);
    sprtf("Center lat=%g degs, lon=%g degs, elev=%g meters (x,y,z=%g,%g,%g)\n",
        act_center_geod.getLongitudeDeg(),
        act_center_geod.getLatitudeDeg(),
        act_center_geod.getElevationM(),
        act_gbs_p.x(), act_gbs_p.y(), act_gbs_p.z());
    act_tile_bucket.set_bucket(act_center_geod);
    sprtf("Bucket: %s/%d\n", 
        act_tile_bucket.gen_base_path().c_str(),
        act_tile_bucket.gen_index());

    return btg_insertSurfaceGeometry(obj);
}

int load_btg_tile_polys2( char * in_file )
{
    int iret = 0;
    string file = in_file;
    if ( ! is_mapobj_palette_loaded() ) {
        sprtf("ERROR: Loading BTG %s, BUT NO PALETTE LOADED!\n", in_file);
        return 2;
    }
    SGBinObject obj;
    if ( obj.read_bin(file) ) {
        process_bin_load(obj);
    } else {
        sprtf("ERROR: Unable to LOAD [%s] file!\n", in_file);
        iret = 1;
    }

    return iret;
}

// eof - load-btg.cxx

