// load-arr.cxx

#include <vector>
#include <Array/array.hxx>
#include <Polygon/polygon.hxx>

#include "poly-view.hxx"
#include "load-poly.hxx"
#include "load-arr.hxx"
#include "poly-utils.hxx"
#include "poly-array.hxx"
#include "poly-load.hxx"

#define M_VERYSMALL 0.0000001
#define paint_fit_points get_poly_globs()->g_paint_fit_points
#define paint_fit_tris   get_poly_globs()->g_paint_fit_tris

static int debug_write_arr_txt = 0; // write a DEBUG file
static int debug_compare_alts = 1;
static char * temp_arr_txt = "temppvarr.txt";

static     PVArray _array;
static     std::string arr_file;
static     std::string fit_file;

std::string get_base_file_name(const std::string & file)
{
    size_t pos = file.rfind('.');
    if ( pos != std::string::npos ) {
        std::string base = file.substr(0,pos);
        std::string ext = file.substr(pos);
        if (ext == ".gz") {
            pos = base.rfind('.');
            if ( pos != std::string::npos ) {
                base = file.substr(0,pos);
            }
        }
        return base;
    }
    return file;
}

int load_arr_polys_using_lib(const std::string & file)
{
    TGArray _array;
    std::string base, name, dir, ext;
    split_file_path(file, dir, name, ext);
    long index = atoi(name.c_str());
    SGBucket b(index);
    base = dir + "/" + name;
    //std::string base = get_base_file_name(file);
    if( _array.open(base) ) {
        _array.parse(b);
        _array.close();
    }

    return 0;
}

int load_arr_polys(const std::string & file, TGPolyLoad * ppl )
{
    int point_count = 0;
    PPolyGlobs ppg = get_poly_globs();
    //PVArray _array;
    TGPolygon poly;

    std::string base, name, dir, ext;
    split_file_path(file, dir, name, ext);
    long index = atoi(name.c_str());
    SGBucket b(index);
    base = dir + "/" + name;
    //std::string base = get_base_file_name(file);
    arr_file = base + ".arr.gz";
    fit_file = base + ".fit.gz";
    sprtf("Openning array base [%s]...\n", base.c_str());
    if (_array.open(base)) {
        if( _array.parse(b) ) {
            int area = (int)DefaultArea;   // = AreaType poly_type
            double lon, lat, alt, galt, diff;
            int cols, rows, i, j, k;
            double ox, oy;
            double col_step, row_step;
            point_list flist = _array.get_fitted_list();
            ox = _array.get_originx();
            oy = _array.get_originy();
            cols = _array.get_cols();
            rows = _array.get_rows();
            col_step = _array.get_col_step();
            row_step = _array.get_row_step();
            k = (int) flist.size();
            if (k && paint_fit_points) {
                if (paint_fit_tris && _array.fit_tris.size()) {
                    pvTRIV t;
                    Point3D p;
                    k = _array.fit_tris.size();
                    sprtf( "Adding %d fitted tris...\n", k );
                    ppg->g_fit_tris_count = k;
                    for (i = 0; i < k; i++) {
                        t = _array.fit_tris[i];
                        p[0] = t.p1.x();
                        p[1] = t.p1.y();
                        p[2] = t.p1.z();
                        poly.add_node( i, p );
                        p[0] = t.p2.x();
                        p[1] = t.p2.y();
                        p[2] = t.p2.z();
                        poly.add_node( i, p );
                        p[0] = t.p3.x();
                        p[1] = t.p3.y();
                        p[2] = t.p3.z();
                        poly.add_node( i, p );
                        point_count += 3;
                    }
                } else {
                    sprtf("Adding %d fit points...\n", k );
                    ppg->g_fit_point_count = k;
                    for (i = 0; i < k; i++) {
                        Point3D p = flist[i];
                        poly.add_node( i, p );
                        point_count++;
                    }
                }
            } else {
                k = 0;
                poly.erase();
                for (i = 0; i < cols; i++ ) {
                    for (j = 0; j < rows; j++ ) {
                        alt = _array.in_data[i][j];
                        lon = (ox + (i * col_step)) / 3600.0;
                        lat = (oy + (j * row_step)) / 3600.0;
                        //sprtf("%g %g %g\n", lon, lat, alt );
                        //sprtf("%.15f %.15f %.1f\n", lon, lat, alt );
                        Point3D p(lon,lat,alt);
                        poly.add_node( k, p );
                        point_count++;
                        k++;
                    }
                }
            }
            ppl->add_poly(area,poly);
            k = (int) flist.size();
            if (debug_write_arr_txt && k) {
                FILE * fp = fopen(temp_arr_txt,"w");
                if (fp) {
                    ox = _array.get_originx();
                    oy = _array.get_originy();
                    cols = _array.get_cols();
                    rows = _array.get_rows();
                    col_step = _array.get_col_step();
                    row_step = _array.get_row_step();
                    k = (int) flist.size();
                    for (i = 0; i < k; i++) {
                        Point3D p = flist[i];
                        lon = p[0];
                        lat = p[1];
                        alt = p[2];
                        galt = _array.altitude_from_grid(lon * 3600,lat * 3600);
                        diff = fabs(alt - galt);
                        fprintf(fp, "F %.8f %.8f %.1f %.1f %g\n",
                            lon, lat, alt, galt,
                            ((diff > M_VERYSMALL) ? diff : 0.0) );
                    }
                    for (i = 0; i < cols; i++ ) {
                        for (j = 0; j < rows; j++ ) {
                            alt = _array.in_data[i][j];
                            lon = (ox + (i * col_step)) / 3600.0;
                            lat = (oy + (j * row_step)) / 3600.0;
                            fprintf(fp, "A %.8f %.8f %.1f\n",
                                lon, lat, alt );
                        }
                    }

                    fclose(fp);
                }
            } // debug output to file
            if ( debug_compare_alts ) {
                int ialt, igalt, idiff;
                for (i = 0; i < k; i++) {
                    Point3D p = flist[i];
                    lon = p[0] * 3600;
                    lat = p[1] * 3600;
                    alt = p[2];
                    galt = _array.altitude_from_grid(lon,lat);
                    ialt = win_int(alt); // * 10.0);
                    igalt = win_int(galt); // * 10.0);
                    diff = fabs(alt - galt);
                    idiff = abs(ialt - igalt);
                    //if ( diff > M_VERYSMALL ) {
                    if ( idiff ) {
                        sprtf( "pt:%d: %.8f %.8f %.3f, vs %.3f (%g)\n",
                            (i + 1),
                            lon, lat, alt, galt, diff );
                    }
                }
            }
        }
        _array.close();
    }

    return point_count;
}

// eof - load-arr.cxx
