// lib_sprtf.cxx

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#pragma warning( disable:4996 )
#endif // #ifndef _CRT_SECURE_NO_DEPRECATE

#include <stdio.h>
#include <string.h> // for strcpy()
#include <stdarg.h> // for va_start

#include "lib_sprtf.hxx"

#define  MXIO     256
char def_log[] = "tempsprtf.txt";
char logfile[256] = "\0";
FILE * outfile = NULL;
int pv_verbosity = 0;

int   open_log_file( void )
{
   if (logfile[0] == 0)
      strcpy(logfile,def_log);
   outfile = fopen(logfile, "wb");
   if( outfile == 0 ) {
      outfile = (FILE *)-1;
      printf("WARNING: Failed to open log file [%s] ...\n", logfile);
      return 0;   /* failed */
   }
   return 1; /* success */
}

void close_log_file( void )
{
   if( VFP(outfile) ) {
      fclose(outfile);
   }
   outfile = NULL;
}

void   set_log_file( char * nf )
{
   if (logfile[0] == 0)
      strcpy(logfile,def_log);
   if ( nf && *nf && strcmpi(nf,logfile) ) {
      close_log_file(); // remove any previous
      strcpy(logfile,nf); // set new name
      open_log_file();  // and open it ... anything previous written is 'lost'
   }
}

static void oi( char * ps )
{
   int len = (int)strlen(ps);
   if(len) {
      if( outfile == 0 ) {
         open_log_file();
      }
      if( VFP(outfile) ) {
         int w = (int)fwrite( ps, 1, len, outfile );
         if( w != len ) {
            fclose(outfile);
            outfile = (FILE *)-1;
            printf("WARNING: Failed write to log file [%s] ...\n", logfile);
         }
         fflush( outfile );
      }
      fwrite( ps, 1, len, stdout );
   }
}

static void	prt( char * ps )
{
   static char buf[MXIO + 4];
	char * pb = buf;
	size_t i, j, k;
	char   c, d;
   i = strlen(ps);
	if(i) {
		k = 0;
		d = 0;
		for( j = 0; j < i; j++ )
		{
			c = ps[j];
			if( c == 0x0d ) {
				if( (j+1) < i ) {
					if( ps[j+1] != 0x0a ) {
						pb[k++] = c;
						c = 0x0a;
					}
            } else {
					pb[k++] = c;
					c = 0x0a;
				}
			} else if( c == 0x0a ) {
				if( d != 0x0d ) {
					pb[k++] = 0x0d;
				}
			}
			pb[k++] = c;
			d = c;
			if( k >= MXIO ) {
				pb[k] = 0;  // null terminate
				oi( pb );   // output to file
				k = 0;
			}
		}	// for length of string
		if( k ) {
			//if( ( gbCheckCrLf ) &&
			//	( d != 0x0a ) ) {
				// add Cr/Lf pair
				//pb[k++] = 0x0d;
				//pb[k++] = 0x0a;
				//pb[k] = 0;
			//}
			pb[k] = 0;  // null terminate
			oi( pb );   // output to file
		}
	}
}

void out_to_log( char * ps )
{
   prt(ps);
}

int set_pv_verbosity(int i)
{
    int iret = pv_verbosity;
    pv_verbosity = i;
    return iret;
}

int _cdecl sprtf( char * pf, ... )
{
   static char _s_sprtfbuf[4096];
   char * pb = _s_sprtfbuf;
   int   i;
   va_list arglist;
   va_start(arglist, pf);
   i = vsprintf( pb, pf, arglist );
   va_end(arglist);
   prt(pb);
   return i;
}

// eof - lib_sprtf.cxx
