
/************************************************************************
*                                                                       *
*   winerror.h --  error code definitions for the Win32 API functions   *
*                                                                       *
*   Copyright (c) 1991-1996, Microsoft Corp. All rights reserved.       *
*                                                                       *
************************************************************************/

//#ifndef _WINERROR_
//#define _WINERROR_
#include	<windows.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<stdio.h>
//#include	"WinError.h"
#include	"WinErr.h"

//typedef struct {
//	long	we_lgVal;
//	LPSTR	we_lpStg;
//	LPSTR	we_lpEStg;
//}WER;
//typedef WER * LPWER;

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
//#define FACILITY_WINDOWS                 8
//#define FACILITY_STORAGE                 3
//#define FACILITY_RPC                     1
//#define FACILITY_SSPI                    9
//#define FACILITY_WIN32                   7
//#define FACILITY_CONTROL                 10
//#define FACILITY_NULL                    0
//#define FACILITY_ITF                     4
//#define FACILITY_DISPATCH                2
//#define FACILITY_CERT                    11

#ifdef	NDEBUG
// NO DEBUG STUFF
void    outvals( void ){ /*NOTHING*/ }
void	OutWin32Err( long lErr ){ /*NOTHING*/ }

#else	/* !NDEBUG */
//
// Define the severity codes
//

WER		WEr[] = {
	{ ERROR_SUCCESS, "The operation completed successfully.", "ERROR_SUCCESS" },
	{ ERROR_INVALID_FUNCTION, "Incorrect function.", "ERROR_INVALID_FUNCTION" },
	{ ERROR_FILE_NOT_FOUND, "The system cannot find the file specified.", "ERROR_FILE_NOT_FOUND" },
	{ ERROR_PATH_NOT_FOUND, "The system cannot find the path specified.", "ERROR_PATH_NOT_FOUND" },
	{ ERROR_TOO_MANY_OPEN_FILES, "The system cannot open the file.", "ERROR_TOO_MANY_OPEN_FILES" },
	{ ERROR_ACCESS_DENIED, "Access is denied.", "ERROR_ACCESS_DENIED" },
	{ ERROR_INVALID_HANDLE, "The handle is invalid.", "ERROR_INVALID_HANDLE" },
	{ ERROR_ARENA_TRASHED, "The storage control blocks were destroyed.", "ERROR_ARENA_TRASHED" },
	{ ERROR_NOT_ENOUGH_MEMORY, "Not enough storage is available to process this command.", "ERROR_NOT_ENOUGH_MEMORY" },
	{ ERROR_INVALID_BLOCK, "The storage control block address is invalid.", "ERROR_INVALID_BLOCK" },
	{ ERROR_BAD_ENVIRONMENT, "The environment is incorrect.", "ERROR_BAD_ENVIRONMENT" },
	{ ERROR_BAD_FORMAT, "An attempt was made to load a program with an incorrect format..", "ERROR_BAD_FORMAT" },
	{ ERROR_INVALID_ACCESS, "The access code is invalid.", "ERROR_INVALID_ACCESS" },
	{ ERROR_INVALID_DATA, "The data is invalid.", "ERROR_INVALID_DATA" },
	{ ERROR_OUTOFMEMORY, "Not enough storage is available to complete this operation.", "ERROR_OUTOFMEMORY" },
	{ ERROR_INVALID_DRIVE, "The system cannot find the drive specified.", "ERROR_INVALID_DRIVE" },
	{ ERROR_CURRENT_DIRECTORY, "The directory cannot be removed.", "ERROR_CURRENT_DIRECTORY" },
	{ ERROR_NOT_SAME_DEVICE, "The system cannot move the file to a different disk drive..", "ERROR_NOT_SAME_DEVICE" },
	{ ERROR_NO_MORE_FILES, "There are no more files.", "ERROR_NO_MORE_FILES" },
	{ ERROR_WRITE_PROTECT, "The media is write protected.", "ERROR_WRITE_PROTECT" },
	{ ERROR_BAD_UNIT, "The system cannot find the device specified.", "ERROR_BAD_UNIT" },
	{ ERROR_NOT_READY, "The device is not ready.", "ERROR_NOT_READY" },
	{ ERROR_BAD_COMMAND, "The device does not recognize the command.", "ERROR_BAD_COMMAND" },
	{ ERROR_CRC, "Data error (cyclic redundancy check)", "ERROR_CRC" },
	{ ERROR_BAD_LENGTH, "The program issued a command but the command length is incorrect..", "ERROR_BAD_LENGTH" },
	{ ERROR_SEEK, "The drive cannot locate a specific area or track on the disk..", "ERROR_SEEK" },
	{ ERROR_NOT_DOS_DISK, "The specified disk or diskette cannot be accessed.", "ERROR_NOT_DOS_DISK" },
	{ ERROR_SECTOR_NOT_FOUND, "The drive cannot find the sector requested.", "ERROR_SECTOR_NOT_FOUND" },
	{ ERROR_OUT_OF_PAPER, "The printer is out of paper.", "ERROR_OUT_OF_PAPER" },
	{ ERROR_WRITE_FAULT, "The system cannot write to the specified device.", "ERROR_WRITE_FAULT" },
	{ ERROR_READ_FAULT, "The system cannot read from the specified device.", "ERROR_READ_FAULT" },
	{ ERROR_GEN_FAILURE, "A device attached to the system is not functioning.", "ERROR_GEN_FAILURE" },
	{ ERROR_SHARING_VIOLATION, "The process cannot access the file because it is being used by another process..", "ERROR_SHARING_VIOLATION" },
	{ ERROR_LOCK_VIOLATION, "The process cannot access the file because another process has locked a portion of the file..", "ERROR_LOCK_VIOLATION" },
	{ ERROR_WRONG_DISK, "The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1.1.", "ERROR_WRONG_DISK" },
	{ ERROR_SHARING_BUFFER_EXCEEDED, "Too many files opened for sharing.", "ERROR_SHARING_BUFFER_EXCEEDED" },
	{ ERROR_HANDLE_EOF, "Reached end of file.", "ERROR_HANDLE_EOF" },
	{ ERROR_HANDLE_DISK_FULL, "The disk is full.", "ERROR_HANDLE_DISK_FULL" },
	{ ERROR_NOT_SUPPORTED, "The network request is not supported.", "ERROR_NOT_SUPPORTED" },
	{ ERROR_REM_NOT_LIST, "The remote computer is not available.", "ERROR_REM_NOT_LIST" },
	{ ERROR_DUP_NAME, "A duplicate name exists on the network.", "ERROR_DUP_NAME" },
	{ ERROR_BAD_NETPATH, "The network path was not found.", "ERROR_BAD_NETPATH" },
	{ ERROR_NETWORK_BUSY, "The network is busy.", "ERROR_NETWORK_BUSY" },
	{ ERROR_DEV_NOT_EXIST, "The specified network resource or device is no longer available..", "ERROR_DEV_NOT_EXIST" },
	{ ERROR_TOO_MANY_CMDS, "The network BIOS command limit has been reached.", "ERROR_TOO_MANY_CMDS" },
	{ ERROR_ADAP_HDW_ERR, "A network adapter hardware error occurred.", "ERROR_ADAP_HDW_ERR" },
	{ ERROR_BAD_NET_RESP, "The specified server cannot perform the requested operation..", "ERROR_BAD_NET_RESP" },
	{ ERROR_UNEXP_NET_ERR, "An unexpected network error occurred.", "ERROR_UNEXP_NET_ERR" },
	{ ERROR_BAD_REM_ADAP, "The remote adapter is not compatible.", "ERROR_BAD_REM_ADAP" },
	{ ERROR_PRINTQ_FULL, "The printer queue is full.", "ERROR_PRINTQ_FULL" },
	{ ERROR_NO_SPOOL_SPACE, "Space to store the file waiting to be printed is not available on the server..", "ERROR_NO_SPOOL_SPACE" },
	{ ERROR_PRINT_CANCELLED, "Your file waiting to be printed was deleted.", "ERROR_PRINT_CANCELLED" },
	{ ERROR_NETNAME_DELETED, "The specified network name is no longer available.", "ERROR_NETNAME_DELETED" },
	{ ERROR_NETWORK_ACCESS_DENIED, "Network access is denied.", "ERROR_NETWORK_ACCESS_DENIED" },
	{ ERROR_BAD_DEV_TYPE, "The network resource type is not correct.", "ERROR_BAD_DEV_TYPE" },
	{ ERROR_BAD_NET_NAME, "The network name cannot be found.", "ERROR_BAD_NET_NAME" },
	{ ERROR_TOO_MANY_NAMES, "The name limit for the local computer network adapter card was exceeded..", "ERROR_TOO_MANY_NAMES" },
	{ ERROR_TOO_MANY_SESS, "The network BIOS session limit was exceeded.", "ERROR_TOO_MANY_SESS" },
	{ ERROR_SHARING_PAUSED, "The remote server has been paused or is in the process of being started..", "ERROR_SHARING_PAUSED" },
	{ ERROR_REQ_NOT_ACCEP, "No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept..", "ERROR_REQ_NOT_ACCEP" },
	{ ERROR_REDIR_PAUSED, "The specified printer or disk device has been paused.", "ERROR_REDIR_PAUSED" },
	{ ERROR_FILE_EXISTS, "The file exists.", "ERROR_FILE_EXISTS" },
	{ ERROR_CANNOT_MAKE, "The directory or file cannot be created.", "ERROR_CANNOT_MAKE" },
	{ ERROR_FAIL_I24, "Fail on INT 24", "ERROR_FAIL_I24" },
	{ ERROR_OUT_OF_STRUCTURES, "Storage to process this request is not available.", "ERROR_OUT_OF_STRUCTURES" },
	{ ERROR_ALREADY_ASSIGNED, "The local device name is already in use.", "ERROR_ALREADY_ASSIGNED" },
	{ ERROR_INVALID_PASSWORD, "The specified network password is not correct.", "ERROR_INVALID_PASSWORD" },
	{ ERROR_INVALID_PARAMETER, "The parameter is incorrect.", "ERROR_INVALID_PARAMETER" },
	{ ERROR_NET_WRITE_FAULT, "A write fault occurred on the network.", "ERROR_NET_WRITE_FAULT" },
	{ ERROR_NO_PROC_SLOTS, "The system cannot start another process at this time..", "ERROR_NO_PROC_SLOTS" },
	{ ERROR_TOO_MANY_SEMAPHORES, "Cannot create another system semaphore.", "ERROR_TOO_MANY_SEMAPHORES" },
	{ ERROR_EXCL_SEM_ALREADY_OWNED, "The exclusive semaphore is owned by another process.", "ERROR_EXCL_SEM_ALREADY_OWNED" },
	{ ERROR_SEM_IS_SET, "The semaphore is set and cannot be closed.", "ERROR_SEM_IS_SET" },
	{ ERROR_TOO_MANY_SEM_REQUESTS, "The semaphore cannot be set again.", "ERROR_TOO_MANY_SEM_REQUESTS" },
	{ ERROR_INVALID_AT_INTERRUPT_TIME, "Cannot request exclusive semaphores at interrupt time.", "ERROR_INVALID_AT_INTERRUPT_TIME" },
	{ ERROR_SEM_OWNER_DIED, "The previous ownership of this semaphore has ended.", "ERROR_SEM_OWNER_DIED" },
	{ ERROR_SEM_USER_LIMIT, "Insert the diskette for drive %1.", "ERROR_SEM_USER_LIMIT" },
	{ ERROR_DISK_CHANGE, "Program stopped because alternate diskette was not inserted.", "ERROR_DISK_CHANGE" },
	{ ERROR_DRIVE_LOCKED, "The disk is in use or locked by another process..", "ERROR_DRIVE_LOCKED" },
	{ ERROR_BROKEN_PIPE, "The pipe has been ended.", "ERROR_BROKEN_PIPE" },
	{ ERROR_OPEN_FAILED, "The system cannot open the device or file specified..", "ERROR_OPEN_FAILED" },
	{ ERROR_BUFFER_OVERFLOW, "The file name is too long.", "ERROR_BUFFER_OVERFLOW" },
	{ ERROR_DISK_FULL, "There is not enough space on the disk.", "ERROR_DISK_FULL" },
	{ ERROR_NO_MORE_SEARCH_HANDLES, "No more internal file identifiers available.", "ERROR_NO_MORE_SEARCH_HANDLES" },
	{ ERROR_INVALID_TARGET_HANDLE, "The target internal file identifier is incorrect.", "ERROR_INVALID_TARGET_HANDLE" },
	{ ERROR_INVALID_CATEGORY, "The IOCTL call made by the application program is not correct..", "ERROR_INVALID_CATEGORY" },
	{ ERROR_INVALID_VERIFY_SWITCH, "The verify-on-write switch parameter value is not correct..", "ERROR_INVALID_VERIFY_SWITCH" },
	{ ERROR_BAD_DRIVER_LEVEL, "The system does not support the command requested.", "ERROR_BAD_DRIVER_LEVEL" },
	{ ERROR_CALL_NOT_IMPLEMENTED, "This function is only valid in Windows NT mode.", "ERROR_CALL_NOT_IMPLEMENTED" },
	{ ERROR_SEM_TIMEOUT, "The semaphore timeout period has expired.", "ERROR_SEM_TIMEOUT" },
	{ ERROR_INSUFFICIENT_BUFFER, "The data area passed to a system call is too small..", "ERROR_INSUFFICIENT_BUFFER" },
	{ ERROR_INVALID_NAME, "The filename, directory name, or volume label syntax is incorrect.", "ERROR_INVALID_NAME" },
	{ ERROR_INVALID_LEVEL, "The system call level is not correct.", "ERROR_INVALID_LEVEL" },
	{ ERROR_NO_VOLUME_LABEL, "The disk has no volume label.", "ERROR_NO_VOLUME_LABEL" },
	{ ERROR_MOD_NOT_FOUND, "The specified module could not be found.", "ERROR_MOD_NOT_FOUND" },
	{ ERROR_PROC_NOT_FOUND, "The specified procedure could not be found.", "ERROR_PROC_NOT_FOUND" },
	{ ERROR_WAIT_NO_CHILDREN, "There are no child processes to wait for.", "ERROR_WAIT_NO_CHILDREN" },
	{ ERROR_CHILD_NOT_COMPLETE, "The %1 application cannot be run in Windows NT mode.", "ERROR_CHILD_NOT_COMPLETE" },
	{ ERROR_DIRECT_ACCESS_HANDLE, "Attempt to use a file handle to an open disk partition for an operation other than raw disk IO..", "ERROR_DIRECT_ACCESS_HANDLE" },
	{ ERROR_NEGATIVE_SEEK, "An attempt was made to move the file pointer before the beginning of the file.", "ERROR_NEGATIVE_SEEK" },
	{ ERROR_SEEK_ON_DEVICE, "The file pointer cannot be set on the specified device or file.", "ERROR_SEEK_ON_DEVICE" },
	{ ERROR_IS_JOIN_TARGET, "A JOIN or SUBST command cannot be used for a drive that contains previously joined drives.s.", "ERROR_IS_JOIN_TARGET" },
	{ ERROR_IS_JOINED, "An attempt was made to use a JOIN or SUBST command on a drive that has already been joined.d.", "ERROR_IS_JOINED" },
	{ ERROR_IS_SUBSTED, "An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted.d.", "ERROR_IS_SUBSTED" },
	{ ERROR_NOT_JOINED, "The system tried to delete the JOIN of a drive that is not joined..", "ERROR_NOT_JOINED" },
	{ ERROR_NOT_SUBSTED, "The system tried to delete the substitution of a drive that is not substituted..", "ERROR_NOT_SUBSTED" },
	{ ERROR_JOIN_TO_JOIN, "The system tried to join a drive to a directory on a joined drive..", "ERROR_JOIN_TO_JOIN" },
	{ ERROR_SUBST_TO_SUBST, "The system tried to substitute a drive to a directory on a substituted drive..", "ERROR_SUBST_TO_SUBST" },
	{ ERROR_JOIN_TO_SUBST, "The system tried to join a drive to a directory on a substituted drive..", "ERROR_JOIN_TO_SUBST" },
	{ ERROR_SUBST_TO_JOIN, "The system tried to SUBST a drive to a directory on a joined drive..", "ERROR_SUBST_TO_JOIN" },
	{ ERROR_BUSY_DRIVE, "The system cannot perform a JOIN or SUBST at this time.", "ERROR_BUSY_DRIVE" },
	{ ERROR_SAME_DRIVE, "The system cannot join or substitute a drive to or for a directory on the same drive..", "ERROR_SAME_DRIVE" },
	{ ERROR_DIR_NOT_ROOT, "The directory is not a subdirectory of the root directory.", "ERROR_DIR_NOT_ROOT" },
	{ ERROR_DIR_NOT_EMPTY, "The directory is not empty.", "ERROR_DIR_NOT_EMPTY" },
	{ ERROR_IS_SUBST_PATH, "The path specified is being used in a substitute..", "ERROR_IS_SUBST_PATH" },
	{ ERROR_IS_JOIN_PATH, "Not enough resources are available to process this command..", "ERROR_IS_JOIN_PATH" },
	{ ERROR_PATH_BUSY, "The path specified cannot be used at this time.", "ERROR_PATH_BUSY" },
	{ ERROR_IS_SUBST_TARGET, "An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute.te.", "ERROR_IS_SUBST_TARGET" },
	{ ERROR_SYSTEM_TRACE, "System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed..", "ERROR_SYSTEM_TRACE" },
	{ ERROR_INVALID_EVENT_COUNT, "The number of specified semaphore events for DosMuxSemWait is not correct..", "ERROR_INVALID_EVENT_COUNT" },
	{ ERROR_TOO_MANY_MUXWAITERS, "DosMuxSemWait did not execute; too many semaphores are already set..", "ERROR_TOO_MANY_MUXWAITERS" },
	{ ERROR_INVALID_LIST_FORMAT, "The DosMuxSemWait list is not correct.", "ERROR_INVALID_LIST_FORMAT" },
	{ ERROR_LABEL_TOO_LONG, "The volume label you entered exceeds the label character limit of the target file system..", "ERROR_LABEL_TOO_LONG" },
	{ ERROR_TOO_MANY_TCBS, "Cannot create another thread.", "ERROR_TOO_MANY_TCBS" },
	{ ERROR_SIGNAL_REFUSED, "The recipient process has refused the signal.", "ERROR_SIGNAL_REFUSED" },
	{ ERROR_DISCARDED, "The segment is already discarded and cannot be locked.", "ERROR_DISCARDED" },
	{ ERROR_NOT_LOCKED, "The segment is already unlocked.", "ERROR_NOT_LOCKED" },
	{ ERROR_BAD_THREADID_ADDR, "The address for the thread ID is not correct.", "ERROR_BAD_THREADID_ADDR" },
	{ ERROR_BAD_ARGUMENTS, "The argument string passed to DosExecPgm is not correct.", "ERROR_BAD_ARGUMENTS" },
	{ ERROR_BAD_PATHNAME, "The specified path is invalid.", "ERROR_BAD_PATHNAME" },
	{ ERROR_SIGNAL_PENDING, "A signal is already pending.", "ERROR_SIGNAL_PENDING" },
	{ ERROR_MAX_THRDS_REACHED, "No more threads can be created in the system.", "ERROR_MAX_THRDS_REACHED" },
	{ ERROR_LOCK_FAILED, "Unable to lock a region of a file.", "ERROR_LOCK_FAILED" },
	{ ERROR_BUSY, "The requested resource is in use.", "ERROR_BUSY" },
	{ ERROR_CANCEL_VIOLATION, "A lock request was not outstanding for the supplied cancel region.", "ERROR_CANCEL_VIOLATION" },
	{ ERROR_ATOMIC_LOCKS_NOT_SUPPORTED, "The file system does not support atomic changes to the lock type.", "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED" },
	{ ERROR_INVALID_SEGMENT_NUMBER, "The system detected a segment number that was not correct.", "ERROR_INVALID_SEGMENT_NUMBER" },
	{ ERROR_INVALID_ORDINAL, "The operating system cannot run %1.", "ERROR_INVALID_ORDINAL" },
	{ ERROR_ALREADY_EXISTS, "Cannot create a file when that file already exists.", "ERROR_ALREADY_EXISTS" },
	{ ERROR_INVALID_FLAG_NUMBER, "The flag passed is not correct.", "ERROR_INVALID_FLAG_NUMBER" },
	{ ERROR_SEM_NOT_FOUND, "The specified system semaphore name was not found.", "ERROR_SEM_NOT_FOUND" },
	{ ERROR_INVALID_STARTING_CODESEG, "The operating system cannot run %1.", "ERROR_INVALID_STARTING_CODESEG" },
	{ ERROR_INVALID_STACKSEG, "The operating system cannot run %1.", "ERROR_INVALID_STACKSEG" },
	{ ERROR_INVALID_MODULETYPE, "The operating system cannot run %1.", "ERROR_INVALID_MODULETYPE" },
	{ ERROR_INVALID_EXE_SIGNATURE, "Cannot run %1 in Windows NT mode.", "ERROR_INVALID_EXE_SIGNATURE" },
	{ ERROR_EXE_MARKED_INVALID, "The operating system cannot run %1.", "ERROR_EXE_MARKED_INVALID" },
	{ ERROR_BAD_EXE_FORMAT, "%1 is not a valid Windows NT application.", "ERROR_BAD_EXE_FORMAT" },
	{ ERROR_ITERATED_DATA_EXCEEDS_64k, "The operating system cannot run %1.", "ERROR_ITERATED_DATA_EXCEEDS_64k" },
	{ ERROR_INVALID_MINALLOCSIZE, "The operating system cannot run %1.", "ERROR_INVALID_MINALLOCSIZE" },
	{ ERROR_DYNLINK_FROM_INVALID_RING, "The operating system cannot run this application program..", "ERROR_DYNLINK_FROM_INVALID_RING" },
	{ ERROR_IOPL_NOT_ENABLED, "The operating system is not presently configured to run this application..", "ERROR_IOPL_NOT_ENABLED" },
	{ ERROR_INVALID_SEGDPL, "The operating system cannot run %1.", "ERROR_INVALID_SEGDPL" },
	{ ERROR_AUTODATASEG_EXCEEDS_64k, "The operating system cannot run this application program..", "ERROR_AUTODATASEG_EXCEEDS_64k" },
	{ ERROR_RING2SEG_MUST_BE_MOVABLE, "The code segment cannot be greater than or equal to 64KB.", "ERROR_RING2SEG_MUST_BE_MOVABLE" },
	{ ERROR_RELOC_CHAIN_XEEDS_SEGLIM, "The operating system cannot run %1.", "ERROR_RELOC_CHAIN_XEEDS_SEGLIM" },
	{ ERROR_INFLOOP_IN_RELOC_CHAIN, "The operating system cannot run %1.", "ERROR_INFLOOP_IN_RELOC_CHAIN" },
	{ ERROR_ENVVAR_NOT_FOUND, "The system could not find the environment option that was entered..", "ERROR_ENVVAR_NOT_FOUND" },
	{ ERROR_NO_SIGNAL_SENT, "No process in the command subtree has a signal handler..", "ERROR_NO_SIGNAL_SENT" },
	{ ERROR_FILENAME_EXCED_RANGE, "The filename or extension is too long.", "ERROR_FILENAME_EXCED_RANGE" },
	{ ERROR_RING2_STACK_IN_USE, "The ring 2 stack is in use.", "ERROR_RING2_STACK_IN_USE" },
	{ ERROR_META_EXPANSION_TOO_LONG, "The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified..", "ERROR_META_EXPANSION_TOO_LONG" },
	{ ERROR_INVALID_SIGNAL_NUMBER, "The signal being posted is not correct.", "ERROR_INVALID_SIGNAL_NUMBER" },
	{ ERROR_THREAD_1_INACTIVE, "The signal handler cannot be set.", "ERROR_THREAD_1_INACTIVE" },
	{ ERROR_LOCKED, "The segment is locked and cannot be reallocated.", "ERROR_LOCKED" },
	{ ERROR_TOO_MANY_MODULES, "Too many dynamic link modules are attached to this program or dynamic link module..", "ERROR_TOO_MANY_MODULES" },
	{ ERROR_NESTING_NOT_ALLOWED, "Can't nest calls to LoadModule.", "ERROR_NESTING_NOT_ALLOWED" },
	{ ERROR_EXE_MACHINE_TYPE_MISMATCH, "The image file %1 is valid, but is for a machine type other than the current machine..", "ERROR_EXE_MACHINE_TYPE_MISMATCH" },
	{ ERROR_BAD_PIPE, "The pipe state is invalid.", "ERROR_BAD_PIPE" },
	{ ERROR_PIPE_BUSY, "All pipe instances are busy.", "ERROR_PIPE_BUSY" },
	{ ERROR_NO_DATA, "The pipe is being closed.", "ERROR_NO_DATA" },
	{ ERROR_PIPE_NOT_CONNECTED, "No process is on the other end of the pipe.", "ERROR_PIPE_NOT_CONNECTED" },
	{ ERROR_MORE_DATA, "More data is available.", "ERROR_MORE_DATA" },
	{ ERROR_VC_DISCONNECTED, "The session was cancelled.", "ERROR_VC_DISCONNECTED" },
	{ ERROR_INVALID_EA_NAME, "The specified extended attribute name was invalid.", "ERROR_INVALID_EA_NAME" },
	{ ERROR_EA_LIST_INCONSISTENT, "The extended attributes are inconsistent.", "ERROR_EA_LIST_INCONSISTENT" },
	{ ERROR_NO_MORE_ITEMS, "No more data is available.", "ERROR_NO_MORE_ITEMS" },
	{ ERROR_CANNOT_COPY, "The Copy API cannot be used.", "ERROR_CANNOT_COPY" },
	{ ERROR_DIRECTORY, "The directory name is invalid.", "ERROR_DIRECTORY" },
	{ ERROR_EAS_DIDNT_FIT, "The extended attributes did not fit in the buffer.", "ERROR_EAS_DIDNT_FIT" },
	{ ERROR_EA_FILE_CORRUPT, "The extended attribute file on the mounted file system is corrupt.", "ERROR_EA_FILE_CORRUPT" },
	{ ERROR_EA_TABLE_FULL, "The extended attribute table file is full.", "ERROR_EA_TABLE_FULL" },
	{ ERROR_INVALID_EA_HANDLE, "The specified extended attribute handle is invalid.", "ERROR_INVALID_EA_HANDLE" },
	{ ERROR_EAS_NOT_SUPPORTED, "The mounted file system does not support extended attributes.", "ERROR_EAS_NOT_SUPPORTED" },
	{ ERROR_NOT_OWNER, "Attempt to release mutex not owned by caller.", "ERROR_NOT_OWNER" },
	{ ERROR_TOO_MANY_POSTS, "Too many posts were made to a semaphore.", "ERROR_TOO_MANY_POSTS" },
	{ ERROR_PARTIAL_COPY, "Only part of a ReadWriteProcessMemory request was completed.", "ERROR_PARTIAL_COPY" },
	{ ERROR_MR_MID_NOT_FOUND, "The system cannot find message for message number 0x%1 in message file for %2..", "ERROR_MR_MID_NOT_FOUND" },
	{ ERROR_INVALID_ADDRESS, "Attempt to access invalid address.", "ERROR_INVALID_ADDRESS" },
	{ ERROR_ARITHMETIC_OVERFLOW, "Arithmetic result exceeded 32 bits.", "ERROR_ARITHMETIC_OVERFLOW" },
	{ ERROR_PIPE_CONNECTED, "There is a process on other end of the pipe.", "ERROR_PIPE_CONNECTED" },
	{ ERROR_PIPE_LISTENING, "Waiting for a process to open the other end of the pipe.", "ERROR_PIPE_LISTENING" },
	{ ERROR_EA_ACCESS_DENIED, "Access to the extended attribute was denied.", "ERROR_EA_ACCESS_DENIED" },
	{ ERROR_OPERATION_ABORTED, "The IO operation has been aborted because of either a thread exit or an application request..", "ERROR_OPERATION_ABORTED" },
	{ ERROR_IO_INCOMPLETE, "Overlapped IO event is not in a signalled state.", "ERROR_IO_INCOMPLETE" },
	{ ERROR_IO_PENDING, "Overlapped IO operation is in progress.", "ERROR_IO_PENDING" },
	{ ERROR_NOACCESS, "Invalid access to memory location.", "ERROR_NOACCESS" },
	{ ERROR_SWAPERROR, "Error performing inpage operation.", "ERROR_SWAPERROR" },
	{ ERROR_STACK_OVERFLOW, "Recursion too deep, stack overflowed.", "ERROR_STACK_OVERFLOW" },
	{ ERROR_INVALID_MESSAGE, "The window cannot act on the sent message.", "ERROR_INVALID_MESSAGE" },
	{ ERROR_CAN_NOT_COMPLETE, "Cannot complete this function.", "ERROR_CAN_NOT_COMPLETE" },
	{ ERROR_INVALID_FLAGS, "Invalid flags.", "ERROR_INVALID_FLAGS" },
	{ ERROR_UNRECOGNIZED_VOLUME, "The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupt.t.", "ERROR_UNRECOGNIZED_VOLUME" },
	{ ERROR_FILE_INVALID, "The volume for a file has been externally altered such that the opened file is no longer valid..", "ERROR_FILE_INVALID" },
	{ ERROR_FULLSCREEN_MODE, "The requested operation cannot be performed in full-screen mode.", "ERROR_FULLSCREEN_MODE" },
	{ ERROR_NO_TOKEN, "An attempt was made to reference a token that does not exist.", "ERROR_NO_TOKEN" },
	{ ERROR_BADDB, "The configuration registry database is corrupt.", "ERROR_BADDB" },
	{ ERROR_BADKEY, "The configuration registry key is invalid.", "ERROR_BADKEY" },
	{ ERROR_CANTOPEN, "The configuration registry key could not be opened.", "ERROR_CANTOPEN" },
	{ ERROR_CANTREAD, "The configuration registry key could not be read.", "ERROR_CANTREAD" },
	{ ERROR_CANTWRITE, "The configuration registry key could not be written.", "ERROR_CANTWRITE" },
	{ ERROR_REGISTRY_RECOVERED, "One of the files in the Registry database had to be recovered by use of a log or alternate copy. The recovery was successful.l.", "ERROR_REGISTRY_RECOVERED" },
	{ ERROR_REGISTRY_CORRUPT, "The Registry is corrupt. The structure of one of the files that contains Registry data is corrupt, or the system's image of the file in memory is corrupt, or the file could not be recovered because the alternate copy or log was absent or corrupt.pt.", "ERROR_REGISTRY_CORRUPT" },
	{ ERROR_REGISTRY_IO_FAILED, "An IO operation initiated by the Registry failed unrecoverably. The Registry could not read in, or write out, or flush, one of the files that contain the system's image of the Registry.y.", "ERROR_REGISTRY_IO_FAILED" },
	{ ERROR_NOT_REGISTRY_FILE, "The system has attempted to load or restore a file into the Registry, but the specified file is not in a Registry file format..", "ERROR_NOT_REGISTRY_FILE" },
	{ ERROR_KEY_DELETED, "Illegal operation attempted on a Registry key which has been marked for deletion.", "ERROR_KEY_DELETED" },
	{ ERROR_NO_LOG_SPACE, "System could not allocate the required space in a Registry log.", "ERROR_NO_LOG_SPACE" },
	{ ERROR_KEY_HAS_CHILDREN, "Cannot create a symbolic link in a Registry key that already has subkeys or values..", "ERROR_KEY_HAS_CHILDREN" },
	{ ERROR_CHILD_MUST_BE_VOLATILE, "Cannot create a stable subkey under a volatile parent key.", "ERROR_CHILD_MUST_BE_VOLATILE" },
	{ ERROR_NOTIFY_ENUM_DIR, "A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.s.", "ERROR_NOTIFY_ENUM_DIR" },
	{ ERROR_DEPENDENT_SERVICES_RUNNING, "A stop control has been sent to a service which other running services are dependent on..", "ERROR_DEPENDENT_SERVICES_RUNNING" },
	{ ERROR_INVALID_SERVICE_CONTROL, "The requested control is not valid for this service", "ERROR_INVALID_SERVICE_CONTROL" },
	{ ERROR_SERVICE_REQUEST_TIMEOUT, "The service did not respond to the start or control request in a timely fashion..", "ERROR_SERVICE_REQUEST_TIMEOUT" },
	{ ERROR_SERVICE_NO_THREAD, "A thread could not be created for the service.", "ERROR_SERVICE_NO_THREAD" },
	{ ERROR_SERVICE_DATABASE_LOCKED, "The service database is locked.", "ERROR_SERVICE_DATABASE_LOCKED" },
	{ ERROR_SERVICE_ALREADY_RUNNING, "An instance of the service is already running.", "ERROR_SERVICE_ALREADY_RUNNING" },
	{ ERROR_INVALID_SERVICE_ACCOUNT, "The account name is invalid or does not exist.", "ERROR_INVALID_SERVICE_ACCOUNT" },
	{ ERROR_SERVICE_DISABLED, "The specified service is disabled and cannot be started.", "ERROR_SERVICE_DISABLED" },
	{ ERROR_CIRCULAR_DEPENDENCY, "Circular service dependency was specified.", "ERROR_CIRCULAR_DEPENDENCY" },
	{ ERROR_SERVICE_DOES_NOT_EXIST, "The specified service does not exist as an installed service.", "ERROR_SERVICE_DOES_NOT_EXIST" },
	{ ERROR_SERVICE_CANNOT_ACCEPT_CTRL, "The service cannot accept control messages at this time.", "ERROR_SERVICE_CANNOT_ACCEPT_CTRL" },
	{ ERROR_SERVICE_NOT_ACTIVE, "The service has not been started.", "ERROR_SERVICE_NOT_ACTIVE" },
	{ ERROR_FAILED_SERVICE_CONTROLLER_CONNECT, "The service process could not connect to the service controller.", "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT" },
	{ ERROR_EXCEPTION_IN_SERVICE, "An exception occurred in the service when handling the control request.", "ERROR_EXCEPTION_IN_SERVICE" },
	{ ERROR_DATABASE_DOES_NOT_EXIST, "The database specified does not exist.", "ERROR_DATABASE_DOES_NOT_EXIST" },
	{ ERROR_SERVICE_SPECIFIC_ERROR, "The service has returned a service-specific error code.", "ERROR_SERVICE_SPECIFIC_ERROR" },
	{ ERROR_PROCESS_ABORTED, "The process terminated unexpectedly.", "ERROR_PROCESS_ABORTED" },
	{ ERROR_SERVICE_DEPENDENCY_FAIL, "The dependency service or group failed to start.", "ERROR_SERVICE_DEPENDENCY_FAIL" },
	{ ERROR_SERVICE_LOGON_FAILED, "The service did not start due to a logon failure.", "ERROR_SERVICE_LOGON_FAILED" },
	{ ERROR_SERVICE_START_HANG, "After starting, the service hung in a start-pending state.", "ERROR_SERVICE_START_HANG" },
	{ ERROR_INVALID_SERVICE_LOCK, "The specified service database lock is invalid.", "ERROR_INVALID_SERVICE_LOCK" },
	{ ERROR_SERVICE_MARKED_FOR_DELETE, "The specified service has been marked for deletion.", "ERROR_SERVICE_MARKED_FOR_DELETE" },
	{ ERROR_SERVICE_EXISTS, "The specified service already exists.", "ERROR_SERVICE_EXISTS" },
	{ ERROR_ALREADY_RUNNING_LKG, "The system is currently running with the last-known-good configuration.", "ERROR_ALREADY_RUNNING_LKG" },
	{ ERROR_SERVICE_DEPENDENCY_DELETED, "The dependency service does not exist or has been marked for deletion..", "ERROR_SERVICE_DEPENDENCY_DELETED" },
	{ ERROR_BOOT_ALREADY_ACCEPTED, "The current boot has already been accepted for use as the last-known-good control set..", "ERROR_BOOT_ALREADY_ACCEPTED" },
	{ ERROR_SERVICE_NEVER_STARTED, "No attempts to start the service have been made since the last boot.", "ERROR_SERVICE_NEVER_STARTED" },
	{ ERROR_DUPLICATE_SERVICE_NAME, "The name is already in use as either a service name or a service display name..", "ERROR_DUPLICATE_SERVICE_NAME" },
	{ ERROR_DIFFERENT_SERVICE_ACCOUNT, "The account specified for this service is different from the account specified for other services running in the same process..", "ERROR_DIFFERENT_SERVICE_ACCOUNT" },
	{ ERROR_END_OF_MEDIA, "The physical end of the tape has been reached.", "ERROR_END_OF_MEDIA" },
	{ ERROR_FILEMARK_DETECTED, "A tape access reached a filemark.", "ERROR_FILEMARK_DETECTED" },
	{ ERROR_BEGINNING_OF_MEDIA, "Beginning of tape or partition was encountered.", "ERROR_BEGINNING_OF_MEDIA" },
	{ ERROR_SETMARK_DETECTED, "A tape access reached the end of a set of files.", "ERROR_SETMARK_DETECTED" },
	{ ERROR_NO_DATA_DETECTED, "No more data is on the tape.", "ERROR_NO_DATA_DETECTED" },
	{ ERROR_PARTITION_FAILURE, "Tape could not be partitioned.", "ERROR_PARTITION_FAILURE" },
	{ ERROR_INVALID_BLOCK_LENGTH, "When accessing a new tape of a multivolume partition, the current blocksize is incorrect..", "ERROR_INVALID_BLOCK_LENGTH" },
	{ ERROR_DEVICE_NOT_PARTITIONED, "Tape partition information could not be found when loading a tape.", "ERROR_DEVICE_NOT_PARTITIONED" },
	{ ERROR_UNABLE_TO_LOCK_MEDIA, "Unable to lock the media eject mechanism.", "ERROR_UNABLE_TO_LOCK_MEDIA" },
	{ ERROR_UNABLE_TO_UNLOAD_MEDIA, "Unable to unload the media.", "ERROR_UNABLE_TO_UNLOAD_MEDIA" },
	{ ERROR_MEDIA_CHANGED, "Media in drive may have changed.", "ERROR_MEDIA_CHANGED" },
	{ ERROR_BUS_RESET, "The IO bus was reset.", "ERROR_BUS_RESET" },
	{ ERROR_NO_MEDIA_IN_DRIVE, "No media in drive.", "ERROR_NO_MEDIA_IN_DRIVE" },
	{ ERROR_NO_UNICODE_TRANSLATION, "No mapping for the Unicode character exists in the target multi-byte code page.", "ERROR_NO_UNICODE_TRANSLATION" },
	{ ERROR_DLL_INIT_FAILED, "A dynamic link library (DLL) initialization routine failed.", "ERROR_DLL_INIT_FAILED" },
	{ ERROR_SHUTDOWN_IN_PROGRESS, "A system shutdown is in progress.", "ERROR_SHUTDOWN_IN_PROGRESS" },
	{ ERROR_NO_SHUTDOWN_IN_PROGRESS, "Unable to abort the system shutdown because no shutdown was in progress.", "ERROR_NO_SHUTDOWN_IN_PROGRESS" },
	{ ERROR_IO_DEVICE, "The request could not be performed because of an IO device error.", "ERROR_IO_DEVICE" },
	{ ERROR_SERIAL_NO_DEVICE, "No serial device was successfully initialized. The serial driver will unload..", "ERROR_SERIAL_NO_DEVICE" },
	{ ERROR_IRQ_BUSY, "Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.d.", "ERROR_IRQ_BUSY" },
	{ ERROR_MORE_WRITES, "A serial IO operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.))", "ERROR_MORE_WRITES" },
	{ ERROR_COUNTER_TIMEOUT, "A serial IO operation completed because the time-out period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.))", "ERROR_COUNTER_TIMEOUT" },
	{ ERROR_FLOPPY_ID_MARK_NOT_FOUND, "No ID address mark was found on the floppy disk.", "ERROR_FLOPPY_ID_MARK_NOT_FOUND" },
	{ ERROR_FLOPPY_WRONG_CYLINDER, "Mismatch between the floppy disk sector ID field and the floppy disk controller track address..", "ERROR_FLOPPY_WRONG_CYLINDER" },
	{ ERROR_FLOPPY_UNKNOWN_ERROR, "The floppy disk controller reported an error that is not recognized by the floppy disk driver..", "ERROR_FLOPPY_UNKNOWN_ERROR" },
	{ ERROR_FLOPPY_BAD_REGISTERS, "The floppy disk controller returned inconsistent results in its registers.", "ERROR_FLOPPY_BAD_REGISTERS" },
	{ ERROR_DISK_RECALIBRATE_FAILED, "While accessing the hard disk, a recalibrate operation failed, even after retries.", "ERROR_DISK_RECALIBRATE_FAILED" },
	{ ERROR_DISK_OPERATION_FAILED, "While accessing the hard disk, a disk operation failed even after retries.", "ERROR_DISK_OPERATION_FAILED" },
	{ ERROR_DISK_RESET_FAILED, "While accessing the hard disk, a disk controller reset was needed, but even that failed..", "ERROR_DISK_RESET_FAILED" },
	{ ERROR_EOM_OVERFLOW, "Physical end of tape encountered.", "ERROR_EOM_OVERFLOW" },
	{ ERROR_NOT_ENOUGH_SERVER_MEMORY, "Not enough server storage is available to process this command.", "ERROR_NOT_ENOUGH_SERVER_MEMORY" },
	{ ERROR_POSSIBLE_DEADLOCK, "A potential deadlock condition has been detected.", "ERROR_POSSIBLE_DEADLOCK" },
	{ ERROR_MAPPED_ALIGNMENT, "The base address or the file offset specified does not have the proper alignment..", "ERROR_MAPPED_ALIGNMENT" },
	{ ERROR_SET_POWER_STATE_VETOED, "An attempt to change the system power state was vetoed by another application or driver..", "ERROR_SET_POWER_STATE_VETOED" },
	{ ERROR_SET_POWER_STATE_FAILED, "The system BIOS failed an attempt to change the system power state.", "ERROR_SET_POWER_STATE_FAILED" },
	{ ERROR_TOO_MANY_LINKS, "An attempt was made to create more links on a file than the file system supports..", "ERROR_TOO_MANY_LINKS" },
	{ ERROR_OLD_WIN_VERSION, "The specified program requires a newer version of Windows.", "ERROR_OLD_WIN_VERSION" },
	{ ERROR_APP_WRONG_OS, "The specified program is not a Windows or MS-DOS program.", "ERROR_APP_WRONG_OS" },
	{ ERROR_SINGLE_INSTANCE_APP, "Cannot start more than one instance of the specified program.", "ERROR_SINGLE_INSTANCE_APP" },
	{ ERROR_RMODE_APP, "The specified program was written for an older version of Windows.", "ERROR_RMODE_APP" },
	{ ERROR_INVALID_DLL, "One of the library files needed to run this application is damaged.", "ERROR_INVALID_DLL" },
	{ ERROR_NO_ASSOCIATION, "No application is associated with the specified file for this operation.", "ERROR_NO_ASSOCIATION" },
	{ ERROR_DDE_FAIL, "An error occurred in sending the command to the application.", "ERROR_DDE_FAIL" },
	{ ERROR_DLL_NOT_FOUND, "One of the library files needed to run this application cannot be found.", "ERROR_DLL_NOT_FOUND" },
	{ ERROR_BAD_USERNAME, "The specified username is invalid.", "ERROR_BAD_USERNAME" },
	{ ERROR_NOT_CONNECTED, "This network connection does not exist.", "ERROR_NOT_CONNECTED" },
	{ ERROR_OPEN_FILES, "This network connection has files open or requests pending.", "ERROR_OPEN_FILES" },
	{ ERROR_ACTIVE_CONNECTIONS, "Active connections still exist.", "ERROR_ACTIVE_CONNECTIONS" },
	{ ERROR_DEVICE_IN_USE, "The device is in use by an active process and cannot be disconnected.", "ERROR_DEVICE_IN_USE" },
	{ ERROR_BAD_DEVICE, "The specified device name is invalid.", "ERROR_BAD_DEVICE" },
	{ ERROR_CONNECTION_UNAVAIL, "The device is not currently connected but it is a remembered connection.", "ERROR_CONNECTION_UNAVAIL" },
	{ ERROR_DEVICE_ALREADY_REMEMBERED, "An attempt was made to remember a device that had previously been remembered.", "ERROR_DEVICE_ALREADY_REMEMBERED" },
	{ ERROR_NO_NET_OR_BAD_PATH, "No network provider accepted the given network path.", "ERROR_NO_NET_OR_BAD_PATH" },
	{ ERROR_BAD_PROVIDER, "The specified network provider name is invalid.", "ERROR_BAD_PROVIDER" },
	{ ERROR_CANNOT_OPEN_PROFILE, "Unable to open the network connection profile.", "ERROR_CANNOT_OPEN_PROFILE" },
	{ ERROR_BAD_PROFILE, "The network connection profile is corrupt.", "ERROR_BAD_PROFILE" },
	{ ERROR_NOT_CONTAINER, "Cannot enumerate a non-container.", "ERROR_NOT_CONTAINER" },
	{ ERROR_EXTENDED_ERROR, "An extended error has occurred.", "ERROR_EXTENDED_ERROR" },
	{ ERROR_INVALID_GROUPNAME, "The format of the specified group name is invalid.", "ERROR_INVALID_GROUPNAME" },
	{ ERROR_INVALID_COMPUTERNAME, "The format of the specified computer name is invalid.", "ERROR_INVALID_COMPUTERNAME" },
	{ ERROR_INVALID_EVENTNAME, "The format of the specified event name is invalid.", "ERROR_INVALID_EVENTNAME" },
	{ ERROR_INVALID_DOMAINNAME, "The format of the specified domain name is invalid.", "ERROR_INVALID_DOMAINNAME" },
	{ ERROR_INVALID_SERVICENAME, "The format of the specified service name is invalid.", "ERROR_INVALID_SERVICENAME" },
	{ ERROR_INVALID_NETNAME, "The format of the specified network name is invalid.", "ERROR_INVALID_NETNAME" },
	{ ERROR_INVALID_SHARENAME, "The format of the specified share name is invalid.", "ERROR_INVALID_SHARENAME" },
	{ ERROR_INVALID_PASSWORDNAME, "The format of the specified password is invalid.", "ERROR_INVALID_PASSWORDNAME" },
	{ ERROR_INVALID_MESSAGENAME, "The format of the specified message name is invalid.", "ERROR_INVALID_MESSAGENAME" },
	{ ERROR_INVALID_MESSAGEDEST, "The format of the specified message destination is invalid.", "ERROR_INVALID_MESSAGEDEST" },
	{ ERROR_SESSION_CREDENTIAL_CONFLICT, "The credentials supplied conflict with an existing set of credentials.", "ERROR_SESSION_CREDENTIAL_CONFLICT" },
	{ ERROR_REMOTE_SESSION_LIMIT_EXCEEDED, "An attempt was made to establish a session to a network server, but there are already too many sessions established to that server..", "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED" },
	{ ERROR_DUP_DOMAINNAME, "The workgroup or domain name is already in use by another computer on the network..", "ERROR_DUP_DOMAINNAME" },
	{ ERROR_NO_NETWORK, "The network is not present or not started.", "ERROR_NO_NETWORK" },
	{ ERROR_CANCELLED, "The operation was cancelled by the user.", "ERROR_CANCELLED" },
	{ ERROR_USER_MAPPED_FILE, "The requested operation cannot be performed on a file with a user mapped section open.", "ERROR_USER_MAPPED_FILE" },
	{ ERROR_CONNECTION_REFUSED, "The remote system refused the network connection.", "ERROR_CONNECTION_REFUSED" },
	{ ERROR_GRACEFUL_DISCONNECT, "The network connection was gracefully closed.", "ERROR_GRACEFUL_DISCONNECT" },
	{ ERROR_ADDRESS_ALREADY_ASSOCIATED, "The network transport endpoint already has an address associated with it.", "ERROR_ADDRESS_ALREADY_ASSOCIATED" },
	{ ERROR_ADDRESS_NOT_ASSOCIATED, "An address has not yet been associated with the network endpoint.", "ERROR_ADDRESS_NOT_ASSOCIATED" },
	{ ERROR_CONNECTION_INVALID, "An operation was attempted on a non-existent network connection.", "ERROR_CONNECTION_INVALID" },
	{ ERROR_CONNECTION_ACTIVE, "An invalid operation was attempted on an active network connection.", "ERROR_CONNECTION_ACTIVE" },
	{ ERROR_NETWORK_UNREACHABLE, "The remote network is not reachable by the transport.", "ERROR_NETWORK_UNREACHABLE" },
	{ ERROR_HOST_UNREACHABLE, "The remote system is not reachable by the transport.", "ERROR_HOST_UNREACHABLE" },
	{ ERROR_PROTOCOL_UNREACHABLE, "The remote system does not support the transport protocol.", "ERROR_PROTOCOL_UNREACHABLE" },
	{ ERROR_PORT_UNREACHABLE, "No service is operating at the destination network endpoint on the remote system..", "ERROR_PORT_UNREACHABLE" },
	{ ERROR_REQUEST_ABORTED, "The request was aborted.", "ERROR_REQUEST_ABORTED" },
	{ ERROR_CONNECTION_ABORTED, "The network connection was aborted by the local system.", "ERROR_CONNECTION_ABORTED" },
	{ ERROR_RETRY, "The operation could not be completed. A retry should be performed..", "ERROR_RETRY" },
	{ ERROR_CONNECTION_COUNT_LIMIT, "A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached..", "ERROR_CONNECTION_COUNT_LIMIT" },
	{ ERROR_LOGIN_TIME_RESTRICTION, "Attempting to login during an unauthorized time of day for this account.", "ERROR_LOGIN_TIME_RESTRICTION" },
	{ ERROR_LOGIN_WKSTA_RESTRICTION, "The account is not authorized to login from this station.", "ERROR_LOGIN_WKSTA_RESTRICTION" },
	{ ERROR_INCORRECT_ADDRESS, "The network address could not be used for the operation requested.", "ERROR_INCORRECT_ADDRESS" },
	{ ERROR_ALREADY_REGISTERED, "The service is already registered.", "ERROR_ALREADY_REGISTERED" },
	{ ERROR_SERVICE_NOT_FOUND, "The specified service does not exist.", "ERROR_SERVICE_NOT_FOUND" },
	{ ERROR_NOT_AUTHENTICATED, "The operation being requested was not performed because the user has not been authenticated..", "ERROR_NOT_AUTHENTICATED" },
	{ ERROR_NOT_LOGGED_ON, "The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist.t.", "ERROR_NOT_LOGGED_ON" },
	{ ERROR_CONTINUE, "Return that wants caller to continue with work in progress.", "ERROR_CONTINUE" },
	{ ERROR_ALREADY_INITIALIZED, "An attempt was made to perform an initialization operation when initialization has already been completed..", "ERROR_ALREADY_INITIALIZED" },
	{ ERROR_NO_MORE_DEVICES, "No more local devices.", "ERROR_NO_MORE_DEVICES" },
	{ ERROR_NOT_ALL_ASSIGNED, "Not all privileges referenced are assigned to the caller.", "ERROR_NOT_ALL_ASSIGNED" },
	{ ERROR_SOME_NOT_MAPPED, "Some mapping between account names and security IDs was not done.", "ERROR_SOME_NOT_MAPPED" },
	{ ERROR_NO_QUOTAS_FOR_ACCOUNT, "No system quota limits are specifically set for this account.", "ERROR_NO_QUOTAS_FOR_ACCOUNT" },
	{ ERROR_LOCAL_USER_SESSION_KEY, "No encryption key is available. A well-known encryption key was returned..", "ERROR_LOCAL_USER_SESSION_KEY" },
	{ ERROR_NULL_LM_PASSWORD, "The NT password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string.g.", "ERROR_NULL_LM_PASSWORD" },
	{ ERROR_UNKNOWN_REVISION, "The revision level is unknown.", "ERROR_UNKNOWN_REVISION" },
	{ ERROR_REVISION_MISMATCH, "Indicates two revision levels are incompatible.", "ERROR_REVISION_MISMATCH" },
	{ ERROR_INVALID_OWNER, "This security ID may not be assigned as the owner of this object.", "ERROR_INVALID_OWNER" },
	{ ERROR_INVALID_PRIMARY_GROUP, "This security ID may not be assigned as the primary group of an object.", "ERROR_INVALID_PRIMARY_GROUP" },
	{ ERROR_NO_IMPERSONATION_TOKEN, "An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client..", "ERROR_NO_IMPERSONATION_TOKEN" },
	{ ERROR_CANT_DISABLE_MANDATORY, "The group may not be disabled.", "ERROR_CANT_DISABLE_MANDATORY" },
	{ ERROR_NO_LOGON_SERVERS, "There are currently no logon servers available to service the logon request..", "ERROR_NO_LOGON_SERVERS" },
	{ ERROR_NO_SUCH_LOGON_SESSION, "A specified logon session does not exist. It may already have been terminated.ed.", "ERROR_NO_SUCH_LOGON_SESSION" },
	{ ERROR_NO_SUCH_PRIVILEGE, "A specified privilege does not exist.", "ERROR_NO_SUCH_PRIVILEGE" },
	{ ERROR_PRIVILEGE_NOT_HELD, "A required privilege is not held by the client.", "ERROR_PRIVILEGE_NOT_HELD" },
	{ ERROR_INVALID_ACCOUNT_NAME, "The name provided is not a properly formed account name.", "ERROR_INVALID_ACCOUNT_NAME" },
	{ ERROR_USER_EXISTS, "The specified user already exists.", "ERROR_USER_EXISTS" },
	{ ERROR_NO_SUCH_USER, "The specified user does not exist.", "ERROR_NO_SUCH_USER" },
	{ ERROR_GROUP_EXISTS, "The specified group already exists.", "ERROR_GROUP_EXISTS" },
	{ ERROR_NO_SUCH_GROUP, "The specified group does not exist.", "ERROR_NO_SUCH_GROUP" },
	{ ERROR_MEMBER_IN_GROUP, "Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member.r.", "ERROR_MEMBER_IN_GROUP" },
	{ ERROR_MEMBER_NOT_IN_GROUP, "The specified user account is not a member of the specified group account.", "ERROR_MEMBER_NOT_IN_GROUP" },
	{ ERROR_LAST_ADMIN, "The last remaining administration account cannot be disabled or deleted..", "ERROR_LAST_ADMIN" },
	{ ERROR_WRONG_PASSWORD, "Unable to update the password. The value provided as the current password is incorrect.t.", "ERROR_WRONG_PASSWORD" },
	{ ERROR_ILL_FORMED_PASSWORD, "Unable to update the password. The value provided for the new password contains values that are not allowed in passwords.s.", "ERROR_ILL_FORMED_PASSWORD" },
	{ ERROR_PASSWORD_RESTRICTION, "Unable to update the password because a password update rule has been violated..", "ERROR_PASSWORD_RESTRICTION" },
	{ ERROR_LOGON_FAILURE, "Logon failure: unknown user name or bad password.", "ERROR_LOGON_FAILURE" },
	{ ERROR_ACCOUNT_RESTRICTION, "Logon failure: user account restriction.", "ERROR_ACCOUNT_RESTRICTION" },
	{ ERROR_INVALID_LOGON_HOURS, "Logon failure: account logon time restriction violation.", "ERROR_INVALID_LOGON_HOURS" },
	{ ERROR_INVALID_WORKSTATION, "Logon failure: user not allowed to log on to this computer.", "ERROR_INVALID_WORKSTATION" },
	{ ERROR_PASSWORD_EXPIRED, "Logon failure: the specified account password has expired.", "ERROR_PASSWORD_EXPIRED" },
	{ ERROR_ACCOUNT_DISABLED, "Logon failure: account currently disabled.", "ERROR_ACCOUNT_DISABLED" },
	{ ERROR_NONE_MAPPED, "No mapping between account names and security IDs was done.", "ERROR_NONE_MAPPED" },
	{ ERROR_TOO_MANY_LUIDS_REQUESTED, "Too many local user identifiers (LUIDs) were requested at one time.", "ERROR_TOO_MANY_LUIDS_REQUESTED" },
	{ ERROR_LUIDS_EXHAUSTED, "No more local user identifiers (LUIDs) are available.", "ERROR_LUIDS_EXHAUSTED" },
	{ ERROR_INVALID_SUB_AUTHORITY, "The subauthority part of a security ID is invalid for this particular use.", "ERROR_INVALID_SUB_AUTHORITY" },
	{ ERROR_INVALID_ACL, "The access control list (ACL) structure is invalid.", "ERROR_INVALID_ACL" },
	{ ERROR_INVALID_SID, "The security ID structure is invalid.", "ERROR_INVALID_SID" },
	{ ERROR_INVALID_SECURITY_DESCR, "The security descriptor structure is invalid.", "ERROR_INVALID_SECURITY_DESCR" },
	{ ERROR_BAD_INHERITANCE_ACL, "The inherited access control list (ACL) or access control entry (ACE) could not be built..", "ERROR_BAD_INHERITANCE_ACL" },
	{ ERROR_SERVER_DISABLED, "The server is currently disabled.", "ERROR_SERVER_DISABLED" },
	{ ERROR_SERVER_NOT_DISABLED, "The server is currently enabled.", "ERROR_SERVER_NOT_DISABLED" },
	{ ERROR_INVALID_ID_AUTHORITY, "The value provided was an invalid value for an identifier authority.", "ERROR_INVALID_ID_AUTHORITY" },
	{ ERROR_ALLOTTED_SPACE_EXCEEDED, "No more memory is available for security information updates.", "ERROR_ALLOTTED_SPACE_EXCEEDED" },
	{ ERROR_INVALID_GROUP_ATTRIBUTES, "The specified attributes are invalid, or incompatible with the attributes for the group as a whole..", "ERROR_INVALID_GROUP_ATTRIBUTES" },
	{ ERROR_BAD_IMPERSONATION_LEVEL, "Either a required impersonation level was not provided, or the provided impersonation level is invalid..", "ERROR_BAD_IMPERSONATION_LEVEL" },
	{ ERROR_CANT_OPEN_ANONYMOUS, "Cannot open an anonymous level security token.", "ERROR_CANT_OPEN_ANONYMOUS" },
	{ ERROR_BAD_VALIDATION_CLASS, "The validation information class requested was invalid.", "ERROR_BAD_VALIDATION_CLASS" },
	{ ERROR_BAD_TOKEN_TYPE, "The type of the token is inappropriate for its attempted use.", "ERROR_BAD_TOKEN_TYPE" },
	{ ERROR_NO_SECURITY_ON_OBJECT, "Unable to perform a security operation on an object which has no associated security..", "ERROR_NO_SECURITY_ON_OBJECT" },
	{ ERROR_CANT_ACCESS_DOMAIN_INFO, "Indicates a Windows NT Server could not be contacted or that objects within the domain are protected such that necessary information could not be retrieved.d.", "ERROR_CANT_ACCESS_DOMAIN_INFO" },
	{ ERROR_INVALID_SERVER_STATE, "The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation.n.", "ERROR_INVALID_SERVER_STATE" },
	{ ERROR_INVALID_DOMAIN_STATE, "The domain was in the wrong state to perform the security operation.", "ERROR_INVALID_DOMAIN_STATE" },
	{ ERROR_INVALID_DOMAIN_ROLE, "This operation is only allowed for the Primary Domain Controller of the domain.", "ERROR_INVALID_DOMAIN_ROLE" },
	{ ERROR_NO_SUCH_DOMAIN, "The specified domain did not exist.", "ERROR_NO_SUCH_DOMAIN" },
	{ ERROR_DOMAIN_EXISTS, "The specified domain already exists.", "ERROR_DOMAIN_EXISTS" },
	{ ERROR_DOMAIN_LIMIT_EXCEEDED, "An attempt was made to exceed the limit on the number of domains per server.", "ERROR_DOMAIN_LIMIT_EXCEEDED" },
	{ ERROR_INTERNAL_DB_CORRUPTION, "Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk..", "ERROR_INTERNAL_DB_CORRUPTION" },
	{ ERROR_INTERNAL_ERROR, "The security account database contains an internal inconsistency.", "ERROR_INTERNAL_ERROR" },
	{ ERROR_GENERIC_NOT_MAPPED, "Generic access types were contained in an access mask which should already be mapped to non-generic types..", "ERROR_GENERIC_NOT_MAPPED" },
	{ ERROR_BAD_DESCRIPTOR_FORMAT, "A security descriptor is not in the right format (absolute or self-relative).", "ERROR_BAD_DESCRIPTOR_FORMAT" },
	{ ERROR_NOT_LOGON_PROCESS, "The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process.s.", "ERROR_NOT_LOGON_PROCESS" },
	{ ERROR_LOGON_SESSION_EXISTS, "Cannot start a new logon session with an ID that is already in use.", "ERROR_LOGON_SESSION_EXISTS" },
	{ ERROR_NO_SUCH_PACKAGE, "A specified authentication package is unknown.", "ERROR_NO_SUCH_PACKAGE" },
	{ ERROR_BAD_LOGON_SESSION_STATE, "The logon session is not in a state that is consistent with the requested operation..", "ERROR_BAD_LOGON_SESSION_STATE" },
	{ ERROR_LOGON_SESSION_COLLISION, "The logon session ID is already in use.", "ERROR_LOGON_SESSION_COLLISION" },
	{ ERROR_INVALID_LOGON_TYPE, "A logon request contained an invalid logon type value.", "ERROR_INVALID_LOGON_TYPE" },
	{ ERROR_CANNOT_IMPERSONATE, "Unable to impersonate via a named pipe until data has been read from that pipe..", "ERROR_CANNOT_IMPERSONATE" },
	{ ERROR_RXACT_INVALID_STATE, "The transaction state of a Registry subtree is incompatible with the requested operation..", "ERROR_RXACT_INVALID_STATE" },
	{ ERROR_RXACT_COMMIT_FAILURE, "An internal security database corruption has been encountered.", "ERROR_RXACT_COMMIT_FAILURE" },
	{ ERROR_SPECIAL_ACCOUNT, "Cannot perform this operation on built-in accounts.", "ERROR_SPECIAL_ACCOUNT" },
	{ ERROR_SPECIAL_GROUP, "Cannot perform this operation on this built-in special group.", "ERROR_SPECIAL_GROUP" },
	{ ERROR_SPECIAL_USER, "Cannot perform this operation on this built-in special user.", "ERROR_SPECIAL_USER" },
	{ ERROR_MEMBERS_PRIMARY_GROUP, "The user cannot be removed from a group because the group is currently the user's primary group..", "ERROR_MEMBERS_PRIMARY_GROUP" },
	{ ERROR_TOKEN_ALREADY_IN_USE, "The token is already in use as a primary token.", "ERROR_TOKEN_ALREADY_IN_USE" },
	{ ERROR_NO_SUCH_ALIAS, "The specified local group does not exist.", "ERROR_NO_SUCH_ALIAS" },
	{ ERROR_MEMBER_NOT_IN_ALIAS, "The specified account name is not a member of the local group.", "ERROR_MEMBER_NOT_IN_ALIAS" },
	{ ERROR_MEMBER_IN_ALIAS, "The specified account name is already a member of the local group.", "ERROR_MEMBER_IN_ALIAS" },
	{ ERROR_ALIAS_EXISTS, "The specified local group already exists.", "ERROR_ALIAS_EXISTS" },
	{ ERROR_LOGON_NOT_GRANTED, "Logon failure: the user has not been granted the requested logon type at this computer..", "ERROR_LOGON_NOT_GRANTED" },
	{ ERROR_TOO_MANY_SECRETS, "The maximum number of secrets that may be stored in a single system has been exceeded..", "ERROR_TOO_MANY_SECRETS" },
	{ ERROR_SECRET_TOO_LONG, "The length of a secret exceeds the maximum length allowed.", "ERROR_SECRET_TOO_LONG" },
	{ ERROR_INTERNAL_DB_ERROR, "The local security authority database contains an internal inconsistency.", "ERROR_INTERNAL_DB_ERROR" },
	{ ERROR_TOO_MANY_CONTEXT_IDS, "During a logon attempt, the user's security context accumulated too many security IDs..", "ERROR_TOO_MANY_CONTEXT_IDS" },
	{ ERROR_LOGON_TYPE_NOT_GRANTED, "Logon failure: the user has not been granted the requested logon type at this computer..", "ERROR_LOGON_TYPE_NOT_GRANTED" },
	{ ERROR_NT_CROSS_ENCRYPTION_REQUIRED, "A cross-encrypted password is necessary to change a user password.", "ERROR_NT_CROSS_ENCRYPTION_REQUIRED" },
	{ ERROR_NO_SUCH_MEMBER, "A new member could not be added to a local group because the member does not exist..", "ERROR_NO_SUCH_MEMBER" },
	{ ERROR_INVALID_MEMBER, "A new member could not be added to a local group because the member has the wrong account type..", "ERROR_INVALID_MEMBER" },
	{ ERROR_TOO_MANY_SIDS, "Too many security IDs have been specified.", "ERROR_TOO_MANY_SIDS" },
	{ ERROR_LM_CROSS_ENCRYPTION_REQUIRED, "A cross-encrypted password is necessary to change this user password.", "ERROR_LM_CROSS_ENCRYPTION_REQUIRED" },
	{ ERROR_NO_INHERITANCE, "Indicates an ACL contains no inheritable components", "ERROR_NO_INHERITANCE" },
	{ ERROR_FILE_CORRUPT, "The file or directory is corrupt and non-readable.", "ERROR_FILE_CORRUPT" },
	{ ERROR_DISK_CORRUPT, "The disk structure is corrupt and non-readable.", "ERROR_DISK_CORRUPT" },
	{ ERROR_NO_USER_SESSION_KEY, "There is no user session key for the specified logon session.", "ERROR_NO_USER_SESSION_KEY" },
	{ ERROR_LICENSE_QUOTA_EXCEEDED, "The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept.t.", "ERROR_LICENSE_QUOTA_EXCEEDED" },
	{ ERROR_INVALID_WINDOW_HANDLE, "Invalid window handle.", "ERROR_INVALID_WINDOW_HANDLE" },
	{ ERROR_INVALID_MENU_HANDLE, "Invalid menu handle.", "ERROR_INVALID_MENU_HANDLE" },
	{ ERROR_INVALID_CURSOR_HANDLE, "Invalid cursor handle.", "ERROR_INVALID_CURSOR_HANDLE" },
	{ ERROR_INVALID_ACCEL_HANDLE, "Invalid accelerator table handle.", "ERROR_INVALID_ACCEL_HANDLE" },
	{ ERROR_INVALID_HOOK_HANDLE, "Invalid hook handle.", "ERROR_INVALID_HOOK_HANDLE" },
	{ ERROR_INVALID_DWP_HANDLE, "Invalid handle to a multiple-window position structure.", "ERROR_INVALID_DWP_HANDLE" },
	{ ERROR_TLW_WITH_WSCHILD, "Cannot create a top-level child window.", "ERROR_TLW_WITH_WSCHILD" },
	{ ERROR_CANNOT_FIND_WND_CLASS, "Cannot find window class.", "ERROR_CANNOT_FIND_WND_CLASS" },
	{ ERROR_WINDOW_OF_OTHER_THREAD, "Invalid window, belongs to other thread.", "ERROR_WINDOW_OF_OTHER_THREAD" },
	{ ERROR_HOTKEY_ALREADY_REGISTERED, "Hot key is already registered.", "ERROR_HOTKEY_ALREADY_REGISTERED" },
	{ ERROR_CLASS_ALREADY_EXISTS, "Class already exists.", "ERROR_CLASS_ALREADY_EXISTS" },
	{ ERROR_CLASS_DOES_NOT_EXIST, "Class does not exist.", "ERROR_CLASS_DOES_NOT_EXIST" },
	{ ERROR_CLASS_HAS_WINDOWS, "Class still has open windows.", "ERROR_CLASS_HAS_WINDOWS" },
	{ ERROR_INVALID_INDEX, "Invalid index.", "ERROR_INVALID_INDEX" },
	{ ERROR_INVALID_ICON_HANDLE, "Invalid icon handle.", "ERROR_INVALID_ICON_HANDLE" },
	{ ERROR_PRIVATE_DIALOG_INDEX, "Using private DIALOG window words.", "ERROR_PRIVATE_DIALOG_INDEX" },
	{ ERROR_LISTBOX_ID_NOT_FOUND, "The listbox identifier was not found.", "ERROR_LISTBOX_ID_NOT_FOUND" },
	{ ERROR_NO_WILDCARD_CHARACTERS, "No wildcards were found.", "ERROR_NO_WILDCARD_CHARACTERS" },
	{ ERROR_CLIPBOARD_NOT_OPEN, "Thread does not have a clipboard open.", "ERROR_CLIPBOARD_NOT_OPEN" },
	{ ERROR_HOTKEY_NOT_REGISTERED, "Hot key is not registered.", "ERROR_HOTKEY_NOT_REGISTERED" },
	{ ERROR_WINDOW_NOT_DIALOG, "The window is not a valid dialog window.", "ERROR_WINDOW_NOT_DIALOG" },
	{ ERROR_CONTROL_ID_NOT_FOUND, "Control ID not found.", "ERROR_CONTROL_ID_NOT_FOUND" },
	{ ERROR_INVALID_COMBOBOX_MESSAGE, "Invalid message for a combo box because it does not have an edit control.", "ERROR_INVALID_COMBOBOX_MESSAGE" },
	{ ERROR_WINDOW_NOT_COMBOBOX, "The window is not a combo box.", "ERROR_WINDOW_NOT_COMBOBOX" },
	{ ERROR_INVALID_EDIT_HEIGHT, "Height must be less than 256.", "ERROR_INVALID_EDIT_HEIGHT" },
	{ ERROR_DC_NOT_FOUND, "Invalid device context (DC) handle.", "ERROR_DC_NOT_FOUND" },
	{ ERROR_INVALID_HOOK_FILTER, "Invalid hook procedure type.", "ERROR_INVALID_HOOK_FILTER" },
	{ ERROR_INVALID_FILTER_PROC, "Invalid hook procedure.", "ERROR_INVALID_FILTER_PROC" },
	{ ERROR_HOOK_NEEDS_HMOD, "Cannot set non-local hook without a module handle.", "ERROR_HOOK_NEEDS_HMOD" },
	{ ERROR_GLOBAL_ONLY_HOOK, "This hook procedure can only be set globally.", "ERROR_GLOBAL_ONLY_HOOK" },
	{ ERROR_JOURNAL_HOOK_SET, "The journal hook procedure is already installed.", "ERROR_JOURNAL_HOOK_SET" },
	{ ERROR_HOOK_NOT_INSTALLED, "The hook procedure is not installed.", "ERROR_HOOK_NOT_INSTALLED" },
	{ ERROR_INVALID_LB_MESSAGE, "Invalid message for single-selection listbox.", "ERROR_INVALID_LB_MESSAGE" },
	{ ERROR_SETCOUNT_ON_BAD_LB, "LB_SETCOUNT sent to non-lazy listbox.", "ERROR_SETCOUNT_ON_BAD_LB" },
	{ ERROR_LB_WITHOUT_TABSTOPS, "This list box does not support tab stops.", "ERROR_LB_WITHOUT_TABSTOPS" },
	{ ERROR_DESTROY_OBJECT_OF_OTHER_THREAD, "Cannot destroy object created by another thread.", "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD" },
	{ ERROR_CHILD_WINDOW_MENU, "Child windows cannot have menus.", "ERROR_CHILD_WINDOW_MENU" },
	{ ERROR_NO_SYSTEM_MENU, "The window does not have a system menu.", "ERROR_NO_SYSTEM_MENU" },
	{ ERROR_INVALID_MSGBOX_STYLE, "Invalid message box style.", "ERROR_INVALID_MSGBOX_STYLE" },
	{ ERROR_INVALID_SPI_VALUE, "Invalid system-wide (SPI_*) parameter.", "ERROR_INVALID_SPI_VALUE" },
	{ ERROR_SCREEN_ALREADY_LOCKED, "Screen already locked.", "ERROR_SCREEN_ALREADY_LOCKED" },
	{ ERROR_HWNDS_HAVE_DIFF_PARENT, "All handles to windows in a multiple-window position structure must have the same parent..", "ERROR_HWNDS_HAVE_DIFF_PARENT" },
	{ ERROR_NOT_CHILD_WINDOW, "The window is not a child window.", "ERROR_NOT_CHILD_WINDOW" },
	{ ERROR_INVALID_GW_COMMAND, "Invalid GW_* command.", "ERROR_INVALID_GW_COMMAND" },
	{ ERROR_INVALID_THREAD_ID, "Invalid thread identifier.", "ERROR_INVALID_THREAD_ID" },
	{ ERROR_NON_MDICHILD_WINDOW, "Cannot process a message from a window that is not a multiple document interface (MDI) window..", "ERROR_NON_MDICHILD_WINDOW" },
	{ ERROR_POPUP_ALREADY_ACTIVE, "Popup menu already active.", "ERROR_POPUP_ALREADY_ACTIVE" },
	{ ERROR_NO_SCROLLBARS, "The window does not have scroll bars.", "ERROR_NO_SCROLLBARS" },
	{ ERROR_INVALID_SCROLLBAR_RANGE, "Scroll bar range cannot be greater than 0x7FFF.", "ERROR_INVALID_SCROLLBAR_RANGE" },
	{ ERROR_INVALID_SHOWWIN_COMMAND, "Cannot show or remove the window in the way specified.", "ERROR_INVALID_SHOWWIN_COMMAND" },
	{ ERROR_NO_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service.", "ERROR_NO_SYSTEM_RESOURCES" },
	{ ERROR_NONPAGED_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service.", "ERROR_NONPAGED_SYSTEM_RESOURCES" },
	{ ERROR_PAGED_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service.", "ERROR_PAGED_SYSTEM_RESOURCES" },
	{ ERROR_WORKING_SET_QUOTA, "Insufficient quota to complete the requested service.", "ERROR_WORKING_SET_QUOTA" },
	{ ERROR_PAGEFILE_QUOTA, "Insufficient quota to complete the requested service.", "ERROR_PAGEFILE_QUOTA" },
	{ ERROR_COMMITMENT_LIMIT, "The paging file is too small for this operation to complete.", "ERROR_COMMITMENT_LIMIT" },
	{ ERROR_MENU_ITEM_NOT_FOUND, "A menu item was not found.", "ERROR_MENU_ITEM_NOT_FOUND" },
	{ ERROR_INVALID_KEYBOARD_HANDLE, "Invalid keyboard layout handle.", "ERROR_INVALID_KEYBOARD_HANDLE" },
	{ ERROR_HOOK_TYPE_NOT_ALLOWED, "Hook type not allowed.", "ERROR_HOOK_TYPE_NOT_ALLOWED" },
	{ ERROR_EVENTLOG_FILE_CORRUPT, "The event log file is corrupt.", "ERROR_EVENTLOG_FILE_CORRUPT" },
	{ ERROR_EVENTLOG_CANT_START, "No event log file could be opened, so the event logging service did not start.", "ERROR_EVENTLOG_CANT_START" },
	{ ERROR_LOG_FILE_FULL, "The event log file is full.", "ERROR_LOG_FILE_FULL" },
	{ ERROR_EVENTLOG_FILE_CHANGED, "The event log file has changed between reads.", "ERROR_EVENTLOG_FILE_CHANGED" },
	{ RPC_S_INVALID_STRING_BINDING, "The string binding is invalid.", "RPC_S_INVALID_STRING_BINDING" },
	{ RPC_S_WRONG_KIND_OF_BINDING, "The binding handle is not the correct type.", "RPC_S_WRONG_KIND_OF_BINDING" },
	{ RPC_S_INVALID_BINDING, "The binding handle is invalid.", "RPC_S_INVALID_BINDING" },
	{ RPC_S_PROTSEQ_NOT_SUPPORTED, "The RPC protocol sequence is not supported.", "RPC_S_PROTSEQ_NOT_SUPPORTED" },
	{ RPC_S_INVALID_RPC_PROTSEQ, "The RPC protocol sequence is invalid.", "RPC_S_INVALID_RPC_PROTSEQ" },
	{ RPC_S_INVALID_STRING_UUID, "The string universal unique identifier (UUID) is invalid.", "RPC_S_INVALID_STRING_UUID" },
	{ RPC_S_INVALID_ENDPOINT_FORMAT, "The endpoint format is invalid.", "RPC_S_INVALID_ENDPOINT_FORMAT" },
	{ RPC_S_INVALID_NET_ADDR, "The network address is invalid.", "RPC_S_INVALID_NET_ADDR" },
	{ RPC_S_NO_ENDPOINT_FOUND, "No endpoint was found.", "RPC_S_NO_ENDPOINT_FOUND" },
	{ RPC_S_INVALID_TIMEOUT, "The timeout value is invalid.", "RPC_S_INVALID_TIMEOUT" },
	{ RPC_S_OBJECT_NOT_FOUND, "The object universal unique identifier (UUID) was not found.", "RPC_S_OBJECT_NOT_FOUND" },
	{ RPC_S_ALREADY_REGISTERED, "The object universal unique identifier (UUID) has already been registered.", "RPC_S_ALREADY_REGISTERED" },
	{ RPC_S_TYPE_ALREADY_REGISTERED, "The type universal unique identifier (UUID) has already been registered.", "RPC_S_TYPE_ALREADY_REGISTERED" },
	{ RPC_S_ALREADY_LISTENING, "The RPC server is already listening.", "RPC_S_ALREADY_LISTENING" },
	{ RPC_S_NO_PROTSEQS_REGISTERED, "No protocol sequences have been registered.", "RPC_S_NO_PROTSEQS_REGISTERED" },
	{ RPC_S_NOT_LISTENING, "The RPC server is not listening.", "RPC_S_NOT_LISTENING" },
	{ RPC_S_UNKNOWN_MGR_TYPE, "The manager type is unknown.", "RPC_S_UNKNOWN_MGR_TYPE" },
	{ RPC_S_UNKNOWN_IF, "The interface is unknown.", "RPC_S_UNKNOWN_IF" },
	{ RPC_S_NO_BINDINGS, "There are no bindings.", "RPC_S_NO_BINDINGS" },
	{ RPC_S_NO_PROTSEQS, "There are no protocol sequences.", "RPC_S_NO_PROTSEQS" },
	{ RPC_S_CANT_CREATE_ENDPOINT, "The endpoint cannot be created.", "RPC_S_CANT_CREATE_ENDPOINT" },
	{ RPC_S_OUT_OF_RESOURCES, "Not enough resources are available to complete this operation.", "RPC_S_OUT_OF_RESOURCES" },
	{ RPC_S_SERVER_UNAVAILABLE, "The RPC server is unavailable.", "RPC_S_SERVER_UNAVAILABLE" },
	{ RPC_S_SERVER_TOO_BUSY, "The RPC server is too busy to complete this operation.", "RPC_S_SERVER_TOO_BUSY" },
	{ RPC_S_INVALID_NETWORK_OPTIONS, "The network options are invalid.", "RPC_S_INVALID_NETWORK_OPTIONS" },
	{ RPC_S_NO_CALL_ACTIVE, "There is not a remote procedure call active in this thread.", "RPC_S_NO_CALL_ACTIVE" },
	{ RPC_S_CALL_FAILED, "The remote procedure call failed.", "RPC_S_CALL_FAILED" },
	{ RPC_S_CALL_FAILED_DNE, "The remote procedure call failed and did not execute.", "RPC_S_CALL_FAILED_DNE" },
	{ RPC_S_PROTOCOL_ERROR, "A remote procedure call (RPC) protocol error occurred.", "RPC_S_PROTOCOL_ERROR" },
	{ RPC_S_UNSUPPORTED_TRANS_SYN, "The transfer syntax is not supported by the RPC server.", "RPC_S_UNSUPPORTED_TRANS_SYN" },
	{ RPC_S_UNSUPPORTED_TYPE, "The universal unique identifier (UUID) type is not supported.", "RPC_S_UNSUPPORTED_TYPE" },
	{ RPC_S_INVALID_TAG, "The tag is invalid.", "RPC_S_INVALID_TAG" },
	{ RPC_S_INVALID_BOUND, "The array bounds are invalid.", "RPC_S_INVALID_BOUND" },
	{ RPC_S_NO_ENTRY_NAME, "The binding does not contain an entry name.", "RPC_S_NO_ENTRY_NAME" },
	{ RPC_S_INVALID_NAME_SYNTAX, "The name syntax is invalid.", "RPC_S_INVALID_NAME_SYNTAX" },
	{ RPC_S_UNSUPPORTED_NAME_SYNTAX, "The name syntax is not supported.", "RPC_S_UNSUPPORTED_NAME_SYNTAX" },
	{ RPC_S_UUID_NO_ADDRESS, "No network address is available to use to construct a universal unique identifier (UUID)..", "RPC_S_UUID_NO_ADDRESS" },
	{ RPC_S_DUPLICATE_ENDPOINT, "The endpoint is a duplicate.", "RPC_S_DUPLICATE_ENDPOINT" },
	{ RPC_S_UNKNOWN_AUTHN_TYPE, "The authentication type is unknown.", "RPC_S_UNKNOWN_AUTHN_TYPE" },
	{ RPC_S_MAX_CALLS_TOO_SMALL, "The maximum number of calls is too small.", "RPC_S_MAX_CALLS_TOO_SMALL" },
	{ RPC_S_STRING_TOO_LONG, "The string is too long.", "RPC_S_STRING_TOO_LONG" },
	{ RPC_S_PROTSEQ_NOT_FOUND, "The RPC protocol sequence was not found.", "RPC_S_PROTSEQ_NOT_FOUND" },
	{ RPC_S_PROCNUM_OUT_OF_RANGE, "The procedure number is out of range.", "RPC_S_PROCNUM_OUT_OF_RANGE" },
	{ RPC_S_BINDING_HAS_NO_AUTH, "The binding does not contain any authentication information.", "RPC_S_BINDING_HAS_NO_AUTH" },
	{ RPC_S_UNKNOWN_AUTHN_SERVICE, "The authentication service is unknown.", "RPC_S_UNKNOWN_AUTHN_SERVICE" },
	{ RPC_S_UNKNOWN_AUTHN_LEVEL, "The authentication level is unknown.", "RPC_S_UNKNOWN_AUTHN_LEVEL" },
	{ RPC_S_INVALID_AUTH_IDENTITY, "The security context is invalid.", "RPC_S_INVALID_AUTH_IDENTITY" },
	{ RPC_S_UNKNOWN_AUTHZ_SERVICE, "The authorization service is unknown.", "RPC_S_UNKNOWN_AUTHZ_SERVICE" },
	{ EPT_S_INVALID_ENTRY, "The entry is invalid.", "EPT_S_INVALID_ENTRY" },
	{ EPT_S_CANT_PERFORM_OP, "The server endpoint cannot perform the operation.", "EPT_S_CANT_PERFORM_OP" },
	{ EPT_S_NOT_REGISTERED, "There are no more endpoints available from the endpoint mapper.", "EPT_S_NOT_REGISTERED" },
	{ RPC_S_NOTHING_TO_EXPORT, "No interfaces have been exported.", "RPC_S_NOTHING_TO_EXPORT" },
	{ RPC_S_INCOMPLETE_NAME, "The entry name is incomplete.", "RPC_S_INCOMPLETE_NAME" },
	{ RPC_S_INVALID_VERS_OPTION, "The version option is invalid.", "RPC_S_INVALID_VERS_OPTION" },
	{ RPC_S_NO_MORE_MEMBERS, "There are no more members.", "RPC_S_NO_MORE_MEMBERS" },
	{ RPC_S_NOT_ALL_OBJS_UNEXPORTED, "There is nothing to unexport.", "RPC_S_NOT_ALL_OBJS_UNEXPORTED" },
	{ RPC_S_INTERFACE_NOT_FOUND, "The interface was not found.", "RPC_S_INTERFACE_NOT_FOUND" },
	{ RPC_S_ENTRY_ALREADY_EXISTS, "The entry already exists.", "RPC_S_ENTRY_ALREADY_EXISTS" },
	{ RPC_S_ENTRY_NOT_FOUND, "The entry is not found.", "RPC_S_ENTRY_NOT_FOUND" },
	{ RPC_S_NAME_SERVICE_UNAVAILABLE, "The name service is unavailable.", "RPC_S_NAME_SERVICE_UNAVAILABLE" },
	{ RPC_S_INVALID_NAF_ID, "The network address family is invalid.", "RPC_S_INVALID_NAF_ID" },
	{ RPC_S_CANNOT_SUPPORT, "The requested operation is not supported.", "RPC_S_CANNOT_SUPPORT" },
	{ RPC_S_NO_CONTEXT_AVAILABLE, "No security context is available to allow impersonation.", "RPC_S_NO_CONTEXT_AVAILABLE" },
	{ RPC_S_INTERNAL_ERROR, "An internal error occurred in a remote procedure call (RPC).", "RPC_S_INTERNAL_ERROR" },
	{ RPC_S_ZERO_DIVIDE, "The RPC server attempted an integer division by zero.", "RPC_S_ZERO_DIVIDE" },
	{ RPC_S_ADDRESS_ERROR, "An addressing error occurred in the RPC server.", "RPC_S_ADDRESS_ERROR" },
	{ RPC_S_FP_DIV_ZERO, "A floating-point operation at the RPC server caused a division by zero.", "RPC_S_FP_DIV_ZERO" },
	{ RPC_S_FP_UNDERFLOW, "A floating-point underflow occurred at the RPC server.", "RPC_S_FP_UNDERFLOW" },
	{ RPC_S_FP_OVERFLOW, "A floating-point overflow occurred at the RPC server.", "RPC_S_FP_OVERFLOW" },
	{ RPC_X_NO_MORE_ENTRIES, "The list of RPC servers available for the binding of auto handles has been exhausted..", "RPC_X_NO_MORE_ENTRIES" },
	{ RPC_X_SS_CHAR_TRANS_OPEN_FAIL, "Unable to open the character translation table file.", "RPC_X_SS_CHAR_TRANS_OPEN_FAIL" },
	{ RPC_X_SS_CHAR_TRANS_SHORT_FILE, "The file containing the character translation table has fewer than 512 bytes..", "RPC_X_SS_CHAR_TRANS_SHORT_FILE" },
	{ RPC_X_SS_IN_NULL_CONTEXT, "A null context handle was passed from the client to the host during a remote procedure call..", "RPC_X_SS_IN_NULL_CONTEXT" },
	{ RPC_X_SS_CONTEXT_DAMAGED, "The context handle changed during a remote procedure call.", "RPC_X_SS_CONTEXT_DAMAGED" },
	{ RPC_X_SS_HANDLES_MISMATCH, "The binding handles passed to a remote procedure call do not match.", "RPC_X_SS_HANDLES_MISMATCH" },
	{ RPC_X_SS_CANNOT_GET_CALL_HANDLE, "The stub is unable to get the remote procedure call handle.", "RPC_X_SS_CANNOT_GET_CALL_HANDLE" },
	{ RPC_X_NULL_REF_POINTER, "A null reference pointer was passed to the stub.", "RPC_X_NULL_REF_POINTER" },
	{ RPC_X_ENUM_VALUE_OUT_OF_RANGE, "The enumeration value is out of range.", "RPC_X_ENUM_VALUE_OUT_OF_RANGE" },
	{ RPC_X_BYTE_COUNT_TOO_SMALL, "The byte count is too small.", "RPC_X_BYTE_COUNT_TOO_SMALL" },
	{ RPC_X_BAD_STUB_DATA, "The stub received bad data.", "RPC_X_BAD_STUB_DATA" },
	{ ERROR_INVALID_USER_BUFFER, "The supplied user buffer is not valid for the requested operation.", "ERROR_INVALID_USER_BUFFER" },
	{ ERROR_UNRECOGNIZED_MEDIA, "The disk media is not recognized. It may not be formatted..", "ERROR_UNRECOGNIZED_MEDIA" },
	{ ERROR_NO_TRUST_LSA_SECRET, "The workstation does not have a trust secret.", "ERROR_NO_TRUST_LSA_SECRET" },
	{ ERROR_NO_TRUST_SAM_ACCOUNT, "The SAM database on the Windows NT Server does not have a computer account for this workstation trust relationship..", "ERROR_NO_TRUST_SAM_ACCOUNT" },
	{ ERROR_TRUSTED_DOMAIN_FAILURE, "The trust relationship between the primary domain and the trusted domain failed..", "ERROR_TRUSTED_DOMAIN_FAILURE" },
	{ ERROR_TRUSTED_RELATIONSHIP_FAILURE, "The trust relationship between this workstation and the primary domain failed..", "ERROR_TRUSTED_RELATIONSHIP_FAILURE" },
	{ ERROR_TRUST_FAILURE, "The network logon failed.", "ERROR_TRUST_FAILURE" },
	{ RPC_S_CALL_IN_PROGRESS, "A remote procedure call is already in progress for this thread.", "RPC_S_CALL_IN_PROGRESS" },
	{ ERROR_NETLOGON_NOT_STARTED, "An attempt was made to logon, but the network logon service was not started.", "ERROR_NETLOGON_NOT_STARTED" },
	{ ERROR_ACCOUNT_EXPIRED, "The user's account has expired.", "ERROR_ACCOUNT_EXPIRED" },
	{ ERROR_REDIRECTOR_HAS_OPEN_HANDLES, "The redirector is in use and cannot be unloaded.", "ERROR_REDIRECTOR_HAS_OPEN_HANDLES" },
	{ ERROR_PRINTER_DRIVER_ALREADY_INSTALLED, "The specified printer driver is already installed.", "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED" },
	{ ERROR_UNKNOWN_PORT, "The specified port is unknown.", "ERROR_UNKNOWN_PORT" },
	{ ERROR_UNKNOWN_PRINTER_DRIVER, "The printer driver is unknown.", "ERROR_UNKNOWN_PRINTER_DRIVER" },
	{ ERROR_UNKNOWN_PRINTPROCESSOR, "The print processor is unknown.", "ERROR_UNKNOWN_PRINTPROCESSOR" },
	{ ERROR_INVALID_SEPARATOR_FILE, "The specified separator file is invalid.", "ERROR_INVALID_SEPARATOR_FILE" },
	{ ERROR_INVALID_PRIORITY, "The specified priority is invalid.", "ERROR_INVALID_PRIORITY" },
	{ ERROR_INVALID_PRINTER_NAME, "The printer name is invalid.", "ERROR_INVALID_PRINTER_NAME" },
	{ ERROR_PRINTER_ALREADY_EXISTS, "The printer already exists.", "ERROR_PRINTER_ALREADY_EXISTS" },
	{ ERROR_INVALID_PRINTER_COMMAND, "The printer command is invalid.", "ERROR_INVALID_PRINTER_COMMAND" },
	{ ERROR_INVALID_DATATYPE, "The specified datatype is invalid.", "ERROR_INVALID_DATATYPE" },
	{ ERROR_INVALID_ENVIRONMENT, "The Environment specified is invalid.", "ERROR_INVALID_ENVIRONMENT" },
	{ RPC_S_NO_MORE_BINDINGS, "There are no more bindings.", "RPC_S_NO_MORE_BINDINGS" },
	{ ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, "The account used is an interdomain trust account. Use your global user account or local user account to access this server..", "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT" },
	{ ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT, "The account used is a Computer Account. Use your global user account or local user account to access this server..", "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT" },
	{ ERROR_NOLOGON_SERVER_TRUST_ACCOUNT, "The account used is an server trust account. Use your global user account or local user account to access this server..", "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT" },
	{ ERROR_DOMAIN_TRUST_INCONSISTENT, "The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain..", "ERROR_DOMAIN_TRUST_INCONSISTENT" },
	{ ERROR_SERVER_HAS_OPEN_HANDLES, "The server is in use and cannot be unloaded.", "ERROR_SERVER_HAS_OPEN_HANDLES" },
	{ ERROR_RESOURCE_DATA_NOT_FOUND, "The specified image file did not contain a resource section.", "ERROR_RESOURCE_DATA_NOT_FOUND" },
	{ ERROR_RESOURCE_TYPE_NOT_FOUND, "The specified resource type can not be found in the image file.", "ERROR_RESOURCE_TYPE_NOT_FOUND" },
	{ ERROR_RESOURCE_NAME_NOT_FOUND, "The specified resource name can not be found in the image file.", "ERROR_RESOURCE_NAME_NOT_FOUND" },
	{ ERROR_RESOURCE_LANG_NOT_FOUND, "The specified resource language ID cannot be found in the image file.", "ERROR_RESOURCE_LANG_NOT_FOUND" },
	{ ERROR_NOT_ENOUGH_QUOTA, "Not enough quota is available to process this command.", "ERROR_NOT_ENOUGH_QUOTA" },
	{ RPC_S_NO_INTERFACES, "No interfaces have been registered.", "RPC_S_NO_INTERFACES" },
	{ RPC_S_CALL_CANCELLED, "The server was altered while processing this call.", "RPC_S_CALL_CANCELLED" },
	{ RPC_S_BINDING_INCOMPLETE, "The binding handle does not contain all required information.", "RPC_S_BINDING_INCOMPLETE" },
	{ RPC_S_COMM_FAILURE, "Communications failure.", "RPC_S_COMM_FAILURE" },
	{ RPC_S_UNSUPPORTED_AUTHN_LEVEL, "The requested authentication level is not supported.", "RPC_S_UNSUPPORTED_AUTHN_LEVEL" },
	{ RPC_S_NO_PRINC_NAME, "No principal name registered.", "RPC_S_NO_PRINC_NAME" },
	{ RPC_S_NOT_RPC_ERROR, "The error specified is not a valid Windows NT RPC error code.", "RPC_S_NOT_RPC_ERROR" },
	{ RPC_S_UUID_LOCAL_ONLY, "A UUID that is valid only on this computer has been allocated.", "RPC_S_UUID_LOCAL_ONLY" },
	{ RPC_S_SEC_PKG_ERROR, "A security package specific error occurred.", "RPC_S_SEC_PKG_ERROR" },
	{ RPC_S_NOT_CANCELLED, "Thread is not cancelled.", "RPC_S_NOT_CANCELLED" },
	{ RPC_X_INVALID_ES_ACTION, "Invalid operation on the encodingdecoding handle.", "RPC_X_INVALID_ES_ACTION" },
	{ RPC_X_WRONG_ES_VERSION, "Incompatible version of the serializing package.", "RPC_X_WRONG_ES_VERSION" },
	{ RPC_X_WRONG_STUB_VERSION, "Incompatible version of the RPC stub.", "RPC_X_WRONG_STUB_VERSION" },
	{ RPC_X_INVALID_PIPE_OBJECT, "The idl pipe object is invalid or corrupted.", "RPC_X_INVALID_PIPE_OBJECT" },
	{ RPC_X_INVALID_PIPE_OPERATION, "The operation is invalid for a given idl pipe object.", "RPC_X_INVALID_PIPE_OPERATION" },
	{ RPC_X_WRONG_PIPE_VERSION, "The idl pipe version is not supported.", "RPC_X_WRONG_PIPE_VERSION" },
	{ RPC_S_GROUP_MEMBER_NOT_FOUND, "The group member was not found.", "RPC_S_GROUP_MEMBER_NOT_FOUND" },
	{ EPT_S_CANT_CREATE, "The endpoint mapper database could not be created.", "EPT_S_CANT_CREATE" },
	{ RPC_S_INVALID_OBJECT, "The object universal unique identifier (UUID) is the nil UUID.", "RPC_S_INVALID_OBJECT" },
	{ ERROR_INVALID_TIME, "The specified time is invalid.", "ERROR_INVALID_TIME" },
	{ ERROR_INVALID_FORM_NAME, "The specified Form name is invalid.", "ERROR_INVALID_FORM_NAME" },
	{ ERROR_INVALID_FORM_SIZE, "The specified Form size is invalid", "ERROR_INVALID_FORM_SIZE" },
	{ ERROR_ALREADY_WAITING, "The specified Printer handle is already being waited on", "ERROR_ALREADY_WAITING" },
	{ ERROR_PRINTER_DELETED, "The specified Printer has been deleted", "ERROR_PRINTER_DELETED" },
	{ ERROR_INVALID_PRINTER_STATE, "The state of the Printer is invalid", "ERROR_INVALID_PRINTER_STATE" },
	{ ERROR_PASSWORD_MUST_CHANGE, "The user must change his password before he logs on the first time.", "ERROR_PASSWORD_MUST_CHANGE" },
	{ ERROR_DOMAIN_CONTROLLER_NOT_FOUND, "Could not find the domain controller for this domain.", "ERROR_DOMAIN_CONTROLLER_NOT_FOUND" },
	{ ERROR_ACCOUNT_LOCKED_OUT, "The referenced account is currently locked out and may not be logged on to.", "ERROR_ACCOUNT_LOCKED_OUT" },
	{ OR_INVALID_OXID, "The object exporter specified was not found.", "OR_INVALID_OXID" },
	{ OR_INVALID_OID, "The object specified was not found.", "OR_INVALID_OID" },
	{ OR_INVALID_SET, "The object resolver set specified was not found.", "OR_INVALID_SET" },
	{ RPC_S_SEND_INCOMPLETE, "Some data remains to be sent in the request buffer.", "RPC_S_SEND_INCOMPLETE" },
	{ ERROR_NO_BROWSER_SERVERS_FOUND, "The list of servers for this workgroup is not currently available", "ERROR_NO_BROWSER_SERVERS_FOUND" },
	{ ERROR_INVALID_PIXEL_FORMAT, "The pixel format is invalid.", "ERROR_INVALID_PIXEL_FORMAT" },
	{ ERROR_BAD_DRIVER, "The specified driver is invalid.", "ERROR_BAD_DRIVER" },
	{ ERROR_INVALID_WINDOW_STYLE, "The window style or class attribute is invalid for this operation.", "ERROR_INVALID_WINDOW_STYLE" },
	{ ERROR_METAFILE_NOT_SUPPORTED, "The requested metafile operation is not supported.", "ERROR_METAFILE_NOT_SUPPORTED" },
	{ ERROR_TRANSFORM_NOT_SUPPORTED, "The requested transformation operation is not supported.", "ERROR_TRANSFORM_NOT_SUPPORTED" },
	{ ERROR_CLIPPING_NOT_SUPPORTED, "The requested clipping operation is not supported.", "ERROR_CLIPPING_NOT_SUPPORTED" },
	{ ERROR_UNKNOWN_PRINT_MONITOR, "The specified print monitor is unknown.", "ERROR_UNKNOWN_PRINT_MONITOR" },
	{ ERROR_PRINTER_DRIVER_IN_USE, "The specified printer driver is currently in use.", "ERROR_PRINTER_DRIVER_IN_USE" },
	{ ERROR_SPOOL_FILE_NOT_FOUND, "The spool file was not found.", "ERROR_SPOOL_FILE_NOT_FOUND" },
	{ ERROR_SPL_NO_STARTDOC, "A StartDocPrinter call was not issued.", "ERROR_SPL_NO_STARTDOC" },
	{ ERROR_SPL_NO_ADDJOB, "An AddJob call was not issued.", "ERROR_SPL_NO_ADDJOB" },
	{ ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED, "The specified print processor has already been installed.", "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED" },
	{ ERROR_PRINT_MONITOR_ALREADY_INSTALLED, "The specified print monitor has already been installed.", "ERROR_PRINT_MONITOR_ALREADY_INSTALLED" },
	{ ERROR_INVALID_PRINT_MONITOR, "The specified print monitor does not have the required functions.", "ERROR_INVALID_PRINT_MONITOR" },
	{ ERROR_PRINT_MONITOR_IN_USE, "The specified print monitor is currently in use.", "ERROR_PRINT_MONITOR_IN_USE" },
	{ ERROR_PRINTER_HAS_JOBS_QUEUED, "The requested operation is not allowed when there are jobs queued to the printer.", "ERROR_PRINTER_HAS_JOBS_QUEUED" },
	{ ERROR_SUCCESS_REBOOT_REQUIRED, "The requested operation is successful. Changes will not be effective until the system is rebooted..", "ERROR_SUCCESS_REBOOT_REQUIRED" },
	{ ERROR_SUCCESS_RESTART_REQUIRED, "The requested operation is successful. Changes will not be effective until the service is restarted..", "ERROR_SUCCESS_RESTART_REQUIRED" },
	{ ERROR_WINS_INTERNAL, "WINS encountered an error while processing the command.", "ERROR_WINS_INTERNAL" },
	{ ERROR_CAN_NOT_DEL_LOCAL_WINS, "The local WINS can not be deleted.", "ERROR_CAN_NOT_DEL_LOCAL_WINS" },
	{ ERROR_STATIC_INIT, "The importation from the file failed.", "ERROR_STATIC_INIT" },
	{ ERROR_INC_BACKUP, "The backup Failed. Was a full backup done before ??", "ERROR_INC_BACKUP" },
	{ ERROR_FULL_BACKUP, "The backup Failed. Check the directory that you are backing the database to..", "ERROR_FULL_BACKUP" },
	{ ERROR_REC_NON_EXISTENT, "The name does not exist in the WINS database.", "ERROR_REC_NON_EXISTENT" },
	{ ERROR_RPL_NOT_ALLOWED, "Replication with a non-configured partner is not allowed.", "ERROR_RPL_NOT_ALLOWED" },
	{ E_UNEXPECTED, "Catastrophic failure", "E_UNEXPECTED" },
	{ E_NOTIMPL, "Not implemented", "E_NOTIMPL" },
	{ E_OUTOFMEMORY, "Ran out of memory", "E_OUTOFMEMORY" },
	{ E_INVALIDARG, "One or more arguments are invalid", "E_INVALIDARG" },
	{ E_NOINTERFACE, "No such interface supported", "E_NOINTERFACE" },
	{ E_POINTER, "Invalid pointer", "E_POINTER" },
	{ E_HANDLE, "Invalid handle", "E_HANDLE" },
	{ E_ABORT, "Operation aborted", "E_ABORT" },
	{ E_FAIL, "Unspecified error", "E_FAIL" },
	{ E_ACCESSDENIED, "General access denied error", "E_ACCESSDENIED" },
	{ E_NOTIMPL, "Not implemented", "E_NOTIMPL" },
	{ E_OUTOFMEMORY, "Ran out of memory", "E_OUTOFMEMORY" },
	{ E_INVALIDARG, "One or more arguments are invalid", "E_INVALIDARG" },
	{ E_NOINTERFACE, "No such interface supported", "E_NOINTERFACE" },
	{ E_POINTER, "Invalid pointer", "E_POINTER" },
	{ E_HANDLE, "Invalid handle", "E_HANDLE" },
	{ E_ABORT, "Operation aborted", "E_ABORT" },
	{ E_FAIL, "Unspecified error", "E_FAIL" },
	{ E_ACCESSDENIED, "General access denied error", "E_ACCESSDENIED" },
	{ E_PENDING, "The data necessary to complete this operation is not yet available.", "E_PENDING" },
	{ CO_E_INIT_TLS, "Thread local storage failure", "CO_E_INIT_TLS" },
	{ CO_E_INIT_SHARED_ALLOCATOR, "Get shared memory allocator failure", "CO_E_INIT_SHARED_ALLOCATOR" },
	{ CO_E_INIT_MEMORY_ALLOCATOR, "Get memory allocator failure", "CO_E_INIT_MEMORY_ALLOCATOR" },
	{ CO_E_INIT_CLASS_CACHE, "Unable to initialize class cache", "CO_E_INIT_CLASS_CACHE" },
	{ CO_E_INIT_RPC_CHANNEL, "Unable to initialize RPC services", "CO_E_INIT_RPC_CHANNEL" },
	{ CO_E_INIT_TLS_SET_CHANNEL_CONTROL, "Cannot set thread local storage channel control", "CO_E_INIT_TLS_SET_CHANNEL_CONTROL" },
	{ CO_E_INIT_TLS_CHANNEL_CONTROL, "Could not allocate thread local storage channel control", "CO_E_INIT_TLS_CHANNEL_CONTROL" },
	{ CO_E_INIT_UNACCEPTED_USER_ALLOCATOR, "The user supplied memory allocator is unacceptable", "CO_E_INIT_UNACCEPTED_USER_ALLOCATOR" },
	{ CO_E_INIT_SCM_MUTEX_EXISTS, "The OLE service mutex already exists", "CO_E_INIT_SCM_MUTEX_EXISTS" },
	{ CO_E_INIT_SCM_FILE_MAPPING_EXISTS, "The OLE service file mapping already exists", "CO_E_INIT_SCM_FILE_MAPPING_EXISTS" },
	{ CO_E_INIT_SCM_MAP_VIEW_OF_FILE, "Unable to map view of file for OLE service", "CO_E_INIT_SCM_MAP_VIEW_OF_FILE" },
	{ CO_E_INIT_SCM_EXEC_FAILURE, "Failure attempting to launch OLE service", "CO_E_INIT_SCM_EXEC_FAILURE" },
	{ CO_E_INIT_ONLY_SINGLE_THREADED, "There was an attempt to call CoInitialize a second time while single threaded", "CO_E_INIT_ONLY_SINGLE_THREADED" },
	{ CO_E_CANT_REMOTE, "A Remote activation was necessary but was not allowed", "CO_E_CANT_REMOTE" },
	{ CO_E_BAD_SERVER_NAME, "A Remote activation was necessary but the server name provided was invalid", "CO_E_BAD_SERVER_NAME" },
//	{ CO_E_RUNAS_INCOMPATIBLE, "The class is configured to run as a security id different from the caller", "CO_E_RUNAS_INCOMPATIBLE" },
	{ CO_E_OLE1DDE_DISABLED, "Use of Ole1 services requiring DDE windows is disabled", "CO_E_OLE1DDE_DISABLED" },
	{ CO_E_RUNAS_SYNTAX, "A RunAs specification must be <domain name>\\<user name> or simply <user name>", "CO_E_RUNAS_SYNTAX" },
	{ CO_E_CREATEPROCESS_FAILURE, "The server process could not be started. The pathname may be incorrect..", "CO_E_CREATEPROCESS_FAILURE" },
	{ CO_E_RUNAS_CREATEPROCESS_FAILURE, "The server process could not be started as the configured identity. The pathname may be incorrect or unavailable..", "CO_E_RUNAS_CREATEPROCESS_FAILURE" },
	{ CO_E_RUNAS_LOGON_FAILURE, "The server process could not be started because the configured identity is incorrect. Check the username and password..", "CO_E_RUNAS_LOGON_FAILURE" },
	{ CO_E_LAUNCH_PERMSSION_DENIED, "The client is not allowed to launch this server.", "CO_E_LAUNCH_PERMSSION_DENIED" },
	{ CO_E_START_SERVICE_FAILURE, "The service providing this server could not be started.", "CO_E_START_SERVICE_FAILURE" },
	{ CO_E_REMOTE_COMMUNICATION_FAILURE, "This computer was unable to communicate with the computer providing the server.", "CO_E_REMOTE_COMMUNICATION_FAILURE" },
	{ CO_E_SERVER_START_TIMEOUT, "The server did not respond after being launched.", "CO_E_SERVER_START_TIMEOUT" },
	{ CO_E_CLSREG_INCONSISTENT, "The registration information for this server is inconsistent or incomplete.", "CO_E_CLSREG_INCONSISTENT" },
	{ CO_E_IIDREG_INCONSISTENT, "The registration information for this interface is inconsistent or incomplete.", "CO_E_IIDREG_INCONSISTENT" },
	{ OLE_E_OLEVERB, "Invalid OLEVERB structure", "OLE_E_OLEVERB" },
	{ OLE_E_ADVF, "Invalid advise flags", "OLE_E_ADVF" },
	{ OLE_E_ENUM_NOMORE, "Can't enumerate any more, because the associated data is missing", "OLE_E_ENUM_NOMORE" },
	{ OLE_E_ADVISENOTSUPPORTED, "This implementation doesn't take advises", "OLE_E_ADVISENOTSUPPORTED" },
	{ OLE_E_NOCONNECTION, "There is no connection for this connection ID", "OLE_E_NOCONNECTION" },
	{ OLE_E_NOTRUNNING, "Need to run the object to perform this operation", "OLE_E_NOTRUNNING" },
	{ OLE_E_NOCACHE, "There is no cache to operate on", "OLE_E_NOCACHE" },
	{ OLE_E_BLANK, "Uninitialized object", "OLE_E_BLANK" },
	{ OLE_E_CLASSDIFF, "Linked object's source class has changed", "OLE_E_CLASSDIFF" },
	{ OLE_E_CANT_GETMONIKER, "Not able to get the moniker of the object", "OLE_E_CANT_GETMONIKER" },
	{ OLE_E_CANT_BINDTOSOURCE, "Not able to bind to the source", "OLE_E_CANT_BINDTOSOURCE" },
	{ OLE_E_STATIC, "Object is static; operation not allowed", "OLE_E_STATIC" },
	{ OLE_E_PROMPTSAVECANCELLED, "User cancelled out of save dialog", "OLE_E_PROMPTSAVECANCELLED" },
	{ OLE_E_INVALIDRECT, "Invalid rectangle", "OLE_E_INVALIDRECT" },
	{ OLE_E_WRONGCOMPOBJ, "compobj.dll is too old for the ole2.dll initialized", "OLE_E_WRONGCOMPOBJ" },
	{ OLE_E_INVALIDHWND, "Invalid window handle", "OLE_E_INVALIDHWND" },
	{ OLE_E_NOT_INPLACEACTIVE, "Object is not in any of the inplace active states", "OLE_E_NOT_INPLACEACTIVE" },
	{ OLE_E_CANTCONVERT, "Not able to convert object", "OLE_E_CANTCONVERT" },
	{ OLE_E_NOSTORAGE, "Not able to perform the operation because object is not given storage yet", "OLE_E_NOSTORAGE" },
	{ DV_E_FORMATETC, "Invalid FORMATETC structure", "DV_E_FORMATETC" },
	{ DV_E_DVTARGETDEVICE, "Invalid DVTARGETDEVICE structure", "DV_E_DVTARGETDEVICE" },
	{ DV_E_STGMEDIUM, "Invalid STDGMEDIUM structure", "DV_E_STGMEDIUM" },
	{ DV_E_STATDATA, "Invalid STATDATA structure", "DV_E_STATDATA" },
	{ DV_E_LINDEX, "Invalid lindex", "DV_E_LINDEX" },
	{ DV_E_TYMED, "Invalid tymed", "DV_E_TYMED" },
	{ DV_E_CLIPFORMAT, "Invalid clipboard format", "DV_E_CLIPFORMAT" },
	{ DV_E_DVASPECT, "Invalid aspect(s)", "DV_E_DVASPECT" },
	{ DV_E_DVTARGETDEVICE_SIZE, "tdSize parameter of the DVTARGETDEVICE structure is invalid", "DV_E_DVTARGETDEVICE_SIZE" },
	{ DV_E_NOIVIEWOBJECT, "Object doesn't support IViewObject interface", "DV_E_NOIVIEWOBJECT" },
	{ DRAGDROP_E_NOTREGISTERED, "Trying to revoke a drop target that has not been registered", "DRAGDROP_E_NOTREGISTERED" },
	{ DRAGDROP_E_ALREADYREGISTERED, "This window has already been registered as a drop target", "DRAGDROP_E_ALREADYREGISTERED" },
	{ DRAGDROP_E_INVALIDHWND, "Invalid window handle", "DRAGDROP_E_INVALIDHWND" },
	{ CLASS_E_NOAGGREGATION, "Class does not support aggregation (or class object is remote)", "CLASS_E_NOAGGREGATION" },
	{ CLASS_E_CLASSNOTAVAILABLE, "ClassFactory cannot supply requested class", "CLASS_E_CLASSNOTAVAILABLE" },
	{ VIEW_E_DRAW, "Error drawing view", "VIEW_E_DRAW" },
	{ REGDB_E_READREGDB, "Could not read key from registry", "REGDB_E_READREGDB" },
	{ REGDB_E_WRITEREGDB, "Could not write key to registry", "REGDB_E_WRITEREGDB" },
	{ REGDB_E_KEYMISSING, "Could not find the key in the registry", "REGDB_E_KEYMISSING" },
	{ REGDB_E_INVALIDVALUE, "Invalid value for registry", "REGDB_E_INVALIDVALUE" },
	{ REGDB_E_CLASSNOTREG, "Class not registered", "REGDB_E_CLASSNOTREG" },
	{ REGDB_E_IIDNOTREG, "Interface not registered", "REGDB_E_IIDNOTREG" },
	{ CACHE_E_NOCACHE_UPDATED, "Cache not updated", "CACHE_E_NOCACHE_UPDATED" },
	{ OLEOBJ_E_NOVERBS, "No verbs for OLE object", "OLEOBJ_E_NOVERBS" },
	{ OLEOBJ_E_INVALIDVERB, "Invalid verb for OLE object", "OLEOBJ_E_INVALIDVERB" },
	{ INPLACE_E_NOTUNDOABLE, "Undo is not available", "INPLACE_E_NOTUNDOABLE" },
	{ INPLACE_E_NOTOOLSPACE, "Space for tools is not available", "INPLACE_E_NOTOOLSPACE" },
	{ CONVERT10_E_OLESTREAM_GET, "OLESTREAM Get method failed", "CONVERT10_E_OLESTREAM_GET" },
	{ CONVERT10_E_OLESTREAM_PUT, "OLESTREAM Put method failed", "CONVERT10_E_OLESTREAM_PUT" },
	{ CONVERT10_E_OLESTREAM_FMT, "Contents of the OLESTREAM not in correct format", "CONVERT10_E_OLESTREAM_FMT" },
	{ CONVERT10_E_OLESTREAM_BITMAP_TO_DIB, "There was an error in a Windows GDI call while converting the bitmap to a DIB", "CONVERT10_E_OLESTREAM_BITMAP_TO_DIB" },
	{ CONVERT10_E_STG_FMT, "Contents of the IStorage not in correct format", "CONVERT10_E_STG_FMT" },
	{ CONVERT10_E_STG_NO_STD_STREAM, "Contents of IStorage is missing one of the standard streams", "CONVERT10_E_STG_NO_STD_STREAM" },
	{ CONVERT10_E_STG_DIB_TO_BITMAP, "There was an error in a Windows GDI call while converting the DIB to a bitmap.", "CONVERT10_E_STG_DIB_TO_BITMAP" },
	{ CLIPBRD_E_CANT_OPEN, "OpenClipboard Failed", "CLIPBRD_E_CANT_OPEN" },
	{ CLIPBRD_E_CANT_EMPTY, "EmptyClipboard Failed", "CLIPBRD_E_CANT_EMPTY" },
	{ CLIPBRD_E_CANT_SET, "SetClipboard Failed", "CLIPBRD_E_CANT_SET" },
	{ CLIPBRD_E_BAD_DATA, "Data on clipboard is invalid", "CLIPBRD_E_BAD_DATA" },
	{ CLIPBRD_E_CANT_CLOSE, "CloseClipboard Failed", "CLIPBRD_E_CANT_CLOSE" },
	{ MK_E_CONNECTMANUALLY, "Moniker needs to be connected manually", "MK_E_CONNECTMANUALLY" },
	{ MK_E_EXCEEDEDDEADLINE, "Operation exceeded deadline", "MK_E_EXCEEDEDDEADLINE" },
	{ MK_E_NEEDGENERIC, "Moniker needs to be generic", "MK_E_NEEDGENERIC" },
	{ MK_E_UNAVAILABLE, "Operation unavailable", "MK_E_UNAVAILABLE" },
	{ MK_E_SYNTAX, "Invalid syntax", "MK_E_SYNTAX" },
	{ MK_E_NOOBJECT, "No object for moniker", "MK_E_NOOBJECT" },
	{ MK_E_INVALIDEXTENSION, "Bad extension for file", "MK_E_INVALIDEXTENSION" },
	{ MK_E_INTERMEDIATEINTERFACENOTSUPPORTED, "Intermediate operation failed", "MK_E_INTERMEDIATEINTERFACENOTSUPPORTED" },
	{ MK_E_NOTBINDABLE, "Moniker is not bindable", "MK_E_NOTBINDABLE" },
	{ MK_E_NOTBOUND, "Moniker is not bound", "MK_E_NOTBOUND" },
	{ MK_E_CANTOPENFILE, "Moniker cannot open file", "MK_E_CANTOPENFILE" },
	{ MK_E_MUSTBOTHERUSER, "User input required for operation to succeed", "MK_E_MUSTBOTHERUSER" },
	{ MK_E_NOINVERSE, "Moniker class has no inverse", "MK_E_NOINVERSE" },
	{ MK_E_NOSTORAGE, "Moniker does not refer to storage", "MK_E_NOSTORAGE" },
	{ MK_E_NOPREFIX, "No common prefix", "MK_E_NOPREFIX" },
	{ MK_E_ENUMERATION_FAILED, "Moniker could not be enumerated", "MK_E_ENUMERATION_FAILED" },
	{ CO_E_NOTINITIALIZED, "CoInitialize has not been called.", "CO_E_NOTINITIALIZED" },
	{ CO_E_ALREADYINITIALIZED, "CoInitialize has already been called.", "CO_E_ALREADYINITIALIZED" },
	{ CO_E_CANTDETERMINECLASS, "Class of object cannot be determined", "CO_E_CANTDETERMINECLASS" },
	{ CO_E_CLASSSTRING, "Invalid class string", "CO_E_CLASSSTRING" },
	{ CO_E_IIDSTRING, "Invalid interface string", "CO_E_IIDSTRING" },
	{ CO_E_APPNOTFOUND, "Application not found", "CO_E_APPNOTFOUND" },
	{ CO_E_APPSINGLEUSE, "Application cannot be run more than once", "CO_E_APPSINGLEUSE" },
	{ CO_E_ERRORINAPP, "Some error in application program", "CO_E_ERRORINAPP" },
	{ CO_E_DLLNOTFOUND, "DLL for class not found", "CO_E_DLLNOTFOUND" },
	{ CO_E_ERRORINDLL, "Error in the DLL", "CO_E_ERRORINDLL" },
	{ CO_E_WRONGOSFORAPP, "Wrong OS or OS version for application", "CO_E_WRONGOSFORAPP" },
	{ CO_E_OBJNOTREG, "Object is not registered", "CO_E_OBJNOTREG" },
	{ CO_E_OBJISREG, "Object is already registered", "CO_E_OBJISREG" },
	{ CO_E_OBJNOTCONNECTED, "Object is not connected to server", "CO_E_OBJNOTCONNECTED" },
	{ CO_E_APPDIDNTREG, "Application was launched but it didn't register a class factory", "CO_E_APPDIDNTREG" },
	{ CO_E_RELEASED, "Object has been released", "CO_E_RELEASED" },
	{ OLE_S_USEREG, "Use the registry database to provide the requested information", "OLE_S_USEREG" },
	{ OLE_S_STATIC, "Success, but static", "OLE_S_STATIC" },
	{ OLE_S_MAC_CLIPFORMAT, "Macintosh clipboard format", "OLE_S_MAC_CLIPFORMAT" },
	{ DRAGDROP_S_DROP, "Successful drop took place", "DRAGDROP_S_DROP" },
	{ DRAGDROP_S_CANCEL, "Drag-drop operation canceled", "DRAGDROP_S_CANCEL" },
	{ DRAGDROP_S_USEDEFAULTCURSORS, "Use the default cursor", "DRAGDROP_S_USEDEFAULTCURSORS" },
	{ DATA_S_SAMEFORMATETC, "Data has same FORMATETC", "DATA_S_SAMEFORMATETC" },
	{ VIEW_S_ALREADY_FROZEN, "View is already frozen", "VIEW_S_ALREADY_FROZEN" },
	{ CACHE_S_FORMATETC_NOTSUPPORTED, "FORMATETC not supported", "CACHE_S_FORMATETC_NOTSUPPORTED" },
	{ CACHE_S_SAMECACHE, "Same cache", "CACHE_S_SAMECACHE" },
	{ CACHE_S_SOMECACHES_NOTUPDATED, "Some cache(s) not updated", "CACHE_S_SOMECACHES_NOTUPDATED" },
	{ OLEOBJ_S_INVALIDVERB, "Invalid verb for OLE object", "OLEOBJ_S_INVALIDVERB" },
	{ OLEOBJ_S_CANNOT_DOVERB_NOW, "Verb number is valid but verb cannot be done now", "OLEOBJ_S_CANNOT_DOVERB_NOW" },
	{ OLEOBJ_S_INVALIDHWND, "Invalid window handle passed", "OLEOBJ_S_INVALIDHWND" },
	{ INPLACE_S_TRUNCATED, "Message is too long; some of it had to be truncated before displaying", "INPLACE_S_TRUNCATED" },
	{ CONVERT10_S_NO_PRESENTATION, "Unable to convert OLESTREAM to IStorage", "CONVERT10_S_NO_PRESENTATION" },
	{ MK_S_REDUCED_TO_SELF, "Moniker reduced to itself", "MK_S_REDUCED_TO_SELF" },
	{ MK_S_ME, "Common prefix is this moniker", "MK_S_ME" },
	{ MK_S_HIM, "Common prefix is input moniker", "MK_S_HIM" },
	{ MK_S_US, "Common prefix is both monikers", "MK_S_US" },
	{ MK_S_MONIKERALREADYREGISTERED, "Moniker is already registered in running object table", "MK_S_MONIKERALREADYREGISTERED" },
	{ CO_E_CLASS_CREATE_FAILED, "Attempt to create a class object failed", "CO_E_CLASS_CREATE_FAILED" },
	{ CO_E_SCM_ERROR, "OLE service could not bind object", "CO_E_SCM_ERROR" },
	{ CO_E_SCM_RPC_FAILURE, "RPC communication failed with OLE service", "CO_E_SCM_RPC_FAILURE" },
	{ CO_E_BAD_PATH, "Bad path to object", "CO_E_BAD_PATH" },
	{ CO_E_SERVER_EXEC_FAILURE, "Server execution failed", "CO_E_SERVER_EXEC_FAILURE" },
	{ CO_E_OBJSRV_RPC_FAILURE, "OLE service could not communicate with the object server", "CO_E_OBJSRV_RPC_FAILURE" },
	{ MK_E_NO_NORMALIZED, "Moniker path could not be normalized", "MK_E_NO_NORMALIZED" },
	{ CO_E_SERVER_STOPPING, "Object server is stopping when OLE service contacts it", "CO_E_SERVER_STOPPING" },
	{ MEM_E_INVALID_ROOT, "An invalid root block pointer was specified", "MEM_E_INVALID_ROOT" },
	{ MEM_E_INVALID_LINK, "An allocation chain contained an invalid link pointer", "MEM_E_INVALID_LINK" },
	{ MEM_E_INVALID_SIZE, "The requested allocation size was too large", "MEM_E_INVALID_SIZE" },
	{ CO_S_NOTALLINTERFACES, "Not all the requested interfaces were available", "CO_S_NOTALLINTERFACES" },
	{ DISP_E_UNKNOWNINTERFACE, "Unknown interface.", "DISP_E_UNKNOWNINTERFACE" },
	{ DISP_E_MEMBERNOTFOUND, "Member not found.", "DISP_E_MEMBERNOTFOUND" },
	{ DISP_E_PARAMNOTFOUND, "Parameter not found.", "DISP_E_PARAMNOTFOUND" },
	{ DISP_E_TYPEMISMATCH, "Type mismatch.", "DISP_E_TYPEMISMATCH" },
	{ DISP_E_UNKNOWNNAME, "Unknown name.", "DISP_E_UNKNOWNNAME" },
	{ DISP_E_NONAMEDARGS, "No named arguments.", "DISP_E_NONAMEDARGS" },
	{ DISP_E_BADVARTYPE, "Bad variable type.", "DISP_E_BADVARTYPE" },
	{ DISP_E_EXCEPTION, "Exception occurred.", "DISP_E_EXCEPTION" },
	{ DISP_E_OVERFLOW, "Out of present range.", "DISP_E_OVERFLOW" },
	{ DISP_E_BADINDEX, "Invalid index.", "DISP_E_BADINDEX" },
	{ DISP_E_UNKNOWNLCID, "Unknown language.", "DISP_E_UNKNOWNLCID" },
	{ DISP_E_ARRAYISLOCKED, "Memory is locked.", "DISP_E_ARRAYISLOCKED" },
	{ DISP_E_BADPARAMCOUNT, "Invalid number of parameters.", "DISP_E_BADPARAMCOUNT" },
	{ DISP_E_PARAMNOTOPTIONAL, "Parameter not optional.", "DISP_E_PARAMNOTOPTIONAL" },
	{ DISP_E_BADCALLEE, "Invalid callee.", "DISP_E_BADCALLEE" },
	{ DISP_E_NOTACOLLECTION, "Does not support a collection.", "DISP_E_NOTACOLLECTION" },
	{ TYPE_E_BUFFERTOOSMALL, "Buffer too small.", "TYPE_E_BUFFERTOOSMALL" },
	{ TYPE_E_INVDATAREAD, "Old format or invalid type library.", "TYPE_E_INVDATAREAD" },
	{ TYPE_E_UNSUPFORMAT, "Old format or invalid type library.", "TYPE_E_UNSUPFORMAT" },
	{ TYPE_E_REGISTRYACCESS, "Error accessing the OLE registry.", "TYPE_E_REGISTRYACCESS" },
	{ TYPE_E_LIBNOTREGISTERED, "Library not registered.", "TYPE_E_LIBNOTREGISTERED" },
	{ TYPE_E_UNDEFINEDTYPE, "Bound to unknown type.", "TYPE_E_UNDEFINEDTYPE" },
	{ TYPE_E_QUALIFIEDNAMEDISALLOWED, "Qualified name disallowed.", "TYPE_E_QUALIFIEDNAMEDISALLOWED" },
	{ TYPE_E_INVALIDSTATE, "Invalid forward reference, or reference to uncompiled type.", "TYPE_E_INVALIDSTATE" },
	{ TYPE_E_WRONGTYPEKIND, "Type mismatch.", "TYPE_E_WRONGTYPEKIND" },
	{ TYPE_E_ELEMENTNOTFOUND, "Element not found.", "TYPE_E_ELEMENTNOTFOUND" },
	{ TYPE_E_AMBIGUOUSNAME, "Ambiguous name.", "TYPE_E_AMBIGUOUSNAME" },
	{ TYPE_E_NAMECONFLICT, "Name already exists in the library.", "TYPE_E_NAMECONFLICT" },
	{ TYPE_E_UNKNOWNLCID, "Unknown LCID.", "TYPE_E_UNKNOWNLCID" },
	{ TYPE_E_DLLFUNCTIONNOTFOUND, "Function not defined in specified DLL.", "TYPE_E_DLLFUNCTIONNOTFOUND" },
	{ TYPE_E_BADMODULEKIND, "Wrong module kind for the operation.", "TYPE_E_BADMODULEKIND" },
	{ TYPE_E_SIZETOOBIG, "Size may not exceed 64K.", "TYPE_E_SIZETOOBIG" },
	{ TYPE_E_DUPLICATEID, "Duplicate ID in inheritance hierarchy.", "TYPE_E_DUPLICATEID" },
	{ TYPE_E_INVALIDID, "Incorrect inheritance depth in standard OLE hmember.", "TYPE_E_INVALIDID" },
	{ TYPE_E_TYPEMISMATCH, "Type mismatch.", "TYPE_E_TYPEMISMATCH" },
	{ TYPE_E_OUTOFBOUNDS, "Invalid number of arguments.", "TYPE_E_OUTOFBOUNDS" },
	{ TYPE_E_IOERROR, "IO Error.", "TYPE_E_IOERROR" },
	{ TYPE_E_CANTCREATETMPFILE, "Error creating unique tmp file.", "TYPE_E_CANTCREATETMPFILE" },
	{ TYPE_E_CANTLOADLIBRARY, "Error loading type libraryDLL.", "TYPE_E_CANTLOADLIBRARY" },
	{ TYPE_E_INCONSISTENTPROPFUNCS, "Inconsistent property functions.", "TYPE_E_INCONSISTENTPROPFUNCS" },
	{ TYPE_E_CIRCULARTYPE, "Circular dependency between typesmodules.", "TYPE_E_CIRCULARTYPE" },
	{ STG_E_INVALIDFUNCTION, "Unable to perform requested operation.", "STG_E_INVALIDFUNCTION" },
	{ STG_E_FILENOTFOUND, "%1 could not be found.", "STG_E_FILENOTFOUND" },
	{ STG_E_PATHNOTFOUND, "The path %1 could not be found.", "STG_E_PATHNOTFOUND" },
	{ STG_E_TOOMANYOPENFILES, "There are insufficient resources to open another file.", "STG_E_TOOMANYOPENFILES" },
	{ STG_E_ACCESSDENIED, "Access Denied.", "STG_E_ACCESSDENIED" },
	{ STG_E_INVALIDHANDLE, "Attempted an operation on an invalid object.", "STG_E_INVALIDHANDLE" },
	{ STG_E_INSUFFICIENTMEMORY, "There is insufficient memory available to complete operation.", "STG_E_INSUFFICIENTMEMORY" },
	{ STG_E_INVALIDPOINTER, "Invalid pointer error.", "STG_E_INVALIDPOINTER" },
	{ STG_E_NOMOREFILES, "There are no more entries to return.", "STG_E_NOMOREFILES" },
	{ STG_E_DISKISWRITEPROTECTED, "Disk is write-protected.", "STG_E_DISKISWRITEPROTECTED" },
	{ STG_E_SEEKERROR, "An error occurred during a seek operation.", "STG_E_SEEKERROR" },
	{ STG_E_WRITEFAULT, "A disk error occurred during a write operation.", "STG_E_WRITEFAULT" },
	{ STG_E_READFAULT, "A disk error occurred during a read operation.", "STG_E_READFAULT" },
	{ STG_E_SHAREVIOLATION, "A share violation has occurred.", "STG_E_SHAREVIOLATION" },
	{ STG_E_LOCKVIOLATION, "A lock violation has occurred.", "STG_E_LOCKVIOLATION" },
	{ STG_E_FILEALREADYEXISTS, "%1 already exists.", "STG_E_FILEALREADYEXISTS" },
	{ STG_E_INVALIDPARAMETER, "Invalid parameter error.", "STG_E_INVALIDPARAMETER" },
	{ STG_E_MEDIUMFULL, "There is insufficient disk space to complete operation.", "STG_E_MEDIUMFULL" },
	{ STG_E_PROPSETMISMATCHED, "Illegal write of non-simple property to simple property set.", "STG_E_PROPSETMISMATCHED" },
	{ STG_E_ABNORMALAPIEXIT, "An API call exited abnormally.", "STG_E_ABNORMALAPIEXIT" },
	{ STG_E_INVALIDHEADER, "The file %1 is not a valid compound file.", "STG_E_INVALIDHEADER" },
	{ STG_E_INVALIDNAME, "The name %1 is not valid.", "STG_E_INVALIDNAME" },
	{ STG_E_UNKNOWN, "An unexpected error occurred.", "STG_E_UNKNOWN" },
	{ STG_E_UNIMPLEMENTEDFUNCTION, "That function is not implemented.", "STG_E_UNIMPLEMENTEDFUNCTION" },
	{ STG_E_INVALIDFLAG, "Invalid flag error.", "STG_E_INVALIDFLAG" },
	{ STG_E_INUSE, "Attempted to use an object that is busy.", "STG_E_INUSE" },
	{ STG_E_NOTCURRENT, "The storage has been changed since the last commit.", "STG_E_NOTCURRENT" },
	{ STG_E_REVERTED, "Attempted to use an object that has ceased to exist.", "STG_E_REVERTED" },
	{ STG_E_CANTSAVE, "Can't save.", "STG_E_CANTSAVE" },
	{ STG_E_OLDFORMAT, "The compound file %1 was produced with an incompatible version of storage.", "STG_E_OLDFORMAT" },
	{ STG_E_OLDDLL, "The compound file %1 was produced with a newer version of storage.", "STG_E_OLDDLL" },
	{ STG_E_SHAREREQUIRED, "Share.exe or equivalent is required for operation.", "STG_E_SHAREREQUIRED" },
	{ STG_E_NOTFILEBASEDSTORAGE, "Illegal operation called on non-file based storage.", "STG_E_NOTFILEBASEDSTORAGE" },
	{ STG_E_EXTANTMARSHALLINGS, "Illegal operation called on object with extant marshallings.", "STG_E_EXTANTMARSHALLINGS" },
	{ STG_E_DOCFILECORRUPT, "The docfile has been corrupted.", "STG_E_DOCFILECORRUPT" },
	{ STG_E_BADBASEADDRESS, "OLE32.DLL has been loaded at the wrong address.", "STG_E_BADBASEADDRESS" },
	{ STG_E_INCOMPLETE, "The file download was aborted abnormally. The file is incomplete..", "STG_E_INCOMPLETE" },
	{ STG_E_TERMINATED, "The file download has been terminated.", "STG_E_TERMINATED" },
	{ STG_S_CONVERTED, "The underlying file was converted to compound file format.", "STG_S_CONVERTED" },
	{ STG_S_BLOCK, "The storage operation should block until more data is available.", "STG_S_BLOCK" },
	{ STG_S_RETRYNOW, "The storage operation should retry immediately.", "STG_S_RETRYNOW" },
	{ STG_S_MONITORING, "The notified event sink will not influence the storage operation.", "STG_S_MONITORING" },
	{ RPC_E_CALL_REJECTED, "Call was rejected by callee.", "RPC_E_CALL_REJECTED" },
	{ RPC_E_CALL_CANCELED, "Call was canceled by the message filter.", "RPC_E_CALL_CANCELED" },
	{ RPC_E_CANTPOST_INSENDCALL, "The caller is dispatching an intertask SendMessage call and cannot call out via PostMessage..", "RPC_E_CANTPOST_INSENDCALL" },
	{ RPC_E_CANTCALLOUT_INASYNCCALL, "The caller is dispatching an asynchronous call and cannot make an outgoing call on behalf of this call..", "RPC_E_CANTCALLOUT_INASYNCCALL" },
	{ RPC_E_CANTCALLOUT_INEXTERNALCALL, "It is illegal to call out while inside message filter.", "RPC_E_CANTCALLOUT_INEXTERNALCALL" },
	{ RPC_E_CONNECTION_TERMINATED, "The connection terminated or is in a bogus state and cannot be used any more. Other connections are still valid.d.", "RPC_E_CONNECTION_TERMINATED" },
	{ RPC_E_SERVER_DIED, "The callee (server [not server application]) is not available and disappeared; all connections are invalid. The call may have executed.ed.", "RPC_E_SERVER_DIED" },
	{ RPC_E_CLIENT_DIED, "The caller (client) disappeared while the callee (server) was processing a call..", "RPC_E_CLIENT_DIED" },
	{ RPC_E_INVALID_DATAPACKET, "The data packet with the marshalled parameter data is incorrect.", "RPC_E_INVALID_DATAPACKET" },
	{ RPC_E_CANTTRANSMIT_CALL, "The call was not transmitted properly; the message queue was full and was not emptied after yielding..", "RPC_E_CANTTRANSMIT_CALL" },
	{ RPC_E_CLIENT_CANTMARSHAL_DATA, "The client (caller) cannot marshall the parameter data - low memory, etc.", "RPC_E_CLIENT_CANTMARSHAL_DATA" },
	{ RPC_E_CLIENT_CANTUNMARSHAL_DATA, "The client (caller) cannot unmarshall the return data - low memory, etc.", "RPC_E_CLIENT_CANTUNMARSHAL_DATA" },
	{ RPC_E_SERVER_CANTMARSHAL_DATA, "The server (callee) cannot marshall the return data - low memory, etc.", "RPC_E_SERVER_CANTMARSHAL_DATA" },
	{ RPC_E_SERVER_CANTUNMARSHAL_DATA, "The server (callee) cannot unmarshall the parameter data - low memory, etc.", "RPC_E_SERVER_CANTUNMARSHAL_DATA" },
	{ RPC_E_INVALID_DATA, "Received data is invalid; could be server or client data.", "RPC_E_INVALID_DATA" },
	{ RPC_E_INVALID_PARAMETER, "A particular parameter is invalid and cannot be (un)marshalled.", "RPC_E_INVALID_PARAMETER" },
	{ RPC_E_CANTCALLOUT_AGAIN, "There is no second outgoing call on same channel in DDE conversation.", "RPC_E_CANTCALLOUT_AGAIN" },
	{ RPC_E_SERVER_DIED_DNE, "The callee (server [not server application]) is not available and disappeared; all connections are invalid. The call did not execute.e.", "RPC_E_SERVER_DIED_DNE" },
	{ RPC_E_SYS_CALL_FAILED, "System call failed.", "RPC_E_SYS_CALL_FAILED" },
	{ RPC_E_OUT_OF_RESOURCES, "Could not allocate some required resource (memory, events, ...)", "RPC_E_OUT_OF_RESOURCES" },
	{ RPC_E_ATTEMPTED_MULTITHREAD, "Attempted to make calls on more than one thread in single threaded mode.", "RPC_E_ATTEMPTED_MULTITHREAD" },
	{ RPC_E_NOT_REGISTERED, "The requested interface is not registered on the server object.", "RPC_E_NOT_REGISTERED" },
	{ RPC_E_FAULT, "RPC could not call the server or could not return the results of calling the server.", "RPC_E_FAULT" },
	{ RPC_E_SERVERFAULT, "The server threw an exception.", "RPC_E_SERVERFAULT" },
	{ RPC_E_CHANGED_MODE, "Cannot change thread mode after it is set.", "RPC_E_CHANGED_MODE" },
	{ RPC_E_INVALIDMETHOD, "The method called does not exist on the server.", "RPC_E_INVALIDMETHOD" },
	{ RPC_E_DISCONNECTED, "The object invoked has disconnected from its clients.", "RPC_E_DISCONNECTED" },
	{ RPC_E_RETRY, "The object invoked chose not to process the call now. Try again later..", "RPC_E_RETRY" },
	{ RPC_E_SERVERCALL_RETRYLATER, "The message filter indicated that the application is busy.", "RPC_E_SERVERCALL_RETRYLATER" },
	{ RPC_E_SERVERCALL_REJECTED, "The message filter rejected the call.", "RPC_E_SERVERCALL_REJECTED" },
	{ RPC_E_INVALID_CALLDATA, "A call control interfaces was called with invalid data.", "RPC_E_INVALID_CALLDATA" },
	{ RPC_E_CANTCALLOUT_ININPUTSYNCCALL, "An outgoing call cannot be made since the application is dispatching an input-synchronous call.", "RPC_E_CANTCALLOUT_ININPUTSYNCCALL" },
	{ RPC_E_WRONG_THREAD, "The application called an interface that was marshalled for a different thread.", "RPC_E_WRONG_THREAD" },
	{ RPC_E_THREAD_NOT_INIT, "CoInitialize has not been called on the current thread.", "RPC_E_THREAD_NOT_INIT" },
	{ RPC_E_VERSION_MISMATCH, "The version of OLE on the client and server machines does not match.", "RPC_E_VERSION_MISMATCH" },
	{ RPC_E_INVALID_HEADER, "OLE received a packet with an invalid header.", "RPC_E_INVALID_HEADER" },
	{ RPC_E_INVALID_EXTENSION, "OLE received a packet with an invalid extension.", "RPC_E_INVALID_EXTENSION" },
	{ RPC_E_INVALID_IPID, "The requested object or interface does not exist.", "RPC_E_INVALID_IPID" },
	{ RPC_E_INVALID_OBJECT, "The requested object does not exist.", "RPC_E_INVALID_OBJECT" },
	{ RPC_S_CALLPENDING, "OLE has sent a request and is waiting for a reply.", "RPC_S_CALLPENDING" },
	{ RPC_S_WAITONTIMER, "OLE is waiting before retrying a request.", "RPC_S_WAITONTIMER" },
	{ RPC_E_CALL_COMPLETE, "Call context cannot be accessed after call completed.", "RPC_E_CALL_COMPLETE" },
	{ RPC_E_UNSECURE_CALL, "Impersonate on unsecure calls is not supported.", "RPC_E_UNSECURE_CALL" },
	{ RPC_E_TOO_LATE, "Security must be initialized before any interfaces are marshalled or unmarshalled. It cannot be changed once initialized.d.", "RPC_E_TOO_LATE" },
	{ RPC_E_NO_GOOD_SECURITY_PACKAGES, "No security packages are installed on this machine or the user is not logged on or there are no compatible security packages between the client and server..", "RPC_E_NO_GOOD_SECURITY_PACKAGES" },
	{ RPC_E_ACCESS_DENIED, "Access is denied.", "RPC_E_ACCESS_DENIED" },
	{ RPC_E_REMOTE_DISABLED, "Remote calls are not allowed for this process.", "RPC_E_REMOTE_DISABLED" },
	{ RPC_E_UNEXPECTED, "An internal error occurred.", "RPC_E_UNEXPECTED" },
	{ NTE_BAD_UID, "Bad UID.", "NTE_BAD_UID" },
	{ NTE_BAD_HASH, "Bad Hash.", "NTE_BAD_HASH" },
	{ NTE_BAD_KEY, "Bad Key.", "NTE_BAD_KEY" },
	{ NTE_BAD_LEN, "Bad Length.", "NTE_BAD_LEN" },
	{ NTE_BAD_DATA, "Bad Data.", "NTE_BAD_DATA" },
	{ NTE_BAD_SIGNATURE, "Invalid Signature.", "NTE_BAD_SIGNATURE" },
	{ NTE_BAD_VER, "Bad Version of provider.", "NTE_BAD_VER" },
	{ NTE_BAD_ALGID, "Invalid algorithm specified.", "NTE_BAD_ALGID" },
	{ NTE_BAD_FLAGS, "Invalid flags specified.", "NTE_BAD_FLAGS" },
	{ NTE_BAD_TYPE, "Invalid type specified.", "NTE_BAD_TYPE" },
	{ NTE_BAD_KEY_STATE, "Key not valid for use in specified state.", "NTE_BAD_KEY_STATE" },
	{ NTE_BAD_HASH_STATE, "Hash not valid for use in specified state.", "NTE_BAD_HASH_STATE" },
	{ NTE_NO_KEY, "Key does not exist.", "NTE_NO_KEY" },
	{ NTE_NO_MEMORY, "Insufficient memory available for the operation.", "NTE_NO_MEMORY" },
	{ NTE_EXISTS, "Object already exists.", "NTE_EXISTS" },
	{ NTE_PERM, "Access denied.", "NTE_PERM" },
	{ NTE_NOT_FOUND, "Object was not found.", "NTE_NOT_FOUND" },
	{ NTE_DOUBLE_ENCRYPT, "Data already encrypted.", "NTE_DOUBLE_ENCRYPT" },
	{ NTE_BAD_PROVIDER, "Invalid provider specified.", "NTE_BAD_PROVIDER" },
	{ NTE_BAD_PROV_TYPE, "Invalid provider type specified.", "NTE_BAD_PROV_TYPE" },
	{ NTE_BAD_PUBLIC_KEY, "Provider's public key is invalid.", "NTE_BAD_PUBLIC_KEY" },
	{ NTE_BAD_KEYSET, "Keyset does not exist", "NTE_BAD_KEYSET" },
	{ NTE_PROV_TYPE_NOT_DEF, "Provider type not defined.", "NTE_PROV_TYPE_NOT_DEF" },
	{ NTE_PROV_TYPE_ENTRY_BAD, "Provider type as registered is invalid.", "NTE_PROV_TYPE_ENTRY_BAD" },
	{ NTE_KEYSET_NOT_DEF, "The keyset is not defined.", "NTE_KEYSET_NOT_DEF" },
	{ NTE_KEYSET_ENTRY_BAD, "Keyset as registered is invalid.", "NTE_KEYSET_ENTRY_BAD" },
	{ NTE_PROV_TYPE_NO_MATCH, "Provider type does not match registered value.", "NTE_PROV_TYPE_NO_MATCH" },
	{ NTE_SIGNATURE_FILE_BAD, "The digital signature file is corrupt.", "NTE_SIGNATURE_FILE_BAD" },
	{ NTE_PROVIDER_DLL_FAIL, "Provider DLL failed to initialize correctly.", "NTE_PROVIDER_DLL_FAIL" },
	{ NTE_PROV_DLL_NOT_FOUND, "Provider DLL could not be found.", "NTE_PROV_DLL_NOT_FOUND" },
	{ NTE_BAD_KEYSET_PARAM, "The Keyset parameter is invalid.", "NTE_BAD_KEYSET_PARAM" },
	{ NTE_FAIL, "An internal error occurred.", "NTE_FAIL" },
	{ NTE_SYS_ERR, "A base error occurred.", "NTE_SYS_ERR" },
	{ TRUST_E_PROVIDER_UNKNOWN, "The specified trust provider is not known on this system.", "TRUST_E_PROVIDER_UNKNOWN" },
	{ TRUST_E_ACTION_UNKNOWN, "The trust verification action specified is not supported by the specified trust provider.", "TRUST_E_ACTION_UNKNOWN" },
	{ TRUST_E_SUBJECT_FORM_UNKNOWN, "The form specified for the subject is not one supported or known by the specified trust provider.", "TRUST_E_SUBJECT_FORM_UNKNOWN" },
	{ TRUST_E_SUBJECT_NOT_TRUSTED, "The subject is not trusted for the specified action.", "TRUST_E_SUBJECT_NOT_TRUSTED" },
    { -1,                          0,                                              0  }
};

#define	ecount		(sizeof(WEr) / sizeof(WER))

// some DEBUG outputs
// ******************
void    outvals( void )
{
    LPWER   lpe;
    DWORD   dwc;

    printf( "List of %d values is\n", (ecount - 1) );

    lpe = &WEr[0];
    dwc = 0;
    while( lpe->we_lpStg )
    {

		if( lpe->we_lpEStg )
		{
			printf( "Value = 0x%x. [%s]\n", lpe->we_lgVal, lpe->we_lpEStg );
		}
		else
		{
			printf( "Value = 0x%x. [???????]\n", lpe->we_lgVal );
		}

        dwc++;
        lpe++;
    }

    printf( "Have output %d values.", dwc );
}

/* ================================================================
	void	OutWin32Err( long lErr )

	PURPOSE:
		DIAGNOSTIC OUTPUT ONLY

   ================================================================ */
void	OutWin32Err( long lErr )
{
    LPWER   lpe, lplast;
    lpe = &WEr[0];

	// show what we are seeking
	printf( "Finding WIN32 error 0x%x (%d)\n",
					lErr, lErr );

    while( lpe->we_lpStg )
    {
		if( lpe->we_lgVal == lErr )
			break;
		lpe++;
	}
	if( lpe->we_lpStg )
	{
		printf( "Value = 0x%x. [%s] %s\n",
			lpe->we_lgVal,
			lpe->we_lpEStg,
			lpe->we_lpStg );
	}
	else
	{
		// NOT FOUND - Hmmmm what to do
	    lpe = &WEr[0];
		if( lErr > 0 )
		{
			lplast = 0;
			if( lErr < 0x10000 )
			{
				while( lpe->we_lpStg )
				{
					if( (lpe->we_lgVal & 0xffff) >= lErr )
						break;
					lplast = lpe;
					lpe++;
				}
				if( lpe->we_lpStg )
				{
					if( ( lplast ) &&
						( lplast->we_lpStg ) )
					{
						printf( "Previous Value = 0x%x. [%s] %s\n",
							lplast->we_lgVal,
							lplast->we_lpEStg,
							lplast->we_lpStg );
					}
					printf( "Next Value = 0x%x. [%s] %s\n",
						lpe->we_lgVal,
						lpe->we_lpEStg,
						lpe->we_lpStg );
				}
				else
				{
					printf( "Failed to locate 0x%x (%d)\n",
						lErr, lErr );
				}
			}
			else
			{
				// hmmm, greater than 16 bits
				while( ( lpe->we_lpStg ) &&
					( lpe->we_lgVal < lErr ) )
				{
					lplast = lpe;
					lpe++;
				}
				if( lpe->we_lpStg )
				{
					if( ( lplast ) &&
						( lplast->we_lpStg ) )
					{
						printf( "Previous Value = 0x%x. [%s] %s\n",
							lplast->we_lgVal,
							lplast->we_lpEStg,
							lplast->we_lpStg );
					}
					printf( "Next Value = 0x%x. [%s] %s\n",
						lpe->we_lgVal,
						lpe->we_lpEStg,
						lpe->we_lpStg );
				}
				else
				{
					printf( "Failed to locate 0x%x (%d)\n",
						lErr, lErr );
				}
			}
		}
		else
		{
			lplast = 0;
			while( ( lpe->we_lpStg ) &&
				( lpe->we_lgVal > lErr ) )
			{
				lplast = lpe;
				lpe++;
			}
			if( lpe->we_lpStg )
			{
				if( ( lplast ) &&
					( lplast->we_lpStg ) )
				{
					printf( "Last Value = 0x%x. [%s] %s\n",
						lplast->we_lgVal,
						lplast->we_lpEStg,
						lplast->we_lpStg );
				}
				printf( "Next Value = 0x%x. [%s] %s\n",
					lpe->we_lgVal,
					lpe->we_lpEStg,
					lpe->we_lpStg );
			}
			else
			{
				printf( "Failed to locate 0x%x (%d)\n",
					lErr, lErr );
			}
		}
	}
}

#endif	/* NDEBUG y/n */

// eof - winerror.c
