// Fa4Comp.c
// Full compare of FIND

#include "Fa4.h"

BOOL	NotAsciiRng( char c )
{
	BOOL	flg = TRUE;

	if( ( ( c >= 'a' ) && ( c <= 'z' ) ) ||
		( ( c >= 'A' ) && ( c <= 'Z' ) ) ||
		( ( c >= '0' ) && ( c <= '9' ) ) )
	{
		flg = FALSE;
	}
	return flg;
}

#define  ISSPACEY(a)    ( a <= ' ' )


///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : FullComp
// Return type: BOOL 
// Arguments  : WS
//            : LPTSTR lpf
//            : DWORD dwoff
//            : DWORD dwmax
//            : LPTSTR lpc
//            : DWORD len
//            : PDWORD pdw
// Description: Found JUST the first LETTER match
//              Now check it match the WHOLE find request
///////////////////////////////////////////////////////////////////////////////
BOOL	FullComp( WS,
				 LPTSTR lpf, DWORD dwoff, DWORD dwmax,
				 LPTSTR lpc, DWORD flen) // , PDWORD pdw )
{
    DWORD    i;
	INT	   c, cm;
	BOOL	   suc, fC, fP;
	LPTSTR   pbgn = &lpf[dwoff];        // pointer to FIRST LETTER
    DWORD    dwrem = (dwmax - dwoff);

	suc   = FALSE;       // assume NOT the same
	i  = 0;
	fC = g_fCase;         // extract CASE flag
	fP = gfParity;       // extract PARITY flga

	if( fP )
		cm = 0x7f;
	else
		cm = 0xff;

    // can only find if LENGTH of (copy of) find string,
    // is LESS than remainder of file!
    if( flen == 1 ) {
      suc = TRUE;
    } else if( flen < dwrem ) {
        if( gfSpacey ) {   // -I to ignore SPACE chars in COMPARE
            lpc++;
            pbgn++;  // skip past first letter on both
            flen--;  // reduce find length
            i = dwoff;
            i++;
            while( *lpc && flen && ( i < dwrem ) ) {
                if( *lpc <= ' ' ) {
                    if( *pbgn <= ' ' ) {
                        while( *lpc && ( *lpc <= ' ' ) ) {
                            flen--;
                            lpc++;
                        }
                        if( *lpc ) {
                            while( *pbgn && ( *pbgn <= ' ' ) && ( i < dwrem ) ) {
                                i++;
                                pbgn++;
                            }
                            continue;
                        } else {
                            suc = TRUE;
                            break;
                        }
                    } else
                        break;   // space in find, NOT in file = FAILED
                } else {
                    if(fC) {
                        if( *lpc != (*pbgn & cm) )
                            break;
                    } else {
                        if( *lpc != toupper(*pbgn & cm) )
                            break;
                    }
                }
                lpc++;   // next FIND string char
                pbgn++;  // next FILE char
                i++;     // bump the offset into the buffer
                flen--;  // and reduce the length of finding
            }  // for a while
            if( (flen == 0) &&
                (*lpc == 0) )
                suc = TRUE;
        } else { // no ignore space chars
            i = 1;
            if( fC ) {
                for( ; i < flen; i++ ) {
                    c = ( pbgn[i] & cm );
                    if( lpc[i] != c )
                        break;
                }
            } else {
                for( ; i < flen; i++ ) {
                    c = toupper( ( pbgn[i] & cm ) );
                    if( lpc[i] != c )
                        break;
                }
            }
            if( i == flen )
                suc = TRUE;
        }
    }
	if( suc ) {
		suc = TRUE;		// We have a FIND
		if( gfWhole ) {
            if( dwoff ) {
                c = lpf[dwoff-1]; // get PREVIOUS character
                if( fP )
                    c = c & 0x7f;
                if( g_fWhole2 )   // FIX20010413 - add -w2 to force SPACE delimited
                    suc = (BOOL)ISSPACEY( c );
                else
                    suc = (BOOL)NotAsciiRng( (CHAR)c );
            }
			if( suc ) {
                if( (dwoff + i) < dwmax ) {
                    c = lpf[dwoff+i]; // get FOLLOWING character
					if( fP )
						c = c & 0x7f;
                    if( g_fWhole2 )   // FIX20010413 - add -w2 to force SPACE delimited
                        suc = (BOOL)ISSPACEY( c );
                    else
                        suc = (BOOL)NotAsciiRng( (CHAR)c );
                }
            }
		}
		if( suc ) {
			// All appears OK
			// ==============
			gdwFinds++;		// successful FIND
            g_dwOffBgn = dwoff;
            g_dwOffEnd = dwoff + i;
		}
    }
    // UNREFERENCED_PARAMETER(pdw);
    return suc;
}

// eof - Fa4Comp.c
