

// Fa4Util.h
#ifndef	_Fa4Util_H
#define	_Fa4Util_H

#define  ISNUM(a)    ( ( a >= '0' ) && ( a <= '9' ) )

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : InStr
// Return type: INT 
// Arguments  : LPTSTR lpb
//            : LPTSTR lps
// Description: Return the position of the FIRST instance of the string in lps
//              Emulates the Visual Basic function.
///////////////////////////////////////////////////////////////////////////////
extern	INT   InStr( LPTSTR lpb, LPTSTR lps );

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Mid
// Return type: LPTSTR 
// Arguments  : LPTSTR lpl - Pointer to line
//            : DWORD dwb  - Begin here
//            : DWORD dwl  - for this length
// Description: Returns a buffer containing the MIDDLE portion of a string.
//              Emulates the Visual Basic function.
///////////////////////////////////////////////////////////////////////////////
extern   LPTSTR   Mid( LPTSTR lpl, DWORD dwb, DWORD dwl );

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Left
// Return type: LPTSTR 
// Arguments  : LPTSTR lpl
//            : DWORD dwi
// Description: Return the LEFT prortion of a string
//              Emulates the Visual Basic function
///////////////////////////////////////////////////////////////////////////////
extern   LPTSTR   Left( LPTSTR lpl, DWORD dwi );

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Right
// Return type: LPTSTR 
// Arguments  : LPTSTR lpl
//            : DWORD dwl
// Description: Returns a buffer containing the RIGHT postion of a string
//              Emulates the Visual Basic function.
///////////////////////////////////////////////////////////////////////////////
extern   LPTSTR   Right( LPTSTR lpl, DWORD dwl );


extern   DWORD    TrimIB( LPTSTR lps );  // trim leading and trailing spacey stuff

extern   BOOL     Stg2SysTm( LPTSTR lps, SYSTEMTIME * pt );
extern   VOID     AppendDateTime( LPTSTR lpb, LPSYSTEMTIME pst );
extern   int      _cdecl sprtf( LPTSTR lpf, ... );
extern   LPTSTR   DSecs2YDHMSStg( double db );
extern PTSTR GetNxtBuf( VOID );
extern PTSTR My_NiceNumber( PTSTR lpn );
extern PTSTR My_NiceNumberStg( DWORD num );

#endif	// _Fa4Util_H
// eof - Fa4Util.h
