
// GrmOut.c
#define	WIN32_MEAN_AND_LEAN
#include	<windows.h>
#include	"GrmOut.h"

#ifndef	NDEBUG
#define		ADDDIAGT
#else
#undef		ADDDIAGT
#endif	/* NDEBUG y/n */

//#define		MXIO		256
#define		MXIO		1024
#define		MXSTG		32		// In PutThous( )

#ifdef	ADDDIAGT
#pragma message( "NOTE: Diagnotic text is written to TEMPDIAG.TXT" )
extern	void	WriteDiagFile( LPSTR lps );
#endif	// ADDDIAGT

BOOL	bEnsureTail = FALSE;
BOOL	gbCheckCrLf = TRUE;
#if	!(defined FC4W)
BOOL	   fOnce    = TRUE;
HANDLE	hOut     = 0;
HANDLE   hErrOut  = 0;
BOOL     bRedirON = FALSE;
#endif	/* !FC4W */

HANDLE	hUserOut;
//	char * buf = _s_goutbuf; [MXIO + 4];
char _s_goutbuf[MXIO + 4];

// NOTE: In here VH(a) is defined
//#ifndef  VFH
//#define  VFH(a)   ( a && ( a != INVALID_HANDLE_VALUE ) )
//#endif   // VFH

// extracted from FixF32 prohect
// HOW TO DETECT if the CONSOLE stdout is REDIRECTED to a file?
// ============= fprintf() fopen() ????
// Found a way! Presently using handle to get mode. If this get
// fails, then we are being redirected!!

// General Services
void	oi( LPSTR lps )
{
	int		i;
	DWORD	dw;
#ifndef	FC4W
	if( fOnce )
	{
		hOut    = GetStdHandle( STD_OUTPUT_HANDLE );
      hErrOut = GetStdHandle( STD_ERROR_HANDLE  );   // error out
      if( VH(hOut) )
      {
         DWORD dwm;
         if( !GetConsoleMode( hOut, &dwm ) )
            bRedirON = TRUE;
         // g_bRedirON = TRUE;
      }
		fOnce = FALSE;
	}
#endif	/* !FC4W */
   i = 0;
	if( lps )
      i = lstrlen( lps );
   if(i)
	{
#ifndef	FC4W
//		WriteAFile( hOut, lps, i );
		WriteFile( hOut, lps, i, &dw, NULL );
#endif	/* !FC4W */

		if( VH(hUserOut) )
			WriteFile( hUserOut, lps, i, &dw, NULL );

#ifdef	ADDDIAGT
		// write diagnostic text file
		WriteDiagFile( lps );
		// ==========================
#endif	// ADDDIAGT

	}
}

void	doi( LPSTR lps )
{
#ifdef	ADDDIAGT
		WriteDiagFile( lps );
#endif	// ADDDIAGT
}

void	SetEnsureCrLf( int i )
{
	if( i )
		gbCheckCrLf = TRUE;
	else
		gbCheckCrLf = FALSE;
}

BOOL	GetEnsureCrLf( void )
{
	return( gbCheckCrLf ? TRUE : FALSE );
}

void	prt( LPSTR lps )
{
	// char	buf[MXIO + 4];
	char * buf = _s_goutbuf; // [MXIO + 4];
	LPSTR	lpb;
	int		i, j, k;
	char	c, d;

   i = strlen(lps);
	if(i)
	{
		k = 0;
		d = 0;
		lpb = &buf[0];
		for( j = 0; j < i; j++ )
		{
			c = lps[j];
			if( c == 0x0d )
			{
				if( (j+1) < i )
				{
					if( lps[j+1] != 0x0a )
					{
						lpb[k++] = c;
						c = 0x0a;
					}
				}
				else
				{
					lpb[k++] = c;
					c = 0x0a;
				}
			}
			else if( c == 0x0a )
			{
				if( d != 0x0d )
				{
					lpb[k++] = 0x0d;
				}
			}
			lpb[k++] = c;
			d = c;
			if( k >= MXIO )
			{
				lpb[k] = 0;
				oi( lpb );
				k = 0;
			}
		}	// for length of string
		if( k )
		{
			if( ( gbCheckCrLf ) &&
				( d != 0x0a ) )
			{
				// add Cr/Lf pair
				lpb[k++] = 0x0d;
				lpb[k++] = 0x0a;
				lpb[k] = 0;
			}
			lpb[k] = 0;
			oi( lpb );
		}
	}
}

#ifdef   ADDSPRTF2

int   _cdecl sprtf( LPTSTR lpf, ... )
{
   static TCHAR _s_sprtfbuf[1024];
   LPTSTR   lpb = &_s_sprtfbuf[0];
   int   i;
   va_list arglist;
   va_start(arglist, lpf);
   i = vsprintf( lpb, lpf, arglist );
   va_end(arglist);
   prt(lpb);
   return i;
}


#endif   // ADDSPRTF2

/* =====================================================
    int sprt( char * ptr, ... )
   ===================================================== */
int _cdecl sprt( LPTSTR lpf, ... )
{
   static TCHAR _s_sprtfbuf[1024];
   LPTSTR      lpb = &_s_sprtfbuf[0];
   int         i;
   va_list     arg_ptr;

   va_start(arg_ptr, lpf);
   i = wvsprintf( lpb, lpf, arg_ptr );
   va_end(arg_ptr);

   if(i)
      oi(lpb);

   return i;
}

void	dout( LPSTR lps )
{
//	char	buf[MXIO + 4];
 static char _s_buf[MXIO + 4];
	char * buf = _s_buf; // [MXIO + 4];
	LPSTR	lpb;
	int		i, j, k;
	char	c, d;

	i = lstrlen( lps );
	if(i)
	{
		k = 0;
		d = 0;
		lpb = &buf[0];
		for( j = 0; j < i; j++ )
		{
			c = lps[j];
			if( c == 0x0d )
			{
				if( (j+1) < i )
				{
					if( lps[j+1] != 0x0a )
					{
						lpb[k++] = c;
						c = 0x0a;
					}
				}
				else
				{
					lpb[k++] = c;
					c = 0x0a;
				}
			}
			else if( c == 0x0a )
			{
				if( d != 0x0d )
				{
					lpb[k++] = 0x0d;
				}
			}
			lpb[k++] = c;
			d = c;
			if( k >= MXIO )
			{
				lpb[k] = 0;
				doi( lpb );
				k = 0;
			}
		}	// for length of string
		if( k )
		{
			if( bEnsureTail )
			{
				if( d != 0x0a )
				{
					lpb[k++] = 0x0d;
					lpb[k++] = 0x0a;
					lpb[k] = 0;
				}
			}
			lpb[k] = 0;
			doi( lpb );
		}
	}
}

#define		MXSTG		32

void	PutThous( LPSTR lpb,
				 int	len,
				 DWORD	size )
{
	int		i, j, k, l;
	char	szform[16];	// For FORM string
	char	sztmp[MXSTG+4];	// For initial results
	char	c;

	if( len )
	{
		if( len < MXSTG )
			i = len;
		else
			i = MXSTG;
	}
	else
	{
		i = 9;
	}
	wsprintf( &szform[0], "%%%uu", i );	// Get a format string
	wsprintf( &sztmp[0], &szform[0], size );	// and initial string

	i = lstrlen( &sztmp[0] ); 
	if(i)
	{
		lstrcpy( lpb, &sztmp[0] );	// Just COPY first
		k = 0;
		l = i - 1;
		for( j = l; j >= 0; j-- )
		{
			c = sztmp[j];
			if( c > ' ' )
			{
				if( k == 3 )
				{
					lpb[l--] = ',';
					k = 0;
					if( l < 0 )
						break;
				}
			}
			lpb[l--] = c;
			k++;
			if( l < 0 )
				break;
		}
	}
	else
	{
		wsprintf( lpb, "%u", size );
	}
}

LPSTR	ShortName( LPSTR lps, LPSTR lpd, int siz )
{
	int		i, i2, i3, k, j;

	k = 0;
	if( (siz > 10) &&
		((i = lstrlen( lps )) > (siz+3) ) )
	{
		i2 = (siz-1) / 2;
		i3 = i2 + (i - (i2 * 2));
		for( j = 0; j < i; j++ )
		{
			if( j < i2 )
			{
				lpd[k++] = lps[j];
			}
			else if( j == i2 )
			{
				lpd[k++] = '.';
				lpd[k++] = '.';
				lpd[k++] = '.';
			}
			else if( j > i3 )
			{
				lpd[k++] = lps[j];
			}
		}
		lpd[k] = 0;
	}
	else
	{
		lstrcpy( lpd, lps );
	}
	return	lpd;
}

// eof - GrmOut.c
