#!perl -w
# genboostlist.pl - generate boost file list
# 2009/11/16  - geoff mclane - http://geoffair.net/mperl/
my $dir = "boost";
my @filelist = ();
my %file_list = ();
my $out_file = 'tempboostlist.txt';
my $chk_file = 'boostlist.txt';
sub process_dir($);
sub prt($) { print shift; }
if ( ! -d $dir ) {
   prt("ERROR: Can NOT locate directory [$dir]! Aborting...\n");
   exit(1);
}
sub process_dir($) {
    my ($d) = shift;
    if (opendir(DIR, $d)) {
		my @fils = readdir(DIR);
        closedir DIR;
        foreach my $fil (@fils) {
            next if (($fil eq '.')||($fil eq '..'));
            my $ff = $d;
            $ff .= "\\" if !($ff =~ /(\\|\/)$/ );
            $ff .= $fil;
            if (-d $ff) {
                process_dir($ff);
            } else {
                my $lcff = lc($ff);
                push(@filelist,$ff);
                $lcff =~ s/\\/\//g;
                $file_list{$lcff} = [$ff,0];
            }
        }
   } else {
      prt("ERROR: Can not open directory [$d]!\n");
   }
}
sub out_file_list($$) {
    my ($rfl,$fil) = @_;
    my $cnt = scalar @{$rfl};
    if ($cnt == 0) {
        prt("ERROR: NO files to output!\n");
        return 1;
    }
    prt("Output $cnt files, to $fil...\n");
    if (open OUT, ">$fil") {
        foreach my $file (sort @{$rfl}) {
            print OUT "$file\n";
        }
        close OUT;
        prt("Written $cnt files, to $fil...\n");
    } else {
        prt("ERROR: Failed to create [$fil]!\n");
        return 1;
    }
    return 0;
}

sub cmp_boost_lists($$) {
    my ($rfl,$fil) = @_;
    my $cnt = scalar keys(%{$rfl});
    if ($cnt == 0) {
        # quietly forget it...
        return 1;
    }
    if (open INF, "<$fil") {
        my @lines = <INF>;
        close INF;
        my %h = ();
        my ($line,$lcf,$k1,$dups,$new,$old);
        foreach $line (@lines) {
            chomp $line;
            $lcf = lc($line);
            $lcf =~ s/\\/\//g;
            $h{$lcf} = [$line, 0];
        }
        # now compare the two HASHES
        $dups = 0;
        $new = 0;
        $old = 0;
        my @newfiles = ();
        my @oldfiles = ();
        foreach $k1 (keys %h) {
            if (defined ${$rfl}{$k1}) {
                ${$h{$k1}}[1] = 1;
                ${${$rfl}{$k1}}[1] = 1;
                $dups++;
            }
        }
        foreach $k1 (keys %h) {
            if (${$h{$k1}}[1] == 0) {
                $old++;
                push(@oldfiles, ${$h{$k1}}[0]);
            }
        }
        foreach $k1 (keys %{$rfl}) {
            if (${${$rfl}{$k1}}[1] == 0) {
                $new++;
                push(@newfiles,${${$rfl}{$k1}}[0]);
            }
        }
        prt("Of list $cnt file, $old are deleted, $new have been added\n");
        if ($old) {
            prt("The $old deleted are -\n");
            foreach $k1 (@oldfiles) {
                prt(" $k1\n");
            }
        }
        if ($new) {
            prt("The $new added are -\n");
            foreach $k1 (@newfiles) {
                prt(" $k1\n");
            }
        }
        prt("Above are $old deleted, and $new added, when compared with $fil...\n");
    } else {
        # quietly no compare
    }
}

process_dir($dir);
my $res = out_file_list(\@filelist,$out_file);
cmp_boost_lists(\%file_list,$chk_file) if ($res == 0);
exit($res);

# eof - genboostlist.pl
