
// jsName.cxx
// get and return the _FIRST_ active joystick name
// 05NOV2008 - geoff mclane - http://geoffair.net/fg/
//

// ensure NOT using UNICODE
#ifdef UNICODE
#undef UNICODE
#endif
#ifdef _UNICODE
#undef _UNICODE
#endif

#define STRICT    // why not ...
#define DIRECTINPUT_VERSION 0x0800  // set DirectX version
#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE    // disable depreciation warnings
#endif
#pragma warning( disable : 4996 )   // make sure to disable ALL deprecated warning 

#include <windows.h>
#include <dinput.h>
#include "js.h"

#if defined (UL_WIN32)

#pragma comment (lib, "dxguid.lib")    /* link DirectX IID_IDirectInput interface lib */
#pragma comment (lib, "dinput8.lib")   /* link DirectX DirectInput interface lib      */

#define JS_SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

// structure for collecting the information
typedef struct tagJSNAME {
   LPDIRECTINPUT8       pDI;
   LPDIRECTINPUTDEVICE8 pJoystick;
   char * pName;
   UINT  uiLen;
}JSNAME, * PJSNAME;

//-----------------------------------------------------------------------------
// Name: EnumJSCallback()
// Desc: Called once for each enumerated joystick. If one found, create a
//       device interface on it so we can get its name.
//-----------------------------------------------------------------------------
BOOL CALLBACK EnumJSCallback( const DIDEVICEINSTANCE* pdidInstance,
                                     VOID* pContext )
{
   HRESULT hr;
   PJSNAME pjsn = (PJSNAME)pContext;
   // UNREFERENCED_PARAMETER( pContext );
   if( pjsn && pjsn->pDI && pjsn->pName && pjsn->uiLen )
   {
      // Obtain an interface to the enumerated joystick.
      hr = pjsn->pDI->CreateDevice( pdidInstance->guidInstance, &pjsn->pJoystick, NULL );
      if( FAILED(hr) )
         return DIENUM_CONTINUE; // try for next

      //StringCchCopy( pjsn->pName,  pjsn->uiLen,  pdidInstance->tszProductName  );
      if( strlen(pdidInstance->tszProductName) < pjsn->uiLen )
         strcpy(pjsn->pName,pdidInstance->tszProductName);
      else
         strncpy(pjsn->pName, pdidInstance->tszProductName, pjsn->uiLen);

   }
   return DIENUM_STOP;  // stop on first
}

int getJSName( char * name, int len )
{
   if( !name || !len )
      return 0;

   JSNAME jsn;
   jsn.pName = name;
   jsn.uiLen = len;
   jsn.pDI   = NULL;
   jsn.pJoystick = NULL;

   // Register with the DirectInput subsystem and get a pointer
   // to a IDirectInput interface we can use.
   // Create a DInput object
   HRESULT hr;
   if( FAILED( hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION,
      IID_IDirectInput8, (VOID**)&jsn.pDI, NULL ) ) )
      return 0;

   // Look for a simple joystick we can use for this sample program.
   if( FAILED( hr = jsn.pDI->EnumDevices( DI8DEVCLASS_GAMECTRL,
      EnumJSCallback, &jsn, DIEDFL_ATTACHEDONLY ) ) )
   {
      JS_SAFE_RELEASE( jsn.pDI );
      return 0;
   }

   if( jsn.pJoystick )
      jsn.pJoystick->Unacquire();

   // Release any DirectInput objects.
   JS_SAFE_RELEASE( jsn.pJoystick );
   JS_SAFE_RELEASE( jsn.pDI );

   return 1;   // return SUCCESS
}

#endif // if defined (UL_WIN32)
// jsName.cxx
