@echo Update the RUNTIME, to a 'bin' folder ...
@echo This requires nmake.exe to be in the path ...
@REM User Variables - These MUST be adjusted to suit the OpenSceneGraph version used
@REM ===============================================================================
@set TEMPOSGV=34
@set TEMPPIV=2.3.9
@set TEMPOTV=10
@REM end user variables ============================================================
@REM ===============================================================================
@echo Using OSG V=%TEMPOSGV%, Plug-in=%TEMPPIV%, OpenThreads=%TEMPOTV% ...
@REM Test for certain items which MUST be built, and available ...
@set TEMPTEST=OpenSceneGraph\bin\osg%TEMPOSGV%-osg.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_ac.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_rgb.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_png.dll
@if NOT EXIST %TEMPTEST% goto NODLL2 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_zip.dll
@if NOT EXIST %TEMPTEST% goto NODLL2 
@set TEMPTEST=OpenSceneGraph\bin\ot%TEMPOTV%-openthreads.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMP1=update.mak
@if NOT EXIST %TEMP1% goto ERR1


@REM Give nmake a TEST run ...
@nmake /NOLOGO /N /F %TEMP1% RT=bin all > nul 2>&1
@if ERRORLEVEL 1 goto NOMAKE

@set TEMP1OR=updosgr.mak
@set TEMP1OD=updosgd.mak
@set TEMP1PR=updpinr.mak
@set TEMP1PD=updpind.mak
@set TEMP2=bin
@if "%2." == "." goto GOTRT
@set TEMP2=%2
:GOTRT
@if NOT EXIST %TEMP2%\. goto CHECK
:DNBIN
@echo Copy the RUNTIME components to folder %TEMP2%
@set TEMPDBG=RELEASE
@if "%1." == "." goto DORELONLY
@if "%1." == "D." goto DODEBUG
@if "%1." == "d." goto DODEBUG
@if "%1." == "Debug." goto DODEBUG
@if "%1." == "DEBUG." goto DODEBUG
@if "%1." == "debug." goto DODEBUG
@if "%1." == "R." goto DORELONLY
@if "%1." == "r." goto DORELONLY
@if "%1." == "Release." goto DORELONLY
@if "%1." == "RELEASE." goto DORELONLY
@if "%1." == "release." goto DORELONLY
@echo Only command allowed is 'D', to also update DEBUG versions ...
@echo or 'R', to update default RELEASE version ...
@goto END

:CHECK
@echo Folder [%TEMP2%] does NOT EXIST! ... Create a NEW folder? ... Ctrl+C to ABORT ...
@echo NOTE: THIS SHOULD NOT BE REQUIRED IF SETUPFG.BAT WAS RUN FIRST!!!
@pause
md %TEMP2%
@if ERRORLEVEL 1 goto RTERR
@if NOT EXIST %TEMP2%\nul goto RTERR
md %TEMP2%\OpenAL
@goto DNBIN

:RTERR
@echo ERROR: Can NOT create RUNTIME folder %TEMP2% ... check name, location, ...
@goto END

:DODEBUG
@set TEMPDBG=DEBUG
@set TEMPCMD=nmake /nologo /f %TEMP1% DBG=YES RT=%TEMP2%
@if NOT EXIST %TEMP1OR% goto NORMAK
@if NOT EXIST %TEMP1PR% goto NORMAK
@if NOT EXIST %TEMP1OD% goto NODMAK
@if NOT EXIST %TEMP1PD% goto NODMAK
@goto DOIT

:DORELONLY
@set TEMPCMD=nmake /nologo /f %TEMP1% RT=%TEMP2%
@if NOT EXIST %TEMP1OR% goto NORMAK
@if NOT EXIST %TEMP1PR% goto NORMAK
@goto DOIT

:DOIT
@echo Configuration selected: TEMPDBG=%TEMPDBG%
@echo Will run command [%TEMPCMD%] ... Ctrl+C to ABORT ...
@echo Any other key to continue ...
@pause
@if "%TEMPDBG%." == "RELEASE." goto COPYREL
nmake /nologo /f %TEMP1OD% all
nmake /nologo /f %TEMP1PD% all
:COPYREL
nmake /nologo /f %TEMP1OR% all
nmake /nologo /f %TEMP1PR% all
%TEMPCMD%
@goto END

:Err1
@echo CRITICAL ERROR: Can not locate [%TEMP1%] file ... check name, location ...
@goto END

:NORMAK
@echo CRITICAL ERROR: Can NOT locate %TEMPOR% or %TEMPPR% makefiles - check names, location ...
@goto END

:NODMAK
@echo CRITICAL ERROR: Can NOT locate %TEMPOD% or %TEMPPD% makefiles - check names, location ...
@goto END

:NODLL2
@echo --------------------------------------------------------------------------------
@echo NOTE: This component requires SPECIAL setup in CMake to ensure it is built!
@echo Carefully check, and re-configure CMake on the OpenSceneGraph folder, and
@echo run MSVC again when done. Hint: [x] Show Advanced Options MUST be checked!!!
@goto NODLL1

:NODLL1
@echo --------------------------------------------------------------------------------
@echo ERROR: Unable to locate [%TEMPTEST%] ...
@echo Check name, location, version ...
@echo --------------------------------------------------------------------------------
@goto FAILED

:FAILED
@echo ERROR: Failed to find an item, so can only abort ...
@echo --------------------------------------------------------------------------------
@echo This could a problem with the current settings of TEMPOSGV, TEMPPIV, or TEMPOTV ...
@echo Presently using OSG V=%TEMPOSGV%, Plug-in=%TEMPPIV%, OpenThreads=%TEMPOTV% ...
@echo Check and adjust in this UPD.BAT batch file ...
@goto END

:NOMAKE
@echo --------------------------------------------------------------------------------
@echo ERROR: Encountered an error running 'nmake' ... where is nmake.exe ???
@echo Perhaps this is not the special MSVC command prompt, which first
@echo runs vcvars32.bat to establish some variables, and paths ...
@echo In MSVC, try Tools - Visual Studio 200? Command Prompt ???
@if "%DevEnvDir%." == "." goto NODEV1
@if "%VCINSTALLDIR%." == "." goto NODEV2
@goto DNDEV
:NODEV1
@echo --------------------------------------------------------------------------------
@echo This seems confirmed by the fact that DevEnvDir is missing ...
@goto DODEV
:NODEV2
@echo --------------------------------------------------------------------------------
@echo This seems confirmed by the fact that VCINSTALLDIR is missing ...
@goto DODEV
:DODEV
@echo Open the special MSVC command prompt, and try again ...
:DNDEV
@echo --------------------------------------------------------------------------------
@echo CRITICAL ERROR: Must have 'nmake' available to continue ...
@goto END


:END
