// win_map.c

#include "gshhs_win.h"


size_t mapfread( void * buf, size_t sz1, size_t sz2, void * pv)
{
   size_t iret = 0;  // set NO READ
   if( buf && pv ) {
      PMAPVW pmv = (PMAPVW)pv;
      size_t size = sz1 * sz2;
      if( size ) {
         uint64_t off = pmv->off.QuadPart + size;
         if( off <= pmv->ul.QuadPart )
         {  // we are doing it
            PBYTE pb = (PBYTE)pmv->pVoid;
            if(pb) {
               PBYTE src = &pb[pmv->off.QuadPart];
               memcpy(buf, src, size);
               pmv->off.QuadPart += size;
               iret = (int)sz2;
            }
         }
      }
   }
   return iret;
}

int64_t mapseek( void * pv, int64_t off, int pos)
{
   int64_t iret = -1;   // set FAILED
   if(pv) {
      PMAPVW pmv = (PMAPVW)pv;
      if( pos == SEEK_END ) {
         pmv->off.QuadPart = pmv->ul.QuadPart;
         iret = pmv->off.QuadPart;
      } else if( pos == SEEK_CUR ) {
         if(( pmv->off.QuadPart + off ) <= pmv->ul.QuadPart )
         {  // we are doing it
            pmv->off.QuadPart += off;
            iret = pmv->off.QuadPart;
         }
      } else if( pos == SEEK_SET ) {
         if( off <= (int64_t)pmv->ul.QuadPart )
         {  // we are doing it
            pmv->off.QuadPart = off;
            iret = pmv->off.QuadPart;
         }
      }
   }
   return iret;
}

void Close_Map_File_WIN32( PMAPVW pmv )
{
   if( pmv->pVoid )
      UnmapViewOfFile(pmv->pVoid);
   pmv->pVoid = NULL;
   if( pmv->hMap )
      CloseHandle( pmv->hMap );
   pmv->hMap = 0;
   if( VFH(pmv->h) )
      CloseHandle(pmv->h);
   pmv->h = NULL;
}

BOOL Map_File_WIN32( char * fn, PMAPVW pmv )
{
   ZeroMemory( pmv, sizeof(MAPVW) );
   strcpy_s( pmv->fn, MAX_PATH, fn );
   pmv->h = CreateFile( fn,		// pointer to name of the file
			GENERIC_READ | GENERIC_WRITE,	// access (read-write) mode
			0,		// share mode
			NULL,	// pointer to security attributes
			OPEN_EXISTING,	// how to create
			FILE_ATTRIBUTE_NORMAL,	// file attributes
			NULL );	// handle to file with attributes to copy
   if( VFH(pmv->h) ) {
      pmv->ul.LowPart = GetFileSize( pmv->h, &pmv->ul.HighPart );
      pmv->hMap = CreateFileMapping( pmv->h,  // handle to file
         NULL, // optional security attributes
         g_flProtext,   // protection for mapping object
         0,          // high-order 32 bits of object size
         0,          // low-order 32 bits of object size
         NULL );       // name of file-mapping object
      if( pmv->hMap ) {
         pmv->pVoid = MapViewOfFile( pmv->hMap, // file-mapping object to map
            g_ReqAccess,   // access mode
            0,    // high-order 32 bits of file offset
            0,    // low-order 32 bits of file offset
            0 );  // number of bytes to map
         if( pmv->pVoid ) {
            // got FILE mapped into memory
            pmv->mread = mapfread;
            pmv->mseek = mapseek;
            return TRUE;
         } else {
            CloseHandle(pmv->hMap);
            pmv->hMap = 0;
            CloseHandle(pmv->h);
            pmv->h = 0;
         }
      } else {
        CloseHandle(pmv->h);
        pmv->h = 0;
      }
   }
   return FALSE;
}

// eof - win_map.c
