// win_bmp.h
#ifndef _win_bmp_H_
#define _win_bmp_H_
#include "gshhs_info.h" // for PGSINFO

#define WIDTHBYTES(bits) ((((bits) + 31) / 32) * 4)
#define DIB_HEADER_MARKER   ((WORD) ('M' << 8) | 'B')	/* Simple "BM" ... */
#define SGD_180   180.0
#ifndef M_PI
#define SGD_PI 3.14159265358979323846   /* From M_PI under Linux/X86 */
#else
#define SGD_PI M_PI
#endif
#define SGD_DEGREES_TO_RADIANS  (SGD_PI/SGD_180)
#define SGD_RADIANS_TO_DEGREES  (SGD_180/SGD_PI)

// set a 16 color SCALE
#define  WHITE_IND      0
#define  RED_IND        1
#define  BLUE_IND       2
#define  GREEN_IND      3
#define  BROWN_IND      4
#define  GRAY_IND       9
#define  BLACK_IND      15

// BMP color bytes
#define  BMC_WHITE   0
#define  BMC_BLACK   1
#define  BMC_GRAY    2
#define  BMC_RED     3
#define  BMC_BLUE    4
#define  BMC_GREEN   5
#define  BMC_BROWN   6

#define g_AddBorder  pgsi->bmpinfo.addborder
#define g_AddGrid    pgsi->bmpinfo.addgrid   // Add_Lat_Lon_Lines( pgsi )
#define g_bUseMercator pgsi->bmpinfo.mercator

extern void SetMonochromeMap( RGBQUAD * prq );
extern void SetBPP4Map( RGBQUAD * prq );
extern void SetBPP8Map( RGBQUAD * prq );

extern void InitBitmapInfoHeader( LPBITMAPINFOHEADER pih, DWORD dwWid, DWORD dwHt, int nBPP );
extern size_t GetPaletteSize( int nBPP );
extern DWORD GetRowWidth( DWORD dw, DWORD nBPP );

// write generic BITMAP (always)
extern int Write_lon_lat( char * pfile, PGSINFO pgsi );
extern void Clear_lon_lat( PGSINFO pgsi );
extern void Add_lon_lat( double lastlon, double lastlat, PGSINFO pgsi );

#endif // _win_bmp_H_
// eof win_bmp.h

