// sprtf.c
#include "gshhs_win.h"

#define  MXIO     256
#define  VFP(a)   ( a && ( a != (FILE *)-1 ))

char def_log[] = "tempgshhs.txt";
char logfile[256] = "\0";
FILE * outfile = NULL;
int log_closed = 0;
int add_std_out = 1;

int open_log_file( void )
{
   if (logfile[0] == 0)
      strcpy(logfile,def_log);
   outfile = fopen(logfile, "wb");
   if( outfile == 0 ) {
      outfile = (FILE *)-1;
      printf("WARNING: Failed to open log file [%s] ...\n", logfile);
      return 0;   /* failed */
   }
   return 1; /* success */
}

static void oi( char * ps )
{
   int len = (int)strlen(ps);
   if(len) {
      if( outfile == 0 )
         open_log_file();
      if( VFP(outfile) ) {
         int w = (int)fwrite( ps, 1, len, outfile );
         if( w != len ) {
            fclose(outfile);
            outfile = (FILE *)-1;
            printf("WARNING: Failed write to log file [%s] ...\n", logfile);
         } else {
            fflush(outfile);  // ensure WRITTEN to file
         }
      }
      if( add_std_out )
         fwrite( ps, 1, len, stdout );
   }
}

static void	prt( char * ps )
{
   static char buf[MXIO + 4];
	char * pb = buf;
	size_t i, j, k;
	char   c, d;
   i = strlen(ps);
	if(i) {
		k = 0;
		d = 0;
		for( j = 0; j < i; j++ )
		{
			c = ps[j];
			if( c == 0x0d ) {
				if( (j+1) < i ) {
					if( ps[j+1] != 0x0a ) {
						pb[k++] = c;
						c = 0x0a;
					}
            } else {
					pb[k++] = c;
					c = 0x0a;
				}
			} else if( c == 0x0a ) {
				if( d != 0x0d ) {
					pb[k++] = 0x0d;
				}
			}
			pb[k++] = c;
			d = c;
			if( k >= MXIO ) {
				pb[k] = 0;
				oi( pb );
				k = 0;
			}
		}	// for length of string
		if( k ) {
			//if( ( gbCheckCrLf ) &&
			//	( d != 0x0a ) ) {
				// add Cr/Lf pair
				//pb[k++] = 0x0d;
				//pb[k++] = 0x0a;
				//pb[k] = 0;
			//}
			pb[k] = 0;
			oi( pb );
		}
	}
}

int _cdecl sprtf( PTSTR lpf, ... )
{
   static TCHAR _s_sprtfbuf[1024];
   LPTSTR   lpb = &_s_sprtfbuf[0];
   int   i = 0;
   va_list arglist;
   if( !log_closed ) {
      va_start(arglist, lpf);
      i = vsprintf( lpb, lpf, arglist );
      va_end(arglist);
      prt(lpb);
   }
   return i;
}

// eof - sprtf.c
