// gshhs_win.h
#ifndef _gshhs_win_H_
#define _gshhs_win_H_

// Special attempt using windows file mapping
#include "gshhs_vers.h" // version file

#include <windows.h>
#include <stdio.h>   // for printf()
#include <io.h>      // for _lseek()
#include <math.h>    // for fabs()
#include <time.h>    // for time()

#define VFH(a)          ( a && ( a != INVALID_HANDLE_VALUE ) )
#define MEOR            "\r\n"
#define g_flProtext     PAGE_READONLY
#define g_ReqAccess     FILE_MAP_READ
#define swapi4(i4) (((i4) >> 24) + (((i4) >> 8) & 65280) + (((i4) & 65280) << 8) + (((i4) & 255) << 24))
#define swapi2(i2) (((i2) >> 8) + (((i2) & 255) << 8))
#define GSHHS_SCALE	1.0e-6	/* Convert micro-degrees to degrees */
typedef __int64 int64_t;
typedef unsigned __int64  uint64_t;

#include "gshhs_1.9\gshhs.h"  // version 1.9 stucture ...
#include "win_bmp.h"
#include "win_map.h"
#include "gshhs_main.h"
#include "gshhs_info.h"
#include "gshhs_data.h"
#include "gshhs_math.h"
#include "gshhs_bmp.h"
#include "gshhs_list.h"    // double linked list macros
#include "gshhs_color.h"   // group the BMP COLOR OPTIONS
#include "gshhs_utils.h"   // some utility functions
#include "sprtf.h"

#define  MALLOC(a)   malloc(a)
#define  MFREE(a)    free(a)

#ifndef  EndBuf
#define  EndBuf(a)   ( a + strlen(a) )
#endif

#undef NO_SWAP

// Lat/Long is just in DEGREES (from BglView2)
// Lat -90(S) to 90(N) Long -180(W) to 180(E)
// ==========================================
// FIX980523 - Add ID, height(alitude), and time
typedef struct tagLLD {
	double	ll_Lat;  // objects latitude
	double	ll_Long; // longitude, and
   double   ll_Height;  // end of the 3 earth equations
}LLD, * PLLD;

// from SimGear\simgear\constants.h
#define SG_EPSILON 0.0000001
#define OUT_OF_RANGE    1000.0

typedef struct tagGSHHS_13 {	/* Global Self-consistent Hierarchical High-resolution Shorelines */
	int id;				/* Unique polygon id number, starting at 0 */
	int n;				/* Number of points in this polygon */
	int level;			/* 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake */
	int west, east, south, north;	/* min/max extent in micro-degrees */
	int area;			/* Area of polygon in 1/10 km^2 */
	int version;			/* Version of GSHHS polygon (3 is latest and first with this item) */
	short int greenwich;		/* Greenwich is 1 if Greenwich is crossed */
	short int source;		/* 0 = CIA WDBII, 1 = WVS */
} GSHHS_13, * PGSHHS_13;

typedef struct tagGSHHS_19 {	/* Global Self-consistent Hierarchical High-resolution Shorelines */
	int id;				/* Unique polygon id number, starting at 0 */
	int n;				/* Number of points in this polygon */
	int flag;			/* = level + version << 8 + greenwich << 16 + source << 24 */
	/* flag contains 4 items, one in each byte, as follows:
	 * low byte:	level = flag & 255: Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
	 * 2nd byte:	version = (flag >> 8) & 255: Values: Should be 4 for GSHHS version 1.4
	 * 3rd byte:	greenwich = (flag >> 16) & 255: Values: Greenwich is 1 if Greenwich is crossed
	 * 4th byte:	source = (flag >> 24) & 255: Values: 0 = CIA WDBII, 1 = WVS
	 */
	int west, east, south, north;	/* min/max extent in micro-degrees */
	int area;			/* Area of polygon in 1/10 km^2 */
}GSHHS_19, * PGSHHS_19;

typedef struct	tagGSPOINT {	/* Each lon, lat pair is stored in micro-degrees in 4-byte integer format */
	int	x;
	int	y;
}GSPOINT, * PGSPOINT;

typedef struct tagGBOUNDS {
   double e, n, s, w;
   double area;   // km^2
}GBOUNDS, * PGBOUNDS;

extern int Process_GSHHS(PGSINFO pgsi);
extern BOOL Integrity_Check(PGSINFO pgsi);


#endif // _gshhs_win_H_
// eof - gshhs_win.h
