// gshhs_win_c

#include "gshhs_win.h"

//int main_19_WIN32 (PGSINFO pgsi)
int Process_GSHHS (PGSINFO pgsi)
{
	double w, e, s, n, area, lon, lat;
	char source, kind[2] = {'P', 'L'}, *name[2] = {"polygon", "line"};
	int	k, line, info, n_read, flip, level, version, greenwich, src;
	GPOINT p;
	struct GSHHS h;
   char * fn = &pgsi->mv.fn[0];
   BOOL  bmp = (pgsi->bmpinfo.bmpname[0] ? TRUE : FALSE);  // write BITMAP

	info = pgsi->info;

   if( VERB1(pgsi) ) {
      sprtf( "Processing [%s] file, %I64u bytes ...\n", fn, pgsi->mv.ul );
   }
   n_read = (int)pgsi->mv.mread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, &pgsi->mv);
	version = (h.flag >> 8) & 255;
	flip = (version != GSHHS_DATA_VERSION);	/* Take as sign that byte-swabbing is needed */
	
	while (n_read == 1) {
		if (flip) {
			h.id = swabi4 ((unsigned int)h.id);
			h.n  = swabi4 ((unsigned int)h.n);
			h.west  = swabi4 ((unsigned int)h.west);
			h.east  = swabi4 ((unsigned int)h.east);
			h.south = swabi4 ((unsigned int)h.south);
			h.north = swabi4 ((unsigned int)h.north);
			h.area  = swabi4 ((unsigned int)h.area);
			h.flag  = swabi4 ((unsigned int)h.flag);
		}
		level = h.flag & 255;
		version = (h.flag >> 8) & 255;
		greenwich = (h.flag >> 16) & 255;
		src = (h.flag >> 24) & 255;
		w = h.west  * GSHHS_SCL;	/* Convert from microdegrees to degrees */
		e = h.east  * GSHHS_SCL;
		s = h.south * GSHHS_SCL;
		n = h.north * GSHHS_SCL;
      if( w > 180.0 )
         w -= 360.0;
      if( e > 180.0 )
         e -= 360.0;
      Add_2_GSLimits( n, s, e, w, pgsi );
		source = (src == 1) ? 'W' : 'C';	/* Either WVS or CIA (WDBII) pedigree */
		line = (h.area) ? 0 : 1;		/* Either Polygon (0) or Line (1) (if no area) */
		area = 0.1 * h.area;			/* Now im km^2 */

      if( VERB2(pgsi) ) {
   		sprtf ("%c %6d%8d%2d%2c%13.3f%10.5f%10.5f%10.5f%10.5f %d\n", kind[line], h.id, h.n, level, source, area, w, e, s, n, greenwich);
      }
		//if (info) {	/* Skip data, only want headers */
		//	//fseek (fp, (long)(h.n * sizeof(struct POINT)), SEEK_CUR);
		//	pgsi->mv.mseek (&pgsi->mv, (long)(h.n * sizeof(struct POINT)), SEEK_CUR);
		//}
		//else {
			for (k = 0; k < h.n; k++) {
            if (pgsi->mv.mread ((void *)&p, (size_t)sizeof(GPOINT), (size_t)1, &pgsi->mv) != 1) {
            //if(( off.QuadPart + sizeof(struct POINT) ) > mv.ul.QuadPart ) {
               sprtf ( "ERROR: Reading file %s for %s %d, point %d.\n", fn, name[line], h.id, k);
               return EXIT_FAILURE;
				}
				if (flip) {
					p.x = swabi4 ((unsigned int)p.x);
					p.y = swabi4 ((unsigned int)p.y);
				}
				lon = p.x * GSHHS_SCL;
				if (lon > 180.0)
               lon -= 360.0;
				lat = p.y * GSHHS_SCL;
            if( !info && VERB2(pgsi) ) {
               sprtf ("%10.5f%10.5f\n", lon, lat);
            }
            Add_2_GSINFO( lat, lon, pgsi );
            Add_lon_lat( lon, lat, pgsi );
            if(bmp) Add_2_User_BMP( pgsi, lat, lon, h.id );
			}
		//}
		//n_read = (int)fread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, fp);
		n_read = (int)pgsi->mv.mread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, &pgsi->mv);
	}
	//fclose (fp);
	return EXIT_SUCCESS;
}

BOOL Integrity_Check(PGSINFO pgsi2)
{
	int	n_read, flip, version;
	struct GSHHS h;
   int64_t  orig;
   char * fn = &pgsi2->mv.fn[0];
   PMAPVW pmv = &pgsi2->mv;
   PBMPINFO pbmi = &pgsi2->bmpinfo;
   if( VERB1(pgsi2) ) {
      sprtf( "Checking [%s] file integrity, %I64u bytes ...\n", fn, pmv->ul );
   }
   orig = pmv->mseek( pmv, 0, SEEK_CUR );
   if( orig == -1 )
      return FALSE;
   if( pmv->mseek( pmv, 0, SEEK_SET ) == -1 )
      return FALSE;
   n_read = (int)pmv->mread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, pmv);
   if( n_read != 1 ) {
      pmv->mseek( pmv, orig, SEEK_SET );
      return FALSE;
   }
	version = (h.flag >> 8) & 255;
	flip = (version != GSHHS_DATA_VERSION);	/* Take as sign that byte-swabbing is needed */
   // start counters
   pgsi2->hdrcnt = 0;
   pgsi2->ptcnt  = 0;
	while (n_read == 1) {
		if (flip) {
			//h.id = swabi4 ((unsigned int)h.id);
			h.n  = swabi4 ((unsigned int)h.n);
		}
      pgsi2->hdrcnt++;
      pgsi2->ptcnt += h.n;
      if( pmv->mseek (pmv, (long)(h.n * sizeof(GPOINT)), SEEK_CUR) == -1 ) {
         pmv->mseek( pmv, orig, SEEK_SET );
         return FALSE;
      }
		n_read = (int)pmv->mread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, pmv);
	}
   pmv->mseek( pmv, orig, SEEK_SET );
	return TRUE;
}

// eof - gshhs_win.c
