// gshhs_utils.cxx

#include "gshhs_win.h"

// File/String List structure and lists

LE sFileList = { &sFileList, &sFileList };
LE sDoneFiles = { &sDoneFiles, &sDoneFiles };

PLE Get_File_List( void )
{
   return &sFileList;
}

PLE Get_Done_List( void )
{
   return &sDoneFiles;
}


void Kill_Lists( void )
{
   PLE ph;
   
   ph = Get_File_List();
   KillLList(ph);
   ph = Get_Done_List();
   KillLList(ph);
}

PFILLST Add_2_List( PLE ph, PTSTR pfile )
{
   size_t len = strlen(pfile);
   size_t size = sizeof(FILLST) + len;
   PFILLST pfl = (PFILLST)MALLOC(size);
   CHKMEM(pfl,size);
   strcpy( pfl->name, pfile );
   InsertTailList( ph, (PLE)pfl );
   return pfl;
}

PFILLST Add_2_File_List( PTSTR pfile )
{
   PLE ph = Get_File_List();
   return Add_2_List( ph, pfile );
}

PFILLST Add_2_Done_List( PTSTR pfile )
{
   PLE ph = Get_Done_List();
   return Add_2_List( ph, pfile );
}

int Get_File_List_Count( void )
{
   int cnt = 0;
   PLE ph = Get_File_List();
   ListCount2(ph,&cnt);
   return cnt;
}

int Get_Done_List_Count( void )
{
   int cnt = 0;
   PLE ph = Get_Done_List();
   ListCount2(ph,&cnt);
   return cnt;
}

PFILLST Get_List_Ptr( PLE ph, int item )
{
   PLE pn;
   if(item) {
      int   cnt = 0;
      PFILLST pfl;
      Traverse_List( ph, pn )
      {
         cnt++;
         pfl = (PFILLST)pn;
         if( cnt == item )
            return pfl;
      }
   }
   return NULL;
}



PFILLST Get_File_List_Ptr( int item )
{
   PLE ph = Get_File_List();
   return Get_List_Ptr( ph, item );
}

PFILLST Get_Done_List_Ptr( int item )
{
   PLE ph = Get_Done_List();
   return Get_List_Ptr( ph, item );
}

PTSTR Get_File_List_File_Ptr( int item )
{
   PFILLST pfl = Get_File_List_Ptr( item );
   if( pfl )
      return &pfl->name[0];

   return NULL;
}

PTSTR Get_Done_List_File_Ptr( int item )
{
   PFILLST pfl = Get_Done_List_Ptr( item );
   if( pfl )
      return &pfl->name[0];

   return NULL;
}



int trim_num_IB( PTSTR ptmp )
{
   size_t len = strlen(ptmp);
   size_t i;
   while( len && ptmp[0] )
   {
      if(ptmp[0] > ' ')
         break;
      len--;
      for(i = 0; i < len; i++) {
         ptmp[i] = ptmp[i+1];
      }
   }
   while( len && ptmp[0] )
   {
      if( ptmp[len-1] == '0' ) {
         if((len > 1) && (ptmp[len-2] == '.') )
            break;
         len--;
         ptmp[len] = 0;
      } else {
         break;
      }
   }
   return (int)len;
}

#define  MM_BUFF  264
#define  MM_BUFFS 64
static int _next_buffer = 0;

PTSTR GetNxtBuf( void )
{
   static TCHAR _s_tmpbuffs[MM_BUFFS][MM_BUFF];
   _next_buffer++;
   if(_next_buffer >= MM_BUFFS)
      _next_buffer = 0;
   return &_s_tmpbuffs[_next_buffer][0];
}
