// gshhs_scraps.c

#include "gshhs_win.h"


#ifdef NO_SWAP
#define  SWAP(a)
#define  SWAP2(a)
#else
#define  SWAP(a)  a = swapi4(a)
#define  SWAP2(a)  a = swapi2(a)
#endif

GBOUNDS  GBounds;
BOOL bShowAll = FALSE;  // to SHOW all the POINTS
BOOL bShowInLine = TRUE;
BOOL bAssumPoly4 = TRUE;   // ASSUME each Polygon has MIN of 4 POINTS
char chTmpBuf[1024];

void Show_Entry( PGSHHS_13 h, char * msg )
{
   double w,e,s,n,area;
   int   line;
   char * src;
   short greenwich, source;
   PGBOUNDS pgb = &GBounds;

	w = h->west  * GSHHS_SCALE;	/* Convert from microdegrees to degrees */
	e = h->east  * GSHHS_SCALE;
	s = h->south * GSHHS_SCALE;
	n = h->north * GSHHS_SCALE;
   pgb->w = w;
   pgb->e = e;
   pgb->s = s;
   pgb->n = n;
   
   greenwich = h->greenwich;
   source = h->source;
	area = 0.1 * h->area;			/* Now im km^2 */
   pgb->area = area;
   line = (h->area) ? 0 : 1;		/* Either Polygon (0) or Line (1) (if no area) */
   printf ("id    : %6d (%s)\n", h->id, msg );
   printf ("num   : %8d\n", h->n );
	//	source = (src == 1) ? 'W' : 'C';	/* Either WVS or CIA (WDBII) pedigree */
   src = ((h->source == 1) ? "WVS" : "CIA (WDBII)");
   if(line) {
      printf( "Line ... source=%s\n", src);
   } else {
      printf ("area  : %13.3f km^2 (polygon source=%s)\n", area, src);
   }
   printf ("w     : %10.5f\n", w );
   printf ("e     : %10.5f\n", e );
   printf ("s     : %10.5f\n", s );
   printf ("n     : %10.5f\n", n );
   printf (" gren=%d, src=%d - ", greenwich, source );
   if( h->greenwich )
      printf( "Greenwich crossed!\n" );
   else
      printf( "Greenwich not crossed.\n" );
}

void Show_Entry_19( PGSHHS_19 h, char * msg )
{
   double w,e,s,n,area;
   int   line, flag, level, version;
   char * src;
   short greenwich, source;
   PGBOUNDS pgb = &GBounds;

	w = h->west  * GSHHS_SCALE;	/* Convert from microdegrees to degrees */
	e = h->east  * GSHHS_SCALE;
	s = h->south * GSHHS_SCALE;
	n = h->north * GSHHS_SCALE;
   pgb->w = w;
   pgb->e = e;
   pgb->s = s;
   pgb->n = n;

   flag = h->flag;
   level = flag & 255; // Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
   version = (flag >> 8) & 255; // Values: Should be 4 for GSHHS version 1.4
   greenwich = (flag >> 16) & 255; // Values: Greenwich is 1 if Greenwich is crossed
   source = (flag >> 24) & 255; // Values: 0 = CIA WDBII, 1 = WVS

	area = 0.1 * h->area;			/* Now im km^2 */
   pgb->area = area;
   line = (h->area) ? 0 : 1;		/* Either Polygon (0) or Line (1) (if no area) */
   printf ("id    : %6d (%s)\n", h->id, msg );

   if( h->n < 0 )
      printf ("num   : %8d  (NEG NUMBER)\n", h->n );
   else
      printf ("num   : %8d\n", h->n );

	//	source = (src == 1) ? 'W' : 'C';	/* Either WVS or CIA (WDBII) pedigree */
   src = ((source == 1) ? "WVS" : "CIA (WDBII)");
   if(line) {
      printf( "Line ... source=%s\n", src);
   } else {
      printf ("area  : %13.3f km^2 (polygon source=%s)\n", area, src);
   }
   if( bShowInLine ) {
      printf ("w     : %10.5f, ", w );
      printf ("e     : %10.5f, ", e );
      printf ("s     : %10.5f, ", s );
      printf ("n     : %10.5f\n", n );
   } else {
      printf ("w     : %10.5f\n", w );
      printf ("e     : %10.5f\n", e );
      printf ("s     : %10.5f\n", s );
      printf ("n     : %10.5f\n", n );
   }

   printf ("gren=%d, src=%d - ", greenwich, source  );
   if( greenwich )
      printf( "Greenwich crossed!\n" );
   else
      printf( "Greenwich not crossed.\n" );

}

void Add_Header_19( PGSHHS_19 h, PGSINFO pgsi )
{
   if( pgsi ) {
      double w,e,s,n;
	   w = h->west  * GSHHS_SCALE;	/* Convert from microdegrees to degrees */
	   e = h->east  * GSHHS_SCALE;
	   s = h->south * GSHHS_SCALE;
	   n = h->north * GSHHS_SCALE;
      Add_2_GSLimits( n, s, e, w, pgsi );
   }
}

void Get_lon_lat( PGSPOINT pgs2, short greenwich, double max_east,
                 double * plon, double * plat )
{
   double lon, lat;
	lon = pgs2->x * GSHHS_SCALE;
	if (greenwich && (pgs2->x > max_east))
      lon -= 360.0;
	lat = pgs2->y * GSHHS_SCALE;
   *plon = lon;
   *plat = lat;
}


void Show_Point( PGSPOINT pgs2, short greenwich, double max_east, int ptcnt, int cnt,
                char * msg)
{
   double lon, lat;
   Get_lon_lat( pgs2, greenwich, max_east, &lon, &lat );
	printf (" lon %10.5f, lat %10.5f (%u of %d) %s\n", lon, lat, ptcnt, cnt, msg);
}

void Process_Buffer( PBYTE pb, ULARGE_INTEGER sz, char * fn )
{
   ULARGE_INTEGER ui, ul;
   GSHHS_13    gs;
   PGSHHS_13   pg1, pg2;
   int      id = 0;
   short gren, src, greenwich, source;
   GSPOINT  pt;
   PGSPOINT pgs1, pgs2;
   int   ptcnt = 0;
   int   cnt;
   double area;
   double max_east = 270000000;
   double lon, lat;

   pg2 = &gs;
   pgs2 = &pt;
   ul.QuadPart = sz.QuadPart - sizeof(GSPOINT); // subtract ONE point
   pg1   = (PGSHHS_13) &pb[0];
   pgs1  = (PGSPOINT)  &pb[0];
   *pg2  = *pg1;   // copy the structure out of the buffer
   *pgs2 = *pgs1; // and as if it was a POINT also
   // do the bigendian SWAPPING
   SWAP(pg2->id);    // unique ID, starting at ZERO(0)
   SWAP(pg2->area);
   SWAP(pg2->n);     // number of POINTS
   SWAP(pg2->west);
   SWAP(pg2->east);
   SWAP(pg2->south);
   SWAP(pg2->north);
   SWAP2(pg2->greenwich);	/* Greenwich is 1 if Greenwich is crossed */
   SWAP2(pg2->source);	/* 0 = CIA WDBII, 1 = WVS */
   // extract som items
   gren = pg2->greenwich;
   src = pg2->source;
	area = 0.1 * pg2->area;			/* Now im km^2 */
   greenwich = 0;
   source = 0;
   if(( pg2->id == id ) &&
      ( area >= 0.0 ) &&
      ((gren == 0)||(gren == 1)) &&
      ((src == 0) ||(src == 1)) ) {
         Show_Entry( pg2, "First Entry is ok" );
         greenwich = pg2->greenwich;
         source = pg2->source;
         cnt = pg2->n;
         ptcnt = 0;
         id++;
   } else {
      printf( "ERROR: First record FAILED test!\n" );
      Show_Entry( pg2, "First Entry FAILED!" );
      return;
   }

   for( ui.QuadPart = sizeof(GSHHS_13); ui.QuadPart < ul.QuadPart; ui.QuadPart++ )
   {
      BYTE b = pb[ui.QuadPart];
      pg1   = (PGSHHS_13) &pb[ui.QuadPart];
      pgs1  = (PGSPOINT) &pb[ui.QuadPart];
      *pg2  = *pg1;   // copy the structure out of the buffer
      *pgs2 = *pgs1; // and as if it was a POINT also
      // do the bigendian SWAPPING
      SWAP(pg2->id);    // unique ID, starting at ZERO(0)
      SWAP(pg2->area);
      SWAP(pg2->n);     // number of POINTS
      SWAP(pg2->west);
      SWAP(pg2->east);
      SWAP(pg2->south);
      SWAP(pg2->north);
      SWAP2(pg2->greenwich);	/* Greenwich is 1 if Greenwich is crossed */
      SWAP2(pg2->source);	/* 0 = CIA WDBII, 1 = WVS */
      // extract some items
      gren = pg2->greenwich;
      src = pg2->source;
   	area = 0.1 * pg2->area;			/* Now im km^2 */
      SWAP(pgs2->x);
      SWAP(pgs2->y);
      Get_lon_lat( pgs2, gren, max_east, &lon, &lat );
      //if(( pg2->id == id ) &&
      //   ((gren == 0)||(gren == 1)) &&
      //   ((src == 0)||(src == 1)) ) {
      //if( area >= 0.0 &&
      //   ((gren == 0)||(gren == 1)) &&
      //   ((src == 0) ||(src == 1)) ) {
      if(( area >= 0.0 ) &&
         ((gren == 0)||(gren == 1)) &&
         ((src == 0) ||(src == 1) ) ) {
            // good chance it is a HEADER
            if( pg2->id == id ) {
               Show_Entry( pg2,
                  ((src == source) ? "ok" : "ok (CHECKSOURCE)") );
            } else {
               Show_Point( pgs2, gren, max_east, (ptcnt+1), cnt, "CHECKNEXT" );
               Show_Entry( pg2,
                  ((src == source) ? "CHECKME" : "CHECKME (and CHECKSOURCE!)") );
            }
            id++;
            ui.QuadPart += (sizeof(GSHHS_13) - 1);
            cnt = pg2->n;
            ptcnt = 0;
         if( id > 1 )
            max_east = 180000000;	/* Only Eurasiafrica needs 270????? */
      } else {
         ptcnt++;
         Show_Point( pgs2, greenwich, max_east, ptcnt, cnt, "" );
         ui.QuadPart += (sizeof(GSPOINT) - 1);
      }
   }
}

BOOL First_Equals_Last(double firstlon, double firstlat, double lastlon, double lastlat)
{
   double dlon = firstlon - lastlon;
   double dlat = firstlat - lastlat;
   if(( fabs(dlon) < SG_EPSILON ) &&
      ( fabs(dlat) < SG_EPSILON ))
   {
      return TRUE;
   }
   return FALSE;
}

void Show_First_Last( double firstlon, double firstlat, double lastlon, double lastlat,
                     int dcnt, int cnt )
{
   if ( First_Equals_Last(firstlon, firstlat, lastlon, lastlat) ) {
      printf( "%d of %d: Last lon, lat EQUALS first ...\n", dcnt, cnt );
   } else {
      printf( "%d of %d: CHECK LAT/LON - First NOT EQUAL last!\n", dcnt, cnt );
      printf( "First: lon : %10.5f, lon : %10.5f\n", firstlon, firstlat );
      printf( "Last : lon : %10.5f, lon : %10.5f\n", lastlon, lastlat );
   }
}



void Process_Buffer_19( PBYTE pb, ULARGE_INTEGER sz, char * fn,
                       PGSINFO pgsi)
{
   ULARGE_INTEGER ui, ul;
   GSHHS_19    gs;
   PGSHHS_19   pg1, pg2;
   int      id = 0;  // count of HEADERS
   short gren, src, greenwich, source;
   GSPOINT  pt;
   PGSPOINT pgs1, pgs2;
   int   ptcnt = 0;
   int   cnt;
   double area;
   double max_east = 270000000;
   double lon, lat, lastlon, lastlat, difflon, difflat, alon, alastlon;
   int   flag, level, version;
   double firstlat, firstlon;
   BOOL  forcehdr = FALSE;
   BOOL  idok = FALSE;
   BOOL  cntok = FALSE;
   ULONGLONG totpts = 0;
   double mx_lon, mx_lat, mi_lon, mi_lat;

   Init_GSINFO(pgsi);

   mx_lon = -OUT_OF_RANGE;
   mx_lat = -OUT_OF_RANGE;
   mi_lon = OUT_OF_RANGE;
   mi_lat = OUT_OF_RANGE;
   Clear_lon_lat( pgsi );

   pg2 = &gs;
   pgs2 = &pt;
   ul.QuadPart = sz.QuadPart - sizeof(GSHHS_19); // subtract HEADER point
   pg1   = (PGSHHS_19) &pb[0];
   pgs1  = (PGSPOINT)  &pb[0];
   *pg2  = *pg1;   // copy the structure out of the buffer
   *pgs2 = *pgs1; // and as if it was a POINT also
   // do the bigendian SWAPPING
   SWAP(pg2->id);    // unique ID, starting at ZERO(0)
   SWAP(pg2->area);
   SWAP(pg2->n);     // number of POINTS
   SWAP(pg2->west);
   SWAP(pg2->east);
   SWAP(pg2->south);
   SWAP(pg2->north);
   //SWAP2(pg2->greenwich);	/* Greenwich is 1 if Greenwich is crossed */
   //SWAP2(pg2->source);	/* 0 = CIA WDBII, 1 = WVS */
	SWAP(pg2->flag);			/* = level + version << 8 + greenwich << 16 + source << 24 */
	/* flag contains 4 items, one in each byte, as follows:
	 * low byte:	level = flag & 255: Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
	 * 2nd byte:	version = (flag >> 8) & 255: Values: Should be 4 for GSHHS version 1.4
	 * 3rd byte:	greenwich = (flag >> 16) & 255: Values: Greenwich is 1 if Greenwich is crossed
	 * 4th byte:	source = (flag >> 24) & 255: Values: 0 = CIA WDBII, 1 = WVS
	 */
   flag = pg2->flag;
   level = flag & 255; // Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
   version = (flag >> 8) & 255; // Values: Should be 4 for GSHHS version 1.4
   gren = greenwich = (flag >> 16) & 255; // Values: Greenwich is 1 if Greenwich is crossed
   src = source = (flag >> 24) & 255; // Values: 0 = CIA WDBII, 1 = WVS
  	area = 0.1 * pg2->area;			/* Now im km^2 */
   cnt = pg2->n;

   SWAP(pgs2->x);
   SWAP(pgs2->y);
   Get_lon_lat( pgs2, gren, max_east, &lon, &lat );
   lastlat = firstlat = 0.0;
   lastlon = firstlon = 0.0;
   alastlon = 0.0;
   if(( pg2->id == id ) &&
      ( area >= 0.0 ) &&
      ((gren == 0)||(gren == 1)) &&
      ((src == 0) ||(src == 1)) ) {
         Show_Entry_19( pg2, "First Entry is ok" );
         flag = pg2->flag;
         greenwich = (flag >> 16) & 255;
         source = (flag >> 24) & 255;
         cnt = pg2->n;
         ptcnt = 0;
         id++; // bump HEADER count
         pgs1 = (PGSPOINT)((PGSHHS_19)pg1 + 1);
         *pgs2 = *pgs1; // and as if it was a POINT also
         SWAP(pgs2->x);
         SWAP(pgs2->y);
         Get_lon_lat( pgs2, greenwich, max_east, &lastlon, &lastlat );
         firstlon = lastlon;
         firstlat = lastlat;
         Add_Header_19( pg2, pgsi );
   } else {
      printf( "ERROR: First record FAILED test!\n" );
      Show_Entry_19( pg2, "First Entry FAILED!" );
      return;
   }

   for( ui.QuadPart = sizeof(GSHHS_19); ui.QuadPart < ul.QuadPart; ui.QuadPart++ )
   {
      pg1   = (PGSHHS_19) &pb[ui.QuadPart];
      pgs1  = (PGSPOINT) &pb[ui.QuadPart];
      *pg2  = *pg1;   // copy the structure out of the buffer
      *pgs2 = *pgs1; // and as if it was a POINT also
      // do the bigendian SWAPPING
      SWAP(pg2->id);    // unique ID, starting at ZERO(0)
      SWAP(pg2->area);
      SWAP(pg2->n);     // number of POINTS
      SWAP(pg2->west);
      SWAP(pg2->east);
      SWAP(pg2->south);
      SWAP(pg2->north);
	   SWAP(pg2->flag);			/* = level + version << 8 + greenwich << 16 + source << 24 */
      flag = pg2->flag;
      level = flag & 255; // Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
      version = (flag >> 8) & 255; // Values: Should be 4 for GSHHS version 1.4
      gren = (flag >> 16) & 255; // Values: Greenwich is 1 if Greenwich is crossed
      src = (flag >> 24) & 255; // Values: 0 = CIA WDBII, 1 = WVS
  	   area = 0.1 * pg2->area;			/* Now im km^2 */

      // now as a POINT
      SWAP(pgs2->x);
      SWAP(pgs2->y);
      Get_lon_lat( pgs2, gren, max_east, &lon, &lat );
      alon  = lon - 360.0;  // since we do NOT know greenwich crossed or not
      //difflon = min(fabs( lon - lastlon ),fabs(altlon - alastlon));
      difflon = (min(fabs(lon),fabs(alon)) - min(fabs(lastlon),fabs(alastlon)) );
      difflat = ( lat - lastlat );

      if( forcehdr ) {
        difflat = 10.0;
        goto Do_Header;
      }

      if(( area >= 0.0 ) &&
         ((gren == 0)||(gren == 1)) &&
         ((src == 0) ||(src == 1)) )
      {
         if( bAssumPoly4 &&
            ( ptcnt < 4 )) {
               printf( "Application of rule of 4! (%d of %d)\n",
                  ptcnt, cnt );
               goto Do_Point;
         }

Do_Header:

         if( pg2->id == id ) {
            Show_First_Last( firstlon, firstlat, lastlon, lastlat, ptcnt, cnt );
            Show_Entry_19( pg2, "ok" );
         } else {
            //Show_Point( pgs2, greenwich, max_east, (ptcnt+1), cnt, "(CHECKNEXT)" );
            //Show_Entry_19( pg2, "(CHECKME)" );
            //if((cnt > 0)&&(ptcnt < cnt))
            //   goto Do_Point;
            if(( fabs( difflon ) < 5.0 ) &&
               ( fabs( difflat ) < 5.0 ))
               goto Do_Point;

            Show_First_Last( firstlon, firstlat, lastlon, lastlat, ptcnt, cnt );
            Show_Point( pgs2, greenwich, max_east, (ptcnt+1), cnt, "(NEXT POINT?)" );
            Show_Entry_19( pg2, "(ID ERROR)" );
            flag = pg2->flag;
         }

         Add_Header_19( pg2, pgsi );
         flag = pg2->flag;
         greenwich = (flag >> 16) & 255;
         source = (flag >> 24) & 255;

         idok = (pg2->id == id) ? TRUE : FALSE;
         cntok = (pg2->n > 0) ? TRUE : FALSE;

         // NOW UPDATES 
         cnt = pg2->n;  // this is sometime NEGATIVE
         totpts += ptcnt;
         ptcnt = 0;
         id++; // bump HEADER count, and move to END in buffer
         ui.QuadPart += (sizeof(GSHHS_19) - 1);
         forcehdr = FALSE;
      } else {
Do_Point:
         forcehdr = FALSE;
         ptcnt++;

         Get_lon_lat( pgs2, greenwich, max_east, &lastlon, &lastlat );
         Add_lon_lat( lastlon, lastlat, pgsi );
         if(lastlon > mx_lon)
            mx_lon = lastlon;
         if(lastlon < mi_lon)
            mi_lon = lastlon;
         if(lastlat > mx_lat)
            mx_lat = lastlat;
         if(lastlat < mi_lat)
            mi_lat = lastlat;

         if( ptcnt == 1 ) {
            firstlon = lastlon;
            firstlat = lastlat;
         }
         alastlon = lastlon - 360.0;   // get as if greenwich crossed
         if( bShowAll ||
            (ptcnt < 2) ||
            ((cnt > 0) && (ptcnt >= cnt)) ||
            ( cnt < 0 ) ) {   // all good reasons to SHOW the POINT
            Show_Point( pgs2, greenwich, max_east, ptcnt, cnt, "" );
         }
         ui.QuadPart += (sizeof(GSPOINT) - 1);

         if(( id > 1 )&&
            ( cnt > 0 )&&
            ( ptcnt == cnt )&&
            ( First_Equals_Last( firstlon, firstlat, lastlon, lastlat ) ) )
         {
            // ( !cntok || !idok )
            // ok, get as HEADER POINTER
            pg1   = (PGSHHS_19)((PGSPOINT)pgs1 + 1);
            *pg2  = *pg1;   // copy the structure out of the buffer
            // do the bigendian SWAPPING
            SWAP(pg2->id);    // unique ID, starting at ZERO(0)
            SWAP(pg2->area);
            SWAP(pg2->n);     // number of POINTS
            SWAP(pg2->west);
            SWAP(pg2->east);
            SWAP(pg2->south);
            SWAP(pg2->north);
	         SWAP(pg2->flag);			/* = level + version << 8 + greenwich << 16 + source << 24 */
            flag = pg2->flag;
            level = flag & 255; // Values: 1 land, 2 lake, 3 island_in_lake, 4 pond_in_island_in_lake
            version = (flag >> 8) & 255; // Values: Should be 4 for GSHHS version 1.4
            gren = (flag >> 16) & 255; // Values: Greenwich is 1 if Greenwich is crossed
            src = (flag >> 24) & 255; // Values: 0 = CIA WDBII, 1 = WVS
  	         area = 0.1 * pg2->area;			/* Now im km^2 */
            if(( area >= 0.0 ) &&
               ((gren == 0)||(gren == 1)) &&
               ((src == 0) ||(src == 1)) )
            {
               // looks like it WILL be a HEADER
            } else {
               printf( "Force HEADER next even though " );
               if( area < 0.0 )
                  printf( "Area LT zero! (%13.3f km^2)\n", area );
               else if( !((gren == 0)||(gren == 1)) )
                  printf( "Greenwich NOT 0 or 1!\n" );
               else
                  printf( "Source NOT 0 or 1!\n" );
               forcehdr = TRUE;  // SPECIAL
            }
         }
      }
   }

   // deal with any remaining data as POINTS - adjust END value
   ul.QuadPart = sz.QuadPart; // up to END OF BUFFER
   bShowAll = TRUE;  // show this LAST set
   for( ; ui.QuadPart < ul.QuadPart; ui.QuadPart++ )
   {
      ULONGLONG diff = sz.QuadPart - ui.QuadPart;
      if( diff < sizeof(GSPOINT) )
         break;
      pgs1  = (PGSPOINT) &pb[ui.QuadPart];
      *pgs2 = *pgs1; // and as if it was a POINT also
      // now as a POINT
      SWAP(pgs2->x);
      SWAP(pgs2->y);
      Get_lon_lat( pgs2, gren, max_east, &lon, &lat );
      alon  = lon - 360.0;  // since we do NOT know greenwich crossed or not
      //difflon = min(fabs( lon - lastlon ),fabs(altlon - alastlon));
      difflon = (min(fabs(lon),fabs(alon)) - min(fabs(lastlon),fabs(alastlon)) );
      difflat = ( lat - lastlat );
      ptcnt++;
      Get_lon_lat( pgs2, greenwich, max_east, &lastlon, &lastlat );
      Add_lon_lat( lastlon, lastlat, pgsi );
      if(lastlon > mx_lon)
         mx_lon = lastlon;
      if(lastlon < mi_lon)
         mi_lon = lastlon;
      if(lastlat > mx_lat)
         mx_lat = lastlat;
      if(lastlat < mi_lat)
         mi_lat = lastlat;
      if( ptcnt == 1 ) {
         firstlon = lastlon;
         firstlat = lastlat;
      }
      alastlon = lastlon - 360.0;   // get as if greenwich crossed
      if( bShowAll ||
         (ptcnt < 2) ||
         ((cnt > 0) && (ptcnt >= cnt)) ||
         ( cnt < 0 ) ) {   // all good reasons to SHOW the POINT
         Show_Point( pgs2, greenwich, max_east, ptcnt, cnt, "" );
      }
      ui.QuadPart += (sizeof(GSPOINT) - 1);
   }
   if( ptcnt ) {
      Show_First_Last( firstlon, firstlat, lastlon, lastlat, ptcnt, cnt );
   }
   totpts += ptcnt;
   if(pgsi) {
      pgsi->hdrcnt = id;
      pgsi->ptcnt  = totpts;
      pgsi->max_lat = mx_lat;
      pgsi->max_lon = mx_lon;
      pgsi->min_lat = mi_lat;
      pgsi->min_lon = mi_lon;
   }
}

static GSINFO _s_sGSInfo;


void Process_File( char * fn )
{
   MAPVW mv;
   PGSINFO pgsi = &_s_sGSInfo;

   if( Map_File_WIN32( fn, &mv ) ) {
      printf( "Processing [%s] file, %I64u bytes...\n", fn, mv.ul );
      Process_Buffer_19((PBYTE)mv.pVoid, mv.ul, mv.fn, pgsi);
      Close_Map_File_WIN32( &mv );

      printf( "Done file, %I64u headers, %I64u points ...\n",
         pgsi->hdrcnt, pgsi->ptcnt );
      printf( "Max lon : %10.5f, lat : %10.5f, Min lon : %10.5f, lat : %10.5f\n",
         pgsi->max_lon, pgsi->max_lat, pgsi->min_lon, pgsi->min_lat );
      printf( "Header Max and Min ...\n" );
      printf( "North Max : %10.5f, Min : %10.5f\n",
         pgsi->n_max, pgsi->n_min );
      printf( "South Max : %10.5f, Min : %10.5f\n",
         pgsi->s_max, pgsi->s_min );
      printf( "East Max : %10.5f, Min : %10.5f\n",
         pgsi->e_max, pgsi->e_min );
      printf( "West Max : %10.5f, Min : %10.5f\n",
         pgsi->w_max, pgsi->w_min );
      Write_lon_lat( "templl2.bmp", 0 );

   } else {
      printf( "ERROR: Failed to open [%s] file!"MEOR, fn );
   }
}


int main_19 (int argc, char **argv)
{
	double w, e, s, n, area, lon, lat;
	char source, kind[2] = {'P', 'L'}, *name[2] = {"polygon", "line"};
	FILE	*fp;
	int	k, line, max_east = 270000000, info, n_read, flip, level, version, greenwich, src;
	GPOINT p;
	struct GSHHS h;
        
	if (argc < 2 || argc > 3) {
		fprintf (stderr, "gshhs v. %s ASCII export tool\n", GSHHS_PROG_VERSION);
		fprintf (stderr, "usage:  gshhs gshhs_[f|h|i|l|c].b [-L] > ascii.dat\n");
		fprintf (stderr, "-L will only list headers (no data output)\n");
		exit (EXIT_FAILURE);
	}

	info = (argc == 3);
	if ((fp = fopen (argv[1], "rb")) == NULL ) {
		fprintf (stderr, "gshhs:  Could not find file %s.\n", argv[1]);
		exit (EXIT_FAILURE);
	}
		
	n_read = (int)fread ((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, fp);
	version = (h.flag >> 8) & 255;
	flip = (version != GSHHS_DATA_VERSION);	/* Take as sign that byte-swabbing is needed */
	
	while (n_read == 1) {
		if (flip) {
			h.id = swabi4 ((unsigned int)h.id);
			h.n  = swabi4 ((unsigned int)h.n);
			h.west  = swabi4 ((unsigned int)h.west);
			h.east  = swabi4 ((unsigned int)h.east);
			h.south = swabi4 ((unsigned int)h.south);
			h.north = swabi4 ((unsigned int)h.north);
			h.area  = swabi4 ((unsigned int)h.area);
			h.flag  = swabi4 ((unsigned int)h.flag);
		}
		level = h.flag & 255;
		version = (h.flag >> 8) & 255;
		greenwich = (h.flag >> 16) & 255;
		src = (h.flag >> 24) & 255;
		w = h.west  * GSHHS_SCL;	/* Convert from microdegrees to degrees */
		e = h.east  * GSHHS_SCL;
		s = h.south * GSHHS_SCL;
		n = h.north * GSHHS_SCL;
		source = (src == 1) ? 'W' : 'C';	/* Either WVS or CIA (WDBII) pedigree */
		line = (h.area) ? 0 : 1;		/* Either Polygon (0) or Line (1) (if no area) */
		area = 0.1 * h.area;			/* Now im km^2 */

		printf ("%c %6d%8d%2d%2c%13.3f%10.5f%10.5f%10.5f%10.5f\n", kind[line], h.id, h.n, level, source, area, w, e, s, n);

		if (info) {	/* Skip data, only want headers */
			fseek (fp, (long)(h.n * sizeof(GPOINT)), SEEK_CUR);
		}
		else {
			for (k = 0; k < h.n; k++) {

				if (fread ((void *)&p, (size_t)sizeof(GPOINT), (size_t)1, fp) != 1) {
					fprintf (stderr, "gshhs:  Error reading file %s for %s %d, point %d.\n", argv[1], name[line], h.id, k);
					exit (EXIT_FAILURE);
				}
				if (flip) {
					p.x = swabi4 ((unsigned int)p.x);
					p.y = swabi4 ((unsigned int)p.y);
				}
				lon = p.x * GSHHS_SCL;
				if (greenwich && p.x > max_east) lon -= 360.0;
				lat = p.y * GSHHS_SCL;
				printf ("%10.5f%10.5f\n", lon, lat);
			}
		}
		max_east = 180000000;	/* Only Eurasiafrica needs 270 */
		n_read = (int)fread((void *)&h, (size_t)sizeof (struct GSHHS), (size_t)1, fp);
	}
		
	fclose (fp);

	exit (EXIT_SUCCESS);
}

// eof - gshhs_scraps.c
