// gshhs_math.c

#include "gshhs_win.h"

BOOL	IsldPDecSig( long double ys )
{
	long double	flr, dyy, dy2;
	BOOL	flg = FALSE;

//	if( ys < 20000 )
//	{
		flr = floor(ys);
		dyy = ( ys - flr );
//	else
//	{
//		dyy = modf( ys, &flr );
//	}
		dy2 = ( dyy * (long double)10.0 );
		if( dy2 >= (long double)5.0 )
		{
			flg = TRUE;
		}
//	}
	return flg;
}

void	LLD2Pt( PPOINT lpsz, PLLD lplld, PPOINT lpp )
{
	long double	ldw, ldh, ldhw, ldhh;
	long double ldlat, ldlong, ldlares, ldlores;
	long double	ldy, ldx;
	//long double	ldxx, ldyy;
	//long double ldt;
	// The BIG size of the MAP
	ldw = (long double)lpsz->x;		// Size of BITMAP
	ldh = (long double)lpsz->y;
	ldhw = (ldw / 2.0);		// Get HALF sizes
	ldhh = (ldh / 2.0);

	if( lplld->ll_Lat < 0.0 )
	{
		// y Latitude is NEGATIVE = SOUTH
		ldlat = (long double) -lplld->ll_Lat;
		if( ldlat < (long double)90.0 )
		{
			ldlares = ( ldlat * ldhh ) / (long double)90.0;
			ldy = ldhh + ldlares;
		}
		else
		{
			ldlares = ldhh;
			ldy = ldh - 1;
		}
	}
	else
	{
		// y Latitude is POSITIVE = NORTH
		ldlat = (long double) lplld->ll_Lat;
		if( ldlat < (long double)90.0 )
		{

			ldlares = ( ldlat * ldhh ) / (long double)90.0;
			ldy = ldhh - ldlares;
		}
		else
		{
			ldlares = ldhh;
			//ldy = ldhh - ldlares;
			ldy = (long double)0.0;
		}
	}

	if( lplld->ll_Long < 0.0 )
	{
		// x Longitude is NEGATIVE = WEST
		ldlong = (long double) -lplld->ll_Long;
		if( ldlong < (long double)180.0 )
		{
			ldlores = ( ldlong * ldhw ) / (long double)180.0;
			ldx = ldhw - ldlores;	// Half width MINUS fraction of 180
		}
		else
		{
			ldlores = ldhw;
			ldx = (long double)0.0;
			//ldx = ldhw - ldlores;	// Half width MINUS fraction of 180
		}
	}
	else
	{
		// x Longitude is POSITIVE = EAST
		ldlong = (long double) lplld->ll_Long;
		if( ldlong < (long double)180.0 )
		{
			ldlores = ( ldlong * ldhw ) / (long double)180.0;
			ldx = ldhw + ldlores;	// Half width PLUS fraction of 180
		}
		else
		{
			ldlores = ldhw;
			//ldx = ldhw + ldlores;	// Half width PLUS fraction of 180
			ldx = ldw - 1;	// width minus fraction
		}
	}

	// Finally, extract the int
	lpp->x = (int)ldx;
	lpp->y = (int)ldy;

//	ldt = (long double)10.0;
//	ldxx = (ldx - floor(ldx)) * ldt;
//	ldyy = (ldy - floor(ldy)) * ldt;
//	ldt = (long double)5.0;
//	if( ldxx >= ldt )
//		lpp->x++;
//	if( ldyy >= ldt )
//		lpp->y++;
	if( lpp->x < lpsz->x )		// Size of BITMAP
	{
		if( (lpp->x + 1) < lpsz->x )
		{
			if( IsldPDecSig( ldx ) )
				lpp->x++;
		}
	}
	else
	{
		lpp->x = lpsz->x - 1;
	}
	if( lpp->y < lpsz->y )
	{
		if( ( lpp->y + 1 ) < lpsz->y )
		{
			if( IsldPDecSig( ldy ) )
				lpp->y++;
		}
	}
	else
	{
		lpp->y = lpsz->y - 1;
	}

}

// Set DEFAULT SIZE (of bitmap and world)
#define		DEF_XWIDTH			1024  // 600
#define		DEF_YHEIGHT			1024  // 400
void LatLon2Pt( PGSINFO pgsi, double lat, double lon, PPOINT pt )
{
   POINT ptsz;
   LLD   lld;
   ptsz.x = DEF_XWIDTH;
   ptsz.y = DEF_YHEIGHT;
   lld.ll_Height = 0.0;
   lld.ll_Lat    = lat;
   lld.ll_Long   = lon;
   LLD2Pt( &ptsz, &lld, pt );
}

void Trans_Lat_Lon( PGSINFO pgsi, double lat, double lon, PINT pilat, PINT pilon )
{
   POINT pt;
   LatLon2Pt( pgsi, lat, lon, &pt );
   *pilat = pt.y;
   *pilon = pt.x;
}

// eof - gshhs_math.c
