// gshhs_main.c

#include "gshhs_win.h"

#define  ISNUM(a) (( a >= '0' ) && ( a <= '9' ))

#define  DEF_IN_FILE    "..\\data_1.6\\gshhs_i.b"
//#define  DEF_OUT_FILE   "tempi.bmp"
//#define  DEF_OUT_FILE   "tempimerc.bmp"
//#define  DEF_OUT_FILE   "tempi4r.bmp"
#define  DEF_OUT_FILE   "tempi8.bmp"

//#define  DEF_IN_FILE    "..\\data_1.6\\wdb_rivers_h.b"
//#define  DEF_OUT_FILE   "temprivi.bmp"

//#define  DEF_IN_FILE    "..\\data_1.6\\wdb_borders_i.b"
//#define  DEF_IN_FILE    "..\\data_1.6\\gshhs_h.b"
//#define  DEF_IN_FILE    "..\\data_1.6\\gshhs_i.b"

// others tried
//#define  DEF_IN_FILE    "..\\data_1.3\\gshhs_i.b"
//#define  DEF_IN_FILE    "..\\gshhs_isl\\gshhs_isle.shx"
//#define DEF_IN_FILE "..\\GMT\\share\\coast\\binned_border_c.cdf"
char * def_file = DEF_IN_FILE;
char * def_args[4];

static char filedate[] = __DATE__;
static char filetime[] = __TIME__;

int bShowRanges = 1; // output the RANGES
BOOL bDoReverseTest = TRUE;

char szTmpBuf[1024];
static PGSINFO _s_pgsi = NULL;

// forward reference
void only_exit( int i );

void pgm_exit( int ret )
{
   PGSINFO pgsi = _s_pgsi;

   Kill_Lists();
   if( pgsi ) {
      Close_Map_File_WIN32( &pgsi->mv );
      if( pgsi->bmpinfo.range.pblock )
         MFREE(pgsi->bmpinfo.range.pblock);
      pgsi->bmpinfo.range.pblock = NULL;
      MFREE( pgsi );
      _s_pgsi = NULL;
   }

   only_exit(ret);
}

char * Get_Version( void )
{
   static char vers_buf[128];
   char * ptmp = vers_buf;
   int i = sprintf(ptmp, "Version: %d.%d.%d of %s at %s (Base %s)",
      GSHHS_WIN_MAJ_VERSION, GSHHS_WIN_MIN_VERSION, GSHHS_WIN_PT_VERSION,
      filedate, filetime,
      GSHHS_PROG_VERSION );
   return ptmp;
}

void Get_File_Name_Only( PTSTR dest, PTSTR src )
{
   size_t len = strlen(src);
   size_t i;
   PTSTR pbgn = src;
   for( i = 0; i < len; i++ )
   {
      int c = src[i];
      if(( c == ':' )||( c == '\\')||( c == '/')) {
         pbgn = &src[i+1];
      }
   }
   strcpy(dest,pbgn);
   len = strlen(dest);
   for( i = 0; i < len; i++ )
   {
      int c = dest[i];
      if(( c == '.' )&&(strcmpi(&dest[i+1], "exe") == 0)) {
         dest[i] = 0;
         break;
      }
   }
}

void show_help( char * pn, int ex, PGSINFO pgsi )
{
   PBMPINFO pbmi = &pgsi->bmpinfo;
   char * ptmp = szTmpBuf;
   Get_File_Name_Only(ptmp, pn);
   sprtf ( "%s: %s\n", ptmp, Get_Version() );
   sprtf ( "GSHHS dataset ASCII and BITMAP export tool, and more ...\n" );
   sprtf ( "Usage: %s [Options] gshhs_[f|h|i|l|c].b [more_input_files]\n", ptmp);
   sprtf ( "Options, in any order, case insensitive ...\n" );
   sprtf ( " -? (or -h[elp])    - This brief HELP.\n" );
   sprtf ( " -bmp=outfile.bmp   - Output results of search to BITMAP file. (%s)\n",
      pgsi->bmpinfo.bmpname[0] ? pgsi->bmpinfo.bmpname : "Off" );
   sprtf ( " -bpp=nn            - Set Bits Per Pixel, 1,4,8,24. Default is %d.\n",
      pgsi->bmpinfo.nBPP );
   sprtf ( " -border[+|-]       - Add border to bitmap. Default is %s.\n",
      ( pgsi->bmpinfo.addborder ? "On" : "Off" ));
   sprtf ( " -grid[+|-]         - Add lat/lon grid to bitmap. Default is %s.\n",
      ( pgsi->bmpinfo.addgrid ? "On" : "Off" ));
	sprtf ( " -l                 - List only headers (no point data output)\n");
   sprtf ( " -maxlat=[-]nn.nnnn - Maximum latitude. Default is %3.1f north.\n",
      pbmi->range.n );
   sprtf ( " -minlat=[-]nn.nnnn - Minimum latitude. Default is %3.1f south.\n",
      pbmi->range.s );
   sprtf ( " -maxlon=[-]nn.nnnn - Maximum longitude. Default is %3.1f east.\n",
      pbmi->range.e );
   sprtf ( " -minlon=[-]nn.nnnn - Minimum longitude. Default is %3.1f west.\n",
      pbmi->range.w );
   sprtf ( " -p[-|+]            - Use Mercator projection, Default is %s.\n",
      (pgsi->bmpinfo.mercator ? "Yes" : "No") );
   sprtf ( " -scale=nn          - Bitmap scaling. Default is %d.\n",
      pbmi->range.scale );
   sprtf ( " -v[0-9]            - Verbosity. Default is %d.\n",
      pgsi->verbosity );
   sprtf ( "Any non-switched entry is treated as a file name. Multiple names allowed.\n" );
   sprtf ( "NOTES: Warning: Very large bitmaps can be created, but there are very few"MEOR );
   sprtf ( "       programs capable of displaying them. It is best to set max/min of"MEOR );
   sprtf ( "       the lat/lon, especially if an enlarged scale is used, like 80 or 100"MEOR );
   sprtf ( "       or more. No attempt has been made to compress the bitmaps created."MEOR );
   sprtf ( "       This is beyond the purpose of this program."MEOR );
   sprtf ( "                                                       Happy GSHHS'ing ;=))\n" );

}

void give_help( char * pn, int ex, PGSINFO pgsi )
{
   show_help( pn, ex, pgsi );
	pgm_exit (ex);
}


void Unknown_Cmd( char * pn, char * bopt, PGSINFO pgsi )
{
   sprtf( "\nBrief help -\n" );
   show_help( pn, 3, pgsi );
   sprtf( "\nERROR: Unknown command! [%s]\n", bopt );
   pgm_exit( 3 );
}

void Get_V_Opt(  char * pn, char * cp, PGSINFO pgsi )
{
   char * bopt = cp;
   char * ptmp = szTmpBuf;
   char c;
   size_t len;
   bopt--;  // back up to beginning of command
   strcpy(ptmp, cp);
   len = strlen(ptmp);
   if( _strnicmp(ptmp, "V", 1) == 0 ) {
      ptmp++;
      c = *ptmp;
      if( ISNUM(c) ) {
         pgsi->verbosity = atoi(ptmp);
      } else {
         sprtf( "ERROR: Only NUMBER can follow -v!\n" );
         goto Error_V;
      }
   } else {
Error_V:
      Unknown_Cmd( pn, bopt, pgsi );
   }
   if( VERB8(pgsi) ) {
      sprtf( "v8: Verbosity set to %d ...\n", pgsi->verbosity );
   }
}


void Get_G_Opt( char * pn, char * cp, PGSINFO pgsi )
{
   char * bopt = cp;
   char * ptmp = szTmpBuf;
   char c;
   size_t len;
   PBOOL pb = &pgsi->bmpinfo.addgrid;
   BOOL  val = TRUE;
   bopt--;  // back up to beginning of command
   strcpy(ptmp, cp);
   len = strlen(ptmp);
   if( _strnicmp(ptmp, "grid", 4) == 0 ) {
      if( len > 4 ) {
         ptmp = &ptmp[4];
         c = *ptmp;
         if( c == '-' )
            val = FALSE;
         else if( c == '+' )
            val = TRUE;
         else {
            sprtf( "ERROR: Only + (on) or - (off) can follow -grid ...\n" );
            goto Error_G;
         }
      }
      *pb = val;
      if( VERB8(pgsi) ) {
         sprtf( "v8: Grid set to %s ...\n", (val ? "On" : "Off") );
      }
   } else {
Error_G:
      Unknown_Cmd( pn, bopt, pgsi );
   }
}


void Get_B_Opt( char * pn, char * cp, PGSINFO pgsi )
{
   char * bopt = cp;
   char * ptmp = szTmpBuf; 
   char * p;
   char c;
   int   val;
   BOOL  bval = TRUE;
   size_t len;

   bopt--;  // back up to beginning of command
   strcpy(ptmp,cp);  // copy it, for modification
   len = strlen(ptmp);
   p = strchr( ptmp, '=' );
   if(p) {
      *p = 0;
      p++;
      if((strcmpi(ptmp, "bmp") == 0) && *p) {
         strcpy(pgsi->bmpinfo.bmpname, p);
         if( VERB8(pgsi) ) {
            sprtf( "v8: BMP output to %s ...\n", pgsi->bmpinfo.bmpname );
         }
      } else if(( strcmpi(ptmp, "bpp") == 0) && *p) {
         val = atoi(p);
         if((val == 1)||(val == 4)||(val == 24)||(val == 8)) {
            pgsi->bmpinfo.nBPP = val;
            if( VERB8(pgsi) ) {
               sprtf( "v8: BPP set to %d ...\n", pgsi->bmpinfo.nBPP );
            }
         } else {
            sprtf( "ERROR: Presently only 1, 4, 8, or 24 can follow -bpp!\n" );
            goto Error_B;
         }
      } else {
         goto Error_B;
      }

   } else if( _strnicmp(ptmp, "border", 6) == 0  ) {
      PBOOL pb = &pgsi->bmpinfo.addborder;
      if( len > 6 ) {
         ptmp = &ptmp[6];
         c = *ptmp;
         if( c == '-' )
            bval = FALSE;
         else if( c == '+' )
            bval = TRUE;
         else {
            sprtf( "ERROR: Only + (on) or - (off) can follow -border ...\n" );
            goto Error_B;
         }
      }
      *pb = bval;
      if( VERB8(pgsi) ) {
         sprtf( "v8: Add border set to %s ...\n", (bval ? "On" : "Off") );
      }
   } else {
Error_B:
      Unknown_Cmd( pn, bopt, pgsi );
   }
}

typedef BOOL (*INRANGE)( double );

BOOL  Lat_In_Range( double lat )
{
   if(( lat >= -90.0 )&&
      ( lat <=  90.0 ))
      return TRUE;

   return FALSE;
}

BOOL  Lon_In_Range( double lat )
{
   if(( lat >= -180.0 )&&
      ( lat <=  180.0 ))
      return TRUE;

   return FALSE;
}


void Get_M_Opt( char * pn, char * cp, PGSINFO pgsi )
{
   char * bopt = cp;
   char * ptmp = szTmpBuf; 
   char * p;
   double * pd;
   int res;
   _CRT_DOUBLE crtd;
   INRANGE  ir = NULL;
   PBMPINFO pbmi = &pgsi->bmpinfo;

   bopt--;  // back up to beginning of command
   strcpy(ptmp,cp);  // copy it, for modification
   p = strchr( ptmp, '=' );
   if(p) {
      *p = 0;
      p++;
      if( strcmpi(ptmp, "maxlat") == 0 ) {
         pd = &pbmi->range.n;
         ir = Lat_In_Range;
      } else if( strcmpi(ptmp, "minlat") == 0 ) {
         pd = &pbmi->range.s;
         ir = Lat_In_Range;
      } else if( strcmpi(ptmp, "maxlon") == 0 ) {
         pd = &pbmi->range.e;
         ir = Lon_In_Range;
      } else if( strcmpi(ptmp, "minlon") == 0 ) {
         pd = &pbmi->range.w;
         ir = Lon_In_Range;
      } else {
         goto Error_M;
      }
      res = _atodbl(&crtd, p);
      if(res) {
         sprtf( "ERROR: Failed to get double value! %s\n",
            ((res == _UNDERFLOW) ? "(Underflow)" :
            (res == _OVERFLOW) ? "(Overflow)" : "(Unknown)"));
         goto Error_M;
      } else {
         if(ir) {
            if (ir(crtd.x)) {
               *pd = crtd.x;
               if( VERB8(pgsi) ) {
                  sprtf( "v8: %s set to %f ...\n", ptmp, *pd );
               }
            } else {
               sprtf( "ERROR: Out of WORLD range, value %3.3f!\n", crtd.x );
               goto Error_M;
            }
         }
      }
   } else {
Error_M:
      Unknown_Cmd( pn, bopt, pgsi );
   }
}

BOOL  Is_All_Numbers( char * ps )
{
   BOOL  bret = FALSE;
   size_t len = strlen(ps);
   size_t i;
   if(len) {
      for( i = 0; i < len; i++ )
      {
         if( !ISNUM(ps[i]) )
            return FALSE;
      }
      bret = TRUE;
   }
   return bret;
}

void Get_P_Opt( char * pn, char * bopt, char * cp, PGSINFO pgsi )
{
   char * ptmp = szTmpBuf;
   char c;
   size_t len;
   PBOOL pb = &pgsi->bmpinfo.mercator;
   BOOL  val = TRUE;

   strcpy(ptmp, cp);
   len = strlen(ptmp);
   if( _strnicmp(ptmp, "p", 1) == 0 ) {
      if( len > 1 ) {
         ptmp = &ptmp[1];
         c = *ptmp;
         if( c == '-' )
            val = FALSE;
         else if( c == '+' )
            val = TRUE;
         else {
            sprtf( "ERROR: Only + (on) or - (off) can follow -p (projections) ...\n" );
            goto Error_P;
         }
      }
      *pb = val;
      if( VERB8(pgsi) ) {
         sprtf( "v8: Projection (Mercator) set to %s ...\n", (val ? "On" : "Off") );
      }
   } else {
Error_P:
      Unknown_Cmd( pn, bopt, pgsi );
   }
}


void Get_S_Opt( char * pn, char * bopt, char * cp, PGSINFO pgsi )
{
   PBMPINFO pbmi = &pgsi->bmpinfo;
   char * ptmp = szTmpBuf; 
   char * p;
   PINT pi = (PINT)&pbmi->range.scale;
   strcpy(ptmp,cp);  // copy it, for modification
   p = strchr( ptmp, '=' );
   if(p) {
      *p = 0;
      p++;
      if( strcmpi(ptmp, "scale") == 0 ) {
         if( *p && Is_All_Numbers(p) )
         {
            *pi = atoi(p);
            if( *pi > 0 ) {
               if( VERB8(pgsi) ) {
                  sprtf( "v8: Scale set to %d ...\n", *pi );
               }
            } else {
               sprtf( "ERROR: Scale must be greater than ZERO! (%d)...\n",
                  *pi );
               goto Error_S;
            }
         } else {
            sprtf( "ERROR: Only integral number(s) can follow -scale= ...\n" );
            goto Error_S;
         }
      } else {
         sprtf( "ERROR: Only -scale=nn allowed ...\n" );
         goto Error_S;
      }
   } else {
Error_S:
      Unknown_Cmd( pn, bopt, pgsi );
   }
}


typedef struct tagPISTR {
   HANDLE   hFile;
   INT      iCnt;
   PTSTR   pBuf;
   PTSTR * pArgs;
}PISTR, * PPISTR;
#define  MXARGS   128    // should be ENOUGH

BOOL  Getpis( char * pn, PPISTR ppis, LPTSTR lpf )
{
   BOOL     bRet = FALSE;
   PTSTR   lptmp;

   ppis->iCnt  = 0;
   ppis->pBuf  = 0;
   ppis->pArgs = 0;
   // read this input file
   ppis->hFile = CreateFile( lpf,
            GENERIC_READ,
            FILE_SHARE_READ,
            0,
            OPEN_EXISTING,
            FILE_ATTRIBUTE_NORMAL,
            0 );
   if( VFH( ppis->hFile ) ) {
      DWORD dws, dwh;
      dws = GetFileSize( ppis->hFile, &dwh );
      if( dws && !dwh ) {
         PTSTR   lpb;
         dwh = dws + (MXARGS * sizeof(LPVOID));
         lpb = (PTSTR)MALLOC(dwh);
         CHKMEM(lpb,dwh);
         if( lpb ) {
            ppis->pBuf = lpb; // this is for freeing the pointer
            if( ( ReadFile( ppis->hFile, lpb, dws, &dwh, 0) ) &&
                ( dws == dwh ) ) {
               LPTSTR * lpv;
               int      icnt;
               TCHAR    c, d;
               DWORD    dwi;

               lpv = (LPTSTR *) (LPTSTR) ( lpb + dws + 2 );
               icnt = 0;
               lpv[icnt++] = pn; // points back to ORIGINAL NAME
               // ==============================================
               for( dwh = 0; dwh < dws; dwh++ ) {
                  c = lpb[dwh];
                  if( c > ' ' ) {
                     if( c == ';' ) {
                        dwh++;
                        for( ; dwh < dws; dwh++ ) {
                           if( lpb[dwh] < ' ' )
                              break;
                        }
                     } else {
                        // begin of an ARGUMENT
                        lptmp = &lpb[dwh];
                        lpv[icnt] = lptmp; // &lpb[dwh];
                        d = *lptmp;    // get first char
                        c = d;
                        dwh++;
                        for( ; dwh < dws; dwh++ ) {
                           c = lpb[dwh];
                           if( c < ' ' )
                              break;
                           else if( ( d != '"' ) && // not "protect" by DOUBLE QUOTES
                              ( c == ';' ) ) // this is a comment tailing a command
                              break;
                        }
                        lpb[dwh] = 0;  // zero terminate the string
                        dwi = dwh - 1; // remove any trailing space
                        while(dwi) {
                           if( lpb[dwi] > ' ' )
                              break;
                           lpb[dwi--] = 0;
                        }
                        // FIX20010329 - Ensure if the argument is "encased"
                        // in double quotes, remove them NOW (like command)
                        dwi = (DWORD)strlen(lptmp);    // get length of the command
                        if( ( dwi > 2      ) &&
                           ( d == '"' ) &&
                           ( lptmp[dwi-1] == '"' ) ) {
                           dwi--;
                           lptmp[dwi] = 0;   // kill trailing DOUBLE QUOTE
                           dwi--;
                           lptmp++;          // bump past leading DOUBLE QUOTE
                           lpv[icnt] = lptmp; // set this new pointer
                        }
                        if( dwi ) {
                           icnt++;  // bump the argument count
                        }
                        if( c >= ' ' ) {
                           // ensure we go to the end of the line
                           dwh++;   // get past the ZERO - FIX20020324
                           for( ; dwh < dws; dwh++ ) {
                              c = lpb[dwh];
                              if( c < ' ' )
                                 break;
                           }
                        }
                     }
                  }
               }  // for the length of the read in buffer
               // =======================================
               if( icnt > 1 ) {
                  ppis->iCnt = icnt;
                  ppis->pArgs = lpv;
               }
               // note we quietly forget BLANK input files!!!
               bRet = TRUE;
            }
         }
      }
   }
   return bRet;
}

void Process_Args(int argc, char **argv, PGSINFO pgsi);

void Process_Input( char * pn, char * porg, char * cp, PGSINFO pgsi )
{
   PISTR is;
   PPISTR   ppis = &is;
   BOOL  failed = FALSE;
   ZeroMemory( ppis, sizeof(PISTR) );
   if( Getpis( pn, ppis, cp ) ) {
      if( ( ppis->iCnt > 1 ) && ( ppis->pArgs ) )
         Process_Args( ppis->iCnt, ppis->pArgs, pgsi );
      // note we quietly forget BLANK input files!!!
   } else {
      failed = TRUE;
   }
   if( ppis->pBuf )
      MFREE(ppis->pBuf);

   if( VFH( ppis->hFile ) )
      CloseHandle( ppis->hFile );

   if( failed ) {
      sprtf("ERROR: Failed to OPEN, and load file %s ...\n", cp );
      Unknown_Cmd( pn, porg, pgsi );
   }
}

void Process_Verb(int argc, char **argv, PGSINFO pgsi)
{
   int i;
   char * cp;
   char c;
   char * pn = argv[0];
   for( i = 1; i < argc; i++ ) {
      cp = argv[i];
      c = toupper(*cp);
      if(( c == '-' )||( c == '/')) {
         cp++;
         c = toupper(*cp);
         if( c == 'V' )
            Get_V_Opt( pn, cp, pgsi);
      }
   }
}

void Process_Args(int argc, char **argv, PGSINFO pgsi)
{
   int i;
   char * cp;
   char c;
   char * pn = argv[0];
   Process_Verb(argc, argv, pgsi); // Always pre-process VERBOSITY
   for( i = 1; i < argc; i++ ) {
      cp = argv[i];
      c = toupper(*cp);
      if( VERB8(pgsi) ) {
         sprtf( "v8: Processing argument %s ...\n", cp );
      }
      if(( c == '-' )||( c == '/')) {
         cp++;
         c = toupper(*cp);
         switch(c)
         {
         case 'H':
         case '?':
            give_help( pn, 0, pgsi );
            break;
         case 'B':
            Get_B_Opt( pn, cp, pgsi );
            break;
         case 'G':
            Get_G_Opt( pn, cp, pgsi );
            break;
         case 'L':
            pgsi->info = 1;
            break;
         case 'M':
            Get_M_Opt( pn, cp, pgsi);
            break;
         case 'P':
            Get_P_Opt( pn, argv[i], cp, pgsi);
            break;
         case 'S':
            Get_S_Opt( pn, argv[i], cp, pgsi);
            break;
         case 'V':
            //Get_V_Opt( pn, cp, pgsi); // already done '-V[n]'
            break;
         default:
            sprtf( "ERROR: Option %c not cased!\n", c );
            Unknown_Cmd( pn, argv[i], pgsi );
            break;
         }
      } else if( c == '@' ) {
         // input file
         cp++;
         Process_Input( pn, argv[i], cp, pgsi );
      } else {
         // bare argument - assume a FILE NAME
         Add_2_File_List(cp); // add to list to process
      }
   }
}

#define  TLat(a)  Trans_Lat(pgsi, a)
#define  TLon(a)  Trans_Lon(pgsi, a)

long Trans_Lat( PGSINFO pgsi, double lat )
{
   double scale = (double)pgsi->bmpinfo.range.scale;
   //int ilat = (int)(((lat +  90.0) * scale * 2.0) + 0.5); // range 0 to 180
   int ilat = (int)(((lat +  90.0) * scale) + 0.5); // range 0 to 180
   return ilat;
}
long Trans_Lon( PGSINFO pgsi, double lon )
{
   double scale = (double)pgsi->bmpinfo.range.scale;
   int ilon = (int)(((lon + 180.0) * scale) + 0.5); // range 0 to 360
   return ilon;
}

void Show_Memory_Problem( PGSINFO pgsi, size_t insize )
{
   PBMPINFO pbmi = &pgsi->bmpinfo;
   PGSRANGE pgsr = &pbmi->range;
   size_t size = insize;
   double dscale = (double) pgsi->bmpinfo.range.scale;
   long width = pgsr->width;
   long height = pgsr->height;
   PBYTE pb;
   sprtf("ERROR: Memory allocation of %d bytes FAILED!"MEOR, size );
   sprtf("That is %d x %d, using scale %d ... moment, checking ..."MEOR,
      pgsr->width, pgsr->height, pgsi->bmpinfo.range.scale );
   pb = NULL;
   while( pb == NULL ) {
      dscale = dscale / 2.0;
      size = ((int) ((pgsr->dwid * dscale) + 1.5)) * ((int) ((pgsr->dhgt * dscale) + 1.5));
      pb = (PBYTE)MALLOC(size);
   }
   MFREE(pb);
   sprtf( "Things MAY work if scale is reduced to %d or less ..."MEOR,
      (int)dscale );
   sprtf( "That is a %d byte allocation ..."MEOR, size );
   sprtf( "Or reduce the width %3.1f, or heigth %3.1f degrees by min/max lat/lon..."MEOR,
      pgsr->dwid, pgsr->dhgt );
   sprtf( "Or do NOT request a USER bitmap be written ..."MEOR );
   pb = NULL;
}



// a check of the INPUT arguments
void Check_Args( PGSINFO pgsi )
{
   PBMPINFO pbmi = &pgsi->bmpinfo;
   PGSRANGE pgsr = &pbmi->range;
   PLE ph = Get_File_List();
   if( pbmi->bmpname[0] )  // given a USER bitmap to write
   {
      // if an OUPUT USER BITMAP FILE
      if( Lat_In_Range( pgsr->n )&&
          Lat_In_Range( pgsr->s )&&
          Lon_In_Range( pgsr->e )&&
          Lon_In_Range( pgsr->w )&&
          ( pgsr->s < pgsr->n )&&
          ( pgsr->w < pgsr->e ))
      {
         double dscale = (double)pgsi->bmpinfo.range.scale;
         size_t size;
         pgsr->dwid = pgsr->e - pgsr->w;  // width, in degrees
         pgsr->dhgt = pgsr->n - pgsr->s;  // height, in degrees
         pgsr->centerlat = (pgsr->n + pgsr->s) / 2.0;
         pgsr->centerlon = (pgsr->e + pgsr->w) / 2.0;

         // get integral height and width, adding 1
         pgsr->height = (int) ((pgsr->dhgt * dscale) + 1.5);
         if(pgsr->height == 0)
            pgsr->height = 1;
         pgsr->width  = (int) ((pgsr->dwid * dscale) + 1.5);
         if(pgsr->width == 0)
            pgsr->width = 1;
         // allocate the memory
         size = pgsr->width * pgsr->height;
         //size = WIDTHBYTES(pgsr->width * 8) * pgsr->height;
         pgsr->pblock = (PBYTE)MALLOC(size);  // ALLOCATE BLOCK FOR POINT ACCUMULATION
         if( !pgsr->pblock ) { Show_Memory_Problem( pgsi, size ); }
         CHKMEM(pgsr->pblock, size);   // store bits in here
         ZeroMemory(pgsr->pblock, size);
         // establish OFFSET
         pgsr->ailon = TLon(pgsr->w); // range 0 to 360
         pgsr->ailat = TLat(pgsr->s); // range 0 to 180
         // get pixel BOUNDARIES ...
         Get_BMP_iLatLon( pgsi, pgsr->n, pgsr->w, &pgsr->TLilat, &pgsr->TLilon );
         Get_BMP_iLatLon( pgsi, pgsr->s, pgsr->e, &pgsr->BRilat, &pgsr->BRilon );
         if( !pgsi->bmpinfo.mercator ) {
            int tlat;
            // but this may NOT be the actual BOUNDARIES
            if(( pgsr->n > 0.0 )&&( pgsr->s < 0.0 )) {
               // then 0.0 lat is widest
               Get_BMP_iLatLon( pgsi, 0.0, pgsr->e, &tlat, &pgsr->BRilon );
            } else if( pgsr->n < 0.0 ) {
               // then North is WIDEST
               Get_BMP_iLatLon( pgsi, pgsr->n, pgsr->e, &tlat, &pgsr->BRilon );
            }
         }
         if( VERB8(pgsi) || bShowRanges ) {
            int ilat, ilon;
            BOOL  merc = pgsi->bmpinfo.mercator;
            //double lat, lon;
             sprtf( "v8: Limits are in range ... Mercator %s\n",
                ( merc ? "On" : "Off" ));
             sprtf( "v8: Lat max %3.7f, min %3.7f, "
                "Lon min %3.7f, max %3.7f\n",
                pgsr->n, pgsr->s, pgsr->w, pgsr->e );
             sprtf( "v8: Degrees height %3.7f, width %3.7f, scale %d\n",
                pgsr->dhgt, pgsr->dwid,
                pgsr->scale );
             sprtf( "v8: Integral pixels y %d, x %d, (adj %d,%d)\n",
                pgsr->height, pgsr->width, 
                pgsr->ailat, pgsr->ailon );

             // SHOW pixel boundaries
             sprtf( "v8: TL Lat %3.7f, TL Lon %3.7f, translates to %d, %d\n",
                pgsr->n, pgsr->w, pgsr->TLilat, pgsr->TLilon);
             Get_BMP_iLatLon( pgsi, pgsr->centerlat, pgsr->centerlon, &ilat, &ilon );
             sprtf( "V8: CT Lat %3.7f, CT Lon %3.7f, translates to %d, %d"MEOR,
                pgsr->centerlat, pgsr->centerlon, ilat, ilon );
             sprtf( "v8: BR Lat %3.7f, BR Lon %3.7f, translates to %d, %d\n",
                pgsr->s, pgsr->e, pgsr->BRilat, pgsr->BRilon);
             Get_BMP_iLatLon( pgsi, pgsr->n, pgsr->e, &ilat, &ilon );
             sprtf( "V8: T- Lat %3.7f, -R Lon %3.7f, translates to %d, %d"MEOR,
                pgsr->n, pgsr->e, ilat, ilon );
             Get_BMP_iLatLon( pgsi, pgsr->s, pgsr->w, &ilat, &ilon );
             sprtf( "V8: B- Lat %3.7f, -L Lon %3.7f, translates to %d, %d"MEOR,
                pgsr->s, pgsr->w, ilat, ilon );
             Get_BMP_iLatLon( pgsi, pgsr->centerlat, pgsr->e, &ilat, &ilon );
             sprtf( "V8: CT Lat %3.7f, -R Lon %3.7f, translates to %d, %d"MEOR,
                pgsr->centerlat, pgsr->e, ilat, ilon );
             Get_BMP_iLatLon( pgsi, pgsr->centerlat, pgsr->w, &ilat, &ilon );
             sprtf( "V8: CT Lat %3.7f, -L Lon %3.7f, translates to %d, %d"MEOR,
                pgsr->centerlat, pgsr->w, ilat, ilon );

             sprtf( "Mercator ON ...\n" );
             pgsi->bmpinfo.mercator = 1;
             Get_BMP_iLatLon( pgsi, pgsr->n, pgsr->w, &ilat, &ilon );
             sprtf( "v8: Lat %3.7f, Lon %3.7f, translates to %d, %d\n",
                pgsr->n, pgsr->w, ilat, ilon);
             Get_BMP_iLatLon( pgsi, pgsr->s, pgsr->e, &ilat, &ilon );
             sprtf( "v8: Lat %3.7f, Lon %3.7f, translates to %d, %d\n",
                pgsr->s, pgsr->e, ilat, ilon);

             sprtf( "Mercator OFF ...\n" );
             pgsi->bmpinfo.mercator = 0;
             Get_BMP_iLatLon( pgsi, pgsr->n, pgsr->w, &ilat, &ilon );
             sprtf( "v8: Lat %3.7f, Lon %3.7f, translates to %d, %d\n",
                pgsr->n, pgsr->w, ilat, ilon);
             Get_BMP_iLatLon( pgsi, pgsr->s, pgsr->e, &ilat, &ilon );
             sprtf( "v8: Lat %3.7f, Lon %3.7f, translates to %d, %d\n",
                pgsr->s, pgsr->e, ilat, ilon);
             pgsi->bmpinfo.mercator = merc;

             sprtf( "v8: Full BITMAP items ... Mercator %s\n",
                ( pgsi->bmpinfo.mercator ? "On" : "Off" ));
             sprtf( "v8: Full tl=(%d,%d) br=(%d,%d), Lims tl=(%d,%d) br=(%d,%d)\n",
                TLon(-180.0),
                TLat( 90.0),
                TLon(180.0),
                TLat(-90.0),
                TLon(pgsr->w),
                TLat(pgsr->n),
                TLon(pgsr->e),
                TLat(pgsr->s));
             Trans_Lat_Lon( pgsi, 90.0, -180.0, &ilat, &ilon );
             sprtf( "v8: Full tl(90,-180)=(%d,%d) ", ilat, ilon );
             Trans_Lat_Lon( pgsi, -90.0, 180.0, &ilat, &ilon );
             sprtf( "br(-90,180)=(%d,%d)\n", ilat, ilon );

             //Trans_Lat_Lon( pgsi, pgsr->n, pgsr->w, &ilat, &ilon );
             //sprtf( "v8: Limits tl=(%d,%d) ", ilat, ilon );
             //Trans_Lat_Lon( pgsi, pgsr->s, pgsr->e, &ilat, &ilon );
             //sprtf( "br=(%d,%d)\n", ilat, ilon );
             if( bDoReverseTest ) {
                double lat, lon;
                //double tlat, tlon;
                //int  tilat, tilon, i;
                sprtf( "Doing 'reverse' test - pixel to lat,lon ..."MEOR );
                sprtf( "For TL %3.6f, %3.6f, pixel %d, %d"MEOR,
                   pgsr->n, pgsr->w, pgsr->TLilat, pgsr->TLilon );
                BMP_iLatLon_2_latlon( pgsi, &lat, &lon, pgsr->TLilat, pgsr->TLilon );
                Get_BMP_iLatLon( pgsi, lat, lon, &ilat, &ilon );
                sprtf( "Got TL %3.6f, %3.6f, pixel %d, %d ... ",
                   lat, lon, ilat, ilon );
                if( ilat != pgsr->TLilat ) {
                   sprtf( " (ilat diff = %d)", abs(ilat - pgsr->TLilat));
                } else {
                   sprtf( " (ilat ok)" );
                }
                if( ilon != pgsr->TLilon ) {
                   sprtf( " (ilon diff = %d)", abs(ilon - pgsr->TLilon));
                } else {
                   sprtf( " (ilon ok)" );
                }
                sprtf(MEOR);

                sprtf( "For BR %3.6f, %3.6f, pixel %d, %d"MEOR,
                   pgsr->s, pgsr->e, pgsr->BRilat, pgsr->BRilon );
                BMP_iLatLon_2_latlon( pgsi, &lat, &lon, pgsr->BRilat, pgsr->BRilon );
                Get_BMP_iLatLon( pgsi, lat, lon, &ilat, &ilon );
                sprtf( "Got BR %3.6f, %3.6f, pixel %d, %d ...",
                   lat, lon, ilat, ilon );
                if( ilat != pgsr->BRilat ) {
                   sprtf( " (ilat diff = %d)", abs(ilat - pgsr->BRilat));
                } else {
                   sprtf( " (ilat ok)" );
                }
                if( ilon != pgsr->BRilon ) {
                   sprtf( " (ilon diff = %d)", abs(ilon - pgsr->BRilon));
                } else {
                   sprtf( " (ilat ok)" );
                }
                sprtf(MEOR);

             }

             sprtf("\n");
          }
      } else {
         sprtf("ERROR: Range min/max out of world view!\n"
            "Lat max %f, min %f, "
            "Lon min %f, max %f\n",
            pgsr->n, pgsr->s, pgsr->w, pgsr->e );
         pgm_exit(1);
      }
   }

   // establish a DEFAULT file, if NO ARGS GIVEN!!!
   if( IsListEmpty(ph) ) {
      // if( !pgsi->fn[0] ) strcpy( pgsi->fn, def_file);
      Add_2_File_List( def_file );
   }
}

extern void Bitmap_2_Bits(void);


int main (int argc, char **argv)
{
   int   iret = 0;
   BOOL  bmp;
   PTSTR pfile;
   int   item, cnt;
   PGSINFO pgsi;
   PTSTR pb;

   _s_pgsi = (PGSINFO)MALLOC( sizeof(GSINFO) );
   CHKMEM(_s_pgsi,( sizeof(GSINFO) ));

   pgsi = _s_pgsi;
   ZeroMemory(pgsi,sizeof(GSINFO));

   // Bitmap_2_Bits(); // use to generate data in gshhs_data.c

   Init_GSINFO(pgsi);

   Process_Args( argc, argv, pgsi);

   Check_Args( pgsi );

   Clear_lon_lat( pgsi );

   bmp = (pgsi->bmpinfo.bmpname[0] ? TRUE : FALSE);  // write BITMAP

   cnt = Get_File_List_Count();
   if( !cnt ) {
      sprtf( "WARNING: No INPUT file name(s) found!\n" );
      pgm_exit(EXIT_FAILURE);
   }
   item = 1;
   while( (pfile = Get_File_List_File_Ptr(item)) != NULL ) {
      if( !Map_File_WIN32( pfile, &pgsi->mv ) ) {
		   sprtf ( "%s:  Could not find file %s.\n", argv[0], pfile );
		   iret = EXIT_FAILURE;
      } else {
         pb = GetNxtBuf();
         if( Integrity_Check(pgsi) ) {
            sprintf(pb, "[%s]", pfile );
            sprintf(EndBuf(pb), ", Headers %ld", pgsi->hdrcnt );
            sprintf(EndBuf(pb), ", Points %ld", pgsi->ptcnt );
            if( VERB8(pgsi) ) {
               sprtf( "v8: File %s ", pb );
               sprtf( " (= %ld bytes)"MEOR,
                  ((pgsi->hdrcnt * sizeof(struct GSHHS))+
                   (pgsi->ptcnt * sizeof(GPOINT))) );
            }
         } else {
            sprintf(pb, "WARNING: File [%s] FAILED itegrity check!", pfile );
            sprtf( "WARNING: %s"MEOR, pb );
         }
         Add_2_Done_List( pb );
         iret = Process_GSHHS( pgsi );
         Close_Map_File_WIN32( &pgsi->mv );
      }
      item++;  // bump to NEXT file
      Set_Next_Color( pgsi );
   }

   if(bmp) {
      if( VERB1(pgsi) ) {
         sprtf( "Accumulated %d points on bitmap ...\n",
            pgsi->bmpinfo.range.ptcount );
      }
      if( pgsi->bmpinfo.range.ptcount ) {
         Write_User_BMP( pgsi );
      }
   }

   if( VERB1(pgsi) )
   {
      sprtf( "Header Max and Min ...\n" );
      sprtf( "North Max : %10.5f, Min : %10.5f\n",
         pgsi->n_max, pgsi->n_min );
      sprtf( "South Max : %10.5f, Min : %10.5f\n",
         pgsi->s_max, pgsi->s_min );
      sprtf( "East  Max : %10.5f, Min : %10.5f\n",
         pgsi->e_max, pgsi->e_min );
      sprtf( "West  Max : %10.5f, Min : %10.5f\n",
         pgsi->w_max, pgsi->w_min );

      sprtf( "Point Max and Min ...\n" );
      sprtf( "Max lat : %10.5f, Min lat : %10.5f\n",
         pgsi->max_lat, pgsi->min_lat );
      sprtf( "Max lon : %10.5f, Min lon : %10.5f\n",
         pgsi->max_lon, pgsi->min_lon );
   }

   Write_lon_lat( DEF_OUT_FILE, pgsi );

   pgm_exit( iret );
   return iret;
}

void only_exit( int i )
{
   exit(i);
}


// gshhs_main.c
