// gshhs_info.h
#ifndef _gshhs_info_H_
#define _gshhs_info_H_
#include "win_map.h"    // for MAPVW

typedef struct tagGSRANGE {
   double e, n, s, w;   // boundary, in degrees
   int TLilat, TLilon, BRilat, BRilon; // boundary, in pixels
   double area;   // km^2
   double dwid, dhgt;
   double centerlat, centerlon;
   long scale, height, width;
   long ailat, ailon;   // offsets
   long ptcount;  // bits ADDED to block
   double mxlat, mnlat, mxlon, mnlon;  // point limits, in degrees
   long maxilat, maxilon, minilat, minilon;  // point limits, in pixels
   PBYTE pblock;
}GSRANGE, * PGSRANGE;

typedef struct tagBMPSTUFF {
   int   bms_width, bms_height, bms_rowwid;
   double vscale, hscale;
   PBYTE pbits;
}BMPSTUFF, * PBMPSTUFF;

typedef struct tagBMPINFO {
   BOOL addgrid;        // add lat/lon grid
   BOOL addborder;      // add a border around BMP
   int  nBPP;           // bits per pixel bitmap
   int  mercator;   // use mercator projection
   GSRANGE  range;   // ranges of bitmap
   BMPSTUFF bmpstuff;   // various items fro writing the BITAMP
   char bmpname[MAX_PATH];  // output FILE NAME
}BMPINFO, * PBMPINFO;

typedef struct tagGSINFO {
   //char fn[MAX_PATH];   // file being process
   double max_lon, max_lat;
   double min_lon, min_lat;
   ULONGLONG hdrcnt, ptcnt;   // set during Integrity_Check(pgsi)
   double n_max, n_min;
   double e_max, e_min;
   double s_max, s_min;
   double w_max, w_min;
   double h_max, h_min;
   int   info;
   int   verbosity;
   BMPINFO  bmpinfo;
   MAPVW mv;   // WIN32 mapped file buffer
   int   overwrite;  // set for FIRST, cleared for others for GSHHS points
   BYTE  def_bmc; // set block to this
   BYTE  txt_bmc; // when putting TEXT
   BYTE  ll_bmc;  // lat/lon grid color
   BYTE  bdr_bmc; // border color

}GSINFO, * PGSINFO;

extern void Init_GSINFO( PGSINFO pgsi );
extern void Add_2_GSLimits( double n, double s, double e, double w, PGSINFO pgsi );
extern void Add_2_GSINFO( double lat, double lon, PGSINFO pgsi );
extern BOOL In_GSHHS_Range( double lat, double lon, PGSINFO pgsi );

#define  VERB1(a) ( a->verbosity >= 1 )
#define  VERB2(a) ( a->verbosity >= 2 )
#define  VERB3(a) ( a->verbosity >= 3 )
#define  VERB4(a) ( a->verbosity >= 4 )
#define  VERB5(a) ( a->verbosity >= 5 )
#define  VERB8(a) ( a->verbosity >= 8 )
#define  VERB9(a) ( a->verbosity >= 9 )

#endif // _gshhs_info_H_
// eof - gshhs_info.h
