// gshhs_info.c

#include "gshhs_win.h"

//#define  BMP_DEF_BPP     24
#define  BMP_DEF_BPP     4
#define  BMP_DEF_SCALE   4

// GSINFO sGSInfo;

void Init_GSINFO( PGSINFO pgsi )
{
   if( pgsi ) {
      PBMPINFO pbmi = &pgsi->bmpinfo;
      ZeroMemory(pgsi, sizeof(GSINFO));

      // establish DEFAULTS
      pgsi->verbosity = 1;
      pgsi->overwrite = 1; // always put new BYTE
      pgsi->def_bmc = BMC_BLACK; // default to BLACK
      pgsi->txt_bmc = BMC_RED;
      pgsi->ll_bmc  = BMC_GRAY;
      pgsi->bdr_bmc = BMC_GREEN;

      pgsi->n_max = -OUT_OF_RANGE;
      pgsi->s_max = -OUT_OF_RANGE;
      pgsi->e_max = -OUT_OF_RANGE;
      pgsi->w_max = -OUT_OF_RANGE;
      pgsi->h_max = -OUT_OF_RANGE;
      pgsi->n_min = OUT_OF_RANGE;
      pgsi->s_min = OUT_OF_RANGE;
      pgsi->e_min = OUT_OF_RANGE;
      pgsi->w_min = OUT_OF_RANGE;
      pgsi->h_min = OUT_OF_RANGE;
      pgsi->max_lat = -OUT_OF_RANGE;
      pgsi->min_lat = OUT_OF_RANGE;
      pgsi->max_lon = -OUT_OF_RANGE;
      pgsi->min_lon = OUT_OF_RANGE;

      // set standard RANGE = WHOLE WORLD
      pbmi->range.e =  180.0;
      pbmi->range.n =   90.0;
      pbmi->range.s =  -90.0;
      pbmi->range.w = -180.0;
      pbmi->range.scale = BMP_DEF_SCALE;
      pbmi->addborder = TRUE; // default to ADD BORDERS
      pbmi->addgrid   = TRUE; // default to ADD lat/lon grid
      pbmi->nBPP      = BMP_DEF_BPP;    // default to 4 bits per pixel (16 colors)
 
   }
}

void Add_2_GSLimits( double n, double s, double e, double w, PGSINFO pgsi )
{
   if( pgsi ) {

      if( w > pgsi->w_max )
         pgsi->w_max = w;
      if( e > pgsi->e_max )
         pgsi->e_max = e;
      if( s > pgsi->s_max )
         pgsi->s_max = s;
      if( n > pgsi->n_max )
         pgsi->n_max = n;

      if( w < pgsi->w_min )
         pgsi->w_min = w;
      if( e < pgsi->e_min )
         pgsi->e_min = e;
      if( s < pgsi->s_min )
         pgsi->s_min = s;
      if( n < pgsi->n_min )
         pgsi->n_min = n;
   }
}

void Add_2_GSINFO( double lat, double lon, PGSINFO pgsi )
{
   if(pgsi) {
      if( lat > pgsi->max_lat )
         pgsi->max_lat = lat;
      if( lat < pgsi->min_lat )
         pgsi->min_lat = lat;
      if( lon > pgsi->max_lon )
         pgsi->max_lon = lon;
      if( lon < pgsi->min_lon )
         pgsi->min_lon = lon;
   }
}

BOOL  In_GSHHS_Range( double lat, double lon, PGSINFO pgsi )
{
   PBMPINFO pbmi = &pgsi->bmpinfo;
   if(( lat >= pbmi->range.s )&&
      ( lat <= pbmi->range.n )&&
      ( lon >= pbmi->range.w )&&
      ( lon <= pbmi->range.e ))
      return TRUE;

   return FALSE;
}

// eof - gshhs_info.c
