// gshhs_data.c

#include "gshhs_win.h"

// Just some bit array of the numbers 0 to 9 ...
// In 7 x 9 bits, as a fixed font size, small
// =================================================
// Number 0
static BYTE bits_num0[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end number 0
};
// Number 1
static BYTE bits_num1[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0  // end number 1
};
// Number 2
static BYTE bits_num2[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0  // end number 2
};
// Number 3
static BYTE bits_num3[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,0,0,0,0,1,0,
 0,0,0,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end number 3
};
// Number 4
static BYTE bits_num4[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,1,0,0,
 0,0,1,0,1,0,0,
 0,1,0,0,1,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,1,0,0,
 0,0,0,1,1,1,0,
 0,0,0,0,0,0,0  // end number 4
};
// Number 5
static BYTE bits_num5[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end number 5
};
// Number 6
static BYTE bits_num6[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,1,1,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end number 6
};
// Number 7
static BYTE bits_num7[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0  // end number 7
};
// Number 8
static BYTE bits_num8[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end number 8
};
// Number 9
static BYTE bits_num9[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0  // end number 9
};

// Number 10 = minus sign
static BYTE bits_num10[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end number 10 = minus sign
};


// In 7 x 9 bits, as a fixed font size, small
PBYTE Get_Num_Array( int num )
{
   PBYTE pb = NULL;
   switch(num)
   {
   case 0: pb = bits_num0; break;
   case 1: pb = bits_num1; break;
   case 2: pb = bits_num2; break;
   case 3: pb = bits_num3; break;
   case 4: pb = bits_num4; break;
   case 5: pb = bits_num5; break;
   case 6: pb = bits_num6; break;
   case 7: pb = bits_num7; break;
   case 8: pb = bits_num8; break;
   case 9: pb = bits_num9; break;
   case 10: pb = bits_num10; break; // acutally a MINUS SIGN
   }
   return pb;
}

void Get_Num_Bit_Size( PINT px, PINT py )
{
   *px = 7;
   *py = 9;
}


// Arrays are 7 x 11 ...
// #0 32, 0x20, ( )
static BYTE bits_ascii0[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #0 32, 0x20 ( )
};
// #1 33, 0x21, (!)
static BYTE bits_ascii1[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #1 33, 0x21 (!)
};
// #2 34, 0x22, (")
static BYTE bits_ascii2[] = {
 0,0,0,0,0,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #2 34, 0x22 (")
};
// #3 35, 0x23, (#)
static BYTE bits_ascii3[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,1,0,
 0,0,1,0,1,0,0,
 0,1,1,1,1,1,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,1,1,1,1,1,0,
 0,0,1,0,1,0,0,
 0,1,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #3 35, 0x23 (#)
};
// #4 36, 0x24, ($)
static BYTE bits_ascii4[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #4 36, 0x24 ($)
};
// #5 37, 0x25, (%)
static BYTE bits_ascii5[] = {
 0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,1,1,1,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #5 37, 0x25 (%)
};
// #6 38, 0x26, (&)
static BYTE bits_ascii6[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,1,1,0,0,
 0,1,0,0,1,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #6 38, 0x26 (&)
};
// #7 39, 0x27, (')
static BYTE bits_ascii7[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #7 39, 0x27 (')
};
// #8 40, 0x28, (()
static BYTE bits_ascii8[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #8 40, 0x28 (()
};
// #9 41, 0x29, ())
static BYTE bits_ascii9[] = {
 0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #9 41, 0x29 ())
};
// #10 42, 0x2a, (*)
static BYTE bits_ascii10[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #10 42, 0x2a (*)
};
// #11 43, 0x2b, (+)
static BYTE bits_ascii11[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #11 43, 0x2b (+)
};
// #12 44, 0x2c, (,)
static BYTE bits_ascii12[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,1,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,0,0,0,0  // end #12 44, 0x2c (,)
};
// #13 45, 0x2d, (-)
static BYTE bits_ascii13[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #13 45, 0x2d (-)
};
// #14 46, 0x2e, (.)
static BYTE bits_ascii14[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #14 46, 0x2e (.)
};
// #15 47, 0x2f, (/)
static BYTE bits_ascii15[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #15 47, 0x2f (/)
};
// #16 48, 0x30, (0)
static BYTE bits_ascii16[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #16 48, 0x30 (0)
};
// #17 49, 0x31, (1)
static BYTE bits_ascii17[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #17 49, 0x31 (1)
};
// #18 50, 0x32, (2)
static BYTE bits_ascii18[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #18 50, 0x32 (2)
};
// #19 51, 0x33, (3)
static BYTE bits_ascii19[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,0,0,0,0,1,0,
 0,0,0,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #19 51, 0x33 (3)
};
// #20 52, 0x34, (4)
static BYTE bits_ascii20[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,1,0,0,
 0,0,1,0,1,0,0,
 0,1,0,0,1,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,1,0,0,
 0,0,0,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #20 52, 0x34 (4)
};
// #21 53, 0x35, (5)
static BYTE bits_ascii21[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #21 53, 0x35 (5)
};
// #22 54, 0x36, (6)
static BYTE bits_ascii22[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,1,1,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #22 54, 0x36 (6)
};
// #23 55, 0x37, (7)
static BYTE bits_ascii23[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #23 55, 0x37 (7)
};
// #24 56, 0x38, (8)
static BYTE bits_ascii24[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #24 56, 0x38 (8)
};
// #25 57, 0x39, (9)
static BYTE bits_ascii25[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #25 57, 0x39 (9)
};
// #26 58, 0x3a, (:)
static BYTE bits_ascii26[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #26 58, 0x3a (:)
};
// #27 59, 0x3b, (;)
static BYTE bits_ascii27[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,1,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #27 59, 0x3b (;)
};
// #28 60, 0x3c, (<)
static BYTE bits_ascii28[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,1,0,
 0,0,0,1,1,0,0,
 0,1,1,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,0,0,0,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #28 60, 0x3c (<)
};
// #29 61, 0x3d, (=)
static BYTE bits_ascii29[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #29 61, 0x3d (=)
};
// #30 62, 0x3e, (>)
static BYTE bits_ascii30[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,1,1,0,
 0,0,1,1,0,0,0,
 0,1,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #30 62, 0x3e (>)
};
// #31 63, 0x3f, (?)
static BYTE bits_ascii31[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,1,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #31 63, 0x3f (?)
};
// #32 64, 0x40, (@)
static BYTE bits_ascii32[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,1,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,0,1,1,0,
 0,1,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #32 64, 0x40 (@)
};
// #33 65, 0x41, (A)
static BYTE bits_ascii33[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 1,1,1,0,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #33 65, 0x41 (A)
};
// #34 66, 0x42, (B)
static BYTE bits_ascii34[] = {
 0,0,0,0,0,0,0,
 1,1,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #34 66, 0x42 (B)
};
// #35 67, 0x43, (C)
static BYTE bits_ascii35[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #35 67, 0x43 (C)
};
// #36 68, 0x44, (D)
static BYTE bits_ascii36[] = {
 0,0,0,0,0,0,0,
 1,1,1,1,0,0,0,
 0,1,0,0,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,1,0,0,
 1,1,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #36 68, 0x44 (D)
};
// #37 69, 0x45, (E)
static BYTE bits_ascii37[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,1,0,0,1,0,
 0,0,1,0,1,0,0,
 0,0,1,1,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,0,1,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #37 69, 0x45 (E)
};
// #38 70, 0x46, (F)
static BYTE bits_ascii38[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,1,0,0,1,0,
 0,0,1,0,1,0,0,
 0,0,1,1,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,0,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #38 70, 0x46 (F)
};
// #39 71, 0x47, (G)
static BYTE bits_ascii39[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,0,1,1,1,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #39 71, 0x47 (G)
};
// #40 72, 0x48, (H)
static BYTE bits_ascii40[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,0,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #40 72, 0x48 (H)
};
// #41 73, 0x49, (I)
static BYTE bits_ascii41[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #41 73, 0x49 (I)
};
// #42 74, 0x4a, (J)
static BYTE bits_ascii42[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,1,0,0,1,0,0,
 0,1,0,0,1,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #42 74, 0x4a (J)
};
// #43 75, 0x4b, (K)
static BYTE bits_ascii43[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,1,0,0,1,0,0,
 0,1,0,0,0,1,0,
 1,1,1,0,0,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #43 75, 0x4b (K)
};
// #44 76, 0x4c, (L)
static BYTE bits_ascii44[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,1,0,
 0,0,1,0,0,1,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #44 76, 0x4c (L)
};
// #45 77, 0x4d, (M)
static BYTE bits_ascii45[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,1,0,1,1,0,
 0,1,1,0,1,1,0,
 0,1,0,1,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,0,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #45 77, 0x4d (M)
};
// #46 78, 0x4e, (N)
static BYTE bits_ascii46[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,1,0,0,1,0,
 0,1,1,0,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,0,1,1,0,
 1,1,1,0,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #46 78, 0x4e (N)
};
// #47 79, 0x4f, (O)
static BYTE bits_ascii47[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #47 79, 0x4f (O)
};
// #48 80, 0x50, (P)
static BYTE bits_ascii48[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,0,0,
 0,0,1,0,0,1,0,
 0,0,1,0,0,1,0,
 0,0,1,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,1,0,0,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #48 80, 0x50 (P)
};
// #49 81, 0x51, (Q)
static BYTE bits_ascii49[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #49 81, 0x51 (Q)
};
// #50 82, 0x52, (R)
static BYTE bits_ascii50[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,0,0,
 0,0,1,0,0,1,0,
 0,0,1,0,0,1,0,
 0,0,1,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,1,0,0,1,0,
 0,1,1,1,0,0,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #50 82, 0x52 (R)
};
// #51 83, 0x53, (S)
static BYTE bits_ascii51[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,1,0,
 0,1,0,0,1,1,0,
 0,1,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #51 83, 0x53 (S)
};
// #52 84, 0x54, (T)
static BYTE bits_ascii52[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,1,0,1,0,1,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #52 84, 0x54 (T)
};
// #53 85, 0x55, (U)
static BYTE bits_ascii53[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #53 85, 0x55 (U)
};
// #54 86, 0x56, (V)
static BYTE bits_ascii54[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #54 86, 0x56 (V)
};
// #55 87, 0x57, (W)
static BYTE bits_ascii55[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,0,1,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #55 87, 0x57 (W)
};
// #56 88, 0x58, (X)
static BYTE bits_ascii56[] = {
 0,0,0,0,0,0,0,
 1,1,0,0,0,1,1,
 0,1,0,0,0,1,0,
 0,0,1,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,1,0,0,0,1,0,
 1,1,0,0,0,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #56 88, 0x58 (X)
};
// #57 89, 0x59, (Y)
static BYTE bits_ascii57[] = {
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,0,1,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #57 89, 0x59 (Y)
};
// #58 90, 0x5a, (Z)
static BYTE bits_ascii58[] = {
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #58 90, 0x5a (Z)
};
// #59 91, 0x5b, ([)
static BYTE bits_ascii59[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #59 91, 0x5b ([)
};
// #60 92, 0x5c, (\)
static BYTE bits_ascii60[] = {
 0,0,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #60 92, 0x5c (\)
};
// #61 93, 0x5d, (])
static BYTE bits_ascii61[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #61 93, 0x5d (])
};
// #62 94, 0x5e, (^)
static BYTE bits_ascii62[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,1,0,0,0,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #62 94, 0x5e (^)
};
// #63 95, 0x5f, (_)
static BYTE bits_ascii63[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,1,1,1,1,1  // end #63 95, 0x5f (_)
};
// #64 96, 0x60, (`)
static BYTE bits_ascii64[] = {
 0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #64 96, 0x60 (`)
};
// #65 97, 0x61, (a)
static BYTE bits_ascii65[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #65 97, 0x61 (a)
};
// #66 98, 0x62, (b)
static BYTE bits_ascii66[] = {
 0,0,0,0,0,0,0,
 1,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,1,1,0,0,
 0,1,1,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #66 98, 0x62 (b)
};
// #67 99, 0x63, (c)
static BYTE bits_ascii67[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #67 99, 0x63 (c)
};
// #68 100, 0x64, (d)
static BYTE bits_ascii68[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,1,0,
 0,0,0,0,0,1,0,
 0,0,1,1,0,1,0,
 0,1,0,0,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #68 100, 0x64 (d)
};
// #69 101, 0x65, (e)
static BYTE bits_ascii69[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,1,0,
 0,1,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #69 101, 0x65 (e)
};
// #70 102, 0x66, (f)
static BYTE bits_ascii70[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,1,0,
 0,0,0,1,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #70 102, 0x66 (f)
};
// #71 103, 0x67, (g)
static BYTE bits_ascii71[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,1,1,
 0,1,0,0,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0  // end #71 103, 0x67 (g)
};
// #72 104, 0x68, (h)
static BYTE bits_ascii72[] = {
 0,0,0,0,0,0,0,
 1,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,1,1,0,0,
 0,1,1,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,0,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #72 104, 0x68 (h)
};
// #73 105, 0x69, (i)
static BYTE bits_ascii73[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #73 105, 0x69 (i)
};
// #74 106, 0x6a, (j)
static BYTE bits_ascii74[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0  // end #74 106, 0x6a (j)
};
// #75 107, 0x6b, (k)
static BYTE bits_ascii75[] = {
 0,0,0,0,0,0,0,
 1,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,1,1,1,0,
 0,1,0,0,1,0,0,
 0,1,1,1,0,0,0,
 0,1,0,0,1,0,0,
 1,1,0,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #75 107, 0x6b (k)
};
// #76 108, 0x6c, (l)
static BYTE bits_ascii76[] = {
 0,0,0,0,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #76 108, 0x6c (l)
};
// #77 109, 0x6d, (m)
static BYTE bits_ascii77[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,1,0,1,0,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 1,1,1,1,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #77 109, 0x6d (m)
};
// #78 110, 0x6e, (n)
static BYTE bits_ascii78[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,0,1,1,0,0,
 0,1,1,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 1,1,1,0,1,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #78 110, 0x6e (n)
};
// #79 111, 0x6f, (o)
static BYTE bits_ascii79[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #79 111, 0x6f (o)
};
// #80 112, 0x70, (p)
static BYTE bits_ascii80[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,0,1,1,0,0,
 0,1,1,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,1,1,1,0,0,
 0,1,0,0,0,0,0,
 1,1,1,0,0,0,0,
 0,0,0,0,0,0,0  // end #80 112, 0x70 (p)
};
// #81 113, 0x71, (q)
static BYTE bits_ascii81[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,1,1,
 0,1,0,0,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,1,0,
 0,0,0,0,0,1,0,
 0,0,0,0,1,1,1,
 0,0,0,0,0,0,0  // end #81 113, 0x71 (q)
};
// #82 114, 0x72, (r)
static BYTE bits_ascii82[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,0,1,1,0,
 0,0,1,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,1,0,0,0,0,
 0,1,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #82 114, 0x72 (r)
};
// #83 115, 0x73, (s)
static BYTE bits_ascii83[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,1,1,0,
 0,1,0,0,0,0,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,1,0,
 0,1,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #83 115, 0x73 (s)
};
// #84 116, 0x74, (t)
static BYTE bits_ascii84[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,0,0,0,0,0,
 1,1,1,1,1,0,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,0,0,
 0,1,0,0,0,1,0,
 0,0,1,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #84 116, 0x74 (t)
};
// #85 117, 0x75, (u)
static BYTE bits_ascii85[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,0,0,1,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,0,1,0,
 0,1,0,0,1,1,0,
 0,0,1,1,0,1,1,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #85 117, 0x75 (u)
};
// #86 118, 0x76, (v)
static BYTE bits_ascii86[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,1,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #86 118, 0x76 (v)
};
// #87 119, 0x77, (w)
static BYTE bits_ascii87[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,1,0,1,0,1,0,
 0,1,0,1,0,1,0,
 0,0,1,0,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #87 119, 0x77 (w)
};
// #88 120, 0x78, (x)
static BYTE bits_ascii88[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,0,1,1,0,
 0,0,1,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,1,0,0,
 0,1,1,0,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #88 120, 0x78 (x)
};
// #89 121, 0x79, (y)
static BYTE bits_ascii89[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 1,1,1,0,1,1,1,
 0,1,0,0,0,1,0,
 0,0,1,0,1,0,0,
 0,0,1,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,1,1,1,0,0,0,
 0,0,0,0,0,0,0  // end #89 121, 0x79 (y)
};
// #90 122, 0x7a, (z)
static BYTE bits_ascii90[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,1,1,1,1,1,0,
 0,1,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,1,0,
 0,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #90 122, 0x7a (z)
};
// #91 123, 0x7b, ({)
static BYTE bits_ascii91[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,1,0,0,
 0,0,0,0,0,0,0  // end #91 123, 0x7b ({)
};
// #92 124, 0x7c, (|)
static BYTE bits_ascii92[] = {
 0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #92 124, 0x7c (|)
};
// #93 125, 0x7d, (})
static BYTE bits_ascii93[] = {
 0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,1,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,0,1,0,0,0,
 0,0,1,0,0,0,0,
 0,0,0,0,0,0,0  // end #93 125, 0x7d (})
};
// #94 126, 0x7e, (~)
static BYTE bits_ascii94[] = {
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,1,1,0,1,0,
 0,1,0,1,1,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #94 126, 0x7e (~)
};
// #95 127, 0x7f, ()
static BYTE bits_ascii95[] = {
 0,0,0,0,0,0,0,
 1,1,1,1,1,1,0,
 1,0,0,0,0,1,0,
 1,0,0,0,0,1,0,
 1,0,0,0,0,1,0,
 1,0,0,0,0,1,0,
 1,0,0,0,0,1,0,
 1,1,1,1,1,1,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,
 0,0,0,0,0,0,0  // end #95 127, 0x7f ()
};
// Array of ASCII blocks
static PBYTE ascci_array[] = {
 bits_ascii0,  // 32 0x20 ( )
 bits_ascii1,  // 33 0x21 (!)
 bits_ascii2,  // 34 0x22 (")
 bits_ascii3,  // 35 0x23 (#)
 bits_ascii4,  // 36 0x24 ($)
 bits_ascii5,  // 37 0x25 (%)
 bits_ascii6,  // 38 0x26 (&)
 bits_ascii7,  // 39 0x27 (')
 bits_ascii8,  // 40 0x28 (()
 bits_ascii9,  // 41 0x29 ())
 bits_ascii10,  // 42 0x2a (*)
 bits_ascii11,  // 43 0x2b (+)
 bits_ascii12,  // 44 0x2c (,)
 bits_ascii13,  // 45 0x2d (-)
 bits_ascii14,  // 46 0x2e (.)
 bits_ascii15,  // 47 0x2f (/)
 bits_ascii16,  // 48 0x30 (0)
 bits_ascii17,  // 49 0x31 (1)
 bits_ascii18,  // 50 0x32 (2)
 bits_ascii19,  // 51 0x33 (3)
 bits_ascii20,  // 52 0x34 (4)
 bits_ascii21,  // 53 0x35 (5)
 bits_ascii22,  // 54 0x36 (6)
 bits_ascii23,  // 55 0x37 (7)
 bits_ascii24,  // 56 0x38 (8)
 bits_ascii25,  // 57 0x39 (9)
 bits_ascii26,  // 58 0x3a (:)
 bits_ascii27,  // 59 0x3b (;)
 bits_ascii28,  // 60 0x3c (<)
 bits_ascii29,  // 61 0x3d (=)
 bits_ascii30,  // 62 0x3e (>)
 bits_ascii31,  // 63 0x3f (?)
 bits_ascii32,  // 64 0x40 (@)
 bits_ascii33,  // 65 0x41 (A)
 bits_ascii34,  // 66 0x42 (B)
 bits_ascii35,  // 67 0x43 (C)
 bits_ascii36,  // 68 0x44 (D)
 bits_ascii37,  // 69 0x45 (E)
 bits_ascii38,  // 70 0x46 (F)
 bits_ascii39,  // 71 0x47 (G)
 bits_ascii40,  // 72 0x48 (H)
 bits_ascii41,  // 73 0x49 (I)
 bits_ascii42,  // 74 0x4a (J)
 bits_ascii43,  // 75 0x4b (K)
 bits_ascii44,  // 76 0x4c (L)
 bits_ascii45,  // 77 0x4d (M)
 bits_ascii46,  // 78 0x4e (N)
 bits_ascii47,  // 79 0x4f (O)
 bits_ascii48,  // 80 0x50 (P)
 bits_ascii49,  // 81 0x51 (Q)
 bits_ascii50,  // 82 0x52 (R)
 bits_ascii51,  // 83 0x53 (S)
 bits_ascii52,  // 84 0x54 (T)
 bits_ascii53,  // 85 0x55 (U)
 bits_ascii54,  // 86 0x56 (V)
 bits_ascii55,  // 87 0x57 (W)
 bits_ascii56,  // 88 0x58 (X)
 bits_ascii57,  // 89 0x59 (Y)
 bits_ascii58,  // 90 0x5a (Z)
 bits_ascii59,  // 91 0x5b ([)
 bits_ascii60,  // 92 0x5c (\)
 bits_ascii61,  // 93 0x5d (])
 bits_ascii62,  // 94 0x5e (^)
 bits_ascii63,  // 95 0x5f (_)
 bits_ascii64,  // 96 0x60 (`)
 bits_ascii65,  // 97 0x61 (a)
 bits_ascii66,  // 98 0x62 (b)
 bits_ascii67,  // 99 0x63 (c)
 bits_ascii68,  // 100 0x64 (d)
 bits_ascii69,  // 101 0x65 (e)
 bits_ascii70,  // 102 0x66 (f)
 bits_ascii71,  // 103 0x67 (g)
 bits_ascii72,  // 104 0x68 (h)
 bits_ascii73,  // 105 0x69 (i)
 bits_ascii74,  // 106 0x6a (j)
 bits_ascii75,  // 107 0x6b (k)
 bits_ascii76,  // 108 0x6c (l)
 bits_ascii77,  // 109 0x6d (m)
 bits_ascii78,  // 110 0x6e (n)
 bits_ascii79,  // 111 0x6f (o)
 bits_ascii80,  // 112 0x70 (p)
 bits_ascii81,  // 113 0x71 (q)
 bits_ascii82,  // 114 0x72 (r)
 bits_ascii83,  // 115 0x73 (s)
 bits_ascii84,  // 116 0x74 (t)
 bits_ascii85,  // 117 0x75 (u)
 bits_ascii86,  // 118 0x76 (v)
 bits_ascii87,  // 119 0x77 (w)
 bits_ascii88,  // 120 0x78 (x)
 bits_ascii89,  // 121 0x79 (y)
 bits_ascii90,  // 122 0x7a (z)
 bits_ascii91,  // 123 0x7b ({)
 bits_ascii92,  // 124 0x7c (|)
 bits_ascii93,  // 125 0x7d (})
 bits_ascii94,  // 126 0x7e (~)
 bits_ascii95  // 127 0x7f ()
};

// In 7 x 11 bits, as a fixed font size, small
// PBYTE Get_Char_Bit_Array( char c );   // from space(32) to tilde(126)
// returns a 'block' if OUT OF RANGE
PBYTE Get_Char_Bit_Array( char c )
{
   if(( c >= ' ' )&&( c < 128)) {
      c -= ' ';
      return ascci_array[c];
   }
   return bits_ascii95;
}

void Get_Char_Bit_Size( PINT px, PINT py )
{
   *px = 7;
   *py = 11;
}

// =========== color map - standard color map ===

BYTE Std_Color_Map[256*4] = {
     0,  0,  0,  0, //   0
     0,  0, 51,  0, //   1
     0,  0,102,  0, //   2
     0,  0,153,  0, //   3
     0,  0,204,  0, //   4
     0,  0,255,  0, //   5
     0, 51,  0,  0, //   6
     0, 51, 51,  0, //   7
     0, 51,102,  0, //   8
     0, 51,153,  0, //   9
     0, 51,204,  0, //  10
     0, 51,255,  0, //  11
     0,102,  0,  0, //  12
     0,102, 51,  0, //  13
     0,102,102,  0, //  14
     0,102,153,  0, //  15
     0,102,204,  0, //  16
     0,102,255,  0, //  17
     0,153,  0,  0, //  18
     0,153, 51,  0, //  19
     0,153,102,  0, //  20
     0,153,153,  0, //  21
     0,153,204,  0, //  22
     0,153,255,  0, //  23
     0,204,  0,  0, //  24
     0,204, 51,  0, //  25
     0,204,102,  0, //  26
     0,204,153,  0, //  27
     0,204,204,  0, //  28
     0,204,255,  0, //  29
     0,255,  0,  0, //  30
     0,255, 51,  0, //  31
     0,255,102,  0, //  32
     0,255,153,  0, //  33
     0,255,204,  0, //  34
     0,255,255,  0, //  35
    51,  0,  0,  0, //  36
    51,  0, 51,  0, //  37
    51,  0,102,  0, //  38
    51,  0,153,  0, //  39
    51,  0,204,  0, //  40
    51,  0,255,  0, //  41
    51, 51,  0,  0, //  42
    51, 51, 51,  0, //  43
    51, 51,102,  0, //  44
    51, 51,153,  0, //  45
    51, 51,204,  0, //  46
    51, 51,255,  0, //  47
    51,102,  0,  0, //  48
    51,102, 51,  0, //  49
    51,102,102,  0, //  50
    51,102,153,  0, //  51
    51,102,204,  0, //  52
    51,102,255,  0, //  53
    51,153,  0,  0, //  54
    51,153, 51,  0, //  55
    51,153,102,  0, //  56
    51,153,153,  0, //  57
    51,153,204,  0, //  58
    51,153,255,  0, //  59
    51,204,  0,  0, //  60
    51,204, 51,  0, //  61
    51,204,102,  0, //  62
    51,204,153,  0, //  63
    51,204,204,  0, //  64
    51,204,255,  0, //  65
    51,255,  0,  0, //  66
    51,255, 51,  0, //  67
    51,255,102,  0, //  68
    51,255,153,  0, //  69
    51,255,204,  0, //  70
    51,255,255,  0, //  71
   102,  0,  0,  0, //  72
   102,  0, 51,  0, //  73
   102,  0,102,  0, //  74
   102,  0,153,  0, //  75
   102,  0,204,  0, //  76
   102,  0,255,  0, //  77
   102, 51,  0,  0, //  78
   102, 51, 51,  0, //  79
   102, 51,102,  0, //  80
   102, 51,153,  0, //  81
   102, 51,204,  0, //  82
   102, 51,255,  0, //  83
   102,102,  0,  0, //  84
   102,102, 51,  0, //  85
   102,102,102,  0, //  86
   102,102,153,  0, //  87
   102,102,204,  0, //  88
   102,102,255,  0, //  89
   102,153,  0,  0, //  90
   102,153, 51,  0, //  91
   102,153,102,  0, //  92
   102,153,153,  0, //  93
   102,153,204,  0, //  94
   102,153,255,  0, //  95
   102,204,  0,  0, //  96
   102,204, 51,  0, //  97
   102,204,102,  0, //  98
   102,204,153,  0, //  99
   102,204,204,  0, // 100
   102,204,255,  0, // 101
   102,255,  0,  0, // 102
   102,255, 51,  0, // 103
   102,255,102,  0, // 104
   102,255,153,  0, // 105
   102,255,204,  0, // 106
   102,255,255,  0, // 107
   153,  0,  0,  0, // 108
   153,  0, 51,  0, // 109
   153,  0,102,  0, // 110
   153,  0,153,  0, // 111
   153,  0,204,  0, // 112
   153,  0,255,  0, // 113
   153, 51,  0,  0, // 114
   153, 51, 51,  0, // 115
   153, 51,102,  0, // 116
   153, 51,153,  0, // 117
   153, 51,204,  0, // 118
   153, 51,255,  0, // 119
   153,102,  0,  0, // 120
   153,102, 51,  0, // 121
   153,102,102,  0, // 122
   153,102,153,  0, // 123
   153,102,204,  0, // 124
   153,102,255,  0, // 125
   153,153,  0,  0, // 126
   153,153, 51,  0, // 127
   153,153,102,  0, // 128
   153,153,153,  0, // 129
   153,153,204,  0, // 130
   153,153,255,  0, // 131
   153,204,  0,  0, // 132
   153,204, 51,  0, // 133
   153,204,102,  0, // 134
   153,204,153,  0, // 135
   153,204,204,  0, // 136
   153,204,255,  0, // 137
   153,255,  0,  0, // 138
   153,255, 51,  0, // 139
   153,255,102,  0, // 140
   153,255,153,  0, // 141
   153,255,204,  0, // 142
   153,255,255,  0, // 143
   204,  0,  0,  0, // 144
   204,  0, 51,  0, // 145
   204,  0,102,  0, // 146
   204,  0,153,  0, // 147
   204,  0,204,  0, // 148
   204,  0,255,  0, // 149
   204, 51,  0,  0, // 150
   204, 51, 51,  0, // 151
   204, 51,102,  0, // 152
   204, 51,153,  0, // 153
   204, 51,204,  0, // 154
   204, 51,255,  0, // 155
   204,102,  0,  0, // 156
   204,102, 51,  0, // 157
   204,102,102,  0, // 158
   204,102,153,  0, // 159
   204,102,204,  0, // 160
   204,102,255,  0, // 161
   204,153,  0,  0, // 162
   204,153, 51,  0, // 163
   204,153,102,  0, // 164
   204,153,153,  0, // 165
   204,153,204,  0, // 166
   204,153,255,  0, // 167
   204,204,  0,  0, // 168
   204,204, 51,  0, // 169
   204,204,102,  0, // 170
   204,204,153,  0, // 171
   204,204,204,  0, // 172
   204,204,255,  0, // 173
   204,255,  0,  0, // 174
   204,255, 51,  0, // 175
   204,255,102,  0, // 176
   204,255,153,  0, // 177
   204,255,204,  0, // 178
   204,255,255,  0, // 179
   255,  0,  0,  0, // 180
   255,  0, 51,  0, // 181
   255,  0,102,  0, // 182
   255,  0,153,  0, // 183
   255,  0,204,  0, // 184
   255,  0,255,  0, // 185
   255, 51,  0,  0, // 186
   255, 51, 51,  0, // 187
   255, 51,102,  0, // 188
   255, 51,153,  0, // 189
   255, 51,204,  0, // 190
   255, 51,255,  0, // 191
   255,102,  0,  0, // 192
   255,102, 51,  0, // 193
   255,102,102,  0, // 194
   255,102,153,  0, // 195
   255,102,204,  0, // 196
   255,102,255,  0, // 197
   255,153,  0,  0, // 198
   255,153, 51,  0, // 199
   255,153,102,  0, // 200
   255,153,153,  0, // 201
   255,153,204,  0, // 202
   255,153,255,  0, // 203
   255,204,  0,  0, // 204
   255,204, 51,  0, // 205
   255,204,102,  0, // 206
   255,204,153,  0, // 207
   255,204,204,  0, // 208
   255,204,255,  0, // 209
   255,255,  0,  0, // 210
   255,255, 51,  0, // 211
   255,255,102,  0, // 212
   255,255,153,  0, // 213
   255,255,204,  0, // 214
   255,255,255,  0, // 215
     0, 50,  0,  0, // 216
     0, 50,  0,  0, // 217
     0, 50,  0,  0, // 218
     0, 50,  0,  0, // 219
     0, 50,  0,  0, // 220
     0, 50,  0,  0, // 221
     0, 50,  0,  0, // 222
     0, 50,  0,  0, // 223
     0, 50,  0,  0, // 224
     0, 50,  0,  0, // 225
     0, 50,  0,  0, // 226
     0, 50,  0,  0, // 227
     0, 50,  0,  0, // 228
     0, 50,  0,  0, // 229
     0, 50,  0,  0, // 230
     0, 50,  0,  0, // 231
     0, 50,  0,  0, // 232
     0, 50,  0,  0, // 233
     0, 50,  0,  0, // 234
     0, 50,  0,  0, // 235
     0, 50,  0,  0, // 236
     0, 50,  0,  0, // 237
     0, 50,  0,  0, // 238
     0, 50,  0,  0, // 239
     0, 50,  0,  0, // 240
     0, 50,  0,  0, // 241
     0, 50,  0,  0, // 242
     0, 50,  0,  0, // 243
     0, 50,  0,  0, // 244
     0, 50,  0,  0, // 245
     0, 50,  0,  0, // 246
     0, 50,  0,  0, // 247
     0, 50,  0,  0, // 248
     0, 50,  0,  0, // 249
     0, 50,  0,  0, // 250
     0, 50,  0,  0, // 251
     0, 50,  0,  0, // 252
     0, 50,  0,  0, // 253
     0, 50,  0,  0, // 254
     0, 50,  0,  0, // 255
};

PBYTE Get_Std_Map( void )
{
   return Std_Color_Map;
}

// ==============================================

typedef enum tagCLRREFIND {
   CRI_BLACK = 0,
   CRI_DARKBLUE,
   CRI_DARKGREEN,
   CRI_DARKCYAN,
   CRI_DARKRED,
   CRI_DARKMAGENTA,
   CRI_LIGHTGRAY,
   CRI_GRAY,
   CRI_BLUE,
   CRI_GREEN,
   CRI_BLUEGREEN,
   CRI_RED,
   CRI_REDBLUE,
   CRI_REDGREEN,
   CRI_WHITE
}CLRREFIND;

COLORREF	ColorRef[16] = {
	{ RGB(  0,  0,  0) },	// 00 = BLACK
	{ RGB(  0,  0,128) },
	{ RGB(  0,128,  0) },
	{ RGB(  0,128,128) },
	{ RGB(128,  0,  0) },
	{ RGB(128,  0,128) },
	{ RGB(128,128,  0) },
	{ RGB(192,192,192) },	// 07 = GRAY
	{ RGB(128,128,128) },
	{ RGB(  0,  0,255) },	// 09 = BLUE
	{ RGB(  0,255,  0) },	// 10 = GREEN
	{ RGB(  0,255,255) },
	{ RGB(255,  0,  0) },	// 12 = RED
	{ RGB(255,  0,255) },
	{ RGB(255,255,  0) },
	{ RGB(255,255,255) }	// 15 = WHITE
};

// eof - gshhs_data.c
