// gshhs_color.c

#include "gshhs_win.h"

void Get_Pixel_Color( PGSINFO pgsi, BYTE cb, PBYTE pind,
                     PBYTE pr, PBYTE pg, PBYTE pb,
                     int nBPP )
{
   int ind = WHITE_IND;
   BYTE r = 255;
   BYTE g = 255;
   BYTE b = 255;
   switch(nBPP)
   {
   case 8:
      *pind = cb;
      break;
   case 4:
   case 24:
      switch(cb)
      {
      case BMC_GREEN:
         r = 0;
         g = 255;
         b = 0;
         ind = GREEN_IND;
         break;
      case BMC_BLUE:
         r = 0;
         g = 0;
         b = 255;
         ind = BLUE_IND;
         break;
      case BMC_RED:
         r = 255;
         g = 0;
         b = 0;
         ind = RED_IND;    // set RED
         break;
      case BMC_GRAY:
         r = 190;
         g = 190;
         b = 190;
         ind = GRAY_IND;   // set GRAY
         break;
      case BMC_BLACK:
         r = 0;
         g = 0;
         b = 0;
         ind = BLACK_IND;
         break;
      case BMC_BROWN:
         r = 0x8b;
         g = 0x45;
         b = 0x13;
         ind = BROWN_IND;
         break;
      }
      break;
   }
   *pind = ind;
   *pr = r;
   *pg = g;
   *pb = b;
}

void Set_Next_Color( PGSINFO pgsi )
{
   BYTE b = pgsi->def_bmc; 
   switch(b)
   {
   case BMC_BLACK:
      pgsi->def_bmc = BMC_BLUE;
      break;
   case BMC_BLUE:
      pgsi->def_bmc = BMC_BROWN;
      break;
   case BMC_BROWN:
      pgsi->def_bmc = BMC_BLACK;
      break;
   }
   pgsi->overwrite = 0; // clear the OVERWRITE flag
}

void Set_BMP_Color_Index( RGBQUAD * prq )
{
   // #define  WHITE_IND      0
   prq[WHITE_IND].rgbBlue  = 0xff;
   prq[WHITE_IND].rgbGreen = 0xff;
   prq[WHITE_IND].rgbRed   = 0xff;

   prq[BLUE_IND].rgbBlue  = 0xff;
   prq[BLUE_IND].rgbGreen = 0;
   prq[BLUE_IND].rgbRed   = 0;

   prq[RED_IND].rgbBlue  = 0;
   prq[RED_IND].rgbGreen = 0;
   prq[RED_IND].rgbRed   = 0xff;

   //#define  GREEN_IND      3
   prq[GREEN_IND].rgbBlue  = 0;
   prq[GREEN_IND].rgbGreen = 0xff;
   prq[GREEN_IND].rgbRed   = 0;

   //#define  BROWN_IND      4
   prq[BROWN_IND].rgbBlue  = 0x13;
   prq[BROWN_IND].rgbGreen = 0x45;
   prq[BROWN_IND].rgbRed   = 0x8b;

   //#define  GRAY_IND       9
   prq[GRAY_IND].rgbBlue  = 190;
   prq[GRAY_IND].rgbGreen = 190;
   prq[GRAY_IND].rgbRed   = 190;

   // #define  BLACK_IND      15
   prq[BLACK_IND].rgbBlue  = 0;
   prq[BLACK_IND].rgbGreen = 0;
   prq[BLACK_IND].rgbRed   = 0;

}

void Set_BMP_Color( RGBQUAD * ppal )
{
   ppal[BMC_WHITE].rgbBlue  = 255;
   ppal[BMC_WHITE].rgbGreen = 255;
   ppal[BMC_WHITE].rgbRed   = 255;

   ppal[BMC_BLACK].rgbBlue  = 0;
   ppal[BMC_BLACK].rgbGreen = 0;
   ppal[BMC_BLACK].rgbRed   = 0;

   ppal[BMC_GRAY].rgbBlue  = 190;
   ppal[BMC_GRAY].rgbGreen = 190;
   ppal[BMC_GRAY].rgbRed   = 190;

   ppal[BMC_RED].rgbBlue  = 0;
   ppal[BMC_RED].rgbGreen = 0;
   ppal[BMC_RED].rgbRed   = 255;

   ppal[BMC_BLUE].rgbBlue  = 255;
   ppal[BMC_BLUE].rgbGreen = 0;
   ppal[BMC_BLUE].rgbRed   = 0;

   ppal[BMC_GREEN].rgbBlue  = 0;
   ppal[BMC_GREEN].rgbGreen = 255;
   ppal[BMC_GREEN].rgbRed   = 0;

   //#define  BROWN_IND      4
   ppal[BROWN_IND].rgbBlue  = 0x13;
   ppal[BROWN_IND].rgbGreen = 0x45;
   ppal[BROWN_IND].rgbRed   = 0x8b;

}

void Set_BMP_1BPP( RGBQUAD * prq ) // in gshhs_color.c
{
   prq[0].rgbBlue     = 255;
   prq[0].rgbGreen    = 255;
   prq[0].rgbRed      = 255;
   prq[0].rgbReserved = 0;
   prq[1].rgbBlue     = 0;
   prq[1].rgbGreen    = 0;
   prq[1].rgbRed      = 0;
   prq[1].rgbReserved = 0;
}

void Set_BMP_4BPP( RGBQUAD * prq )
{
   int i;
   BYTE s;
   BYTE sc = 17;
   for( i = 0; i < 16; i++ )
   {
      s = (sc * (15 - i));
      prq[i].rgbBlue     = s;
      prq[i].rgbGreen    = s;
      prq[i].rgbRed      = s;
      prq[i].rgbReserved = 0;
   }

   Set_BMP_Color_Index( prq );
}

void Set_BMP_8BPP( RGBQUAD * ppal )
{
   Set_BMP_Color( ppal );
}


// eof - gshhs_color.c
