//
// "$Id: function_panel.cxx 6302 2008-09-18 21:11:28Z matt $"
//
// Code dialogs for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2005 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems on the following page:
//
//     http://www.fltk.org/str.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "function_panel.h"
#include <FL/Fl_Pixmap.H>
#include "Fl_Type.h"
#include "undo.h"
extern class Fl_Pixmap *pixmap[];
extern class Fl_Type *Fl_Type_make(const char*);
extern void select_only(Fl_Type*);

Fl_Double_Window *function_panel=(Fl_Double_Window *)0;

Fl_Choice *f_public_member_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_f_public_member_choice[] = {
 {"private", 0,  0, (void*)(0), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, (void*)(1), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, (void*)(2), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *f_public_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_f_public_choice[] = {
 {"local", 0,  0, (void*)(0), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"global", 0,  0, (void*)(1), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Light_Button *f_c_button=(Fl_Light_Button *)0;

Fl_Input *f_name_input=(Fl_Input *)0;

Fl_Input *f_return_type_input=(Fl_Input *)0;

Fl_Return_Button *f_panel_ok=(Fl_Return_Button *)0;

Fl_Button *f_panel_cancel=(Fl_Button *)0;

Fl_Text_Editor *f_comment_input=(Fl_Text_Editor *)0;

Fl_Double_Window* make_function_panel() {
  { function_panel = new Fl_Double_Window(343, 232, "Function/Method Properties");
    { Fl_Group* o = new Fl_Group(10, 10, 270, 20);
      { f_public_member_choice = new Fl_Choice(10, 10, 75, 20);
        f_public_member_choice->tooltip("Change member access attribute.");
        f_public_member_choice->down_box(FL_BORDER_BOX);
        f_public_member_choice->labelsize(11);
        f_public_member_choice->textsize(11);
        f_public_member_choice->when(FL_WHEN_CHANGED);
        f_public_member_choice->menu(menu_f_public_member_choice);
      } // Fl_Choice* f_public_member_choice
      { f_public_choice = new Fl_Choice(10, 10, 75, 20);
        f_public_choice->tooltip("Change widget accessibility.");
        f_public_choice->down_box(FL_BORDER_BOX);
        f_public_choice->labelsize(11);
        f_public_choice->textsize(11);
        f_public_choice->when(FL_WHEN_CHANGED);
        f_public_choice->menu(menu_f_public_choice);
      } // Fl_Choice* f_public_choice
      { f_c_button = new Fl_Light_Button(95, 10, 80, 20, "C declaration");
        f_c_button->tooltip("Declare with a C interface instead of C++.");
        f_c_button->labelsize(11);
      } // Fl_Light_Button* f_c_button
      { Fl_Box* o = new Fl_Box(235, 10, 45, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { f_name_input = new Fl_Input(10, 50, 320, 20, "Name(args): (blank for main())");
      f_name_input->tooltip("The name of the function or method.");
      f_name_input->labelfont(1);
      f_name_input->labelsize(11);
      f_name_input->textfont(4);
      f_name_input->textsize(11);
      f_name_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      f_name_input->when(FL_WHEN_NEVER);
    } // Fl_Input* f_name_input
    { f_return_type_input = new Fl_Input(10, 90, 320, 20, "Return Type: (blank to return outermost widget)");
      f_return_type_input->tooltip("The return type of the function or method.");
      f_return_type_input->labelfont(1);
      f_return_type_input->labelsize(11);
      f_return_type_input->textfont(4);
      f_return_type_input->textsize(11);
      f_return_type_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      f_return_type_input->when(FL_WHEN_NEVER);
    } // Fl_Input* f_return_type_input
    { Fl_Group* o = new Fl_Group(10, 200, 320, 20);
      { f_panel_ok = new Fl_Return_Button(220, 200, 50, 20, "OK");
        f_panel_ok->tooltip("Apply the changes.");
        f_panel_ok->labelsize(11);
        f_panel_ok->window()->hotspot(f_panel_ok);
      } // Fl_Return_Button* f_panel_ok
      { f_panel_cancel = new Fl_Button(280, 200, 50, 20, "Cancel");
        f_panel_cancel->tooltip("Cancel the changes.");
        f_panel_cancel->shortcut(0xff1b);
        f_panel_cancel->labelsize(11);
      } // Fl_Button* f_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 200, 205, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { f_comment_input = new Fl_Text_Editor(10, 125, 320, 65, "Comment:");
      f_comment_input->tooltip("Function comment in Doxygen format");
      f_comment_input->box(FL_DOWN_BOX);
      f_comment_input->labelfont(1);
      f_comment_input->labelsize(11);
      f_comment_input->textfont(4);
      f_comment_input->textsize(11);
      f_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(f_comment_input);
      f_comment_input->buffer(new Fl_Text_Buffer());
    } // Fl_Text_Editor* f_comment_input
    function_panel->set_modal();
    function_panel->end();
  } // Fl_Double_Window* function_panel
  return function_panel;
}

Fl_Double_Window *code_panel=(Fl_Double_Window *)0;

CodeEditor *code_input=(CodeEditor *)0;

Fl_Return_Button *code_panel_ok=(Fl_Return_Button *)0;

Fl_Button *code_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_code_panel() {
  { Fl_Double_Window* o = code_panel = new Fl_Double_Window(540, 180, "Code Properties");
    code_panel->labelsize(11);
    { CodeEditor* o = code_input = new CodeEditor(10, 10, 520, 130);
      code_input->box(FL_DOWN_BOX);
      code_input->color(FL_BACKGROUND2_COLOR);
      code_input->selection_color(FL_SELECTION_COLOR);
      code_input->labeltype(FL_NORMAL_LABEL);
      code_input->labelfont(0);
      code_input->labelsize(11);
      code_input->labelcolor(FL_FOREGROUND_COLOR);
      code_input->textfont(4);
      code_input->textsize(11);
      code_input->align(Fl_Align(FL_ALIGN_TOP));
      code_input->when(FL_WHEN_RELEASE);
      Fl_Group::current()->resizable(code_input);
      o->when(FL_WHEN_ENTER_KEY_CHANGED|FL_WHEN_RELEASE);
    } // CodeEditor* code_input
    { Fl_Group* o = new Fl_Group(10, 150, 520, 20);
      o->labelsize(11);
      { code_panel_ok = new Fl_Return_Button(400, 150, 60, 20, "OK");
        code_panel_ok->labelsize(11);
        code_panel_ok->window()->hotspot(code_panel_ok);
      } // Fl_Return_Button* code_panel_ok
      { code_panel_cancel = new Fl_Button(470, 150, 60, 20, "Cancel");
        code_panel_cancel->shortcut(0xff1b);
        code_panel_cancel->labelsize(11);
      } // Fl_Button* code_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 150, 380, 20);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    o->size_range(200, 150);
    code_panel->set_modal();
    code_panel->end();
  } // Fl_Double_Window* code_panel
  return code_panel;
}

Fl_Double_Window *codeblock_panel=(Fl_Double_Window *)0;

Fl_Input *code_before_input=(Fl_Input *)0;

Fl_Input *code_after_input=(Fl_Input *)0;

Fl_Return_Button *codeblock_panel_ok=(Fl_Return_Button *)0;

Fl_Button *codeblock_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_codeblock_panel() {
  { Fl_Double_Window* o = codeblock_panel = new Fl_Double_Window(300, 115, "Code Block Properties");
    codeblock_panel->labelsize(11);
    { code_before_input = new Fl_Input(10, 15, 280, 20, "Conditional code block");
      code_before_input->tooltip("#ifdef or similar conditional code block.");
      code_before_input->labelsize(11);
      code_before_input->textfont(4);
      code_before_input->textsize(11);
      code_before_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      code_before_input->when(FL_WHEN_NEVER);
    } // Fl_Input* code_before_input
    { code_after_input = new Fl_Input(10, 55, 280, 20, "\"{...child code...}\" is inserted here");
      code_after_input->tooltip("#endif or similar conditional code block.");
      code_after_input->labelsize(11);
      code_after_input->textfont(4);
      code_after_input->textsize(11);
      code_after_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      code_after_input->when(FL_WHEN_NEVER);
      Fl_Group::current()->resizable(code_after_input);
    } // Fl_Input* code_after_input
    { Fl_Group* o = new Fl_Group(10, 85, 280, 20);
      { codeblock_panel_ok = new Fl_Return_Button(160, 85, 60, 20, "OK");
        codeblock_panel_ok->labelsize(11);
        codeblock_panel_ok->window()->hotspot(codeblock_panel_ok);
      } // Fl_Return_Button* codeblock_panel_ok
      { codeblock_panel_cancel = new Fl_Button(230, 85, 60, 20, "Cancel");
        codeblock_panel_cancel->shortcut(0xff1b);
        codeblock_panel_cancel->labelsize(11);
      } // Fl_Button* codeblock_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 85, 140, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    o->size_range(o->w(), o->h(), Fl::w(), o->h());
    codeblock_panel->set_modal();
    codeblock_panel->end();
  } // Fl_Double_Window* codeblock_panel
  return codeblock_panel;
}

Fl_Double_Window *declblock_panel=(Fl_Double_Window *)0;

Fl_Choice *declblock_public_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_declblock_public_choice[] = {
 {"in source code only", 0,  0, (void*)(0), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"in header and source", 0,  0, (void*)(1), 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Light_Button *declblock_public_button_x=(Fl_Light_Button *)0;

Fl_Input *decl_before_input=(Fl_Input *)0;

Fl_Input *decl_after_input=(Fl_Input *)0;

Fl_Return_Button *declblock_panel_ok=(Fl_Return_Button *)0;

Fl_Button *declblock_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_declblock_panel() {
  { Fl_Double_Window* o = declblock_panel = new Fl_Double_Window(300, 135, "Declaration Block Properties");
    declblock_panel->labelsize(11);
    { Fl_Group* o = new Fl_Group(10, 10, 280, 20);
      { declblock_public_choice = new Fl_Choice(10, 10, 140, 20);
        declblock_public_choice->tooltip("Change widget accessibility.");
        declblock_public_choice->down_box(FL_BORDER_BOX);
        declblock_public_choice->labelsize(11);
        declblock_public_choice->textsize(11);
        declblock_public_choice->when(FL_WHEN_NEVER);
        declblock_public_choice->menu(menu_declblock_public_choice);
      } // Fl_Choice* declblock_public_choice
      { declblock_public_button_x = new Fl_Light_Button(10, 10, 60, 20, "public");
        declblock_public_button_x->tooltip("Make the declaration publicly accessible.");
        declblock_public_button_x->labelsize(11);
        declblock_public_button_x->when(FL_WHEN_NEVER);
        declblock_public_button_x->hide();
      } // Fl_Light_Button* declblock_public_button_x
      { Fl_Box* o = new Fl_Box(155, 10, 135, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { decl_before_input = new Fl_Input(10, 40, 280, 20);
      decl_before_input->tooltip("#ifdef or similar conditional declaration block.");
      decl_before_input->labelsize(11);
      decl_before_input->textfont(4);
      decl_before_input->textsize(11);
      decl_before_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      decl_before_input->when(FL_WHEN_NEVER);
      Fl_Group::current()->resizable(decl_before_input);
    } // Fl_Input* decl_before_input
    { decl_after_input = new Fl_Input(10, 75, 280, 20, "\"\\n...child code...\\n\" is inserted here");
      decl_after_input->tooltip("#endif or similar declaration code block.");
      decl_after_input->labelsize(11);
      decl_after_input->textfont(4);
      decl_after_input->textsize(11);
      decl_after_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      decl_after_input->when(FL_WHEN_NEVER);
    } // Fl_Input* decl_after_input
    { Fl_Group* o = new Fl_Group(10, 105, 280, 20);
      { declblock_panel_ok = new Fl_Return_Button(160, 105, 60, 20, "OK");
        declblock_panel_ok->labelsize(11);
        declblock_panel_ok->window()->hotspot(declblock_panel_ok);
      } // Fl_Return_Button* declblock_panel_ok
      { declblock_panel_cancel = new Fl_Button(230, 105, 60, 20, "Cancel");
        declblock_panel_cancel->shortcut(0xff1b);
        declblock_panel_cancel->labelsize(11);
      } // Fl_Button* declblock_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 105, 140, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    o->size_range(o->w(), o->h(), Fl::w(), o->h());
    declblock_panel->set_modal();
    declblock_panel->end();
  } // Fl_Double_Window* declblock_panel
  return declblock_panel;
}

Fl_Double_Window *decl_panel=(Fl_Double_Window *)0;

Fl_Choice *decl_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_decl_choice[] = {
 {"in source file only", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"in header file only", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"\"static\" in source file", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"in source and \"extern\" in header", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *decl_class_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_decl_class_choice[] = {
 {"private", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Input *decl_input=(Fl_Input *)0;

Fl_Return_Button *decl_panel_ok=(Fl_Return_Button *)0;

Fl_Button *decl_panel_cancel=(Fl_Button *)0;

Fl_Text_Editor *decl_comment_input=(Fl_Text_Editor *)0;

Fl_Double_Window* make_decl_panel() {
  { decl_panel = new Fl_Double_Window(343, 237, "Declaration Properties");
    decl_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(10, 10, 270, 20);
      { Fl_Box* o = new Fl_Box(200, 10, 80, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { decl_choice = new Fl_Choice(10, 10, 185, 20);
        decl_choice->down_box(FL_BORDER_BOX);
        decl_choice->labelsize(11);
        decl_choice->textsize(11);
        decl_choice->menu(menu_decl_choice);
      } // Fl_Choice* decl_choice
      { decl_class_choice = new Fl_Choice(10, 10, 75, 20);
        decl_class_choice->down_box(FL_BORDER_BOX);
        decl_class_choice->labelsize(11);
        decl_class_choice->textsize(11);
        decl_class_choice->menu(menu_decl_class_choice);
      } // Fl_Choice* decl_class_choice
      o->end();
    } // Fl_Group* o
    { decl_input = new Fl_Input(10, 40, 320, 20, "This can be any declaration, like \"int x;\", an external symbol like \"exter\
n int foo();\", a #directive like \"#include <foo.h>\", a comment like \"//foo\
\" or \"/*foo*/\", or typedef like \"typedef char byte;\" or \"using std::list\
;\".");
      decl_input->tooltip("Declaration text.");
      decl_input->labelsize(11);
      decl_input->textfont(4);
      decl_input->textsize(11);
      decl_input->align(Fl_Align(134));
      decl_input->when(FL_WHEN_NEVER);
    } // Fl_Input* decl_input
    { Fl_Group* o = new Fl_Group(10, 205, 320, 20);
      { decl_panel_ok = new Fl_Return_Button(200, 205, 60, 20, "OK");
        decl_panel_ok->labelsize(11);
        decl_panel_ok->window()->hotspot(decl_panel_ok);
      } // Fl_Return_Button* decl_panel_ok
      { decl_panel_cancel = new Fl_Button(270, 205, 60, 20, "Cancel");
        decl_panel_cancel->shortcut(0xff1b);
        decl_panel_cancel->labelsize(11);
      } // Fl_Button* decl_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 205, 185, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { decl_comment_input = new Fl_Text_Editor(10, 130, 320, 65, "Comment:");
      decl_comment_input->tooltip("Declaration comment in Doxygen format");
      decl_comment_input->box(FL_DOWN_BOX);
      decl_comment_input->labelfont(1);
      decl_comment_input->labelsize(11);
      decl_comment_input->textfont(4);
      decl_comment_input->textsize(11);
      decl_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(decl_comment_input);
      decl_comment_input->buffer(new Fl_Text_Buffer());
    } // Fl_Text_Editor* decl_comment_input
    decl_panel->size_range(343, 237);
    decl_panel->end();
  } // Fl_Double_Window* decl_panel
  return decl_panel;
}

Fl_Double_Window *class_panel=(Fl_Double_Window *)0;

Fl_Light_Button *c_public_button=(Fl_Light_Button *)0;

Fl_Input *c_name_input=(Fl_Input *)0;

Fl_Input *c_subclass_input=(Fl_Input *)0;

Fl_Text_Editor *c_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *c_panel_ok=(Fl_Return_Button *)0;

Fl_Button *c_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_class_panel() {
  { class_panel = new Fl_Double_Window(342, 196, "Class Properties");
    class_panel->labelsize(11);
    { Fl_Group* o = new Fl_Group(10, 10, 280, 20);
      o->hide();
      { c_public_button = new Fl_Light_Button(10, 10, 60, 20, "public");
        c_public_button->tooltip("Make the class publicly accessible.");
        c_public_button->labelsize(11);
        c_public_button->when(FL_WHEN_NEVER);
        c_public_button->hide();
      } // Fl_Light_Button* c_public_button
      { Fl_Box* o = new Fl_Box(80, 10, 210, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { c_name_input = new Fl_Input(10, 20, 320, 20, "Name:");
      c_name_input->tooltip("Name of class.");
      c_name_input->labelfont(1);
      c_name_input->labelsize(11);
      c_name_input->textfont(4);
      c_name_input->textsize(11);
      c_name_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      c_name_input->when(FL_WHEN_NEVER);
    } // Fl_Input* c_name_input
    { c_subclass_input = new Fl_Input(10, 55, 320, 20, "Subclass of (text between : and {)");
      c_subclass_input->tooltip("Name of subclass.");
      c_subclass_input->labelfont(1);
      c_subclass_input->labelsize(11);
      c_subclass_input->textfont(4);
      c_subclass_input->textsize(11);
      c_subclass_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      c_subclass_input->when(FL_WHEN_NEVER);
    } // Fl_Input* c_subclass_input
    { c_comment_input = new Fl_Text_Editor(10, 90, 320, 65, "Comment:");
      c_comment_input->tooltip("Class comment in Doxygen format");
      c_comment_input->box(FL_DOWN_BOX);
      c_comment_input->labelfont(1);
      c_comment_input->labelsize(11);
      c_comment_input->textfont(4);
      c_comment_input->textsize(11);
      c_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(c_comment_input);
      c_comment_input->buffer(new Fl_Text_Buffer());
    } // Fl_Text_Editor* c_comment_input
    { Fl_Group* o = new Fl_Group(10, 165, 320, 20);
      { c_panel_ok = new Fl_Return_Button(200, 165, 60, 20, "OK");
        c_panel_ok->labelsize(11);
        c_panel_ok->window()->hotspot(c_panel_ok);
      } // Fl_Return_Button* c_panel_ok
      { c_panel_cancel = new Fl_Button(270, 165, 60, 20, "Cancel");
        c_panel_cancel->shortcut(0xff1b);
        c_panel_cancel->labelsize(11);
      } // Fl_Button* c_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 165, 185, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    class_panel->set_modal();
    class_panel->size_range(343, 188);
    class_panel->end();
  } // Fl_Double_Window* class_panel
  return class_panel;
}

Fl_Double_Window *comment_panel=(Fl_Double_Window *)0;

CodeEditor *comment_input=(CodeEditor *)0;

Fl_Return_Button *comment_panel_ok=(Fl_Return_Button *)0;

Fl_Button *comment_panel_cancel=(Fl_Button *)0;

Fl_Light_Button *comment_in_source=(Fl_Light_Button *)0;

Fl_Light_Button *comment_in_header=(Fl_Light_Button *)0;

Fl_Menu_Button *comment_predefined=(Fl_Menu_Button *)0;

Fl_Button *comment_load=(Fl_Button *)0;

Fl_Double_Window* make_comment_panel() {
  { Fl_Double_Window* o = comment_panel = new Fl_Double_Window(550, 280, "Comment Properties");
    comment_panel->labelsize(11);
    { CodeEditor* o = comment_input = new CodeEditor(110, 10, 430, 230);
      comment_input->box(FL_DOWN_BOX);
      comment_input->color(FL_BACKGROUND2_COLOR);
      comment_input->selection_color(FL_SELECTION_COLOR);
      comment_input->labeltype(FL_NORMAL_LABEL);
      comment_input->labelfont(0);
      comment_input->labelsize(11);
      comment_input->labelcolor(FL_FOREGROUND_COLOR);
      comment_input->textfont(4);
      comment_input->textsize(11);
      comment_input->align(Fl_Align(FL_ALIGN_TOP));
      comment_input->when(FL_WHEN_RELEASE);
      Fl_Group::current()->resizable(comment_input);
      o->when(FL_WHEN_ENTER_KEY_CHANGED|FL_WHEN_RELEASE);
    } // CodeEditor* comment_input
    { Fl_Group* o = new Fl_Group(110, 250, 430, 20);
      o->labelsize(11);
      { comment_panel_ok = new Fl_Return_Button(370, 250, 80, 20, "OK");
        comment_panel_ok->labelsize(11);
        comment_panel_ok->window()->hotspot(comment_panel_ok);
      } // Fl_Return_Button* comment_panel_ok
      { comment_panel_cancel = new Fl_Button(460, 250, 80, 20, "Cancel");
        comment_panel_cancel->shortcut(0xff1b);
        comment_panel_cancel->labelsize(11);
      } // Fl_Button* comment_panel_cancel
      { Fl_Box* o = new Fl_Box(110, 250, 250, 20);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(10, 10, 90, 243);
      o->labelsize(11);
      { comment_in_source = new Fl_Light_Button(10, 10, 90, 20, "In Source");
        comment_in_source->tooltip("Put the comment into the source (.cxx) file.");
        comment_in_source->labelsize(11);
        comment_in_source->when(FL_WHEN_NEVER);
      } // Fl_Light_Button* comment_in_source
      { comment_in_header = new Fl_Light_Button(10, 40, 90, 20, "In Header");
        comment_in_header->tooltip("Put the comment into the header (.h) file.");
        comment_in_header->labelsize(11);
        comment_in_header->when(FL_WHEN_NEVER);
      } // Fl_Light_Button* comment_in_header
      { comment_predefined = new Fl_Menu_Button(10, 70, 90, 20, "Predefined");
        comment_predefined->labelsize(11);
        comment_predefined->textsize(11);
      } // Fl_Menu_Button* comment_predefined
      { comment_load = new Fl_Button(10, 100, 90, 20, "Import...");
        comment_load->labelsize(11);
      } // Fl_Button* comment_load
      { Fl_Box* o = new Fl_Box(10, 132, 90, 121);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    o->size_range(320, 180);
    comment_panel->set_modal();
    comment_panel->end();
  } // Fl_Double_Window* comment_panel
  return comment_panel;
}

void type_make_cb(Fl_Widget*,void*d) {
  undo_checkpoint();
  Fl_Type *t = Fl_Type_make((char*)d);
  if (t) {
    select_only(t);
    set_modflag(1);
    t->open();
  } else {
    undo_current --;
    undo_last --;
  }
}

Fl_Window *widgetbin_panel=(Fl_Window *)0;

Fl_Window* make_widgetbin() {
  { widgetbin_panel = new Fl_Window(550, 85, "Widget Bin");
    widgetbin_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(3, 3, 79, 79);
      { Fl_Button* o = new Fl_Button(5, 5, 24, 24);
        o->tooltip("Function");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Function"));
        o->image(pixmap[7]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 5, 24, 24);
        o->tooltip("Class");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Class"));
        o->image(pixmap[12]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(55, 5, 24, 24);
        o->tooltip("Comment");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("comment"));
        o->image(pixmap[46]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(5, 30, 24, 24);
        o->tooltip("Code");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Code"));
        o->image(pixmap[8]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 30, 24, 24);
        o->tooltip("Code Block");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("CodeBlock"));
        o->image(pixmap[9]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(55, 30, 24, 24);
        o->tooltip("Widget Class");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("widget_class"));
        o->image(pixmap[48]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(5, 55, 24, 24);
        o->tooltip("Declaration");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("decl"));
        o->image(pixmap[10]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 55, 24, 24);
        o->tooltip("Declaration Block");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("declblock"));
        o->image(pixmap[11]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(87, 3, 79, 79);
      { Fl_Button* o = new Fl_Button(89, 5, 24, 24);
        o->tooltip("Window");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Window"));
        o->image(pixmap[1]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(114, 5, 24, 24);
        o->tooltip("Group");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Group"));
        o->image(pixmap[6]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(139, 5, 24, 24);
        o->tooltip("Pack");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Pack"));
        o->image(pixmap[22]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(89, 30, 24, 24);
        o->tooltip("Tabs");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Tabs"));
        o->image(pixmap[13]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(114, 30, 24, 24);
        o->tooltip("Scroll");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Scroll"));
        o->image(pixmap[19]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(89, 55, 24, 24);
        o->tooltip("Tile");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Tile"));
        o->image(pixmap[20]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(114, 55, 24, 24);
        o->tooltip("Wizard");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Wizard"));
        o->image(pixmap[21]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(171, 3, 54, 79);
      { Fl_Button* o = new Fl_Button(173, 5, 24, 24);
        o->tooltip("Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Button"));
        o->image(pixmap[2]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(198, 5, 24, 24);
        o->tooltip("Return Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Return_Button"));
        o->image(pixmap[23]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(173, 30, 24, 24);
        o->tooltip("Light Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Light_Button"));
        o->image(pixmap[24]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(198, 30, 24, 24);
        o->tooltip("Repeat Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Repeat_Button"));
        o->image(pixmap[25]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(173, 55, 24, 24);
        o->tooltip("Check Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Check_Button"));
        o->image(pixmap[3]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(198, 55, 24, 24);
        o->tooltip("Round Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Round_Button"));
        o->image(pixmap[4]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(230, 3, 104, 79);
      { Fl_Button* o = new Fl_Button(232, 5, 24, 24);
        o->tooltip("Slider");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Slider"));
        o->image(pixmap[37]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(257, 5, 24, 24);
        o->tooltip("Scroll Bar");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Scrollbar"));
        o->image(pixmap[38]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(282, 5, 24, 24);
        o->tooltip("Value Slider");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Slider"));
        o->image(pixmap[39]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(307, 5, 24, 24);
        o->tooltip("Value Output");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Output"));
        o->image(pixmap[45]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(232, 30, 24, 24);
        o->tooltip("Adjuster");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Adjuster"));
        o->image(pixmap[40]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(257, 30, 24, 24);
        o->tooltip("Counter");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Counter"));
        o->image(pixmap[41]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(282, 30, 24, 24);
        o->tooltip("Dial");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Dial"));
        o->image(pixmap[42]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(232, 55, 24, 24);
        o->tooltip("Roller");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Roller"));
        o->image(pixmap[43]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(257, 55, 24, 24);
        o->tooltip("Spinner");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Spinner"));
        o->image(pixmap[47]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(282, 55, 24, 24);
        o->tooltip("Value Input");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Input"));
        o->image(pixmap[44]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(339, 3, 54, 79);
      { Fl_Button* o = new Fl_Button(341, 5, 24, 24);
        o->tooltip("Input");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Input"));
        o->image(pixmap[14]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(366, 5, 24, 24);
        o->tooltip("Output");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Output"));
        o->image(pixmap[27]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(341, 30, 24, 24);
        o->tooltip("Text Edit");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Text_Editor"));
        o->image(pixmap[29]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(366, 30, 24, 24);
        o->tooltip("Text Display");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Text_Display"));
        o->image(pixmap[28]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(341, 55, 24, 24);
        o->tooltip("File Input");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_File_Input"));
        o->image(pixmap[30]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(398, 3, 54, 79);
      { Fl_Button* o = new Fl_Button(400, 5, 24, 24);
        o->tooltip("Menu Bar");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Menu_Bar"));
        o->image(pixmap[17]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(425, 5, 24, 24);
        o->tooltip("Input Choice");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Input_Choice"));
        o->image(pixmap[15]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(400, 30, 24, 24);
        o->tooltip("Menu Button");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Menu_Button"));
        o->image(pixmap[26]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(425, 30, 24, 24);
        o->tooltip("Menu Item");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("menuitem"));
        o->image(pixmap[16]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(400, 55, 24, 24);
        o->tooltip("Choice");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Choice"));
        o->image(pixmap[15]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(425, 55, 24, 24);
        o->tooltip("Sub Menu");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("submenu"));
        o->image(pixmap[18]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(457, 3, 29, 79);
      { Fl_Button* o = new Fl_Button(459, 5, 24, 24);
        o->tooltip("Browser");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Browser"));
        o->image(pixmap[31]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(459, 30, 24, 24);
        o->tooltip("Check Browser");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Check_Browser"));
        o->image(pixmap[32]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(459, 55, 24, 24);
        o->tooltip("File Browser");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_File_Browser"));
        o->image(pixmap[33]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(491, 3, 55, 79);
      { Fl_Button* o = new Fl_Button(493, 5, 24, 24);
        o->tooltip("Box");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Box"));
        o->image(pixmap[5]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(518, 5, 24, 24);
        o->tooltip("Clock");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Clock"));
        o->image(pixmap[34]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(493, 30, 24, 24);
        o->tooltip("Help Browser");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Help_View"));
        o->image(pixmap[35]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(493, 55, 24, 24);
        o->tooltip("Progress");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Progress"));
        o->image(pixmap[36]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    widgetbin_panel->set_non_modal();
    widgetbin_panel->end();
  } // Fl_Window* widgetbin_panel
  return widgetbin_panel;
}

Fl_Double_Window *sourceview_panel=(Fl_Double_Window *)0;

Fl_Tabs *sv_tab=(Fl_Tabs *)0;

CodeViewer *sv_source=(CodeViewer *)0;

CodeViewer *sv_header=(CodeViewer *)0;

Fl_Light_Button *sv_autorefresh=(Fl_Light_Button *)0;

Fl_Light_Button *sv_autoposition=(Fl_Light_Button *)0;

Fl_Double_Window* make_sourceview() {
  { sourceview_panel = new Fl_Double_Window(520, 490, "Code View");
    sourceview_panel->callback((Fl_Callback*)toggle_sourceview_cb);
    sourceview_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { sv_tab = new Fl_Tabs(10, 10, 500, 440);
      sv_tab->selection_color((Fl_Color)4);
      sv_tab->labelcolor(FL_BACKGROUND2_COLOR);
      sv_tab->callback((Fl_Callback*)update_sourceview_position_cb);
      { Fl_Group* o = new Fl_Group(10, 35, 500, 415, "Source");
        o->labelsize(13);
        o->hide();
        { sv_source = new CodeViewer(20, 50, 480, 390);
          sv_source->box(FL_DOWN_FRAME);
          sv_source->color(FL_BACKGROUND2_COLOR);
          sv_source->selection_color(FL_SELECTION_COLOR);
          sv_source->labeltype(FL_NORMAL_LABEL);
          sv_source->labelfont(0);
          sv_source->labelsize(14);
          sv_source->labelcolor(FL_FOREGROUND_COLOR);
          sv_source->textfont(4);
          sv_source->textsize(11);
          sv_source->align(Fl_Align(FL_ALIGN_TOP));
          sv_source->when(FL_WHEN_RELEASE);
          Fl_Group::current()->resizable(sv_source);
        } // CodeViewer* sv_source
        o->end();
        Fl_Group::current()->resizable(o);
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(10, 35, 500, 415, "Header");
        o->labelsize(13);
        { sv_header = new CodeViewer(20, 50, 480, 390);
          sv_header->box(FL_DOWN_FRAME);
          sv_header->color(FL_BACKGROUND2_COLOR);
          sv_header->selection_color(FL_SELECTION_COLOR);
          sv_header->labeltype(FL_NORMAL_LABEL);
          sv_header->labelfont(0);
          sv_header->labelsize(14);
          sv_header->labelcolor(FL_FOREGROUND_COLOR);
          sv_header->textfont(4);
          sv_header->textsize(11);
          sv_header->align(Fl_Align(FL_ALIGN_TOP));
          sv_header->when(FL_WHEN_RELEASE);
          Fl_Group::current()->resizable(sv_header);
        } // CodeViewer* sv_header
        o->end();
      } // Fl_Group* o
      sv_tab->end();
      Fl_Group::current()->resizable(sv_tab);
    } // Fl_Tabs* sv_tab
    { Fl_Group* o = new Fl_Group(10, 460, 500, 20);
      { Fl_Button* o = new Fl_Button(10, 460, 61, 20, "Refresh");
        o->labelsize(11);
        o->callback((Fl_Callback*)update_sourceview_cb);
      } // Fl_Button* o
      { Fl_Light_Button* o = sv_autorefresh = new Fl_Light_Button(76, 460, 91, 20, "Auto-Refresh");
        sv_autorefresh->labelsize(11);
        o->callback((Fl_Callback*)update_sourceview_cb);
      } // Fl_Light_Button* sv_autorefresh
      { sv_autoposition = new Fl_Light_Button(172, 460, 89, 20, "Auto-Position");
        sv_autoposition->labelsize(11);
      } // Fl_Light_Button* sv_autoposition
      { Fl_Button* o = new Fl_Button(460, 460, 50, 20, "Close");
        o->labelsize(11);
        o->callback((Fl_Callback*)toggle_sourceview_b_cb);
      } // Fl_Button* o
      { Fl_Box* o = new Fl_Box(265, 460, 190, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    sourceview_panel->size_range(384, 120);
    sourceview_panel->end();
  } // Fl_Double_Window* sourceview_panel
  return sourceview_panel;
}

//
// End of "$Id: function_panel.cxx 6302 2008-09-18 21:11:28Z matt $".
//
