@REM To RUN this batch file you need a zip8 batch file in the path!!!
@setlocal
@set TEMPVER2=
@call zipsetup
@if "%TEMPVER2%x" == "x" goto ERR1
@set TMPZDIR=C:\FG\Atlas
@if NOT EXIST %TMPZDIR%\. goto NOZIPDIR
@set TEMPZF=%TMPZDIR%\atlas-%TEMPVER2%-msvc.zip
@set TEMPZF2=%TMPZDIR%\atlas-%TEMPVER2%-3part.zip
@echo Zipping the MSVC8 build files - to %TEMPZF% and
@echo and the 3rdparty stuff to %TEMPZF2%
@set TEMP1=-a
@if NOT EXIST %TEMPZF% goto DNUP
@echo WARNING: %TEMPZF% already exists ... doing UPDATE only ...
@set TEMP1=-u
:DNUP

@set TEMP1=%TEMP1% -o
@set TEMP1=%TEMP1% -P -r

@echo Will run following commands ...
@echo call zip8 %TEMP1% %TEMPZF% build\msvc\*.* build\win_src\*.*
@echo call zip8 %TEMP1% %TEMPZF2% build\3rdparty\*.*
@echo Continue? Ctrl+C, or Ctrl+Break to abort batch ...
@pause

@cd ..\..
@if NOT EXIST build\msvc\. goto BAD_PLACE
@if NOT EXIST build\win_src\. goto BAD_PLACE
@if NOT EXIST build\3rdparty\. goto BAD_PLACE
call zip8 %TEMP1% %TEMPZF% build\msvc\*.* build\win_src\*.*
@if ERRORLEVEL 1 goto ZIPERR
call zip8 %TEMP1% %TEMPZF2% build\3rdparty\*.*
@cd build\msvc

@dir %TEMPZF%
@dir %TEMPZF2%
@if NOT EXIST %TEMPZF% goto ERRNZ
@if NOT EXIST %TEMPZF2% goto ERRNZ2
@goto END

:BAD_PLACE
@echo ERROR: Being run in BAD PLACE!
@goto END

:ZIPERR
@echo zip8 batch returned ERRORLEVEL %ERRORLEVEL% !!!
@echo Perhaps zip8.bat batch files is NOT in the path ...
@echo SOme other error has occurred ...
@cd build\msvc
@goto WAIT

:ERR1
@echo ERROR: The version, TEMPVER2 environment variable not set ... can not build zip file ...
@goto WAIT
:ERR2
@echo ERROR: Can NOT locate %TEMPE1% file. Has build been done? ... can not build zip file ...
@goto WAIT
:ERR3
@echo ERROR: Can NOT locate %TEMPE2% file. Has build been done? ... can not build zip file ...
@goto WAIT
:ERRNZ
@echo ERROR: Creation of ZIP %TEMPZF% failed ... maybe no zip8.bat batch file available ...
@goto WAIT
:ERRNZ2
@echo ERROR: Creation of ZIP %TEMPZF2% failed ... maybe no zip8.bat batch file available ...
@goto WAIT

:NOZIPDIR
@echo ERROR: %TMPZDIR%\. DOES NOT EXIST! FIX ME!
@goto WAIT


:WAIT
@pause
:END
@endlocal
