// -*-C++-*-

varying vec4 diffuse, constantColor;
varying vec3 normal, lightDir, halfVector;
varying float fogCoord, alpha;

uniform bool twoSideHack;

uniform sampler2D texture;

float luminance(vec3 color)
{
    return dot(vec3(0.212671, 0.715160, 0.072169), color);
}

void main()
{
    vec3 n, halfV;
    float NdotL, NdotHV, fogFactor;
    vec4 color = constantColor;
    vec4 texel;
    vec4 fragColor;
    vec4 specular = vec4(0.0);
    n = normalize(normal);
    if (twoSideHack && gl_Color.a == 0.0)
        n = -n;
    NdotL = max(dot(n, lightDir), 0.0);
    if (NdotL > 0.0) {
        color += diffuse * NdotL;
        halfV = normalize(halfVector);
        NdotHV = max(dot(n, halfV), 0.0);
        if (gl_FrontMaterial.shininess > 0.0)
            specular.rgb = (gl_FrontMaterial.specular.rgb
                            * gl_LightSource[0].specular.rgb
                            * pow(NdotHV, gl_FrontMaterial.shininess));
    }
    color.a = alpha;
    // This shouldn't be necessary, but our lighting becomes very
    // saturated. Clamping the color before modulating by the texture
    // is closer to what the OpenGL fixed function pipeline does.
    color = clamp(color, 0.0, 1.0);
    texel = texture2D(texture, gl_TexCoord[0].st);
    fragColor = color * texel + specular;
    fogFactor = exp(-gl_Fog.density * gl_Fog.density * fogCoord * fogCoord);
    gl_FragColor = mix(gl_Fog.color, fragColor, fogFactor);
}
